#include <stdio.h>
#include <asm/types.h>
#include "ronnyvideo.h"
#include "ccd.h"


static int bpp;
static int bytespp;
static unsigned char* pixels;
/* static int pitch; */
static int start_x = 0;
/* static int max_x = 384; */
static int max_x = 400;
static int start_y = 0;
static int max_y = 288;


static __u32 r_arr[256];
static __u32 g_arr[256];
static __u32 b_arr[256];

static __u32 r_bitmask;
static __u32 g_bitmask;
static __u32 b_bitmask;

/* static int InitDdrawSurfaces(bool windowed); */

extern bool always_on_top;
extern bool aspect_ratio;

static int r_shift;
static int g_shift;
static int b_shift;

static int r_cnt;
static int g_cnt;
static int b_cnt;

/* extern bool use_double_buffering; */


/* static void findShiftValue(__u32 mask, int &shft, int& cnt) -- check & */
static void findShiftValue(__u32 mask, int shft, int cnt)
{
    int t;

    for (t = 0; t < 32; t++) {
	if (mask & (1 << t)) break;
    }
   
    shft = t;

    cnt = 0;
    while (mask & (1 << t)) {
	t++;
	cnt++;
    }
}


static void init_rgb_array(__u32 dwRBitMask, __u32 dwGBitMask, __u32 dwBBitMask)
{
    int i;

   r_bitmask = dwRBitMask;
   g_bitmask = dwGBitMask;
   b_bitmask = dwBBitMask;

   findShiftValue(r_bitmask, r_shift, r_cnt);
   findShiftValue(g_bitmask, g_shift, g_cnt);
   findShiftValue(b_bitmask, b_shift, b_cnt);

   for (i = 0; i < 256; i++) {
       r_arr[i] = (__u32) (((i * (__u32) dwRBitMask) / 255) & dwRBitMask);
       g_arr[i] = (__u32) (((i * (__u32) dwGBitMask) / 255) & dwGBitMask);
       b_arr[i] = (__u32) (((i * (__u32) dwBBitMask) / 255) & dwBBitMask);
   }
}


void initRonnyVideo(void *p2)
{
    __u32 dwBBitMask = 0x0000001f;
    __u32 dwGBitMask = 0x000007e0;
    __u32 dwRBitMask = 0x0000f800;

/*    pitch = 380 * 2; */

    pixels = p2;

    bpp = 16;
/*    bytespp = (bpp + 7) / 8; */
    bytespp = 2;

    /* init_rgb_array(pf.dwRBitMask, pf.dwGBitMask, pf.dwBBitMask); */
    init_rgb_array(dwRBitMask, dwGBitMask, dwBBitMask);
}


void drawPixels(int x, int y, RGBTRIPLE* rgbpixels, int nbr_pixels, int pitch)
{
    unsigned char *surface;

    x += start_x;
    y += start_y;

    if (y < 0 || y > max_y)
        return;
        
    if (x + nbr_pixels > max_x)
        nbr_pixels = max_x - x;
        
    if (x < 0) {
        int r = 0 - x;
        rgbpixels += r;
        nbr_pixels -= r;
        x = 0;
    }

    surface = pixels + y * pitch + x * bytespp;

    if (bpp == 16) {
        register unsigned short *s0 = (unsigned short*) surface;
        while (--nbr_pixels > 0) {
            *s0++ = (unsigned short) MAKERGB(rgbpixels->rgbtRed, rgbpixels->rgbtGreen, rgbpixels->rgbtBlue);
            rgbpixels++;
        }
    } else if (bpp == 32) {
        register unsigned long *s0 = (unsigned long*) surface;
        while (--nbr_pixels > 0) {
            *s0++ = MAKERGB(rgbpixels->rgbtRed, rgbpixels->rgbtGreen, rgbpixels->rgbtBlue);
            rgbpixels++;
        }
    }
}
