/*
 * Set the framebuffer parameters for bttv.
 *   tries first to ask the X-Server
 *   if this failes, it checks /dev/fb0
 *
 *  (c) 1998 Gerd Knorr <kraxel@cs.tu-berlin.de>
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <strings.h>
#include <string.h>
#include <errno.h>
#include <fcntl.h>
#include <getopt.h>
#include <sys/ioctl.h>
/* #include <linux/fb.h> */

#include "config.h"

#include <asm/types.h>          /* XXX glibc */
#include "bttv/videodev.h"

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#ifdef HAVE_LIBXXF86DGA
# include <X11/extensions/xf86dga.h>
#endif

int    verbose = 1;
int    bpp     = 0;
char  *display = NULL;
char  *device  = "/dev/video0";
char  *fbdev   = "/dev/fb0";

int
main(int argc, char *argv[])
{
    /* X11 */
    Display                  *dpy;
    Screen                   *scr;
    Window                   root;
    XWindowAttributes        wts;
    XPixmapFormatValues      *pf;
    int                      depth=0;
#ifdef HAVE_LIBXXF86DGA
    int                      width,bar,foo,flags=0;
    void                     *base = 0;
#endif

    /* fbdev */
/*    struct fb_fix_screeninfo   fix; */
/*    struct fb_var_screeninfo   var; */
    
    /* v4l */
    struct video_capability  capability;
    struct video_buffer      fbuf;
    int                      set_width=0, set_height=0, set_bpp=0, set_bpl=0;
    void                     *set_base=NULL;

    /* misc */
    int                      fd,c,i,n;
    char                     *h;

    
    /* take defaults from environment */
    if (NULL != (h = getenv("DISPLAY")))
	display = h;
    if (NULL != (h = getenv("FRAMEBUFFER")))
	fbdev = h;
    
    /* parse options */
    for (;;) {
	if (-1 == (c = getopt(argc, argv, "hqd:c:b:")))
	    break;
	switch (c) {
	case 'q':
	    verbose = 0;
	    break;
	case 'd':
	    display = optarg;
	    break;
	case 'c':
	    device = optarg;
	    break;
	case 'b':
	    bpp = atoi(optarg);
	    break;
	case 'h':
	default:
	    fprintf(stderr,
		    "usage: %s  [ options ] \n"
		    "\n"
		    "options:\n"
		    "    -q        quiet\n"
		    "    -d <dpy>  X11 Display     [%s]\n"
		    "    -c <dev>  video device    [%s]\n"
		    "    -b <n>    displays color depth is <n> bpp\n"
		    "              might be required for (and works\n"
		    "              only with) 24/32 bpp\n",
		    argv[0],
		    display,
		    device);
	    exit(1);
	}
    }

    if (display) {
	/* using X11 */
	if (display[0] != ':') {
	    fprintf(stderr,
		    "non-local display `%s' not allowed, using `:0.0' instead\n",
		    display);
	    display = ":0.0";
	}
	
	/* get screen params */
	if (NULL == (dpy = XOpenDisplay(display))) {
	    fprintf(stderr,"can't open x11 display %s\n",display);
	    exit(1);
	}

	scr  = DefaultScreenOfDisplay(dpy);
	root = DefaultRootWindow(dpy);
	XGetWindowAttributes(dpy, root, &wts);
	depth = wts.depth;
	
	pf = XListPixmapFormats(dpy,&n);
	for (i = 0; i < n; i++) {
	    if (pf[i].depth == depth) {
		depth = pf[i].bits_per_pixel;
		break;
	    }
	}

	if ((bpp == 32 || bpp == 24) && (depth == 32 || depth == 24))
	    depth = bpp;
	
	set_width  = wts.width;
	set_height = wts.height;
	set_bpp    = (depth+7) & 0xf8;
	set_bpl    = set_width*set_bpp/8;
		
#ifdef HAVE_LIBXXF86DGA
	if (XF86DGAQueryExtension(dpy,&foo,&bar)) {
	    XF86DGAQueryDirectVideo(dpy,XDefaultScreen(dpy),&flags);
	    if (flags & XF86DGADirectPresent) {
		XF86DGAGetVideoLL(dpy,XDefaultScreen(dpy),(int*)&base,&width,&foo,&bar);
		set_bpl  = width * set_bpp/8;
		set_base = base;
	    }
	}
	if (verbose)
	    fprintf(stderr,"using X11 display %s%s\n",display,
		    flags & XF86DGADirectPresent ? " (dga available)" : "");
#else
	if (verbose)
	    fprintf(stderr,"using X11 display %s\n",display);
#endif
    }
/*    } else {

	if (-1 == (fd = open(fbdev,O_RDWR))) {
	    fprintf(stderr,"open %s: %s\n",fbdev,strerror(errno));
	    exit(1);
	}
	if (-1 == ioctl(fd,FBIOGET_FSCREENINFO,&fix)) {
	    perror("ioctl FBIOGET_FSCREENINFO");
	    exit(1);
	}
	if (-1 == ioctl(fd,FBIOGET_VSCREENINFO,&var)) {
	    perror("ioctl FBIOGET_VSCREENINFO");
	    exit(1);
	}
	if (fix.type != FB_TYPE_PACKED_PIXELS) {
	    fprintf(stderr,"can handle only packed pixel frame buffers\n");
	    exit(1);
	}
	close(fd);
	if (verbose)
	    fprintf(stderr,"using framebuffer device %s: %s\n",fbdev,fix.id);

	set_width  = var.xres_virtual;
	set_height = var.yres_virtual;
	set_bpp    = var.bits_per_pixel;
	set_bpl    = fix.line_length;
	set_base   = fix.smem_start;
    }
*/
    /* open & check v4l device */
    if (-1 == (fd = open(device,O_RDWR))) {
	fprintf(stderr,"can't open %s: %s\n",device,strerror(errno));
	exit(1);
    }
    if (-1 == ioctl(fd,VIDIOCGCAP,&capability)) {
	fprintf(stderr,"%s: ioctl VIDIOCGCAP: %s\n",device,strerror(errno));
	exit(1);
    }
    if (!(capability.type & VID_TYPE_OVERLAY)) {
	fprintf(stderr,"%s: no overlay support\n",device);
	exit(1);
    }

    /* read-modify-write v4l screen parameters */
    if (-1 == ioctl(fd,VIDIOCGFBUF,&fbuf)) {
	fprintf(stderr,"%s: ioctl VIDIOCGFBUF: %s\n",device,strerror(errno));
	exit(1);
    }

    /* set values */
    fbuf.width        = set_width;
    fbuf.height       = set_height;
    fbuf.depth        = set_bpp;
    fbuf.bytesperline = set_bpl;
    if (set_base)
	fbuf.base     = set_base;

    /* XXX bttv confuses color depth and bits/pixel */
    if (wts.depth == 15)
	fbuf.depth = 15;

    if (verbose) {
	fprintf(stderr,"video mode: %dx%d, %d bit/pixel, %d byte/scanline\n",
		fbuf.width,fbuf.height,fbuf.depth,fbuf.bytesperline);
	if (set_base)
	    fprintf(stderr,"framebuffer at %p\n",set_base);
    }

    if (-1 == ioctl(fd,VIDIOCSFBUF,&fbuf)) {
	fprintf(stderr,"%s: ioctl VIDIOCSFBUF: %s\n",device,strerror(errno));
	exit(1);
    }
    if (verbose)
	fprintf(stderr,"ok\n");

    return 0;
}
