#include <windows.h>
#include <Winioctl.h>
#include <IOC.h>
#include <EVIP.h>

#include "main.h"
#include "decoder.h"
#include "support.h"

#include "vidwindow.h"

BOOL synced = FALSE;
BOOL inverted = FALSE;
BOOL chroma = FALSE;

HANDLE hVLio = INVALID_HANDLE_VALUE;

BOOL init_hardware() {

	//hardware i/o variables
	VLIO_Params Params;
	LPDWORD dwRet;

	// fire up device driver.
	hVLio	= CreateFile(
						"\\\\.\\VLIO",
						GENERIC_READ | GENERIC_WRITE,
						FILE_SHARE_READ | FILE_SHARE_WRITE,
						NULL,
						OPEN_EXISTING,
						0,
						0);

	if(hVLio == INVALID_HANDLE_VALUE) {
		FATAL("Can't open device handler, check for vlio.sys");
		return FALSE;
	}

	// this may need to be changed.
	Params.Param1 = modelTNT;
	DeviceIoControl(
					hVLio,
					VLIO_SETMODEL,
					&Params,
					sizeof(Params),
					&Params,
					sizeof(Params),
					dwRet,
					NULL);

	Params.Param1 = 0;
	DeviceIoControl(
					hVLio,
					VLIO_EVIP_CHIP_OK,
					&Params,
					sizeof(Params),
					&Params,
					sizeof(Params),
					dwRet,
					NULL);

	if(Params.Param1 != TRUE) {
		FATAL("Video processor failed test (do you have an Asus TV card?)");
		CloseHandle(hVLio);
		return FALSE;
	}
	return TRUE;
}

void disconnect_hardware() {
	CloseHandle(hVLio);
}

void sync_toggle() {

	VLIO_Params Params;
	LPDWORD dwRet;

	Params.Param1 = Params.Param2 = 0;

	if (synced)
		Params.Param3 = DESYNC_CONTROL_BYTE;
	else 
		Params.Param3 = SYNC_CONTROL_BYTE;

	Params.Param1 = i2C_SLAVE;
	Params.Param2 = EVIP_SA08;
	DeviceIoControl(
		hVLio,
		VLIO_EVIP_WRITE_BYTE,
		&Params,
		sizeof(Params),
		&Params,
		sizeof(Params),
		dwRet,
		NULL);

	synced = !synced;
}

void inv_luminance() {

	VLIO_Params Params;
	LPDWORD dwRet;

	Params.Param2 = Params.Param3 = 0;

	if (inverted)
		Params.Param1 = 71;
	else 
		Params.Param1 = -64;

	DeviceIoControl(
		hVLio,
		VLIO_EVIP_SET_CONTRAST,
		&Params,
		sizeof(Params),
		&Params,
		sizeof(Params),
		dwRet,
		NULL);

	inverted = !inverted;
}

void inv_chrominance() {

	VLIO_Params Params;
	LPDWORD dwRet;

	Params.Param2 = Params.Param3 = 0;

	if (chroma)
		Params.Param1 = 64;
	else
		Params.Param1 = -64;

	DeviceIoControl(
		hVLio,
		VLIO_EVIP_SET_SATURATION,
		&Params,
		sizeof(Params),
		&Params,
		sizeof(Params),
		dwRet,
		NULL);
	chroma = !chroma;
}
/*
int get_contrast(HANDLE hVLio) {
	VLIO_Params Params;
	LPDWORD dwRet;

	DeviceIoControl(
		hVLio,
		VLIO_EVIP_GET_CONTRAST,
		&Params,
		sizeof(Params),
		&Params,
		sizeof(Params),
		dwRet,
		NULL);
	return(Params.Param1);
}
*/