// events.c

#include <windows.h>

#include "decoder.h"
#include "main.h"
#include "events.h"
#include "vidwindow.h"

void handle_keyboard_event(TCHAR key, HWND hwndLocal) {
	switch (key) {
	case 'e':
		PostMessage(hwndLocal, WM_CLOSE, 0, 0);
		break;
	case 'x':
		inv_luminance();
		break;
	case 's':
		sync_toggle();
		break;
	case 'c':
		inv_chrominance();
		break;
	case 'v':
		start_video_feed();
		break;
	}
}

LONG FAR PASCAL 
vidwindowProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam) {
    switch(message) {

    case WM_MOVE:
    case WM_SIZE:
		vidwindow_update_overlay();
        break;

    case WM_PAINT:
		vidwindow_paint();
        break;

    case WM_CHAR:
		handle_keyboard_event((TCHAR)wParam, hwnd);
		break;
	case WM_CLOSE:
		// disconnect hardware
		disconnect_hardware();
        // Destroy child windows...
	    DestroyWindow(hwnd) ;
		exit(0);
		break;

    default:
        return(DefWindowProc(hwnd, message, wParam, lParam));

    }
    return(0);
}