//main.c

#include <windows.h>

#include "vidwindow.h"
#include "events.h"
#include "decoder.h"
#include "support.h"
#include "main.h"

char debug_str[256];

HINSTANCE hinstMain; //instance of application

char AppTitle[20] = APPLICATION_NAME;

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, 
    LPSTR lpszCmdLine, int nCmdShow) 
{ 	

    MSG msg; 
    UNREFERENCED_PARAMETER(lpszCmdLine); 
	hinstMain = hInstance;  // save instance handle 

/*
	// init i2c command bus
	if(!init_hardware())
		return FALSE;
*/
    // Register window classes. 
	if (!dekoder_register_classes(hInstance, hPrevInstance)) {
		FATAL("Can't register window classes");
        return FALSE;
    }

    // Create the main window. 
	if (!dekoder_create_windows(hInstance, hPrevInstance))
        return FALSE;

	// init the shit
	if(!main_video_init())
		return FALSE;

    // Show the window and paint its contents. 
    ShowWindow(hwndMain, nCmdShow); 

    UpdateWindow(hwndMain); 

    // Start the message loop. 
    while (GetMessage(&msg, (HWND) NULL, 0, 0)) { 
        TranslateMessage(&msg); 
        DispatchMessage(&msg); 
    } 
 
    // Return the exit code to Windows. 
 
    return msg.wParam; 
} 

BOOL dekoder_register_classes(HINSTANCE hInstance, HINSTANCE hPrevInstance) {
    WNDCLASS wc; 

    if (!hPrevInstance) { 
        wc.lpszClassName = VIDWNDCLASSNAME;
        wc.style         = CS_HREDRAW | CS_VREDRAW ;
        wc.lpfnWndProc   = (WNDPROC) vidwindowProc;
        wc.hInstance     = hInstance;
        wc.hIcon         = NULL;
        wc.hCursor       = LoadCursor(NULL, IDC_ARROW) ;
        wc.lpszMenuName  = NULL;
        wc.hbrBackground = GetStockObject(BLACK_BRUSH);
        wc.cbClsExtra    = 0 ;
        wc.cbWndExtra    = 0 ;   

        if(!RegisterClass(&wc)) {
			return FALSE;
        }
	} 
	return TRUE;
}

// Create all windows needed
BOOL dekoder_create_windows(HINSTANCE hInstance, HINSTANCE hPrevInstance) {
	hwndMain = CreateWindowEx(
			WS_EX_APPWINDOW ,
			VIDWNDCLASSNAME,
            AppTitle,
			WS_CAPTION      |
			WS_SYSMENU |
            //WS_MINIMIZEBOX  |
            //WS_MAXIMIZEBOX  |
            WS_THICKFRAME, //	|
            //WS_OVERLAPPED,
            CW_USEDEFAULT, 0, // start pos
            APP_INIT_WIDTH, APP_INIT_HEIGHT, // start size
            NULL,
            NULL,
            hInstance,
            0) ;

    if (!hwndMain) {
		FATAL("Could not create video overlay frame");
        return FALSE;
	}
	return TRUE;
}  

