#include <windows.h>
#include <Winioctl.h>
#include <stdio.h>
#include <conio.h>

#include <EVIP.h>
#include <IOC.h>

//#include "main.h"

#define SYNC_CONTROL_BYTE 0x82
#define DESYNC_CONTROL_BYTE 0x80

BOOL synced = FALSE;
BOOL inverted = FALSE;
BOOL chroma = FALSE;

void sync_toggle(HANDLE hVLio, VLIO_Params Params, LPDWORD dwRet) {
	if (synced) {
		printf("vsync free\n");
		Params.Param3 = DESYNC_CONTROL_BYTE;
	}
	else {
		printf("vsync locked\n");
		Params.Param3 = SYNC_CONTROL_BYTE;
	}
	Params.Param1 = i2C_SLAVE;
	Params.Param2 = EVIP_SA08;
	DeviceIoControl(
		hVLio,
		VLIO_EVIP_WRITE_BYTE,
		&Params,
		sizeof(Params),
		&Params,
		sizeof(Params),
		dwRet,
		NULL);

	synced = !synced;
}

void inv_luminance(HANDLE hVLio, VLIO_Params Params, LPDWORD dwRet) {

	if (inverted) {
		printf("luminance reset\n");
		Params.Param1 = 71;
	}
	else {
		printf("luminance invert\n");
		Params.Param1 = -64;
	}

	inverted = !inverted;

	DeviceIoControl(
		hVLio,
		VLIO_EVIP_SET_CONTRAST,
		&Params,
		sizeof(Params),
		&Params,
		sizeof(Params),
		dwRet,
		NULL);

}

void inv_chrominance(HANDLE hVLio, VLIO_Params Params, LPDWORD dwRet) {

	if (chroma) {
		printf("color reset\n");
		Params.Param1 = 64;
	}
	else {
		printf("color invert\n");
		Params.Param1 = -64;
	}

	chroma = !chroma;

	DeviceIoControl(
		hVLio,
		VLIO_EVIP_SET_SATURATION,
		&Params,
		sizeof(Params),
		&Params,
		sizeof(Params),
		dwRet,
		NULL);

}

int get_contrast(HANDLE hVLio, VLIO_Params Params, LPDWORD dwRet) {

	DeviceIoControl(
		hVLio,
		VLIO_EVIP_GET_CONTRAST,
		&Params,
		sizeof(Params),
		&Params,
		sizeof(Params),
		dwRet,
		NULL);

	return(Params.Param1);
}

int main() {

	HANDLE hVLio = INVALID_HANDLE_VALUE;
	VLIO_Params Params;
	LPDWORD dwRet;

	printf("cablecrypt preliminary decoder for Asus V3800/tv cards, by kossak.\n");
	printf("remember, it isn't legal to use this program, but it was legal to write it :)\n");


	hVLio	= CreateFile(
						"\\\\.\\VLIO",
						GENERIC_READ | GENERIC_WRITE,
						FILE_SHARE_READ | FILE_SHARE_WRITE,
						NULL,
						OPEN_EXISTING,
						0,
						0
						);

	if(hVLio == INVALID_HANDLE_VALUE) {
		printf("Can't open device handler, exiting...\n");
		exit(-1);
	}

	Params.Param1 = modelTNT2;
	DeviceIoControl(
					hVLio,
					VLIO_SETMODEL,
					&Params,
					sizeof(Params),
					&Params,
					sizeof(Params),
					dwRet,
					NULL);

	Params.Param1 = 0;
	DeviceIoControl(
					hVLio,
					VLIO_EVIP_CHIP_OK,
					&Params,
					sizeof(Params),
					&Params,
					sizeof(Params),
					dwRet,
					NULL);

	if(Params.Param1 == TRUE)
		printf("EVIP init ok.\n");
	else {
		printf("Video processor failed test.\n");
		CloseHandle(hVLio);
		exit(-1);
	}

	sync_toggle(hVLio, Params, dwRet);

	printf(	"\nUsage:\n"
			"'s' -> turn on/off vertical sync locking\n"
			"'x' -> inverse/reset luminance signal\n"
			"'c' -> inverse/reset chrominance signal\n"
			"'e' -> exit program\n");

	for (;;) {
		switch(getch()) {
		case 's':
			sync_toggle(hVLio, Params, dwRet);
			break;
		case 'e':
			CloseHandle(hVLio);
			exit(0);
			break;
		case 'x':
			inv_luminance(hVLio, Params, dwRet);
			break;
		case 'c':
			inv_chrominance(hVLio, Params, dwRet);
			break;
		default:
			break;
		}
		
	}

	return (-1);
}
