//vidport.cpp

#include <windows.h>
#include <ddraw.h>
#include <dvp.h>

#include "main.h"
#include "support.h"
#include "vidport.h"
#include "vidwindow.h"

//for debugging only 
#include <stdio.h>

extern LPDIRECTDRAW lpDD;
extern LPDIRECTDRAWSURFACE lpOverlay;

/*
#define SCREEN_BITCOUNT	16
#define OVERLAY_FORMAT	MAKEFOURCC('U','Y','V','Y')
*/
// object that will reference future video ports.
LPDDVIDEOPORTCONTAINER lpVideoContainer;
// future video port
LPDIRECTDRAWVIDEOPORT lpVideoPort;

DWORD num_vidports; //number of video ports, cant handle more than one for now.

// initializes lpVideoContainer and creates valid video port object in lpVideoPort
BOOL create_video_port() {
	HRESULT ddrval;

	LPDDVIDEOPORTCAPS lpVideoPortCaps;
	DDVIDEOPORTDESC VideoPortDesc;
	DDVIDEOPORTCONNECT VideoConnection[MAX_VID_CON];
	DDVIDEOPORTSTATUS VideoPortStatus;

	DWORD num_connects;	//number of connections supported by video port

	ddrval = lpDD->QueryInterface(	IID_IDDVideoPortContainer,
									(void **)&lpVideoContainer);
	if(ddrval != S_OK)
		return FALSE;
	
	num_vidports = 0;
	lpVideoPortCaps = (DDVIDEOPORTCAPS *)malloc(sizeof(DDVIDEOPORTCAPS));

	// check how many and how good are our video ports :)
	ddrval = lpVideoContainer->EnumVideoPorts(	0,
												NULL,
												lpVideoPortCaps,
												enumvidport_callback);
	if(ddrval != DD_OK)
		return FALSE;

	if (num_vidports > 1) {
		FATAL("You have more than one video input mechanism, Im confused!!");
		return FALSE;
	} 
	if (num_vidports < 1) {
		FATAL("your video input hardware is nowhere to be found...");
		return FALSE;
	}

	ddrval = lpVideoContainer->GetVideoPortConnectInfo(
									lpVideoPortCaps->dwVideoPortID,
									&num_connects,
									NULL);
	if(ddrval != DD_OK)
		return FALSE;
/*
	sprintf(debug_str, "number of connections supported is %i", num_connects);
	FATAL(debug_str);
*/
	VideoPortStatus.dwSize = sizeof(DDVIDEOPORTSTATUS);
	ddrval = lpVideoContainer->QueryVideoPortStatus(
									lpVideoPortCaps->dwVideoPortID,
									&VideoPortStatus);
	
	if(ddrval != DD_OK) {
		FATAL("Could not get video port status");
		return FALSE;
	}
	if(VideoPortStatus.bInUse) {
		FATAL("Video port already in use");
		return FALSE;
	}

	VideoConnection[0].dwSize = sizeof(DDVIDEOPORTCONNECT);
	ddrval = lpVideoContainer->GetVideoPortConnectInfo(
								lpVideoPortCaps->dwVideoPortID,
								&num_connects,
								VideoConnection);
	if(ddrval != DD_OK) 
		return FALSE;

	if(VideoConnection[0].guidTypeID != DDVPTYPE_CCIR656) {
		FATAL("Wrong video bus type. Invalid Hardware?");
		return FALSE;
	}

	// check entries for validity
	if(!(lpVideoPortCaps->dwFlags & DDVPD_CAPS &&
		 lpVideoPortCaps->dwFlags & DDVPD_HEIGHT &&
		 lpVideoPortCaps->dwFlags & DDVPD_ID &&
		 lpVideoPortCaps->dwFlags & DDVPD_WIDTH)) {
		FATAL("lpVideoPortCaps contains illegal values");
		return FALSE;
	}

	// ok, now fill in the VideoPortDesc structure...
	VideoPortDesc.dwSize					= sizeof(DDVIDEOPORTDESC);
	/*
	VideoPortDesc.dwFieldWidth				= lpVideoPortCaps->dwMaxWidth;
	VideoPortDesc.dwVBIWidth				= lpVideoPortCaps->dwMaxVBIWidth;
	VideoPortDesc.dwFieldHeight				= lpVideoPortCaps->dwMaxHeight;
	*/
	VideoPortDesc.dwFieldWidth				= 640;
	VideoPortDesc.dwVBIWidth				= 640;
	VideoPortDesc.dwFieldHeight				= 480;
	VideoPortDesc.dwMicrosecondsPerField	= 20000;
	VideoPortDesc.dwMaxPixelsPerSecond		= 7680000;
	VideoPortDesc.dwVideoPortID				= lpVideoPortCaps->dwVideoPortID;
	VideoPortDesc.dwReserved1				= 0;
	VideoPortDesc.dwReserved2				= 0;
	VideoPortDesc.dwReserved3				= 0;

	memcpy(	&VideoPortDesc.VideoPortType,
			&VideoConnection[0],
			sizeof(DDVIDEOPORTCONNECT));

	VideoPortDesc.VideoPortType.dwSize = sizeof(DDVIDEOPORTCONNECT);

/*
	if (!(VideoPortDesc.VideoPortType.dwFlags & DDVPCONNECT_INTERLACED)) {
		FATAL("image is not set to be interlaced");
	}

	VideoPortDesc.VideoPortType.dwFlags |= DDVPCONNECT_INTERLACED;
*/
	VideoPortDesc.VideoPortType.dwReserved1 = 0;

	sprintf(debug_str,
			"Creating VideoPort %i with: \n%i x %i size, \n%i VBI width, \nbus width: %i \nmicrosecs per field: %i \npixels per second: %i ",
			VideoPortDesc.dwVideoPortID,
			VideoPortDesc.dwFieldWidth,
			VideoPortDesc.dwFieldHeight,
			VideoPortDesc.dwVBIWidth,
			VideoPortDesc.VideoPortType.dwPortWidth,
			VideoPortDesc.dwMicrosecondsPerField,
			VideoPortDesc.dwMaxPixelsPerSecond);
	FATAL(debug_str);

	// create the video port (FINALLY!!)
	ddrval = lpVideoContainer->CreateVideoPort(	NULL,
												&VideoPortDesc,
												&lpVideoPort,
												NULL);
	if(ddrval != DD_OK) {
		switch (ddrval) {
		case DDERR_INVALIDPARAMS:
			FATAL("Invalid params");
			break;
		case DDERR_CURRENTLYNOTAVAIL:
			FATAL("No support is currently available.");
			break;
		case DDERR_INVALIDOBJECT:
			FATAL("Invalid DirectDraw object");
			break;
		case DDERR_OUTOFCAPS:
			FATAL("The hardware needed for the requested operation has already been allocated.");
			break;
		case DDERR_OUTOFMEMORY:
			FATAL("Out of memory!");
			break;
		case DDERR_NOCOOPERATIVELEVELSET:
			FATAL("no cooperative level set");
			break;
		default:
			FATAL("Impossible error ocurred. Windows rules, heh? :)");
		}
		return FALSE;
	}
	return TRUE;
}


// callback for lpVideoPortContainer->EnumVideoPorts()
HRESULT WINAPI enumvidport_callback(LPDDVIDEOPORTCAPS lpDDVideoPortCaps,
									 LPVOID lpVideoPortCaps) {

	memcpy(lpVideoPortCaps, lpDDVideoPortCaps, sizeof(DDVIDEOPORTCAPS));
	num_vidports++;
	return DDENUMRET_OK;
}

// binds already created video port to already created overlay surface
BOOL bind_video_port() {
	HRESULT ddrval;

	ddrval = lpVideoPort->SetTargetSurface(lpOverlay, DDVPTARGET_VIDEO);
	if(ddrval != DD_OK)
		return FALSE;

	return TRUE;
}

// to be called when overlay changes size
BOOL update_video() {
	HRESULT ddrval;
	DDPIXELFORMAT ddpf;
	DDVIDEOPORTINFO VideoPortInfo;
	DWORD VideoStatus;
	char *debug_str;

	memset(&ddpf, 0, sizeof(ddpf));
    ddpf.dwSize        = sizeof(DDPIXELFORMAT);
    ddpf.dwFlags       = DDPF_FOURCC;
    ddpf.dwFourCC      = MAKEFOURCC('U','Y','V','Y');
    ddpf.dwYUVBitCount = 16;

	ZeroMemory(&VideoPortInfo, sizeof(DDVIDEOPORTINFO));
	VideoPortInfo.dwSize = sizeof(DDVIDEOPORTINFO);
	VideoPortInfo.dwOriginX = 0;
	VideoPortInfo.dwOriginY = 0;
	VideoPortInfo.dwVPFlags =  0; // DDVP_PRESCALE ; // | DDVP_OVERRIDEBOBWEAVE ; 
	VideoPortInfo.dwVBIHeight = 10;
	VideoPortInfo.lpddpfInputFormat = &ddpf;
	VideoPortInfo.lpddpfVBIInputFormat = &ddpf;
	VideoPortInfo.dwPrescaleWidth = APP_INIT_WIDTH;
	VideoPortInfo.dwPrescaleHeight = APP_INIT_HEIGHT;

	ddrval = lpVideoPort->UpdateVideo(&VideoPortInfo);
	if(ddrval != DD_OK) {
		if (ddrval == DDERR_INVALIDPARAMS)
			FATAL("invalid params");
		if (ddrval == DDERR_INVALIDOBJECT)
			FATAL("invalid object");
		if (ddrval == DDERR_SURFACELOST)
			FATAL("surface lost");
		if (ddrval == DDERR_HEIGHTALIGN)
			FATAL("wrong alignment");
		if (ddrval == DDERR_GENERIC)
			FATAL("generic error");
		else
			sprintf(debug_str, "error %u", ddrval);
			FATAL(debug_str);

		return FALSE;
	}

	return TRUE;
}

void get_default_pixelformat(LPDDPIXELFORMAT lpddpf) {
	/*
	DDPIXELFORMAT ddpf;

	memset(&ddpf, 0, sizeof(ddpf));
    ddpf.dwSize        = sizeof(DDPIXELFORMAT);
    ddpf.dwFlags       = DDPF_FOURCC;
    ddpf.dwFourCC      = OVERLAY_FORMAT;
    ddpf.dwYUVBitCount = SCREEN_BITCOUNT;

	memcpy(lpddpf, &ddpf, sizeof(DDPIXELFORMAT));
*/
}
