//vidwindow.c

#include <windows.h>

#include <ddraw.h>
#include <dvp.h>
// #include <unknwn.h>

#include "main.h"
#include "vidwindow.h"
#include "vidport.h"
#include "support.h"

// this is for debug only
#include <stdio.h>

// REMINDER: Release ddraw object after exiting main function, if things go wrong

const int SCREEN_BITCOUNT  = 16;
const DWORD OVERLAY_FORMAT = MAKEFOURCC('U','Y','V','Y');

// The main window for now. holds overlay and shows video.
HWND hwndMain;

extern LPDIRECTDRAWVIDEOPORT lpVideoPort;

// our pointer to the directdraw object
LPDIRECTDRAW lpDD;

// primary surface
LPDIRECTDRAWSURFACE lpPrimary;
// overlay surface
LPDIRECTDRAWSURFACE lpOverlay; 
// clipper
LPDIRECTDRAWCLIPPER lpClipper; 

BOOL main_video_init() {

	if(!init_ddraw()) {
		FATAL("Houston we have a problem");
		return FALSE;
	}
	if(!ddraw_create_primary()) {
		FATAL("Can't create primary overlay surface");
		return FALSE;
	}

	if(!ddraw_create_overlay()) {
		FATAL("Can't create video overlay surface");
		return FALSE;
	}
	if(!ddraw_create_clipper()) {
		FATAL("FUCKING BAD LUCK HEH?? Can't create clipper, oh well...");
		return FALSE;
	}
	if(!create_video_port()) {
		FATAL("Could not create video port object");
		return FALSE;
	}
	if(!bind_video_port()) {
		FATAL("Could not bind video to overlay surface");
		return FALSE;
	}
	if(!start_video_feed()) {
		FATAL("Could not start video feed");
		return FALSE;
	}
	return TRUE;
}


// init directdraw and set cooperative mode in client window
BOOL init_ddraw() {
	HRESULT      ddrval;

	ddrval = DirectDrawCreate(NULL, &lpDD, NULL); 
	if(ddrval != DD_OK) 
		return FALSE;

	ddrval = lpDD->SetCooperativeLevel(hwndMain, DDSCL_NORMAL);
	if(ddrval != DD_OK) {
		IDirectDraw_Release(lpDD);
		return FALSE;
	}
	return TRUE;
}


// creates primary ddraw surface
BOOL ddraw_create_primary() {
	DDSURFACEDESC ddsd;
	HRESULT ddrval;
	DDCOLORKEY ddckey;

	ddsd.dwSize = sizeof(DDSURFACEDESC);
	ddsd.dwFlags = DDSD_CAPS;
	ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE;

	ddrval = lpDD->CreateSurface( &ddsd, &lpPrimary, NULL );
	if(ddrval != DD_OK) {
		IDirectDraw_Release(lpDD);
  		return FALSE;
	}

	ddckey.dwColorSpaceLowValue = KEYCOLOR;
	ddckey.dwColorSpaceHighValue = KEYCOLOR;

	ddrval = lpPrimary->SetColorKey(DDCKEY_DESTOVERLAY, &ddckey);
	if(ddrval != DD_OK) {
		IDirectDraw_Release(lpDD);
  		return FALSE;
	}

	return TRUE;
}


// creates overlay surface
BOOL ddraw_create_overlay() {
	DDSURFACEDESC ddsd;
	DDPIXELFORMAT ddpf;
	HRESULT ddrval;

	memset(&ddsd, 0, sizeof(ddsd));
	ddsd.dwSize = sizeof(ddsd);
    ddrval = lpDD->GetDisplayMode(&ddsd);
	if(ddrval != DD_OK) {
		FATAL("0005:Erro in GetDisplayMode");
		return false; }

   if(ddsd.ddpfPixelFormat.dwGBitMask == 0x03e0)
      FATAL("RGB15");
   else
      FATAL("RGB16");

	memset(&ddpf, 0, sizeof(ddpf));
    ddpf.dwSize        = sizeof(DDPIXELFORMAT);
    ddpf.dwFlags       = DDPF_FOURCC;
    ddpf.dwFourCC      = OVERLAY_FORMAT;
    ddpf.dwYUVBitCount = SCREEN_BITCOUNT;

	// Criacao do Overlay
	memset(&ddsd, 0, sizeof(ddsd));	
	ddsd.dwSize = sizeof(ddsd);
	ddsd.dwFlags =  DDSD_CAPS | 
					DDSD_HEIGHT | 
					DDSD_WIDTH | 
					DDSD_PIXELFORMAT;
	ddsd.ddsCaps.dwCaps =	DDSCAPS_OVERLAY |
							DDSCAPS_VIDEOMEMORY | 
							DDSCAPS_VIDEOPORT;

	ddsd.dwWidth = APP_INIT_WIDTH;
	ddsd.dwHeight = APP_INIT_HEIGHT;
	ddsd.ddpfPixelFormat = ddpf;

	ddrval = lpDD->CreateSurface(&ddsd, &lpOverlay, NULL);
	if( ddrval != DD_OK ) {
		IDirectDrawSurface_Release(lpPrimary);
		IDirectDraw_Release(lpDD);
		return FALSE;
	}
	return TRUE;
}


// creates clipper for our window
BOOL ddraw_create_clipper() {
	HRESULT ddrval;

	ddrval = lpDD->CreateClipper(0, &lpClipper, NULL);

	if( ddrval != DD_OK ) {
		IDirectDrawSurface_Release(lpOverlay);
		IDirectDrawSurface_Release(lpPrimary);
		IDirectDraw_Release(lpDD);
		return FALSE;
	}

	ddrval = lpClipper->SetHWnd(0, hwndMain);
	if( ddrval != DD_OK ) {
		IDirectDrawSurface_Release(lpOverlay);
		IDirectDrawSurface_Release(lpPrimary);
		IDirectDraw_Release(lpDD);
		return FALSE;
	}
	return TRUE;
}

// process WM_PAINT messages for the video overlay window
void vidwindow_paint() {
	HDC hdc; // handler to display device context;
	PAINTSTRUCT ps;
	HRESULT ddrval;
	POINT ptClient; // left top of overlay relative to video window (client area)
	DDBLTFX ddbfx; // ddraw BLT structure
	RECT rectBlt;

	// attach clipper for this operation.
	ddrval = lpPrimary->SetClipper(lpClipper);

	hdc = BeginPaint(hwndMain, &ps);

// Fill the client area with colour key 
	ptClient.x = ps.rcPaint.left;
	ptClient.y = ps.rcPaint.top;
	ClientToScreen(hwndMain, &ptClient);
	rectBlt.left = ptClient.x;
	rectBlt.top = ptClient.y;

	ptClient.x = ps.rcPaint.right;
	ptClient.y = ps.rcPaint.bottom;
	ClientToScreen(hwndMain, &ptClient);
	rectBlt.right = ptClient.x;
	rectBlt.bottom = ptClient.y;

	ddbfx.dwSize = sizeof(DDBLTFX);
	ddbfx.dwFillColor = KEYCOLOR;

	lpPrimary->Blt(	&rectBlt,
                    NULL,
                    &rectBlt,
                    DDBLT_COLORFILL | DDBLT_WAIT,
                    &ddbfx);

	EndPaint(hwndMain, &ps);

	// remove clipper
	ddrval = lpPrimary->SetClipper(NULL);
}

// update the overlay with colour keying (for WM_SIZE || WM_MOVE operations)
void vidwindow_update_overlay() {
	// window size and position
	RECT rectClient; 
	// overlay source rectangle
	RECT rectOverlay; 
	// effectx used in displaying overlay
	DDOVERLAYFX ddofx;
	DWORD dwFlags;
	HRESULT ddrval;

	// get window position
	GetWindowRect(hwndMain, &rectClient);

	SetRect(&rectOverlay, 0, 0, 320, 240);

	ddofx.dwSize = sizeof(DDOVERLAYFX);
	ddofx.dckDestColorkey.dwColorSpaceLowValue = KEYCOLOR;
	ddofx.dckDestColorkey.dwColorSpaceHighValue = KEYCOLOR;

	dwFlags = DDOVER_KEYSRC | DDOVER_SHOW | DDOVER_DDFX;

/*
	ddrval = lpOverlay->UpdateOverlay(	&rectOverlay,
										lpPrimary,
                                        &rectClient,
                                        dwFlags,
                                        &ddofx);
	if(ddrval != DD_OK) {
	// Oops - can't update overlay. Put your error handling code here.
//		FATAL("Can't update overlay!");
//		PostMessage(hwndMain, WM_CLOSE, 0, 0);
	}
	
*/
	if(!update_video()) 
		FATAL("Cant update video");

}

BOOL start_video_feed() {
/*
	HRESULT ddrval;
	DDPIXELFORMAT ddpf;
	DDVIDEOPORTINFO VideoPortInfo;

	DWORD VideoStatus;
	ddrval = lpVideoPort->GetVideoSignalStatus(&VideoStatus);
	if (VideoStatus == DDVPSQ_SIGNALOK)
		FATAL("Valid video signal found");
	if (VideoStatus == DDVPSQ_NOSIGNAL)
		FATAL("no valid signal found");

	if(ddrval == DDERR_INVALIDOBJECT)
		FATAL("FODAX");

    get_default_pixelformat(&ddpf);

	ZeroMemory(&VideoPortInfo, sizeof(DDVIDEOPORTINFO));
	VideoPortInfo.dwSize = sizeof(DDVIDEOPORTINFO);
	VideoPortInfo.dwOriginX = 0;
	VideoPortInfo.dwOriginY = 0;
	VideoPortInfo.dwVPFlags = DDVP_PRESCALE | DDVP_INTERLEAVE | DDVP_SYNCMASTER; 
	VideoPortInfo.dwVBIHeight = 10;
	VideoPortInfo.lpddpfInputFormat = &ddpf;
	VideoPortInfo.lpddpfVBIInputFormat = &ddpf;

	VideoPortInfo.dwPrescaleWidth = APP_INIT_WIDTH;
	VideoPortInfo.dwPrescaleHeight = APP_INIT_HEIGHT;

	ddrval = lpVideoPort->StartVideo(&VideoPortInfo);

	if(ddrval != DD_OK) {
		if (ddrval == DDERR_INVALIDPARAMS)
			FATAL("invalid params");
		if (ddrval == DDERR_INVALIDOBJECT)
			FATAL("invalid object");
		if (ddrval == DDERR_SURFACELOST)
			FATAL("surface lost");
		if (ddrval == DDERR_HEIGHTALIGN)
			FATAL("wrong alignment");
		if (ddrval == DDERR_GENERIC)
			FATAL("generic error");
		else
			sprintf(debug_str, "error %u", ddrval);
			FATAL(debug_str);

		return FALSE;
	}
	return TRUE;
}
*/
	
	HRESULT ddrval;
	DDPIXELFORMAT ddpf;
	DDVIDEOPORTINFO VideoPortInfo;
	DWORD VideoStatus;
	char *debug_str;

	ddrval = lpVideoPort->GetVideoSignalStatus(&VideoStatus);
	if (VideoStatus == DDVPSQ_SIGNALOK)
		FATAL("Valid video signal found");
	if (VideoStatus == DDVPSQ_NOSIGNAL)
		FATAL("no valid signal found");

	if(ddrval == DDERR_INVALIDOBJECT)
		FATAL("error: lpVideoPort->GetVideoSignalStatus");

	memset(&ddpf, 0, sizeof(ddpf));
    ddpf.dwSize        = sizeof(DDPIXELFORMAT);
    ddpf.dwFlags       = DDPF_FOURCC;
    ddpf.dwFourCC      = OVERLAY_FORMAT;
    ddpf.dwYUVBitCount = SCREEN_BITCOUNT;

	ZeroMemory(&VideoPortInfo, sizeof(DDVIDEOPORTINFO));
	VideoPortInfo.dwSize = sizeof(DDVIDEOPORTINFO);
	VideoPortInfo.dwOriginX = 0;
	VideoPortInfo.dwOriginY = 0;
	//VideoPortInfo.dwVPFlags = DDVP_PRESCALE | DDVP_INTERLEAVE | DDVP_SYNCMASTER | DDVP_OVERRIDEBOBWEAVE ; 
	VideoPortInfo.dwVPFlags =  0; // DDVP_PRESCALE ; // | DDVP_OVERRIDEBOBWEAVE ; 
	VideoPortInfo.dwVBIHeight = 10;
	VideoPortInfo.lpddpfInputFormat = &ddpf;
	VideoPortInfo.lpddpfVBIInputFormat = &ddpf;
	VideoPortInfo.dwPrescaleWidth = APP_INIT_WIDTH;
	VideoPortInfo.dwPrescaleHeight = APP_INIT_HEIGHT;

	ddrval = lpVideoPort->StartVideo(&VideoPortInfo);
	if(ddrval != DD_OK) {
		if (ddrval == DDERR_INVALIDPARAMS)
			FATAL("invalid params");
		if (ddrval == DDERR_INVALIDOBJECT)
			FATAL("invalid object");
		if (ddrval == DDERR_SURFACELOST)
			FATAL("surface lost");
		if (ddrval == DDERR_HEIGHTALIGN)
			FATAL("wrong alignment");
		if (ddrval == DDERR_GENERIC)
			FATAL("generic error");
		else
			sprintf(debug_str, "error %u", ddrval);
			FATAL(debug_str);

		return FALSE;
	}


	return true;
}

