#ifndef CCRYPT_H
#define CCRYPT_H

#include "video.h"


class VirtualDecoder
{
	public:
		VirtualDecoder(void) { }
		virtual ~VirtualDecoder() { }

		virtual void decodeFrame(unsigned char *membase, int offset, bool invert_polarity) = 0;

		const char* getDescription(void) const  { return(_description); }
		int getOutWidth(void) const { return(_outwidth); }
		int getOutHeight(void) const { return(_outheight); }

		bool useVBI(void) const { return(_use_vbi); }
		virtual bool usesMMX(void) const { return(false); }

		static void decColorBurstWidth(void) { if (_cb_width > 0)  _cb_width--; }
		static void incColorBurstWidth(void) { _cb_width++; }
		static int getColorBurstWidth(void) { return(_cb_width); }

		virtual const char* getHelp(void) const { return(NULL); }
		virtual void processKey(WPARAM key) { }

		void setHSync(int hsync) { _hsync = hsync; }
		int  getHSync(void) const { return(_hsync); }

		virtual int convertRawXToScreenX(int x) const
			{ return((x-_cb_width)*_outwidth/2268); }
		virtual int convertRawYToScreenY(int y) const { return(y); }

		virtual int convertScreenXToRawX(int x) const
			{ return((x*2268 / _outwidth) + _cb_width); }
		virtual int convertScreenYToRawY(int y) const { return(y); }

	protected:
		const char* _description;
		int _outwidth;
		int _outheight;
		bool _use_vbi;
		int _hsync;

   private:
		static int _cb_width;
};


void addDecoder(VirtualDecoder* decoder);





#define FATAL(a) error_win(a, __FILE__, __LINE__, 1)
#define LOG_ERR(a) error_win(a, __FILE__, __LINE__, 0)

void error_win(char *msg, char *file, int line, int fatal_error);


#endif
