#ifndef __CPUID_H
#define __CPUID_H

class CpuInfo {
	public:
		CpuInfo();

		const char* getInfo(void);

		int getCPUfamily(void) const
			{ return(100*_family + 86); }
		const char* getCPUvendorID(void) const
			{ return(_vendorID); }
		bool hasMMX(void) const
			{ return(_features.mmx); }

	private:
		char _family;
		char _model;
		char _stepping;
		char _vendorID[13];
		struct
		{
			unsigned char
				fpu:1,	vme:1,	de:1,	pse:1,		// 0..3
				tsc:1,  msr:1,	pae:1,	mce:1,
				cx8:1,  apic:1, __r10:1,sep:1,		// 8..11
				mtrr:1,	pge:1,	mca:1,	cmov:1,
				pat:1,	pse36:1,__r18:2,			// 16..19
				__r20:3,				mmx:1,
				fxsr:1, __r25:7;					// 24..31
		} _features;
};


#endif

