#include "rgb24decode.h"

void RGB24Decoder::decodeFrame(unsigned char *membase, int offset, bool invert_polarity)
{
	RGBTRIPLE pixels[320];

	lockDisplay();

	for (int y=0; y < 240; y++)
	{
   		for (int x = 0; x < 320; x++)
			{
      		pixels[x].rgbtBlue = membase[x*3+0];
      		pixels[x].rgbtGreen = membase[x*3+1];
      		pixels[x].rgbtRed = membase[x*3+2];
		}

		drawPixels(0, y, pixels, 320);

		membase += 320*3;
	}

	unlockDisplay();
}
