#ifndef BT_MEMMAP_H
#define BT_MEMMAP_H

#ifdef BORLAND_C

typedef struct
{
	unsigned char	sda:1,
			scl:1,
			w3b:1,
			sync:1,
			div:4;
	unsigned char	db2;
	unsigned char	db1;
	unsigned char	db0;
} I2C_t;

typedef struct
{
	unsigned char			// Device Status Register  (DSTATUS)
		cof:1,
		lof:1,
		plock:1,	// unused
		csel:1,
		numl:1,
		evenfield:1,
		hloc:1,
		pres:1;
  	char dummy1[3];
	unsigned char			// Input Format Register  (IFORM)
		format:3,
		xtsel:2,
		muxsel:2,
		hactive:1;
  	char dummy2[3];
	unsigned char			// Temporal Decimation Register  (TDEC)
		dec_rate:6,
		dec_fieldalign:1,
		dec_field:1;
  	char dummy3[3];
	unsigned char			// MSB Cropping Register  (E_CROP)
		e_hactive_msb:2,
		e_hdelay_msb:2,
		e_vactive_msb:2,
		o_vdelay_msb:2;
  	char dummy4[3];
	unsigned char			// Vertical Delay Register, Lower Byte
		o_vdelay_lo;
  	char dummy5[3];
	unsigned char			// Vertical Active Register, Lower Byte
		e_vactive_lo;
	char dummy6[3];
	unsigned char			// Horizontal Delay Register, Lower Byte
		e_hdelay_lo;
	char dummy7[3];
	unsigned char			// Horizontal Active Register, Lower Byte
		e_hactive_lo;
	char dummy8[3];
	signed char				// Horizontal Scaling Register, Upper Byte
		e_hscale_hi;
	char dummy9[3];
	unsigned char			// Horizontal Scaling Register, Lower Byte
		e_hscale_lo;
	char dummy10[3];

   char bright;         // Brightness Control Register
   char dummy11[3];
	unsigned char			// Miscellaneous Control Register  (E_CONTROL)
		e_sat_v_hi:1,
		e_sat_u_hi:1,
		e_contrast_hi:1,
		res1:1,			/* (0) res */
		e_cbsense:1,
		e_ldec:1,
		e_comp:1,
		e_lnotch:1;
   char dummy12[3];
	unsigned char			// Luma Gain Register, Lower Byte
		contrast_lo;
   char dummy13[3];
	unsigned char			// Chroma (U) Gain Register, Lower Byte
		sat_u_lo;
   char dummy14[3];
	unsigned char			// Chroma (V) Gain Register, Lower Byte
		sat_v_lo;
   char dummy15[3];
	signed char				// Hue Control Register
		hue;
   char dummy16[3];
	unsigned char			// SC Loop Control Register
		res2:3,			/* (000) res */
		e_hfilt:2,
		e_ckill:1,
		e_cagc:1,
		e_peak:1;
   char dummy17[3];
	unsigned char			// White Crush Up Register  (WC_UP)
		UPCNT:6,	// unused
		MAJS:2;		// unused
   char dummy18[3];
	unsigned char			// Output Format Register  (OFORM)
		res3:5,			/* (00000) res */
		core:2,
		range:1;
   char dummy19[3];
	unsigned char			// Vertical Scaling Register, Upper Byte  (E_VSCALE_HI)
		e_vscale_hi:5,
		e_uint:1,	// unused
		e_comb:1,
		e_vsfldalign:1;// unused
   char dummy20[3];
	unsigned char			// Vertical Scaling Register, Lower Byte
		e_vscale_lo;
   char dummy21[3];
	unsigned char			// Test Control Register
		test;
   char dummy22[3];
	char reg58;// (?)
   char dummy22b[3];
	char reg5C;
   char dummy23[3];
	unsigned char			// AGC Delay Register
		adelay;
   char dummy24[3];
	unsigned char			// Burst Delay Register
		bdelay;
   char dummy25[3];
	unsigned char			// ADC Interface Register
		crush:1,
		c_sleep:1,
		y_sleep:1,
		clk_sleep:1,
		agc_en:1,
		sync_t:1,
		res5:2;	/* (10) res */
   char dummy26[3];
	unsigned char			// Video Timing Control Register  (E_VTC)
		e_vfilt:3,
		res6:4,			/* (0000) res */
		e_hsfmt:1;	// unused
   char dummy27[3];
	int reg70;	// (?)
	int reg74;	// (?)
	unsigned char			// White Crush Down Register
		DNCNT:6,	// unused
		WCFRAME:1,	// unused
		VERTEN:1;	// unused
   char dummy27b[3];
	unsigned char			// Software Reset Register
		sreset;
   char dummy28[3];
	unsigned char			// Timing Generator Load Byte
		tglb;		//unused
   char dummy29[3];
	unsigned char			// Timing Generator Control  (TGCTRL)
		tgc_vm:1,	// unused
		gpc_ar:1,	// unused
		tgc_ai:1,	// unused
		tgcki:2,	// unused
		tgcko:2,	// unused
		res4:1;
   char dummy30[3];
	char reg88;
   char dummy31[3];
	unsigned char			// MSB Cropping Register  (O_CROP)
		o_hactive_msb:2,
		o_hdelay_msb:2,
		o_vactive_msb:2,
		e_vdelay_msb:2;
   char dummy32[3];
	unsigned char			// Vertical Delay Register, Lower Byte  (E_VDELAY_LO)
		e_vdelay_lo;
   char dummy32b[3];
	unsigned char			// Vertical Active Register, Lower Byte  (O_VACTIVE_LO)
		o_vactive_lo;
   char dummy33[3];
	unsigned char			// Horizontal Delay Register, Lower Byte  (O_HDELAY_LO)
		o_hdelay_lo;
   char dummy34[3];
	unsigned char			// Horizontal Active Register, Lower Byte  (O_HACTIVE_LO)
		o_hactive_lo;
   char dummy35[3];
	signed char				// Horizontal Scaling Register, Upper Byte  (O_HSCALE_HI)
		o_hscale_hi;
   char dummy36[3];
	unsigned char			// Horizontal Scaling Register, Lower Byte  (O_HSCALE_LO)
		o_hscale_lo;
   char dummy37[3];
	char regA8;
   char dummy38[3];
	unsigned char			// Miscellaneous Control Register  (E_CONTROL)
		o_sat_v_hi:1,
		o_sat_u_hi:1,
		o_contrast_hi:1,
		res7:1,			/* (0) res */
		o_cbsense:1,
		o_ldec:1,
		o_comp:1,
		o_lnotch:1;
   char dummy39[3];
	unsigned char			// Total Line Count Register
		vtotal_lo;
   char dummy40[3];
	unsigned char			// Total Line Count Register
		vtotal_hi:2,
		res8:6;	/* (000000) res */
   char dummy41[3];
	char regB8;
   char dummy42[3];
	char regBC;
   char dummy43[3];
	unsigned char			// SC Loop Control Register  (O_SCLOOP)
		res9:3,			/* (000) res */
		o_hfilt:2,
		o_ckill:1,
		o_cagc:1,
		o_peak:1;
   char dummy44[3];
	char regC4;
   char dummy45[3];
	char regC8;
   char dummy46[3];
	unsigned char			// Vertical Scaling Register, Upper Byte  (O_VSCALE_HI)
		o_vscale_hi:5,
		o_uint:1,	// unused
		o_comb:1,
		o_vsfldalign:1;// unused
   char dummy47[3];
	unsigned char			// Vertical Scaling Register, Lower Byte
		o_vscale_lo;
   char dummy48[3];
	unsigned char			// Color Format Register  (COLOR_FMT)
		color_even:4,
		color_odd:4;
   char dummy49[3];
	unsigned char			// Color Control Register  (COLOR_CTL)
		bswap_even:1,
		bswap_odd:1,
		wswap_even:1,
		wswap_odd:1,
		gamma:1,
		rgb_ded:1,	// unused
		color_bars:1,
		ext_frmrate:1;// unused
   char dummy50[3];
	unsigned char			// Capture Control Register  (CAP_CTL)
		capture_even:1,
		capture_odd:1,
		capture_vbi_even:1,
		capture_vbi_odd:1,
		dith_frame:1,// unused
		res10:3;	/* (000) res */
   char dummy51[3];
	unsigned char			// VBI Packet Size Register  (VBI_PACK_SIZE)
		vbi_pkt_lo;// unused
   char dummy52[3];
	unsigned char			// VBI Packet Size / Delay Register  (VBI_PACK_DEL)
		vbi_pkt_hi:1,// unused
		ext_frame:1,
		vbi_hdelay:6;// unused
   char dummy53[3];
	unsigned char			// Field Capture Counter Register  (FCAP)
		fcntr;
   char dummy54[3];
	unsigned char			// Video Timing Control Register  (O_VTC)
		o_vfilt:3,
		res11:4,			/* (0000) res */
		o_hsfmt:1;	// unused
   char dummy55[3];
	unsigned char			// PLL Reference Multiplier
		pll_f_lo;
   char dummy56[3];
	unsigned char			// PLL Reference Multiplier
		pll_f_hi;
   char dummy57[3];
	unsigned char			// Integer PLL-XCI Register
		pll_i:6,
		pll_c:1,
		pll_x:1;
   char dummy58[3];
	unsigned char			// Digital Signal Interface Register  (DVSIF)
		dvsif;
   char dummy59[3];
	unsigned int			// Interrupt Status Register  (INT_STAT)
		interruptStatus;
	unsigned int			// Interrupt Status Register  (INT_MASK)
		interruptMask;
	char reg108;	// (?)
   char dummy60[3];
	unsigned int			// GPIO and DMA Control Register  (GPIO_DMA_CTL)
		fifo_enable:1,
		risc_enable:1,
		pktp:2,		// unused
		pltp1:2,	// unused
		pltp23:2,	// unused
		res12:2,			/* (00) res */
		gpclkmode:1,// unused
		gpiomode:2,	// unused
		gpwec:1,	// unused
		gpuinti:1,	// unused
		gpuintc:1;	// unused
   char dummy61[2];
	I2C_t I2C;				//I2C Data/Control Register
	unsigned int			// RISC Program Start Address Register  (RISC_STRT_ADD)
		risc_ipc;
	unsigned int			// GPIO Output Enable Control Register  (GPIO_OUT_EN)
		gpoe:24,
      dummy62:8;
	unsigned int			// GPIO Registered Input Control  (GPIO_REG_INP)
		GPIE:24,	// unused
		res13:8;
	unsigned int			// RISC Program Counter Register
		risc_pc;
//------------------------------------------------//
	int reserved[7+8*6];
//------------------------------------------------//
	unsigned int			// GPIO Data I/O  (GPIO_DATA)
		GPData;
} BTxxx_memmap;

#else		// Microsoft C++

#define uchar unsigned char
#define uint  unsigned int

typedef struct
{
	uchar	sda:1,
			scl:1,
			w3b:1,
			sync:1,
			div:4;
	uchar	db2;
	uchar	db1;
	uchar	db0;
} I2C_t;

typedef struct
{
	uchar	cof:1,				// Device Status Register  (DSTATUS)
			lof:1,
			plock:1,
			csel:1,
			numl:1,
			evenfield:1,
			hloc:1,
			pres:1,
			__unused_00[3];
	uchar	format:3,			// Input Format Register  (IFORM)
			xtsel:2,
			muxsel:2,
			hactive:1,
			__unused_04[3];
	uchar	dec_rate:6,			// Temporal Decimation Register  (TDEC)
			dec_fieldalign:1,
			dec_field:1,
			__unused_08[3];
	uchar	e_hactive_msb:2,	// MSB Cropping Register  (E_CROP)
			e_hdelay_msb:2,
			e_vactive_msb:2,
			o_vdelay_msb:2,
			__unused_0C[3];
	uchar	o_vdelay_lo,		// Vertical Delay Register, Lower Byte
			__unused_10[3];
	uchar	e_vactive_lo,		// Vertical Active Register, Lower Byte
			__unused_14[3];
	uchar	e_hdelay_lo,		// Horizontal Delay Register, Lower Byte
			__unused_18[3];
	uchar	e_hactive_lo,		// Horizontal Active Register, Lower Byte
			__unused_1C[3];
	char	e_hscale_hi,		// Horizontal Scaling Register, Upper Byte
			__unused_20[3];
	uchar	e_hscale_lo,		// Horizontal Scaling Register, Lower Byte
			__unused_24[3];
	char	bright:8,			// Brightness Control Register
			__unused_28[3];
	uchar	e_sat_v_hi:1,		// Miscellaneous Control Register  (E_CONTROL)
			e_sat_u_hi:1,
			e_contrast_hi:1,
			__reserved0_2C_3:1,
			e_cbsense:1,
			e_ldec:1,
			e_comp:1,
			e_lnotch:1,
			__unused_2C[3];
	uchar	contrast_lo,		// Luma Gain Register, Lower Byte
			__unused_30[3];
	uchar	sat_u_lo,			// Chroma (U) Gain Register, Lower Byte
			__unused_34[3];
	uchar	sat_v_lo,			// Chroma (V) Gain Register, Lower Byte
			__unused_38[3];
	char	hue,				// Hue Control Register
			__unused_3C[3];
	uchar	__reserved0_40_0:3,	// SC Loop Control Register
			e_hfilt:2,
			e_ckill:1,
			e_cagc:1,
			e_peak:1,
			__unused_40[3];
	uchar	upcnt:6,			// White Crush Up Register  (WC_UP)
			majs:2,
			__unused_44[3];
	uchar	__reserved0_48_0:5,	// Output Format Register  (OFORM)
			core:2,
			range:1,
			__unused_48[3];
	uchar	e_vscale_hi:5,		// Vertical Scaling Register, Upper Byte  (E_VSCALE_HI)
			e_uint:1,
			e_comb:1,
			e_vsfldalign:1,
			__unused_4C[3];
	uchar	e_vscale_lo,		// Vertical Scaling Register, Lower Byte
			__unused_50[3];
	uchar	test,				// Test Control Register
			__unused_54[3];
	int		__unused_58;
	int		__unused_5C;
	uchar	adelay,				// AGC Delay Register
			__unused_60[3];
	uchar	bdelay,				// Burst Delay Register
			__unused_64[3];
	uchar	crush:1,			// ADC Interface Register
			c_sleep:1,
			y_sleep:1,
			clk_sleep:1,
			agc_en:1,
			sync_t:1,
			__reserved_68_6:2,		//10
			__unused_68[3];
	uchar	e_vfilt:3,			// Video Timing Control Register  (E_VTC)
			__reserved0_6C_3:4,
			e_hsfmt:1,
			__unused_6C[3];
	int		__unused_70;
	int		__unused_74;
	uchar	dncnt:6,			// White Crush Down Register
			wcframe:1,
			VERTEN:1,
			__unused_78[3];
	uchar	sreset,				// Software Reset Register
			__unused_7C[3];

	uchar	tglb,				// Timing Generator Load Byte
			__unused_80[3];
	uchar	tgc_vm:1,			// Timing Generator Control  (TGCTRL)
			gpc_ar:1,
			tgc_ai:1,
			tgcki:2,
			tgcko:2,
			__reserved0_84_7:1,
			__unused84[3];
	int		__unused_88;
	uchar	o_hactive_msb:2,	// MSB Cropping Register  (O_CROP)
			o_hdelay_msb:2,
			o_vactive_msb:2,
			e_vdelay_msb:2,
			__unused_8C[3];
	uchar	e_vdelay_lo,		// Vertical Delay Register, Lower Byte  (E_VDELAY_LO)
			__unused_90[3];
	uchar	o_vactive_lo,		// Vertical Active Register, Lower Byte  (O_VACTIVE_LO)
			__unused_94[3];
	uchar	o_hdelay_lo,		// Horizontal Delay Register, Lower Byte  (O_HDELAY_LO)
			__unused_98[3];
	uchar	o_hactive_lo,		// Horizontal Active Register, Lower Byte  (O_HACTIVE_LO)
			__unused_9C[3];
	char	o_hscale_hi,		// Horizontal Scaling Register, Upper Byte  (O_HSCALE_HI)
			__unused_A0[3];
	uchar	o_hscale_lo,		// Horizontal Scaling Register, Lower Byte  (O_HSCALE_LO)
			__unused_A4[3];
	int		__unused_A8;
	uchar	o_sat_v_hi:1,		// Miscellaneous Control Register  (E_CONTROL)
			o_sat_u_hi:1,
			o_contrast_hi:1,
			__reserved0_AC_3:1,
			o_cbsense:1,
			o_ldec:1,
			o_comp:1,
			o_lnotch:1,
			__unused_AC[3];
	uchar	vtotal_lo:8,		// Total Line Count Register
			__unused_B0[3];
	uchar	vtotal_hi:2,		// Total Line Count Register
			__reserved0_B4_2:6,
			__unused_B4[3];
	int		__unused_B8;
	int		__unused_BC;
	uchar	__reserved0_C0_0:2,	// SC Loop Control Register  (O_SCLOOP)
			o_hfilt:2,
			o_ckill:1,
			o_cagc:1,
			o_peak:1,
			__unused_C0[3];
	int		__unused_C4;
	int		__unused_C8;
	uchar	o_vscale_hi:5,		// Vertical Scaling Register, Upper Byte  (O_VSCALE_HI)
			o_uint:1,
			o_comb:1,
			o_vsfldalign:1,
			__unused_CC[3];
	uchar	o_vscale_lo,		// Vertical Scaling Register, Lower Byte
			__unused_D0[3];
	uchar	color_even:4,		// Color Format Register  (COLOR_FMT)
			color_odd:4,
			__unused_D4[3];
	uchar	bswap_even:1,		// Color Control Register  (COLOR_CTL)
			bswap_odd:1,
			wswap_even:1,
			wswap_odd:1,
			gamma:1,
			rgb_ded:1,
			color_bars:1,
			ext_frmrate:1,
			__unused_D8[3];
	uchar	capture_even:1,		// Capture Control Register  (CAP_CTL)
			capture_odd:1,
			capture_vbi_even:1,
			capture_vbi_odd:1,
			dith_frame:1,
			__reserved0_DC_5:3,
			__unused_DC[3];
	uchar	vbi_pkt_lo,			// VBI Packet Size Register  (VBI_PACK_SIZE)
			__unused_E0[3];
	uchar	vbi_pkt_hi:1,		// VBI Packet Size / Delay Register  (VBI_PACK_DEL)
			ext_frame:1,
			vbi_hdelay:6,
			__unused_E4[3];
	uchar	fcntr,				// Field Capture Counter Register  (FCAP)
			__unused_E8[3];
	uchar	o_vfilt:3,			// Video Timing Control Register  (O_VTC)
			__reserved0_EC_3:4,
			o_hsfmt:1,
			__unused_EC[3];
	uchar	pll_f_lo,			// PLL Reference Multiplier
			__unused_F0[3];
	uchar	pll_f_hi,			// PLL Reference Multiplier
			__unused_F4[3];
	uchar	pll_i:6,			// Integer PLL-XCI Register
			pll_c:1,
			pll_x:1,
			__unused_F8[3];
	uchar	dvsif,				// Digital Signal Interface Register  (DVSIF)
			__unused_FC[3];
	uint	interruptStatus;	// Interrupt Status Register  (INT_STAT)
	uint	interruptMask;		// Interrupt Status Register  (INT_MASK)
	int		__unused_108;
//
	uchar	fifo_enable:1,		// GPIO and DMA Control Register  (GPIO_DMA_CTL)
			risc_enable:1,
			pktp:2,
			pltp1:2,
			pltp23:2,
			__reserved0_108_8:2,
			gpclkmode:1,
			gpiomode:2,
			gpwec:1,
			gpuinti:1,
			gpuintc:1,
			__unused_10C[2];
	I2C_t I2C;					//I2C Data/Control Register
	uint	risc_ipc;			// RISC Program Start Address Register  (RISC_STRT_ADD)
	uint	gpoe:24,			// GPIO Output Enable Control Register  (GPIO_OUT_EN)
			__reserved0_118_24:8;
	uint	gpie:24,			// GPIO Registered Input Control  (GPIO_REG_INP)
			__reserved0_11C_24:8;
	uint	risc_pc;			// RISC Program Counter Register
	//
	uint	__unused_124[7 + 8*6];
	//
	uint	GPData:32;			// GPIO Data I/O  (GPIO_DATA)
} BTxxx_memmap;

#endif


#endif
