const char	*AppTitle = "Ronnys CCD V2.04, Modified Version 1.0";
#include <stdio.h>
#include <windows.h>

#include <math.h>
#include <limits.h>
#include <fcntl.h>
#include <io.h>
#include <sys/stat.h>
#include <time.h>
#include <ddraw.h>
#include <dsound.h>

#include <stdio.h>
#include <stdlib.h>

#include "cpuid.h"
#include "btxxx.h"
#include "ccrypt.h"
#include "video.h"
#include "paldecode.h"
#include "graydecode.h"
#include "rgb24decode.h"
#include "esneldecode.h"
#include "esnelmdecode.h"
#include "debugdecode.h"

#define IDM_FILE_SUBMENU_POS		0
#define IDM_DECODER_SUBMENU_POS		1
#define IDM_OPTIONS_SUBMENU_POS		2
#define IDM_HELP_SUBMENU_POS		3

#define IDM_MANUAL_INVERT			51

#define IDM_AUTO_INVERT_NONE		60
#define IDM_AUTO_INVERT_NORMAL		61
#define IDM_AUTO_INVERT_WHITE_CROSS	62

#define IDM_DECODE_MODE				100

#define IDM_AUTO_LOCK_MODE1			150
#define IDM_AUTO_LOCK_MODE2			151
#define IDM_AUTO_LOCK_MODE3			152

#define IDM_ALWAYS_ON_TOP			500
#define IDM_ASPECT_RATIO			501
#define IDM_SHOW_DEBUG				502
#define IDM_TOGGLE_FULLSCREEN		505
#define IDM_USE_DOUBLE_BUFFERING	507
#define IDM_FORCE_VSEARCH			510

#define IDM_SVIDEO					550
#define IDM_TUNER					551
#define IDM_COMPOSITE				552

#define IDM_SNAPSHOT				600
#define IDM_SNAPSHOTS				601

#define IDM_EXIT					1000
#define IDM_ABOUT					1001
#define IDM_SYSTEM_INFO				1002

#define D_PLL_FREQ					35435616


int VirtualDecoder::_cb_width = 200;

typedef struct
{
	int *LinAddr;
	int *PhysAddr;
	int size;
	int __reserved;
} MEMBLK;						// physical memory block structure


/*
 dynamically load PHYSMEM, do Ioctl call and close handle
*/
bool PhysmemIoctl( int dwIoControlCode, void *lpInBuffer, int nInBufferSize,
                   void *lpOutBuffer, int nOutBufferSize )
{
	unsigned long  nBytesReturned=0;
	bool result;

	HANDLE hVxD = CreateFile( "\\\\.\\PHYSMEM.VXD", 0,0,0,0, FILE_FLAG_DELETE_ON_CLOSE, 0 );

	if (hVxD == INVALID_HANDLE_VALUE)
	{
		FATAL( "Couldn't load PHYSMEM VxD" );
	}
	result = DeviceIoControl( hVxD, dwIoControlCode, lpInBuffer, nInBufferSize,
							  lpOutBuffer, nOutBufferSize, &nBytesReturned, 0 );
	CloseHandle( hVxD );
	return( result );
}

/*
 allocate physical memory (RAM), returns physical and linear address
*/
void allocMemBlk( MEMBLK *lpMB )
{
	if (!PhysmemIoctl( 2, &lpMB->size, 4, lpMB, 8 ))
	{
		FATAL( "Couldn't allocate physical memory buffer" );
	}
}

/*
 free physical memory block
*/
void freeMemBlk( MEMBLK *lpMB )
{
	PhysmemIoctl( 3, &lpMB->LinAddr, 4, NULL, 0 );

	lpMB->LinAddr = NULL;
	lpMB->PhysAddr = NULL;
	lpMB->size = 0;
}

/*
 map device I/O memory into linear (paged) memory
*/
void mapMemBlk( MEMBLK *lpMB )
{
	if (!PhysmemIoctl( 1, &lpMB->PhysAddr, 8, &lpMB->LinAddr, 4 ))
	{
		lpMB->LinAddr = NULL;
	}
}

static const char* getCFKey(const char* section, const char* key,
const char* default_value, bool create_if_not_found);
static unsigned long getCFKey(const char* section, const char* key,
unsigned long default_value, bool create_if_not_found);
static bool getCFKeyBool(const char* section, const char* key,
bool default_value, bool create_if_not_found);


static void setCFKey(const char* section, const char* key, const char* value);
static void setCFKey(const char* section, const char* key, unsigned long value);
static void setCFKeyBool(const char* section, const char* key, bool value);
static HMENU createMenu(void);


HWND				hWnd;				// surface window
HMENU				g_hMenu;

static bool isWindowed;
static BTxxx* bt = 0;
static CpuInfo* cpu_info = 0;
static bool man_pol_invert = false;
static bool debug_mode = false;
static bool test_toggled = false;
static bool lock_it = false;
static int lock_pll;
static int signal_source;
static int hsync_extra;
static bool stop_decoder = false;

static bool vsync_change_busy = false;
static bool vsync_search_forced = false;

bool always_on_top = true;
bool aspect_ratio = true;
bool use_double_buffering = true;

static long show_help_timeout;

static long next_save_bmp_time = LONG_MAX;
static long save_bitmap_delay;


static VirtualDecoder* decoders[50];
static int nbr_decoders = 0;
static VirtualDecoder* active_decoder = NULL;
static int active_decoder_index = -1;

static LPDIRECTSOUND lpds = NULL;
static LPDIRECTSOUNDBUFFER lpDsb;

void addDecoder(VirtualDecoder* decoder)
{
	if (nbr_decoders >= 50)
   	return;
	decoders[nbr_decoders++] = decoder;
}

void deleteDecoders(void)
{
	for (int t = 0; t < nbr_decoders; t++)
	{
		delete decoders[t];
	}
}


static char* lock_modes[3] = { "Off", "Default", "Start Of Image" };
static int auto_lock_mode = 1;

static int norm_pll_freq = 35468934;
static int dec_pll_freq =  D_PLL_FREQ;		

static int nbr_vsync_errors = 100;

#define POL_CHECK_BUF_SIZE 300
static char* auto_pol_mode_descr[3] = { "Off", "Default", "White cross" };
static int auto_pol_mode = 0;	// 0 OFF 1 LINE 2 +
static int pol_check_buf[POL_CHECK_BUF_SIZE];
static int pol_check_head = 0;
static int pol_check_level = 0;
static bool polarity_invert = false;

static struct
{
	int x;
	int y;
	int level;
} pol_param[3] = { { 0, 0, 0}, { 1631+374, -1, 4}, { -55+374, 29, 30 }};

static bool pol_debug_mode = false;

static bool decode_sound= false;

MEMBLK				framebuf = { NULL, NULL, 	675*1024 };	// single-frame-buffer
MEMBLK				myProg   = { NULL, NULL,   2*7*1024 };	// RISC video program

static unsigned char* raw_data_buf;

static void buildRisc(void);

static void setModeRGB24(void);
static void storeFrameRGB24(unsigned char *membase);

static void setModeRaw(void);
static void findLockDefault(unsigned char *membase, int &v_offset, int &h_offset);
static void findLockStartOffImage(unsigned char *membase, int &v_offset, int &h_offset);

static void findPolarity(unsigned char *membase, int v_offset, int h_offset);

static void writeBMP(void);

static BOOL initSound(void);
static void exitSound(void);
static BOOL writeSound(LPBYTE lpbSoundData, DWORD dwSoundBytes);


static void setDecodeMode(int new_mode)
{
	while(true)
	{
		if (new_mode < 0 || new_mode >= nbr_decoders)
			new_mode = 0;

		if (decoders[new_mode]->usesMMX() && !cpu_info->hasMMX())
			new_mode++;	// Volgende nemen
		else
			break;
	}

	active_decoder = decoders[new_mode];
	active_decoder_index = new_mode;

	vsync_change_busy = false;		// TODO ???????????,

	clearDisplay();
	if (bt->getType() != 0)
	{
   		if (active_decoder->useVBI())
		{
   	 		setModeRaw();
		}
		else      
   		{
     		setModeRGB24();
		}
	}

	DdrawsetSrcSize(active_decoder->getOutWidth(),active_decoder->getOutHeight());

	for (int t = 0; t < nbr_decoders; t++)
	{
		CheckMenuItem(g_hMenu, IDM_DECODE_MODE+t, 
		  (decoders[t]==active_decoder)?MFS_CHECKED:MFS_UNCHECKED);
	}
}


LRESULT CALLBACK WindowProc( HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam )
{
	switch (msg)
	{
		case WM_SIZE:
		case WM_MOVE:
			if (isWindowed)
			{
				DdrawWindowChanged();
	      		if (!use_double_buffering)
   	      			DdrawsetSrcSize(-1,-1);
			}
      		break;

		case WM_EXITSIZEMOVE:
			if (isWindowed && aspect_ratio)
			{
				DdrawCheckAspectRatio();
				return(0L);
			}
      		break;

		case WM_PAINT:
			if (isWindowed)
	        	DdrawCopyBackToFront();
      		break;

		case WM_LBUTTONDOWN:
			if (pol_debug_mode && auto_pol_mode == 2)// && (wParam & MK_LBUTTON))
			{
				int xpos = LOWORD(lParam); 
				int ypos = HIWORD(lParam);
				DdrawTranslateToSrcRect(xpos, ypos);
				pol_param[auto_pol_mode].x = active_decoder->convertScreenXToRawX(xpos);
				pol_param[auto_pol_mode].y = active_decoder->convertScreenYToRawY(ypos);
			}
			break;

		case WM_COMMAND:
      		switch (LOWORD(wParam))
			{
				case IDM_AUTO_INVERT_NONE:
				case IDM_AUTO_INVERT_NORMAL:
				case IDM_AUTO_INVERT_WHITE_CROSS:
					{
               			auto_pol_mode = LOWORD(wParam)-IDM_AUTO_INVERT_NONE;
						for (int t = 0; t < 3; t++)
							CheckMenuItem(g_hMenu, IDM_AUTO_INVERT_NONE+t,
				        	  (t==auto_pol_mode)?MFS_CHECKED:MFS_UNCHECKED);
					}
					return 0L;

				case IDM_AUTO_LOCK_MODE1:
				case IDM_AUTO_LOCK_MODE2:
				case IDM_AUTO_LOCK_MODE3:
            		{
           				auto_lock_mode = LOWORD(wParam)-IDM_AUTO_LOCK_MODE1;
  						for (int t = 0; t < 3; t++)
							CheckMenuItem(g_hMenu, IDM_AUTO_LOCK_MODE1+t,
				        	  (t==auto_lock_mode)?MFS_CHECKED:MFS_UNCHECKED);
					}
            		return 0L;

				case IDM_MANUAL_INVERT:
           			man_pol_invert = !man_pol_invert;
        			CheckMenuItem(g_hMenu, IDM_MANUAL_INVERT,
					  (man_pol_invert)?MFS_CHECKED:MFS_UNCHECKED);
            		return 0L;

				case IDM_TOGGLE_FULLSCREEN:
            		isWindowed = !isWindowed;
					DdrawChangeCoopLevel(isWindowed);
            		return 0L;

				case IDM_ALWAYS_ON_TOP:
           			always_on_top = !always_on_top;
					if (!use_double_buffering)
               			always_on_top = true;
        				CheckMenuItem(g_hMenu, IDM_ALWAYS_ON_TOP,
							(always_on_top)?MFS_CHECKED:MFS_UNCHECKED);
						DdrawsetSrcSize(-1, -1);
            		return 0L;

				case IDM_USE_DOUBLE_BUFFERING:
           			use_double_buffering = !use_double_buffering;
        			CheckMenuItem(g_hMenu, IDM_USE_DOUBLE_BUFFERING,
						(use_double_buffering)?MFS_CHECKED:MFS_UNCHECKED);
					// Always on top eventueel aanzetten
            		if (!use_double_buffering && !always_on_top)
	              		WindowProc(hwnd, WM_COMMAND, IDM_ALWAYS_ON_TOP, 0);
					DdrawsetSrcSize(-1, -1);               
            		return 0L;

				case IDM_ASPECT_RATIO:
           			aspect_ratio = !aspect_ratio;
        			CheckMenuItem(g_hMenu, IDM_ASPECT_RATIO,
						(aspect_ratio)?MFS_CHECKED:MFS_UNCHECKED);
					if (aspect_ratio)
						DdrawCheckAspectRatio();
            		return 0L;

				case IDM_SHOW_DEBUG:
            		debug_mode = !debug_mode;
        			CheckMenuItem(g_hMenu, IDM_SHOW_DEBUG,
						(debug_mode)?MFS_CHECKED:MFS_UNCHECKED);
            		return 0L;

				case IDM_FORCE_VSEARCH:
					vsync_search_forced = true;
            		return 0L;

         		case IDM_SYSTEM_INFO:
            		{
               			char buf[500];

						sprintf(buf, "%s chip found\n\n%s", 
							bt->getTypeName(), cpu_info->getInfo());
	         				MessageBox(hwnd, buf, "System Info",
        					MB_OK | MB_ICONINFORMATION | MB_APPLMODAL );
					}
					return 0L;

         		case IDM_ABOUT:
         			MessageBox(hwnd,
						"Ronnys CableCrypt Decoder\r\r"
						"Latest version at http://esnel.op.het.net/\r"
						"\rEmail: roncrypt@yahoo.com\r"
						"\rModified Version 1.0", "About ...",
        				MB_OK | MB_ICONINFORMATION | MB_APPLMODAL );
					return 0L;

				case IDM_SNAPSHOT:
					writeBMP();
            		break;

				case IDM_SNAPSHOTS:
            		if (next_save_bmp_time == LONG_MAX)
               			next_save_bmp_time = 0l;
					else
						next_save_bmp_time = LONG_MAX;
        			CheckMenuItem(g_hMenu, IDM_SNAPSHOTS,
						(next_save_bmp_time==0l)?MFS_CHECKED:MFS_UNCHECKED);
            		break;

				case IDM_SVIDEO:
           				CheckMenuItem(g_hMenu, IDM_SVIDEO,MFS_CHECKED);
           				CheckMenuItem(g_hMenu, IDM_TUNER,MFS_UNCHECKED);
           				CheckMenuItem(g_hMenu, IDM_COMPOSITE,MFS_UNCHECKED);
						signal_source = VIDEO_SVIDEO;
						bt->setVideoSource( signal_source );
            		return 0L;

				case IDM_TUNER:
           				CheckMenuItem(g_hMenu, IDM_SVIDEO,MFS_UNCHECKED);
           				CheckMenuItem(g_hMenu, IDM_TUNER,MFS_CHECKED);
           				CheckMenuItem(g_hMenu, IDM_COMPOSITE,MFS_UNCHECKED);
						signal_source = VIDEO_TUNER;
						bt->setVideoSource( signal_source );
            		return 0L;

				case IDM_COMPOSITE:
           				CheckMenuItem(g_hMenu, IDM_SVIDEO,MFS_UNCHECKED);
           				CheckMenuItem(g_hMenu, IDM_TUNER,MFS_UNCHECKED);
           				CheckMenuItem(g_hMenu, IDM_COMPOSITE,MFS_CHECKED);
						signal_source = VIDEO_COMPOSITE;
						bt->setVideoSource( signal_source );
            		return 0L;

				case IDM_EXIT:
            		PostMessage(hWnd, WM_CLOSE, 0, 0);
					return 0L;

				default:
            		if (LOWORD(wParam) >= IDM_DECODE_MODE &&
						LOWORD(wParam) < IDM_DECODE_MODE + nbr_decoders)
					{
						setDecodeMode(LOWORD(wParam)-IDM_DECODE_MODE);
						return 0L;
					}
            		break;
			}
			break;

		case WM_KEYDOWN:
			switch (wParam)
			{
				case VK_LEFT:
            		if (GetKeyState(VK_SHIFT) & 0xFF00)
					{
	            		if (pol_param[auto_pol_mode].x > -200) pol_param[auto_pol_mode].x--;
					}
					else
					{
						bt->setPllFrequency(dec_pll_freq - 20);  // was 20
   						dec_pll_freq = bt->getPllFrequency();
					}
					break;

				case VK_RIGHT:
            		if (GetKeyState(VK_SHIFT) & 0xFF00)
					{
	            		if (pol_param[auto_pol_mode].x < 2200) pol_param[auto_pol_mode].x++;
					}
					else
					{
						bt->setPllFrequency(dec_pll_freq + 20);   // was 20
   						dec_pll_freq = bt->getPllFrequency();
					}
					break;
				
				case VK_UP:
            		if (GetKeyState(VK_SHIFT) & 0xFF00)
					{
	            		if (pol_param[auto_pol_mode].level > 0) pol_param[auto_pol_mode].level--;
					}
					else
					{
						if (bt->getType() == BT878 || bt->getType() == BT879)
						{
							bt->setVerticalTotal(bt->getVerticalTotal()+1);
						}
						else
						{
							bt->setPllFrequency(dec_pll_freq - 56700);
	   						dec_pll_freq = bt->getPllFrequency();
						}
					}
					break;
				
				case VK_DOWN:
            		if (GetKeyState(VK_SHIFT) & 0xFF00)
					{
	            		if (pol_param[auto_pol_mode].level < 100) pol_param[auto_pol_mode].level++;
					}
					else
					{
						if (bt->getType() == BT878 || bt->getType() == BT879)
						{
							bt->setVerticalTotal(bt->getVerticalTotal()-1);
						}
						else
						{
							bt->setPllFrequency(dec_pll_freq + 56700);
	   						dec_pll_freq = bt->getPllFrequency();
						}
					}
					break;

				case VK_RETURN:
				case VK_SPACE:
              		WindowProc(hwnd, WM_COMMAND, IDM_TOGGLE_FULLSCREEN, 0);
					break;

				case VK_F1:
				case 'H':
					{
						long now = time(0);
						if (show_help_timeout < now)
            				show_help_timeout = now + 10;
						else
							show_help_timeout = 0l;
					}
					break;

				case VK_F2:
            		if (GetKeyState(VK_SHIFT) & 0xFF00)
						setDecodeMode(--active_decoder_index);
					else
               			setDecodeMode(++active_decoder_index);
					break;

	            case VK_F4:
			        WindowProc(hwnd, WM_COMMAND, IDM_MANUAL_INVERT, 0);
					break;

				case VK_F5:
            		hsync_extra--;
					break;

				case VK_F6:
					hsync_extra++;
					break;

				case VK_F7:
            		VirtualDecoder::decColorBurstWidth();
					break;

				case VK_F8:
            		VirtualDecoder::incColorBurstWidth();
					break;

				case VK_F9:
            		if (GetKeyState(VK_SHIFT) & 0xFF00)
						WindowProc(hwnd, WM_COMMAND, IDM_SNAPSHOTS, 0);
					else
						WindowProc(hwnd, WM_COMMAND, IDM_SNAPSHOT, 0);
					break;

				case VK_F11:
            		pol_debug_mode = !pol_debug_mode;
					break;

				case VK_F12:
					WindowProc(hwnd, WM_COMMAND, IDM_SHOW_DEBUG, 0);
					break;

				case 'T':
            		if (test_toggled)
					{
						bt->setTest(1);test_toggled=false;
					}
					else
					{
						bt->setTest(239);test_toggled=true;
					}
					break;

				case 'I':
					dec_pll_freq = D_PLL_FREQ;
					bt->setPllFrequency(dec_pll_freq);
					break;

				case 'L':
           			lock_it = !lock_it;
					lock_pll = bt->getPllFrequency();
					break;

				case 'S':
					{
					bt->setAudioSource((bt->getAudioSource() == AUDIO_MUTE) ? AUDIO_TUNER : AUDIO_MUTE );
            		break;
					}

				case 'D':
					decode_sound = !decode_sound;
					if( decode_sound )
					{
						if( lpds == NULL )
						{
							if( !initSound() )
							{
								decode_sound = false;
							}
						}
					}
					break;

				case 'R':
            		writeBMP("rawdata.bmp", raw_data_buf, 2268, 300);
					break;

				case 'F':
            		stop_decoder = !stop_decoder;
					break;


				case VK_ESCAPE:
					PostQuitMessage( 0 );
					return(0);

				default:
					active_decoder->processKey(wParam);
					break;
			}
			break;

		case WM_DESTROY:
			PostQuitMessage( 0 );
			return(0);
	}
	return DefWindowProc( hwnd, msg, wParam, lParam );
}


static void adjustPLL(int v_offset, int h_offset)
{
	static int last_h_offset;
	static int vertical_total = bt->getVerticalTotal();

	if (auto_lock_mode == 1 &&
     (v_offset < -2 || v_offset > 2 || vsync_search_forced))
	{
   		if (vsync_search_forced)
		{
      		vsync_search_forced = false;
      		nbr_vsync_errors = 1000;
			vsync_change_busy = false;
		}

   		if (++nbr_vsync_errors < 30)
      		return;

		if (!vsync_change_busy)
		{
			vsync_change_busy = true;
			if (bt->getType() == BT878 || bt->getType() == BT879)
				bt->setVerticalTotal(vertical_total + 1);
			else
				bt->setPllFrequency(dec_pll_freq - 56700);
		}
     	return;
	}

	nbr_vsync_errors = 0;
	if (vsync_change_busy)
	{
		vsync_change_busy = false;
		if (bt->getType() == BT878 || bt->getType() == BT879)
			bt->setVerticalTotal(vertical_total);
		else
    		bt->setPllFrequency(dec_pll_freq);
	}

	int step = (abs(h_offset) > 100)?100:10;
	// Fine tuning (left <-> right)
	if (h_offset > 0)
	{
		// dec_pll_freq kleiner maken
		if (h_offset >= last_h_offset)	// Nog niet beter ?
       		dec_pll_freq -= step;
  	}
	else if (h_offset < 0)
	{	
  		// dec_pll_freq groter maken
		if (h_offset <= last_h_offset)	// Nog niet beter ?
			dec_pll_freq += step;
	}
	else
  	{
   		dec_pll_freq = bt->getPllFrequency();
	}

	if (auto_lock_mode == 2)
	{	
   		if (!lock_it)
      		return;

  		if (dec_pll_freq > lock_pll + 20)
	      	dec_pll_freq = lock_pll + 20;
     	else if (dec_pll_freq < lock_pll - 20)
		  	dec_pll_freq = lock_pll - 20;
	}

	bt->setPllFrequency(dec_pll_freq);

	last_h_offset = h_offset;
}


int WINAPI WinMain( HINSTANCE hInst, HINSTANCE hPrev, LPSTR szCmdLine, int sw )
{
	MSG msg;

	cpu_info = new CpuInfo();
	bt = new BTxxx();

	allocMemBlk( &myProg );				// allocate RAM for RISC programs
	allocMemBlk( &framebuf );			// allocate RAM for frame buffer
	raw_data_buf = (unsigned char*)malloc(675*1024);
	signal_source = VIDEO_TUNER; //COMPOSITE

	if (bt->getType() != 0)
	{
		bt->softwareReset();
   		Sleep(100);
		bt->scalerInit();
		bt->setCrystal( XT0 );					// base for PLL or XT1 for BT848
		bt->setPllFrequency(norm_pll_freq);
		bt->setPllEnabled(true);				// enable PLL
		bt->setVideoSource( signal_source );				// select tvtuner
		bt->setVideoFormat( VIDEOFORMAT_PAL_BDGHI );		// set PAL video
		bt->setComponentVideo( false );				// PAL is composite
		bt->setDropEvenField( true );			// align fields
		bt->setDropRate(0);								// don't drop any frames
		bt->setAnalogWindow( 190, 914, 2, 622 );// setup scaler
		bt->setFieldSize(320, 240);
	}

	/*
	** Read config file
	*/
	dec_pll_freq = getCFKey("GENERAL", "DEC_PLL_FREQ", D_PLL_FREQ, true);
	active_decoder_index = getCFKey("GENERAL", "DECODE_MODE", (unsigned long)0, true);
	auto_pol_mode = getCFKey("GENERAL", "AUTO_POLARITY_MODE", (unsigned long)1, true);
	if (auto_pol_mode < 0 || auto_pol_mode > 2)
   		auto_pol_mode = 1;
	man_pol_invert = getCFKeyBool("GENERAL", "MANUAL_POLARITY_INVERT", false, true);
	auto_lock_mode = getCFKey("GENERAL", "AUTO_LOCK_MODE", 1, true);
	always_on_top = getCFKeyBool("GENERAL", "ALWAYS_ON_TOP", true, true);
	aspect_ratio = getCFKeyBool("GENERAL", "ASPECT_RATIO", true, true);
	use_double_buffering = getCFKeyBool("GENERAL", "USE_DOUBLE_BUFFERING", true, true);

	save_bitmap_delay = getCFKey("GENERAL", "SNAPSHOTS_DELAY", (unsigned long)1, true);
	if (save_bitmap_delay < 0)
   		save_bitmap_delay = 1;

	for (int t = 0; t < POL_CHECK_BUF_SIZE; t++)
		pol_check_buf[t] = -1;

	// register Window class
	WNDCLASS wc;
	memset(&wc, 0, sizeof(wc));
	wc.lpszClassName = AppTitle;
	wc.lpfnWndProc = WindowProc;
	wc.style = CS_VREDRAW | CS_HREDRAW;
	wc.hInstance = hInst;
	//wc.hIcon = LoadIcon(hInst, MAKEINTRESOURCE(IDI_MAIN_ICON));
	wc.hCursor = LoadCursor(NULL, IDC_ARROW);
	wc.hbrBackground = (HBRUSH) (COLOR_WINDOW + 1);
	//wc.lpszMenuName = MAKEINTRESOURCE(IDR_MENU);
	wc.cbClsExtra = 0;
	wc.cbWndExtra = 0;
	RegisterClass(&wc);
	
	hWnd = CreateWindowEx( 0,
		AppTitle,
		AppTitle,
		WS_OVERLAPPEDWINDOW,
		CW_USEDEFAULT,
		CW_USEDEFAULT,
		10,
		10,
		NULL,
		NULL,
		hInst,
		NULL);

//	initSound();

	/*
	** Decoder objecten aanmaken
	*/
	addDecoder(new EsnelMMXDecoder());
	addDecoder(new EsnelDecoder());
	addDecoder(new PalColorDecoder());
	addDecoder(new PalGrayDecoder());
	addDecoder(new AveragingDecoder());
	addDecoder(new FastAveragingDecoder());
	addDecoder(new DebugDecoder());   
	addDecoder(new RGB24Decoder());

	g_hMenu = createMenu();
	SetMenu(hWnd, g_hMenu);

	char errorbuf[500];
	if (initDdraw(hWnd, errorbuf) < 0)
   		FATAL(errorbuf);
	isWindowed = true;

	setDecodeMode(active_decoder_index);

	ShowWindow(hWnd, sw);
	UpdateWindow(hWnd);

	// message loop
	while( true )
	{
		if (PeekMessage( &msg, NULL, 0, 0, PM_REMOVE ))
		{
			if (msg.message == WM_QUIT)
				break;

			TranslateMessage( &msg );
			DispatchMessage( &msg );
		}
		else if (bt->getType() != 0)
		{	
	      	static int prevFrame = -1;
			int curFrame = bt->getFieldCount();
			if (curFrame != prevFrame && bt->isDecodeEvenField())
			{
         		static int fps, cfps;
				static long last_time;
           		int v_offset = 0;
           		int h_offset = 0;
				bool invert=false;

				__int64 start_microsec;
				if (debug_mode)
					start_microsec = getMicroSec();

				prevFrame = curFrame;
				
				if( !stop_decoder )
					memcpy(raw_data_buf, framebuf.LinAddr, 675*1024);

				// Clear the back buffer
				clearDisplay();

				cfps++;
				long tijd= time(0);
				if (tijd != last_time)
				{
            		last_time = tijd;
					fps = cfps;
					cfps = 0;
				}

				if (active_decoder->useVBI())
				{
            		switch (auto_lock_mode)
					{
               			case 1:
							findLockDefault(raw_data_buf, v_offset, h_offset);
							break;
						case 2:
							findLockStartOffImage(raw_data_buf, v_offset, h_offset);
							if (!lock_it)
                     			h_offset = 0;
							break;
					}

					if (auto_pol_mode == 1)
					{
  						// De lijntjes staan onderaan, dus dit is van het volgende beeld
         	     		invert = polarity_invert;
					}

					adjustPLL(v_offset, h_offset);

					if(auto_pol_mode != 0) 
						findPolarity(raw_data_buf, v_offset, h_offset);

					if (auto_pol_mode == 2)
					{
                 		// Witte kruis
         	     		invert = polarity_invert;
					}

					if (man_pol_invert)
	   	       			invert = !invert;

					if (decode_sound)
					{
						unsigned char buf[100];

						unsigned char* p = raw_data_buf+2090+h_offset;

						for (int y = 0; y < 100; y++)
						{
							unsigned char d = 0;
							for (int t = 0; t < 8; t++)
								if (*(p+t)>20)
									d |= (1<<t);
							buf[y] = d;
							p+=2268;
						}
						writeSound(buf, 100);
					}
				}

				active_decoder->decodeFrame(raw_data_buf, h_offset+2268, invert);

	            if (tijd >= next_save_bmp_time)
		        {
			    	next_save_bmp_time = tijd + save_bitmap_delay;
					writeBMP();
				}

				if (auto_lock_mode == 1 && vsync_change_busy)
				{
            		drawText(0,0,"Searching vertical lock, please wait ...",
						RGB(0,0,255));
				}
				else if (auto_lock_mode == 2 && !lock_it)
				{
		      		drawText(0,0,"Adjust the image position and\n"
						"press 'L' to start locking ...",
     					RGB(0,0,255));

	               if (active_decoder->getHSync() != -1)
		           {
						int x = active_decoder->convertRawXToScreenX(active_decoder->getHSync());
						if (x >= 0 || x < active_decoder->getOutWidth())
                  		for (int y = 0; y < active_decoder->getOutHeight(); y+=2)
                     		putPixel(x,y,0,0,255);
					}
				}

				if (tijd < show_help_timeout)
				{
            		char helpbuf[500] = "ActiveDecoder keys:\n";
					if (active_decoder->getHelp())
               			strcat(helpbuf, active_decoder->getHelp());
					else
		               	strcat(helpbuf, "  <None>");

			    	drawText(10, 30, helpbuf, RGB(0, 0, 200));
				}
				else if (debug_mode)
				{
					__int64 stop_microsec = getMicroSec();
					int diff_microsec = stop_microsec - start_microsec;

              		char buf[500];
					sprintf(buf,
						"FPS %02d (%d microsec/frame)\n"
						"Voffset %d Hoffset %d (hsync %d)\n"
						"%sPolLevel %d\n"
						"PLL %d\n"
						"cb_width %d hsync_extra %d",
						fps, diff_microsec,
						v_offset, h_offset, active_decoder->getHSync(),
						(invert)?"Inverted ":"",
						pol_check_level, dec_pll_freq,
						VirtualDecoder::getColorBurstWidth(), hsync_extra);
						drawText(10, 30, buf, RGB(0, 0, 200));
      			}

				if (pol_debug_mode)
		   		{
					int t = pol_check_head;
					int x = 50;
					do
					{
	   					putPixel(x, pol_param[auto_pol_mode].level + 100, 0, 0, 255);
						int y = pol_check_buf[t];
						if (y >= 0 && y < 400)
						{
							if (y <= pol_param[auto_pol_mode].level)
			   					putPixel(x, y + 100, 0,255,0);
							else
                     			putPixel(x, y + 100, 255,0,0);
						}
						x++;
						if (++t >= POL_CHECK_BUF_SIZE)
                  			t = 0;
					}
					while (t != pol_check_head);

					if (auto_pol_mode != 0)
					{
               			int x, y;

						if (auto_pol_mode == 2)
						{
							y = active_decoder->convertRawYToScreenY(pol_param[auto_pol_mode].y);
   							for (x = 0; x < active_decoder->getOutWidth(); x+=2)
      	            			putPixel(x,y,255,255,255);
						}
						x = active_decoder->convertRawXToScreenX(h_offset + pol_param[auto_pol_mode].x);
						for (y = 0; y < active_decoder->getOutHeight(); y+=2)
                  			putPixel(x,y,255,255,255);
					}
				}

				DdrawCopyBackToFront();
			}
		}
		else
		{
      		static int y = 10;
			static int dir = 1;

			y += dir;
			if (y < 10 || y > 170)
         		dir = -dir;

	   		clearDisplay();
	   		drawText(30, y,
        	  "No valid BTxxx Chip found !\r\r"
        	  "This program supports BT848,\r"
        	  "BT849, BT878 and BT879 chip\r"
        	  "based capture cards.",
        	  RGB(255, 20, 20));
			DdrawCopyBackToFront();
			Sleep(10);
   		}
	}

	deleteDecoders();

	uninitDdraw();

	/*
	** Config file bijwerken
	*/
	setCFKey("GENERAL", "DEC_PLL_FREQ", dec_pll_freq);
	setCFKey("GENERAL", "DECODE_MODE", active_decoder_index);
	setCFKey("GENERAL", "AUTO_POLARITY_MODE", auto_pol_mode);
	setCFKeyBool("GENERAL", "MANUAL_POLARITY_INVERT", man_pol_invert);
	setCFKey("GENERAL", "AUTO_LOCK_MODE", auto_lock_mode);
	setCFKeyBool("GENERAL", "ALWAYS_ON_TOP", always_on_top);
	setCFKeyBool("GENERAL", "ASPECT_RATIO", aspect_ratio);
	setCFKeyBool("GENERAL", "USE_DOUBLE_BUFFERING", use_double_buffering);
	setCFKey("GENERAL", "SNAPSHOTS_DELAY", save_bitmap_delay);

	if (bt->getType() != 0)
	{
		bt->setPllFrequency(norm_pll_freq);
   		bt->setTest(1);test_toggled = false;
		bt->setVerticalTotal( 1 );		// disable vertical total
		bt->setCaptureEnabled( false );	// disable capture of both fields
		bt->setFifoEnabled( false );	// disable FIFO unit
		bt->setRiscEnabled( false );	// disable RISC unit
	}

	delete bt;

	freeMemBlk( &myProg );
	freeMemBlk( &framebuf );

	if (raw_data_buf)
		free(raw_data_buf);

	exitSound();

	return(0);
}


/*
 Error handler

 display message and file, line where the error occured.
*/
void error_win(char *msg, char *file, int line, int FATAL)
{
	if (file)
	{
		char errout[512];
		sprintf( errout, "Error (%s line %d): %s\n", file, line, msg );
		msg = errout;
	}

	ShowCursor(true);
	uninitDdraw();

	MessageBox( NULL, msg, AppTitle, MB_OK | MB_ICONEXCLAMATION | MB_APPLMODAL );

   if (FATAL)
   {
		if (hWnd)
  			DestroyWindow( hWnd );
		ExitProcess(1);		// Win32's exit()
   }
}


static void setModeRGB24(void)
{
	int i, membase, PC, lus;

	bt->setCaptureEnabled( false );				// disable capture
	bt->setFifoEnabled( false );	// disable FIFO unit
	bt->setRiscEnabled( false );	// disable RISC unit

	bt->setColorFormat(COLORFORMAT_RGB24);	// output format is RAW samples
  	bt->setPllFrequency(norm_pll_freq);
	bt->setTest(1);test_toggled = false;

	membase = (int) framebuf.PhysAddr;
	lus = PC = 0;

	myProg.LinAddr[ PC++ ] = RISC_SYNC(RISC_RESYNC, RISC_SC_VRE);
	myProg.LinAddr[ PC++ ] = 0;
	myProg.LinAddr[ PC++ ] = RISC_SYNC(0, RISC_SC_FM1);
	myProg.LinAddr[ PC++ ] = 0;
	for (i=0; i < 240; i++)
	{
		myProg.LinAddr[ PC++ ] = RISC_WRITE(RISC_SOL|RISC_EOL , 320*3);
		myProg.LinAddr[ PC++ ] = membase;
		membase += 320*3;
	}
/*
	myProg.LinAddr[ PC++ ] = RISC_SYNC(RISC_RESYNC, RISC_SC_VRO);
	myProg.LinAddr[ PC++ ] = 0;
	myProg.LinAddr[ PC++ ] = RISC_SYNC(0, RISC_SC_FM1);
	myProg.LinAddr[ PC++ ] = 0;
	for (i=0; i < 240; i++)
	{
		myProg.LinAddr[ PC++ ] = RISC_WRITE(RISC_SOL|RISC_EOL , 320*3);
		myProg.LinAddr[ PC++ ] = membase;
		membase += 320*3;
	}
*/
	myProg.LinAddr[ PC++ ] = RISC_JUMP(0);	// loop to start (next frame)
	myProg.LinAddr[ PC++ ] = (int) &myProg.PhysAddr[ lus ];

	bt->setRiscIPC( (unsigned int) myProg.PhysAddr );	// set RISC program counter
	bt->setRiscEnabled( true );					// enable RISC processor
	bt->setFifoEnabled( true );					// enable FIFO processor
	bt->setCaptureEnabled( true );		// enable capture of even and odd fields
}


static void setModeRaw(void)
{
	int i, membase, PC, lus;

	bt->setCaptureEnabled( false );				// disable capture
	bt->setFifoEnabled( false );	// disable FIFO unit
	bt->setRiscEnabled( false );	// disable RISC unit

	membase = (int) framebuf.PhysAddr;
	lus = PC = 0;

	myProg.LinAddr[ PC++ ] = RISC_SYNC( RISC_RESYNC, RISC_SC_VRE );	// even field
	myProg.LinAddr[ PC++ ] = 0;
	myProg.LinAddr[ PC++ ] = RISC_SYNC( 0, RISC_SC_FM1 );			// raw data
	myProg.LinAddr[ PC++ ] = 0;

	for (i=0; i < 674; i++)
	{
		myProg.LinAddr[ PC++ ] = RISC_WRITE( RISC_SOL|RISC_EOL, 1024 );// 1 KB ..
		myProg.LinAddr[ PC++ ] = membase;				// .. here
		membase += 1024;
	}

	myProg.LinAddr[ PC++ ] = RISC_JUMP(RISC_SOL|RISC_EOL);	// loop to start (next frame)
	myProg.LinAddr[ PC++ ] = (int) &myProg.PhysAddr[ lus ];

	bt->setTest(239);test_toggled=true;  	// patch test register (undocumented!)
	bt->setVerticalTotal( 625 );					// enable vertical total

	bt->setColorFormat(COLORFORMAT_Raw8X);	// output format is RAW samples
  	bt->setPllFrequency(dec_pll_freq);		// 2268 bytes/line

	bt->setExtFrame( true );						// extend capture size

	bt->setRiscIPC( (unsigned int) myProg.PhysAddr );	// set RISC program counter
	bt->setRiscEnabled( true );					// enable RISC processor
	bt->setFifoEnabled( true );					// enable FIFO processor
	bt->setCaptureEvenEnabled( true );			// enable capture of even and odd fields
}


static void findLockDefault(unsigned char *membase, int &v_offset, int &h_offset)
{
	int l = 0;
   int sx = 0;
   int sy = 0;
   int limit = 30;
   int starty = 280;

   membase += 2268 * starty;

	for (int y=starty; y < 300; y++)
	{
   	for (int x = 0; x < 2268; x++)
		{
         if (membase[x] > limit)
         {
         	l++;
         }
         else
         {
         	if (l>1450 && l<1490)
            {
            	int vsync = sy;
               int hsync = sx;

              	active_decoder->setHSync(hsync);

               v_offset = vsync - 283;
               h_offset = hsync - 374 + hsync_extra;
               return;
            }

            sx = x;
            sy = y;
            l = 0;
         }
      }

      membase += 2268;
   }

 	active_decoder->setHSync(-1);
   h_offset = 0;
   v_offset = 100;
}


static void findLockStartOffImage(unsigned char *membase, int &v_offset, int &h_offset)
{
	h_offset = v_offset = 0;

	unsigned char* ptr;
  	for (int x = 160; x < 400; x++)
   {
   	ptr = membase;
      int nbr = 0;
		for (int y=0; y < 30; y++)
      {
         int xdiff = abs(ptr[x] - ptr[x+2]);
         if (xdiff > 5)
         {
         	nbr++;
            if (nbr > 5)
            {
            	active_decoder->setHSync(x);
	            h_offset = x-163+hsync_extra;
               return;
            }
         }

         ptr += 2268 * 5;
      }
   }

 	active_decoder->setHSync(-1);
}

static void findPolarity(unsigned char *membase, int v_offset, int h_offset)
{
	int x;

	if (h_offset > -5 && h_offset < 5)
	{
   		if (auto_pol_mode == 1)
		{
	   		membase += 2268 + h_offset + pol_param[auto_pol_mode].x;

			pol_check_level = 255;

 			for (x = 0; x < 50; x++)
			{
   	   			unsigned char v = *membase;
      			if (v < pol_check_level)
         			pol_check_level = v;
	      		membase += 2268 * 2;
			}

	   		if (pol_check_level <= pol_param[auto_pol_mode].level)
   				polarity_invert = false;
			else
   				polarity_invert = true;
		}
		else
		{
      		// Het witte kruis van Canal+ gebruiken
			pol_check_level = *(membase + 2268*29 + h_offset + pol_param[auto_pol_mode].x);
			/*
			for (int y = -20; y < 20; y++)
				*(membase + 2268*29 + h_offset + pol_dist[2]+y*2268) = (y&1)?255:0;
			for (int x = -100; x < 100; x++)
				*(membase + 2268*29 + h_offset + pol_dist[2] + x) = (x&1)?255:0;;
			*/
	   		if (pol_check_level >= pol_param[auto_pol_mode].level)
   				polarity_invert = false;
			else
   				polarity_invert = true;
		}
	}
	else
	{
   		pol_check_level = -1;
	}

	if (pol_debug_mode)
	{
		pol_check_buf[pol_check_head] = pol_check_level;
   		if (++pol_check_head >= POL_CHECK_BUF_SIZE)
   			pol_check_head = 0;
	}
}



static void writeBMP(void)
{
	static int cnt = 0;
	char filename[100];

   sprintf(filename, "ccrypt%03d.bmp", cnt++);
   writeBMP(filename);
}


/*******************************************************************************
**
**			Config file functions
**
*******************************************************************************/

#define CONFIG_FILE  	 "ccrypt.cfg"
#define CONFIG_FILE_BAK  "ccrypt.bak"

static const char* getCFKey(const char* section, const char* key,
  const char* default_value, bool create_if_not_found)
{
   char buf[600];
   char mykey[300];
   strcpy(mykey, key);
   strcat(mykey, "=");
	int mykeylen = strlen(mykey);

   FILE* cf = fopen(CONFIG_FILE, "rb");
   if (cf != 0)
   {
		// De section zoeken
		while(fgets(buf, 600, cf) != 0)
		{
		   if (buf[0] == '[' && strncmp(buf+1, section, strlen(section)) == 0)
			{
				while(fgets(buf, 600, cf) != 0 && buf[0] != '[')
				{
            	if (strncmp(mykey, buf, mykeylen) == 0)
			    	{
						// We verwijderen de newline op het einde
						int len = strlen(buf);
						if (buf[len - 1] == '\n')
			    			buf[len - 1]= '\0';
						// Eventuele <CR> verwijderen
						if (buf[len - 2] == '\r')
			    			buf[len - 2]= '\0';

						fclose(cf);
						return(buf+mykeylen);	// Ok !
            	}
				}
			}
		}

		fclose(cf);
	}

   if (create_if_not_found)
		setCFKey(section, key, default_value);

	return(default_value);
}

/*
** Als *value = '\0' -> delete key
*/
static void setCFKey(const char* section, const char* key, const char* value)
{
	char buf1[600];
	char buf2[600];
   int  value_done = 0;
   char mykey[300];
   strcpy(mykey, key);
   strcat(mykey, "=");
   int mykeylen = strlen(mykey);
   int section_found = 0;

	// De vorige .cfg file wordt een .bak file
   unlink(CONFIG_FILE_BAK);					// Eventueel
   rename(CONFIG_FILE, CONFIG_FILE_BAK);	// Eventueel

   FILE* newf = fopen(CONFIG_FILE, "wb");
   if (newf == 0)
   	return;		// SHiiiiiiiiiiit
	FILE* oldf = fopen(CONFIG_FILE_BAK, "rb");

	if (oldf)
   {
		while(fgets(buf1, 600, oldf) != 0)
		{
      	fputs(buf1, newf);
	    	if (!value_done && buf1[0] == '[' &&
	        strncmp(buf1+1, section, strlen(section)) == 0)
	    	{
				// We komen hier enkel als value_done == 0 !
				section_found = 1;

				// Section gevonden, we zoeken de key
				while(fgets(buf1, 600, oldf) != 0)
				{
		    		if (buf1[0] == '[' ||
		      	  strncmp(mykey, buf1, mykeylen) == 0)
		    		{
						// Einde van de sectie of key gevonden
						if (*value != '\0')
						{
			    			// We schrijven de nieuwe key
			    			sprintf(buf2, "%s=%s\r\n", key, value);
			    			fputs(buf2, newf);
						}

						value_done = 1;

						if (buf1[0] == '[')
						{
			    			sprintf(buf2, "\r\n");// Lege lijn voor de section
			    			fputs(buf2, newf);
			    			fputs(buf1, newf);	// Nieuwe sectie schrijven
						}
						break;			// Nu komen we hier nooit meer
					}

		    		if (buf1[0] != '\r' && buf1[0] != '\n')
						fputs(buf1, newf);  // Geen lege lijnen boven de key
				}
			}
		}

		fclose(oldf);
	}

   if (!value_done && *value != '\0')
   {
		if (!section_found)
		{
      	// We voegen de section toe
      	sprintf(buf1, "[%s]\r\n", section);
	    	fputs(buf1, newf);
      }
		// We voegen de key toe
		sprintf(buf1, "%s=%s\r\n", key, value);
		fputs(buf1, newf);
	}

   fclose(newf);
}


static unsigned long getCFKey(const char* section, const char* key,
  unsigned long default_value, bool create_if_not_found)
{
	char buf[30];
   sprintf(buf, "%ld", default_value);
   return(strtoul(getCFKey(section, key, buf, create_if_not_found), NULL, 10));
}

static void setCFKey(const char* section, const char* key, unsigned long value)
{
	char buf[30];
   sprintf(buf, "%ld", value);
   setCFKey(section, key, buf);
}


static bool getCFKeyBool(const char* section, const char* key,
  bool default_value, bool create_if_not_found)
{
   const char* ret = getCFKey(section, key, (default_value)?"TRUE":"FALSE", create_if_not_found);
   if (strcmp(ret, "TRUE") == 0)
   	return(true);
   return(false);
}


static void setCFKeyBool(const char* section, const char* key, bool value)
{
   setCFKey(section, key, (value)?"TRUE":"FALSE");
}



static HMENU createMenu(void)
{
	int t;
	MENUITEMINFO menuitem;
	HMENU submenu, subsubmenu;
	HMENU menu = CreateMenu();

	memset(&menuitem, 0, sizeof(menuitem));
	menuitem.cbSize = sizeof(menuitem);

	// File menu
	submenu = CreatePopupMenu();
	menuitem.fMask = MIIM_TYPE|MIIM_ID;
	menuitem.fType = MFT_STRING;
	menuitem.dwTypeData = "Snapshot\tF9";
	menuitem.wID = IDM_SNAPSHOT;
	menuitem.cch = strlen((char*)menuitem.dwTypeData);
	InsertMenuItem(submenu, 0, TRUE, &menuitem);

	menuitem.fMask = MIIM_TYPE|MIIM_ID;
	menuitem.fType = MFT_STRING;
	menuitem.dwTypeData = "Snapshots\tShift+F9";
	menuitem.wID = IDM_SNAPSHOTS;
	menuitem.cch = strlen((char*)menuitem.dwTypeData);
	InsertMenuItem(submenu, 1, TRUE, &menuitem);

	menuitem.fMask = MIIM_TYPE;
	menuitem.fType = MFT_SEPARATOR;
	InsertMenuItem(submenu, 2, TRUE, &menuitem);

	menuitem.fMask = MIIM_TYPE|MIIM_ID;
	menuitem.fType = MFT_STRING;
	menuitem.dwTypeData = "E&xit";
	menuitem.wID = IDM_EXIT;
	menuitem.cch = strlen((char*)menuitem.dwTypeData);
	InsertMenuItem(submenu, 3, TRUE, &menuitem);

	menuitem.fMask = MIIM_TYPE|MIIM_SUBMENU;
	menuitem.fType = MFT_STRING;
	menuitem.dwTypeData = "&File";
	menuitem.cch = strlen((char*)menuitem.dwTypeData);
	menuitem.hSubMenu = submenu;
	InsertMenuItem(menu, IDM_FILE_SUBMENU_POS, TRUE, &menuitem);

	// Decode mode menu
	submenu = CreatePopupMenu();
	subsubmenu = CreatePopupMenu();
	for (t = 0; t < nbr_decoders; t++)
	{
		menuitem.fMask = MIIM_TYPE|MIIM_ID;
		menuitem.fType = MFT_STRING|MFT_RADIOCHECK;
		menuitem.dwTypeData = (char*)decoders[t]->getDescription();
		menuitem.wID = IDM_DECODE_MODE+t;
		menuitem.cch = strlen((char*)menuitem.dwTypeData);
		InsertMenuItem(subsubmenu, t, TRUE, &menuitem);

		if (decoders[t]->usesMMX() && !cpu_info->hasMMX())
			EnableMenuItem(subsubmenu, t, MF_BYPOSITION|MF_GRAYED);
	}
	menuitem.fMask = MIIM_TYPE|MIIM_SUBMENU;
	menuitem.fType = MFT_STRING;
	menuitem.dwTypeData = "&Mode\tF2";
	menuitem.cch = strlen((char*)menuitem.dwTypeData);
	menuitem.hSubMenu = subsubmenu;
	InsertMenuItem(submenu, 0, TRUE, &menuitem);

	subsubmenu = CreatePopupMenu();
	for (t = 0; t < 3; t++)
	{
		menuitem.fMask = MIIM_TYPE|MIIM_ID|MIIM_STATE;
		menuitem.fType = MFT_STRING|MFT_RADIOCHECK;
		menuitem.fState = (t==auto_pol_mode)?MFS_CHECKED:MFS_UNCHECKED;
		menuitem.dwTypeData = auto_pol_mode_descr[t];
		menuitem.wID = IDM_AUTO_INVERT_NONE+t;
   		menuitem.cch = strlen((char*)menuitem.dwTypeData);
		InsertMenuItem(subsubmenu, t, TRUE, &menuitem);
	}
	menuitem.fMask = MIIM_TYPE|MIIM_SUBMENU;
	menuitem.fType = MFT_STRING;
	menuitem.dwTypeData = "Auto &polarity";
	menuitem.cch = strlen((char*)menuitem.dwTypeData);
	menuitem.hSubMenu = subsubmenu;
	InsertMenuItem(submenu, 1, TRUE, &menuitem);

	subsubmenu = CreatePopupMenu();
	for (t = 0; t < 3; t++)
	{
		menuitem.fMask = MIIM_TYPE|MIIM_ID|MIIM_STATE;
		menuitem.fType = MFT_STRING|MFT_RADIOCHECK;
		menuitem.fState = (t==auto_lock_mode)?MFS_CHECKED:MFS_UNCHECKED;
		menuitem.dwTypeData = lock_modes[t];
		menuitem.wID = IDM_AUTO_LOCK_MODE1+t;
   		menuitem.cch = strlen((char*)menuitem.dwTypeData);
		InsertMenuItem(subsubmenu, t, TRUE, &menuitem);
	}
	menuitem.fMask = MIIM_TYPE|MIIM_SUBMENU;
	menuitem.fType = MFT_STRING;
	menuitem.dwTypeData = "&Auto lock";
	menuitem.cch = strlen((char*)menuitem.dwTypeData);
	menuitem.hSubMenu = subsubmenu;
	InsertMenuItem(submenu, 2, TRUE, &menuitem);

	menuitem.fMask = MIIM_TYPE|MIIM_ID|MIIM_STATE;
	menuitem.fType = MFT_STRING;
	menuitem.fState = (man_pol_invert)?MFS_CHECKED:MFS_UNCHECKED;
	menuitem.dwTypeData = "&Invert\tF4";
	menuitem.wID = IDM_MANUAL_INVERT;
  	menuitem.cch = strlen((char*)menuitem.dwTypeData);
	InsertMenuItem(submenu, 3, TRUE, &menuitem);

	menuitem.fMask = MIIM_TYPE|MIIM_SUBMENU;
	menuitem.fType = MFT_STRING;
	menuitem.dwTypeData = "&Decoder";
	menuitem.cch = strlen((char*)menuitem.dwTypeData);
	menuitem.hSubMenu = submenu;
	InsertMenuItem(menu, IDM_DECODER_SUBMENU_POS, TRUE, &menuitem);

	// Options menu
	submenu = CreatePopupMenu();
	menuitem.fMask = MIIM_TYPE|MIIM_ID;
	menuitem.fType = MFT_STRING;
	menuitem.dwTypeData = "Toggle Full-Screen\tEnter/Space";
	menuitem.wID = IDM_TOGGLE_FULLSCREEN;
  	menuitem.cch = strlen((char*)menuitem.dwTypeData);
	InsertMenuItem(submenu, 0, TRUE, &menuitem);

	menuitem.fMask = MIIM_TYPE|MIIM_ID|MIIM_STATE;
	menuitem.fType = MFT_STRING;
	menuitem.fState = (always_on_top)?MFS_CHECKED:MFS_UNCHECKED;
	menuitem.dwTypeData = "Always on &top";
	menuitem.wID = IDM_ALWAYS_ON_TOP;
  	menuitem.cch = strlen((char*)menuitem.dwTypeData);
	InsertMenuItem(submenu, 1, TRUE, &menuitem);

	menuitem.fMask = MIIM_TYPE|MIIM_ID|MIIM_STATE;
	menuitem.fType = MFT_STRING;
	menuitem.fState = (aspect_ratio)?MFS_CHECKED:MFS_UNCHECKED;
	menuitem.dwTypeData = "&Aspect ratio";
	menuitem.wID = IDM_ASPECT_RATIO;
  	menuitem.cch = strlen((char*)menuitem.dwTypeData);
	InsertMenuItem(submenu, 2, TRUE, &menuitem);

	menuitem.fMask = MIIM_TYPE|MIIM_ID|MIIM_STATE;
	menuitem.fType = MFT_STRING;
	menuitem.fState = (use_double_buffering)?MFS_CHECKED:MFS_UNCHECKED;
	menuitem.dwTypeData = "D&ouble buffering";
	menuitem.wID = IDM_USE_DOUBLE_BUFFERING;
  	menuitem.cch = strlen((char*)menuitem.dwTypeData);
	InsertMenuItem(submenu, 3, TRUE, &menuitem);

	menuitem.fMask = MIIM_TYPE;
	menuitem.fType = MFT_SEPARATOR;
	InsertMenuItem(submenu, 4, TRUE, &menuitem);
	
	// Signal Source
	menuitem.fMask = MIIM_TYPE|MIIM_ID|MIIM_STATE;
	menuitem.fType = MFT_STRING;
	menuitem.fState = (signal_source==VIDEO_SVIDEO)?MFS_CHECKED:MFS_UNCHECKED;
	menuitem.dwTypeData = "SVideo";
	menuitem.wID = IDM_SVIDEO;
	menuitem.cch = strlen((char*)menuitem.dwTypeData);
	InsertMenuItem(submenu, 5, TRUE, &menuitem);

	menuitem.fMask = MIIM_TYPE|MIIM_ID|MIIM_STATE;
	menuitem.fType = MFT_STRING;
	menuitem.fState = (signal_source==VIDEO_TUNER)?MFS_CHECKED:MFS_UNCHECKED;
	menuitem.dwTypeData = "Tuner";
	menuitem.wID = IDM_TUNER;
	menuitem.cch = strlen((char*)menuitem.dwTypeData);
	InsertMenuItem(submenu, 5, TRUE, &menuitem);

	menuitem.fMask = MIIM_TYPE|MIIM_ID|MIIM_STATE;
	menuitem.fType = MFT_STRING;
	menuitem.fState = (signal_source==VIDEO_COMPOSITE)?MFS_CHECKED:MFS_UNCHECKED;
	menuitem.dwTypeData = "Composite";
	menuitem.wID = IDM_COMPOSITE;
	menuitem.cch = strlen((char*)menuitem.dwTypeData);
	InsertMenuItem(submenu, 5, TRUE, &menuitem);

	menuitem.fMask = MIIM_TYPE;
	menuitem.fType = MFT_SEPARATOR;
	InsertMenuItem(submenu, 4, TRUE, &menuitem);

	menuitem.fMask = MIIM_TYPE|MIIM_ID|MIIM_STATE;
	menuitem.fType = MFT_STRING;
	menuitem.fState = (debug_mode)?MFS_CHECKED:MFS_UNCHECKED;
	menuitem.dwTypeData = "Show &debug\tF12";
	menuitem.wID = IDM_SHOW_DEBUG;
	menuitem.cch = strlen((char*)menuitem.dwTypeData);
	InsertMenuItem(submenu, 5, TRUE, &menuitem);

	menuitem.fMask = MIIM_TYPE|MIIM_ID;
	menuitem.fType = MFT_STRING;
	menuitem.dwTypeData = "&Force vertical lock search";
	menuitem.wID = IDM_FORCE_VSEARCH;
  	menuitem.cch = strlen((char*)menuitem.dwTypeData);
	InsertMenuItem(submenu, 6, TRUE, &menuitem);

	menuitem.fMask = MIIM_TYPE|MIIM_SUBMENU;
	menuitem.fType = MFT_STRING;
	menuitem.dwTypeData = "&Options";
	menuitem.cch = strlen((char*)menuitem.dwTypeData);
	menuitem.hSubMenu = submenu;
	InsertMenuItem(menu, IDM_OPTIONS_SUBMENU_POS, TRUE, &menuitem);

	// Help menu
	submenu = CreatePopupMenu();
	menuitem.fMask = MIIM_TYPE|MIIM_ID;
	menuitem.fType = MFT_STRING;
	menuitem.dwTypeData = "&System info";
	menuitem.wID = IDM_SYSTEM_INFO;
  	menuitem.cch = strlen((char*)menuitem.dwTypeData);
	InsertMenuItem(submenu, 0, TRUE, &menuitem);

	menuitem.fMask = MIIM_TYPE|MIIM_ID;
	menuitem.fType = MFT_STRING;
	menuitem.dwTypeData = "&About ...";
	menuitem.wID = IDM_ABOUT;
  	menuitem.cch = strlen((char*)menuitem.dwTypeData);
	InsertMenuItem(submenu, 1, TRUE, &menuitem);

	menuitem.fMask = MIIM_TYPE|MIIM_SUBMENU;
	menuitem.fType = MFT_STRING;
	menuitem.dwTypeData = "&Help";
	menuitem.cch = strlen((char*)menuitem.dwTypeData);
	menuitem.hSubMenu = submenu;
	InsertMenuItem(menu, IDM_HELP_SUBMENU_POS, TRUE, &menuitem);

	return(menu);
}



static BOOL initSound(void)
{
	if (FAILED (DirectSoundCreate(NULL, &lpds, NULL)) )
	{	
		lpds = NULL;
		MessageBox(NULL, "initSound:DirectSoundCreate failed !", "Error", MB_OK); 
		return FALSE;
	}

	if (FAILED(lpds->SetCooperativeLevel(hWnd, DSSCL_NORMAL)))
	{
		exitSound();
		MessageBox(NULL, "initSound:SetCooperativeLevel failed !", "Error", MB_OK); 
		return FALSE;
	}

	// Create Secondary Buffer
    PCMWAVEFORMAT pcmwf;
	DSBUFFERDESC dsbdesc;
    // Set up wave format structure. 
    memset(&pcmwf, 0, sizeof(PCMWAVEFORMAT)); 
    pcmwf.wf.wFormatTag = WAVE_FORMAT_PCM;     
	pcmwf.wf.nChannels = 1;			// Mono
    pcmwf.wf.nSamplesPerSec = 22050;     
	pcmwf.wf.nBlockAlign = 1;
    pcmwf.wf.nAvgBytesPerSec = pcmwf.wf.nSamplesPerSec * pcmwf.wf.nBlockAlign; 
    pcmwf.wBitsPerSample = 8;     
	// Set up DSBUFFERDESC structure.
    memset(&dsbdesc, 0, sizeof(DSBUFFERDESC)); // Zero it out. 
    dsbdesc.dwSize = sizeof(DSBUFFERDESC);
    // Need default controls (pan, volume, frequency). 
    dsbdesc.dwFlags = DSBCAPS_CTRLDEFAULT;     // 3-second buffer.
    dsbdesc.dwBufferBytes = 3 * pcmwf.wf.nAvgBytesPerSec; 
    dsbdesc.lpwfxFormat = (LPWAVEFORMATEX)&pcmwf;     // Create buffer. 

	if (FAILED(lpds->CreateSoundBuffer(&dsbdesc, &lpDsb, NULL)))
    {    
		exitSound();
		MessageBox(NULL, "initSound:CreateSoundBuffer failed !", "Error", MB_OK); 
		return FALSE;
	}

	return TRUE;
}


static void exitSound(void)
{
	if (lpds != NULL)
	{
		lpds->Release();
		lpds = NULL;
	}
}


static BOOL writeSound(LPBYTE lpbSoundData, DWORD dwSoundBytes)
{ 
    LPVOID  lpvPtr1; 
    DWORD   dwBytes1; 
    LPVOID  lpvPtr2; 
    DWORD   dwBytes2; 
    HRESULT hr; 

	if (lpds == NULL)
		return FALSE;

    // Obtain memory address of write block. This will be in two parts
    // if the block wraps around.
    hr = lpDsb->Lock(0, dwSoundBytes, &lpvPtr1, 
        &dwBytes1, &lpvPtr2, &dwBytes2, DSBLOCK_FROMWRITECURSOR); 
 
    // If DSERR_BUFFERLOST is returned, restore and retry lock. 
    if (DSERR_BUFFERLOST == hr) 
    { 
        lpDsb->Restore(); 
	    hr = lpDsb->Lock(0, dwSoundBytes, &lpvPtr1, 
		    &dwBytes1, &lpvPtr2, &dwBytes2, DSBLOCK_FROMWRITECURSOR); 
    } 
    if SUCCEEDED(hr) 
    { 
        // Write to pointers. 
        CopyMemory(lpvPtr1, lpbSoundData, dwBytes1); 
        if (NULL != lpvPtr2) 
        { 
            CopyMemory(lpvPtr2, lpbSoundData+dwBytes1, dwBytes2); 
        } 
        // Release the data back to DirectSound. 
        hr = lpDsb->Unlock(lpvPtr1, dwBytes1, lpvPtr2, dwBytes2); 
        if SUCCEEDED(hr) 
        { 
			lpDsb->Play(0, 0, 0);
            // Success. 
            return TRUE; 
        } 
    } 
    // Lock, Unlock, or Restore failed. 
    return FALSE; 
}
