#ifndef DEBUGDECODER_H
#define DEBUGDECODER_H

#include "ccrypt.h"

class DebugDecoder : public VirtualDecoder
{
	public:
   		DebugDecoder()
		{
 			_description = "Debug";
			_outwidth = 800;
			_outheight = 600;
			_use_vbi = true;
			_zoom_mode = false;
		}

   		void decodeFrame(unsigned char *membase, int offset, bool invert_polarity);

		virtual int convertRawXToScreenX(int x) const
		{
      		if (!_zoom_mode)
      			return((x)*(2268/4)/2268);
			else
      			return(x);
		}

		virtual int convertScreenXToRawX(int x) const
		{
      		if (!_zoom_mode)
      			return((x*2268)/(2268/4));
			else
      			return(x);
		}

		virtual void processKey(WPARAM key);
		virtual const char* getHelp(void) const;

	private:
   		bool _zoom_mode;
};

#endif
