//---------------------------------------------------------------------------
// Stealth 0.4 - release date: 23-jan-1999
//---------------------------------------------------------------------------

#include <vcl\vcl.h>
#pragma hdrstop

#include "main.h"

//---------------------------------------------------------------------------
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------

#pragma warning(disable: 4100 4201 4514)

#include <windows.h>
#include <stdio.h>
#include <vfw.h>
#include <pbt.h>
#include "directdraw.h"
#include "tvichw32.h"

int nframes=0,sframes=0;

HINSTANCE DLLHandle;
unsigned int m_nAdresseBT;

BITMAPINFO     sDIB;
DWORD          dwDestination  = 0;
LPVOID         pDestination   = NULL;

DWORD          dwFirstLines   = 0;
LPVOID         pFirstLines    = NULL;

HINSTANCE      hInstance      = NULL;
HWND           hWndMain       = NULL;
HWND           hWndCap        = NULL;

const int      VIDEO_BITCOUNT = 8;
const DWORD    VIDEO_FORMAT   = MAKEFOURCC('R','A','W',' ');


int            nFormat        = 0x00;
const int      FORMAT_MASK    = 0x0F;
const int      FORMAT_4_3     = 0x08;
const int      FORMAT_14_9    = 0x01;
const int      FORMAT_16_9    = 0x0B;

bool           bDecode        = true;
bool           bCapture       = false;
bool           bReady         = false;
bool           bBild          = true;
bool           bPhase         = false;

CDirectDraw   *pDirectDraw    = NULL;

bool ReadBND();
bool VidcapInitHardware(HWND, HWND, UINT);
bool WriteBT (int , unsigned int);
unsigned int FindeAdresse();

LRESULT CALLBACK MainWnd(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK VideoStreamCallback(HWND, LPVIDEOHDR);
LRESULT CALLBACK ErrorCallback(HWND, int, LPSTR);
//long offset[600];

bool WriteBT (int nRegister, unsigned int nValue)
{
   unsigned int *pPhysical = (unsigned int*)MapPhysToLinear(m_nAdresseBT+nRegister, 0x04);
   *pPhysical = nValue;
   return true;
}

//
// FindeAdresse() von TL
//
unsigned int FindeAdresse()
{
   const unsigned int   BT848            = 0x0350109E;
   const unsigned int   BT849            = 0x0351109E;
   const unsigned int   BT878            = 0x036E109E;
   const unsigned int   BT879            = 0x036F109E;
   const unsigned short PCIConfigAddress = 0x0CF8;
   const unsigned short PCIConfigData    = 0x0CFC;

   int          nHardAccess;
   unsigned int nPCIEinheit;
   unsigned int nDeviceID;
   unsigned int nAdresse;

   nHardAccess = TestHardAccess();
   if(nHardAccess == TRUE);
      SetHardAccess(TRUE);

   // Sucht Bt8xx von Einheit 00 bis Einheit 31
   for(int nZlr=0; nZlr<32; nZlr++)
   {
      nPCIEinheit = nZlr;
      nPCIEinheit <<= 11;
      nPCIEinheit |= 0x80000000;

      WritePortL(PCIConfigAddress, nPCIEinheit);
      nDeviceID = ReadPortL(PCIConfigData);

      // Wurde ein BT gefunden?
      switch(nDeviceID)
      {
         case BT848:
         case BT849:
         case BT878:
         case BT879:
            // Die Adresse abfragen
            nPCIEinheit = nZlr;
            nPCIEinheit <<= 11;
            nPCIEinheit |= 0x80000010;
            WritePortL(PCIConfigAddress, nPCIEinheit);
            nAdresse = ReadPortL(PCIConfigData);
            // Nicht bentigte Bit's ausblenden
            return nAdresse & 0xFFFFF000;
         break;
      }
   }
   return 0;
}

bool VidcapInitHardware(HWND hWnd, HWND hWndCap, UINT uIndex)
{
   if(FALSE == capDriverConnect(hWndCap, uIndex)) return false;
   capOverlay(hWndCap, false);
   capPreview(hWndCap, false);
   return true;
}

bool polariteit(unsigned char *p, int hsync)
{
 int i,y;
 int tot;
 unsigned long temp;
 unsigned char *dest;
 unsigned char c,cp;
 unsigned int yoffset;
 tot=0;
 for (y=0;y<288;y++) {
    yoffset= (float) (y*2270.08) + hsync;
    tot+= *(p+ yoffset + (yoffset & 0xfffffc00));
 }
 if (tot<5000) {
    Form1->Label1->Caption="-";
    return true;
 }
 Form1->Label1->Caption="+";
 return false;
 }

render2(unsigned char *p, unsigned char *screen, int hsync, int vsync, bool xor)
{
 int i,x,y,yscreen,xscreen;
 unsigned long temp;
 unsigned char *dest;
 unsigned int c1;
 unsigned char c,cp;
 unsigned int yoffset;
 yscreen=0;
 if (vsync>=289) return -1;
 for (y=vsync;y<288;y++) {
    yoffset= (float) (y*2270.08) + hsync;
    yscreen++;
    xscreen=0;
    dest = screen+(yscreen*400);
    for (x=0;x<1850;x+=5) {
        temp = yoffset + x ;
        c1 = 0;
        c1+= *(p+ temp + (temp++ & 0xfffffc00));
        c1+= *(p+ temp + (temp++ & 0xfffffc00));
        c1+= *(p+ temp + (temp++ & 0xfffffc00));
        c1+= *(p+ temp + (temp++ & 0xfffffc00));
        c1+= *(p+ temp + (temp++ & 0xfffffc00));
        c1+= *(p+ temp + (temp++ & 0xfffffc00));
        c1+= *(p+ temp + (temp++ & 0xfffffc00));
        c1+= *(p+ temp + (temp++ & 0xfffffc00));
        c = (unsigned char) (c1>>2);
        if (xor) if (c>120) c=0;else c=120-c;
        if (x==0) cp=(120-c)>>1;
        c+=cp;
        *dest++ = c;
    }
 }
 yscreen+=20;

  for (y=0;((y<vsync) && (y<288));y++) {
    yoffset= (float) (y*2270.08) + hsync;
    yscreen++;
    xscreen=0;
    dest = screen+(yscreen*400);
    for (x=0;x<1850;x+=5) {
        temp = yoffset + x ;
        c1 = 0;
        c1+= *(p+ temp + (temp++ & 0xfffffc00));
        c1+= *(p+ temp + (temp++ & 0xfffffc00));
        c1+= *(p+ temp + (temp++ & 0xfffffc00));
        c1+= *(p+ temp + (temp++ & 0xfffffc00));
        c1+= *(p+ temp + (temp++ & 0xfffffc00));
        c1+= *(p+ temp + (temp++ & 0xfffffc00));
        c1+= *(p+ temp + (temp++ & 0xfffffc00));
        c1+= *(p+ temp + (temp++ & 0xfffffc00));
        c = (unsigned char) (c1>>2);

        if (xor) if (c>120) c=0;else c=120-c;
        if (x==0) cp=(120-c)>>1;
        c+=cp;
        *dest++ = c;
    }
 }
}

searchvsync(char *p, int *hsync, int *vsync)
{
 int vs,i,y,y1,x,l,langste;
 unsigned char *y0;
 unsigned char c,c1;
 vs=Form1->TrackBar5->Position;
 l=0;
 i=0;
 y1=0;
 for (y=0;y<639;y++) {
    y0=p+(y<<11);
    for (x=0;x<1023;x++) {
       i++;
       if (i>=2268) {i=0;y1++;}
       c = (unsigned char) *(y0+x);
       if ((c>vs) && (c1>vs)) { l++; }
       else {
             if ((l>1450) && (l<1480)) {
                *vsync=y1;
                *hsync=i;
                return -1;
             } else {
                l=0;
             }
       }
       c1 = c;
    }
 }
}



LRESULT CALLBACK VideoStreamCallback (HWND hWnd, LPVIDEOHDR  pVideoHeader)
{
if(bReady == false) return 0;

void *pSurface;
int hsync, vsync;
int nStartOfNextLine;
bool xor;
hsync=0;vsync=0;xor=false;
searchvsync((char*)pVideoHeader->lpData+1024, &hsync, &vsync);
xor=polariteit((char*)pVideoHeader->lpData+1024, hsync+550);
if(pDirectDraw->LockSurface(&pSurface, &nStartOfNextLine, false) == true) {
   render2((unsigned char*)pVideoHeader->lpData+1024,(unsigned char*) pSurface,hsync+550,vsync+20,xor);
   pDirectDraw->UnlockSurface();
}
searchvsync((char*)pVideoHeader->lpData, &hsync, &vsync);
if(pDirectDraw->LockSurface(&pSurface, &nStartOfNextLine, false) == true) {
   render2((unsigned char*)pVideoHeader->lpData,(unsigned char*) pSurface,hsync+550,vsync+20,xor);
   pDirectDraw->UnlockSurface();
}
return 0;
}

LRESULT CALLBACK ErrorCallback(HWND hWnd, int nErrorID, LPSTR pErrorText)
{
   if(nErrorID == 0)
      return false;

   // Meldung unterdrcken:"Dieses Format kann nicht dargestellt werden"
   if(nErrorID != 439)
   Application->MessageBox("format error","hoi",1);

   //   MessageBox(hWndMain, pErrorText, pAppTitle, MB_OK | MB_ICONEXCLAMATION);

   return true;
}
void __fastcall TForm1::Button1Click(TObject *Sender)
{
   // Capture initialisieren
   hWndMain=Form1->Handle;
   hWndCap = capCreateCaptureWindow("Form1", WS_CHILD, 0, 0, 200, 200, hWndMain, 1);
   if(hWndCap == NULL)	{
      Application->MessageBox("IDS_ERR_CREATE_WINDOW","hoi",1);
      exit;
   }
   if(VidcapInitHardware(hWndMain, hWndCap, 0) == false) {
      Application->MessageBox("IDS_ERR_FIND_HARDWARE","hoi",1);
      exit;
   }
   if(FALSE == capSetCallbackOnVideoStream(hWndCap, VideoStreamCallback)) {
      Application->MessageBox("IDS_ERR_SETCALLBACKONVIDEOSTREM","hoi",1);
      exit;
   }
   if(FALSE == capSetCallbackOnError(hWndCap, ErrorCallback)) {
      Application->MessageBox("IDS_ERR_SETCALLBACKONERROR","hoi",1);
      exit;
   }
   CAPTUREPARMS sCapParms;
   if(FALSE == capCaptureGetSetup(hWndCap, &sCapParms, sizeof(CAPTUREPARMS))) {
      Application->MessageBox("IDS_ERR_CAPTUREGETSETUP","hoi",1);
      exit;
   }
   sCapParms.dwRequestMicroSecPerFrame = 40000;
   sCapParms.fMakeUserHitOKToCapture   = false;
   sCapParms.fAbortLeftMouse           = false;
   sCapParms.fAbortRightMouse          = false;
   sCapParms.fYield                    = true;
   sCapParms.fCaptureAudio             = false;
   if(FALSE == capCaptureSetSetup(hWndCap, &sCapParms, sizeof(CAPTUREPARMS))) {
      Application->MessageBox("IDS_ERR_CAPTURESETSETUP","hoi",1);
      exit;
   }
   // Eingabeformat festlegen
   BITMAPINFO sBitmapInfo;
   sBitmapInfo.bmiHeader.biSize          = sizeof(BITMAPINFOHEADER);
   sBitmapInfo.bmiHeader.biWidth         = 1024;
   sBitmapInfo.bmiHeader.biHeight        = 1400;
   sBitmapInfo.bmiHeader.biBitCount      = VIDEO_BITCOUNT;
   sBitmapInfo.bmiHeader.biCompression   = VIDEO_FORMAT;
   sBitmapInfo.bmiHeader.biPlanes        = 0;
   sBitmapInfo.bmiHeader.biSizeImage     = 0;
   sBitmapInfo.bmiHeader.biClrUsed       = 0;
   sBitmapInfo.bmiHeader.biXPelsPerMeter = 0;
   sBitmapInfo.bmiHeader.biYPelsPerMeter = 0;
   sBitmapInfo.bmiHeader.biClrImportant  = 0;
   if(FALSE == capSetVideoFormat(hWndCap, &sBitmapInfo, sizeof(sBitmapInfo))) {
      Application->MessageBox("IDS_SETVIDEOFORMAT","hoi",1);
      exit;
   }
   pDirectDraw = new CDirectDraw( hWndMain, hInstance, false, 400, 300, 400, 300, 0,
                                  false, DDSCL_EXCLUSIVE | DDSCL_FULLSCREEN);
   if(pDirectDraw == NULL) {
      Application->MessageBox("IDS_ERR_MEMORY","hoi",1);
      exit;
   }
   // Flag setzen, da alle Zeiger initialisiert sind
   bReady = true;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormShow(TObject *Sender)
{
    SetPriorityClass(GetCurrentProcess(), HIGH_PRIORITY_CLASS);
    SetThreadPriority(GetCurrentThread(), THREAD_PRIORITY_HIGHEST);

	DLLHandle = LoadLibrary("Tvichw32.dll");
	if((int) DLLHandle<=HINSTANCE_ERROR)
	{
		Application->MessageBox("Tvichw32.dll kan niet laden, damn!","",1) ;
		exit(1) ;
	}
   	MapPhysToLinear = (void* (PASCAL *)(DWORD, DWORD)) GetProcAddress(DLLHandle,"MapPhysToLinear") ;
    OpenTVicHW32 = (unsigned char (PASCAL *)(void)) GetProcAddress(DLLHandle,"OpenTVicHW32");
	CloseTVicHW32 = (void (PASCAL *)(void)) GetProcAddress(DLLHandle,"CloseTVicHW32");
    ReadPortL = (DWORD (PASCAL *)(WORD)) GetProcAddress(DLLHandle,"ReadPortL");
	WritePortL = (void (PASCAL *)(WORD, DWORD)) GetProcAddress(DLLHandle,"WritePortL");
    TestHardAccess = (unsigned char (PASCAL *)(void)) GetProcAddress(DLLHandle,"TestHardAccess");
	SetHardAccess = (void (PASCAL *)(unsigned char)) GetProcAddress(DLLHandle,"SetHardAccess");
    IsDriverOpened = (unsigned char (PASCAL *) (void)) GetProcAddress(DLLHandle,"IsDriverOpened");
 	Form1->Button1Click(NULL);
    OpenTVicHW32();
    m_nAdresseBT = FindeAdresse();
}

//---------------------------------------------------------------------------
void __fastcall TForm1::FormClose(TObject *Sender, TCloseAction &Action)
{
 WriteBT(0x054, 1); // test register
 CloseTVicHW32();
 FreeLibrary(DLLHandle);
 }
//---------------------------------------------------------------------------
void __fastcall TForm1::TrackBar3Change(TObject *Sender)
{
//WriteBT(0x06c, Form1->TrackBar3->Position);
//WriteBT(0x0cc, Form1->TrackBar3->Position);
}
//---------------------------------------------------------------------------



void __fastcall TForm1::Label2Click(TObject *Sender)
{
 // ---> start capturing here <---

 WriteBT(0xe4, 197);
 WriteBT(0x054, 239); // "bt848 test register" a write of 239 disables regular sync detection (undocumented)
// WriteBT(0x068, 16); // niveau opkrikken
// WriteBT(0x068, 0); // niveau opkrikken
 WriteBT(0x06c, 255); // better framerate
 WriteBT(0x0ec, 255); // better framerate
 WriteBT(0x010, 0);// vertical delay
 WriteBT(0x090, 0);// vertical delay
 capCaptureSequenceNoFile(hWndCap);
}
//---------------------------------------------------------------------------
