#include <vcl\vcl.h>
#pragma hdrstop

#include <windows.h>
#include <stdio.h>
#include <ddraw.h>

#include "DirectDraw.h"


const int SCREEN_BITCOUNT  = 8;
const DWORD OVERLAY_FORMAT = MAKEFOURCC('R','G','B',' ');

CDirectDraw::CDirectDraw
(
   HWND      hWnd,
   HINSTANCE hInstance,
   bool      bOverlay,
   int       nScreenWidth,
   int       nScreenHeight,
   int       nOverlayWidth,
   int       nOverlayHeight,
   int       nStatusHeight,
   bool      bFensterModus,
   DWORD     dwCooperativeLevel
)
{
   m_bRGB15         = true;
   m_bError         = false;
   m_hWnd           = hWnd;
   m_bOverlay       = bOverlay;
   m_hInstance      = hInstance;
   m_nOverlayWidth  = nOverlayWidth;
   m_nOverlayHeight = nOverlayHeight;
   m_bFensterModus  = bFensterModus;

   if(false == OpenDirectDraw( nScreenWidth, 
                               nScreenHeight, 
                               nStatusHeight, 
                               dwCooperativeLevel
                             )
     )
   {
      m_bError = true;
   }
}


CDirectDraw::~CDirectDraw()
{
   CloseDirectX();
}


void CDirectDraw::CloseDirectX()
{
   if(m_pDirectDraw != NULL)
	{
      if( m_bOverlay &&
          m_pDirectDrawOverlay != NULL
        )
      {
         UpdateOverlay(NULL, DDOVER_HIDE);
			m_pDirectDrawOverlay->Release();
			m_pDirectDrawOverlay = NULL;
      }

		if(m_pDirectDrawSurface != NULL)
		{
			m_pDirectDrawSurface->Release();
			m_pDirectDrawSurface = NULL;
		}

		m_pDirectDraw->Release();
		m_pDirectDraw = NULL;
	}

   // Cursor einschalten
   if(m_bFensterModus == false)
      ShowCursor(true);
}


bool CDirectDraw::EraseOverlaySurface()
{
	int            nStartOfNextLine;
   DWORD          nPixel;
   DWORD          nZeile;
   HRESULT        hError;
	DDSURFACEDESC  sDirectDrawSurfaceDesc;

	// Overlay lschen
   ZeroMemory(&sDirectDrawSurfaceDesc, sizeof(sDirectDrawSurfaceDesc));
	sDirectDrawSurfaceDesc.dwSize = sizeof(sDirectDrawSurfaceDesc);
   hError = m_pDirectDrawOverlay->Lock(NULL, &sDirectDrawSurfaceDesc, 0, 0);
   if(ShowError(hError, "Lock"))
		return false;

   // Start der nchsten Zeile abfragen
   nStartOfNextLine = sDirectDrawSurfaceDesc.lPitch;

   for(nZeile=0; nZeile<sDirectDrawSurfaceDesc.dwHeight; nZeile++)
	   for(nPixel=0; nPixel<sDirectDrawSurfaceDesc.dwWidth*SCREEN_BITCOUNT/8; nPixel++)
		   *((int*)sDirectDrawSurfaceDesc.lpSurface+(nZeile*nStartOfNextLine+nPixel)/4) = 0x80008000;

   hError = m_pDirectDrawOverlay->Unlock(NULL);
   if(ShowError(hError, "Unlock"))
		return false;

   return true;
}


bool CDirectDraw::ErasePrimarySurface()
{
	int            nStartOfNextLine;
   DWORD          nPixel;
   DWORD          nZeile;
   HRESULT        hError;
	DDSURFACEDESC  sDirectDrawSurfaceDesc;

	// Surface lschen
   ZeroMemory(&sDirectDrawSurfaceDesc, sizeof(sDirectDrawSurfaceDesc));
	sDirectDrawSurfaceDesc.dwSize = sizeof(sDirectDrawSurfaceDesc);
   hError = m_pDirectDrawSurface->Lock(NULL, &sDirectDrawSurfaceDesc, 0, 0);
   if(ShowError(hError, "Lock"))
		return false;

   // Start der nchsten Zeile abfragen
   nStartOfNextLine = sDirectDrawSurfaceDesc.lPitch;

   for(nZeile=0; nZeile<sDirectDrawSurfaceDesc.dwHeight; nZeile++)
	   for(nPixel=0; nPixel<sDirectDrawSurfaceDesc.dwWidth*SCREEN_BITCOUNT/8; nPixel++)
		   *((int*)sDirectDrawSurfaceDesc.lpSurface+(nZeile*nStartOfNextLine+nPixel)/4) = 0;

   hError = m_pDirectDrawSurface->Unlock(NULL);
   if(ShowError(hError, "Lock"))
		return false;

   return true;
}


bool CDirectDraw::EraseSurface()
{
   if(m_bOverlay)
      return EraseOverlaySurface();
   else
      return ErasePrimarySurface();
}


bool CDirectDraw::FehlerStatus()
{
   return m_bError;
}


bool CDirectDraw::GetDC
(
   HDC *hDC
)
{
   HRESULT hError;

   hError = m_pDirectDrawSurface->GetDC(hDC);
   if(ShowError(hError, "GetDC"))
		return false;

   return true;
}


bool CDirectDraw::LockSurface
(
   void **pSurface,
   int   *nStartOfNextLine,
   bool   bAustastung
)
{
	DDSURFACEDESC  sDirectDrawSurfaceDesc;

   // Surrface erst locken wenn kein Bild ausgegeben wird
   if(bAustastung == true)
      if(m_pDirectDraw->WaitForVerticalBlank(DDWAITVB_BLOCKBEGIN, NULL))
	      return false;

   if(m_bOverlay == true)
   {
	   ZeroMemory(&sDirectDrawSurfaceDesc, sizeof(sDirectDrawSurfaceDesc));
      sDirectDrawSurfaceDesc.dwSize = sizeof(sDirectDrawSurfaceDesc);
      if(m_pDirectDrawOverlay->Lock(NULL, &sDirectDrawSurfaceDesc, 0, 0) != DD_OK)
		   return false;

      *pSurface = sDirectDrawSurfaceDesc.lpSurface;
      *nStartOfNextLine = sDirectDrawSurfaceDesc.lPitch;
   }
   else
   {
	   ZeroMemory(&sDirectDrawSurfaceDesc, sizeof(sDirectDrawSurfaceDesc));
      sDirectDrawSurfaceDesc.dwSize = sizeof(sDirectDrawSurfaceDesc);
      if(m_pDirectDrawSurface->Lock(NULL, &sDirectDrawSurfaceDesc, 0, 0) != DD_OK)
		   return false;

      *pSurface = sDirectDrawSurfaceDesc.lpSurface;
      *nStartOfNextLine = sDirectDrawSurfaceDesc.lPitch;
   }

   return true;
}


bool CDirectDraw::OpenDirectDraw
(
   int   nScreenWidth,
   int   nScreenHeight,
   int   nStatusHeight,
   DWORD dwCooperativeLevel
)

{
   int i;
   HRESULT        hError;
   DDSURFACEDESC  sDirectDrawSurfaceDesc;
   PALETTEENTRY   palette[256];
   LPDIRECTDRAWPALETTE lpDDPal;
	// DirectDraw Object ffnen
   if(DirectDrawCreate(NULL, &m_pDirectDraw, NULL) != DD_OK) {
   		Application->MessageBox("IDS_ERR_INITDIRECTDRAW","hoi",1);
		return false;
   }
   // Den Ganzen Bildschirm exklusiv besorgen
   hError = m_pDirectDraw->SetCooperativeLevel(m_hWnd, dwCooperativeLevel);
   if(ShowError(hError, "SetCooperativeLevel")) return false;
   if(m_bFensterModus == false)
   {
	   // Auflsung whlen
       	   if(m_pDirectDraw->SetDisplayMode(nScreenWidth, nScreenHeight, SCREEN_BITCOUNT) != DD_OK)
	   {
			Application->MessageBox("IDS_ERR_INITDIRECTDRAW","hoi",1);
			return false;
	   }
   }

   // Surface erzeugen
   //ZeroMemory(&sDirectDrawSurfaceDesc, sizeof(sDirectDrawSurfaceDesc));
   sDirectDrawSurfaceDesc.dwSize         = sizeof(sDirectDrawSurfaceDesc);
   sDirectDrawSurfaceDesc.dwFlags        = DDSD_CAPS;
   sDirectDrawSurfaceDesc.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE;
   hError = m_pDirectDraw->CreateSurface(&sDirectDrawSurfaceDesc, &m_pDirectDrawSurface, NULL);
   if(ShowError(hError, "CreateSurface"))
		return false;

   // Surface lschen
   if(m_bFensterModus == false)
      //ErasePrimarySurface();

   // Herausfinden ob es sich um eine RGB15 oder RGB16 Grafikkarte handelt
   ZeroMemory(&sDirectDrawSurfaceDesc, sizeof(sDirectDrawSurfaceDesc));
	sDirectDrawSurfaceDesc.dwSize = sizeof(sDirectDrawSurfaceDesc);
   hError = m_pDirectDraw->GetDisplayMode(&sDirectDrawSurfaceDesc);
   if(ShowError(hError, "GetDisplayMode"))
		return false;

   if(sDirectDrawSurfaceDesc.ddpfPixelFormat.dwGBitMask == 0x03e0)
      m_bRGB15 = true;
   else
      m_bRGB15 = false;

   // Overlay erzeugen
   if(m_bOverlay)
   {
      // Pixelformat fr Overlay
      DDPIXELFORMAT sDirectDrawPixelFormat;

      ZeroMemory(&sDirectDrawPixelFormat, sizeof(sDirectDrawPixelFormat));
      sDirectDrawPixelFormat.dwSize        = sizeof(DDPIXELFORMAT);
      sDirectDrawPixelFormat.dwFlags       = DDPF_FOURCC;
      sDirectDrawPixelFormat.dwFourCC      = OVERLAY_FORMAT;
      sDirectDrawPixelFormat.dwYUVBitCount = SCREEN_BITCOUNT;

      // Overlay erzeugen
      ZeroMemory(&sDirectDrawSurfaceDesc, sizeof(sDirectDrawSurfaceDesc));
	   sDirectDrawSurfaceDesc.dwSize          = sizeof(sDirectDrawSurfaceDesc);
	   sDirectDrawSurfaceDesc.dwFlags         = DDSD_CAPS | DDSD_HEIGHT | DDSD_WIDTH | DDSD_PIXELFORMAT;
	   sDirectDrawSurfaceDesc.ddsCaps.dwCaps  = DDSCAPS_OVERLAY | DDSCAPS_VIDEOMEMORY | DDSCAPS_LIVEVIDEO;
	   sDirectDrawSurfaceDesc.dwWidth         = m_nOverlayWidth;
	   sDirectDrawSurfaceDesc.dwHeight        = m_nOverlayHeight;
	   sDirectDrawSurfaceDesc.ddpfPixelFormat = sDirectDrawPixelFormat;
      if(m_pDirectDraw->CreateSurface(&sDirectDrawSurfaceDesc, &m_pDirectDrawOverlay, NULL) != DD_OK)
	   {
      		Application->MessageBox("IDS_ERR_INITDIRECTDRAW","hoi",1);
		   return false;
	   }

      // Overlay lschen
      EraseOverlaySurface();

      // Overlay aktivieren und positionieren
      if(m_bFensterModus == false)
      {
         RECT sRect;

         sRect.left   = 0;
         sRect.top    = 0;
         sRect.right  = nScreenWidth-1;
         sRect.bottom = nScreenHeight-1-nStatusHeight;
         if(UpdateOverlay(&sRect, DDOVER_SHOW) == false)
		      return false;
      }
   }

   // Cursor ausschalten
   if(m_bFensterModus == false)//      ShowCursor(false);
   for(i=0;i<256;i++) {
   	palette[i].peRed = i;
        palette[i].peGreen = i;
        palette[i].peBlue = i;
   	palette[i].peFlags = 0;
   }
   m_pDirectDraw->CreatePalette(DDPCAPS_8BIT,palette, &lpDDPal,NULL);
   if(lpDDPal != NULL) m_pDirectDrawSurface->SetPalette(lpDDPal);
   return true;
}


bool CDirectDraw::ReleaseDC
(
   HDC hDC
)
{
   HRESULT  hError;

   hError = m_pDirectDrawSurface->ReleaseDC(hDC);
   if(ShowError(hError, "ReleaseDC"))
		return false;

   return true;
}


bool CDirectDraw::RGB15()
{
   return m_bRGB15;
}


bool CDirectDraw::ShowError
(  
   HRESULT  hError,
   char    *strFunktion
)
{
   char strFormatString[100];
   char strMessage[200];

   if(hError != DD_OK)
   {
      Application->MessageBox("IDS_ERR_DIRECTDRAW","hoi",1);
      //sprintf(strMessage, strFormatString, strFunktion, hError & 0xFFFF);

      // Cursor einschalten
      if(m_bFensterModus == false)
         ShowCursor(true);

      MessageBox(m_hWnd, strMessage, "DirectDraw", MB_OK | MB_ICONEXCLAMATION);

      // Cursor ausschalten
      if(m_bFensterModus == false)
         ShowCursor(false);

      return true;
   }

   return false;
}


bool CDirectDraw::UnlockSurface()
{
   HRESULT hError;

   if(m_bOverlay == true)
   {
      hError = m_pDirectDrawOverlay->Unlock(NULL);
      if(ShowError(hError, "Unlock"))
		   return false;
   }
   else
   {
      hError = m_pDirectDrawSurface->Unlock(NULL);
      if(ShowError(hError, "Unlock"))
		   return false;
   }

   return true;
}


bool CDirectDraw::UpdateOverlay
(
   RECT  *pDestinationRect,
   DWORD  dwFlags
)
{
   RECT   sSourceRect;

   if(m_bOverlay == false)
      return false;

   sSourceRect.left   = 0;
   sSourceRect.top    = 2;
   sSourceRect.right  = m_nOverlayWidth;
   sSourceRect.bottom = m_nOverlayHeight-2;

   if(m_pDirectDrawOverlay->UpdateOverlay(&sSourceRect, m_pDirectDrawSurface, pDestinationRect, dwFlags, NULL) != DD_OK)
      return false;

   return true;
}
