#ifndef __DIRECTDRAW__
#define __DIRECTDRAW__


#include <ddraw.h>


class CDirectDraw  
{
   public:
	   CDirectDraw
      (
         HWND      hWnd,
         HINSTANCE hInstance,
         bool      bOverlay,
         int       nScreenWidth,
         int       nScreenHeight,
         int       nOverlayWidth,
         int       nOverlayHeight,
         int       nStatusHeight,
         bool      bFensterModus,
         DWORD     dwCooperativeLevel
      );

	   virtual ~CDirectDraw();

      bool EraseSurface();
      bool FehlerStatus();

      bool GetDC
      (
         HDC *hDC
      );

      bool LockSurface
      (
         void **pSurface,
         int   *nStartOfNextLine,
         bool   bAustastung
      );

      bool ReleaseDC
      (
         HDC hDC
      );

      bool RGB15();

      bool UpdateOverlay
      (
         RECT  *pDestinationRect,
         DWORD  dwFlags
      );

      bool UnlockSurface();

   private:
      void CloseDirectX();
      bool ErasePrimarySurface();
      bool EraseOverlaySurface();

      bool OpenDirectDraw
      (
         int   nScreenWidth,
         int   nScreenHeight,
         int   nStatusHeight,
         DWORD dwCooperativeLevel
      );

      bool ShowError
      (  
         HRESULT  hError,
         char    *strFunktion
      );

      bool                 m_bError;
      bool                 m_bRGB15;
      bool                 m_bOverlay;
      bool                 m_bFensterModus;
      int                  m_nOverlayWidth;
      int                  m_nOverlayHeight;
      HWND                 m_hWnd;
      HINSTANCE            m_hInstance;
/*
      LPDIRECTDRAW         m_pDirectDrawOld;
      LPDIRECTDRAW4        m_pDirectDraw;
      LPDIRECTDRAWSURFACE4 m_pDirectDrawSurface;
      LPDIRECTDRAWSURFACE4 m_pDirectDrawOverlay;
*/
      LPDIRECTDRAW         m_pDirectDraw;
      LPDIRECTDRAWSURFACE  m_pDirectDrawSurface;
      LPDIRECTDRAWSURFACE  m_pDirectDrawOverlay;
};

#endif
