#ifndef _CFS_FH_H_
#define _CFS_FH_H_

#ifdef NO_UTIMES
int		 utimes(char *, struct timeval tv[2]);
#endif /* NO_UTIMES */

/* Quick test if const char *s matches '.' or '..' */
#define	is_dot_or_dotdot(s)						\
	(s[0] == '.' && (s[1] == '\0' || (s[1] == '.' && s[2] == '\0')))

int		 readblock(char *, int, u_long, u_long, cfskey *, char *);
int		 writeblock(char *, int, u_long, u_long, cfskey *, char *);
char		*encryptname(cfskey *, char *);
void		 chksum(char *, long);
char		*decryptname(cfskey *, char *);
void		 doencrypt(cfskey *, char *, int, uint32_t, char *);
void		 dodecrypt(cfskey *, char *, int, uint32_t, char *);
int		 vtod(int);
int		 dtov(int);
int		 isbndry(int);
cfs_fileid	*geth(nfs_fh *);
int		 htype(cfs_fileid *);
int		 iid(cfs_fileid *);
int		 fhowner(cfs_fileid *, int);
int		 fhmode(cfs_fileid *, int);
int		 fhid(cfs_fileid *);
int		 fhpid(cfs_fileid *);
int		 fhuid(cfs_fileid *, int);
int		 cfsno(int);
int		 fhtofd(cfs_fileid *, int);
int		 modeof(char *);
int		 fhgetstat(cfs_fileid *, struct stat *);
void		 closeout(cfs_fileid *);
void		 closeall();
int		 fhsetattr(cfs_fileid *, sattr *);
int		 fhsetattrprime(cfs_fileid *, sattr *);
int		 fhmkdirent(cfs_fileid *, char *, nfs_fh *);
int		 fhmkfileent(cfs_fileid *, char *, nfs_fh *);
#ifdef SHORTLINKS
int		 mkhandle(cfs_fileid *, char *, char *, int , nfs_fh *, char *, char *,
		     int);
#else
int		 mkhandle(cfs_fileid *, char *, char *, int , nfs_fh *, char *, char *);
#endif /* SHORTLINKS */
int		 fhlook(cfs_fileid *, char *, nfs_fh *);
void		 inserth(cfs_fileid *);
void		 fillinh(nfs_fh *, int, int, u_char *);
int		 fhdelete(cfs_fileid *, char *);
int		 fhdeletedir(cfs_fileid *, char *);
DIR		*fhopendir(cfs_fileid *);
void		 fhclosedir(DIR *);
int		 fhlinkval(cfs_fileid *, char *);
int		 fhdohardlink(cfs_fileid *, cfs_fileid *, char *);
int		 fhdosymlink(cfs_fileid *, char *, char *);
int		 fhrename(cfs_fileid *, char *, cfs_fileid *, char *);
int		 getftype(int);
struct	dirent	*rootrd(int32_t);
int		 fhrootlook(char *, nfs_fh *);

#endif /* !_CFS_FH_H_ */
