; Calculator

.486p
.model flat
MASM
Locals @@
Jumps

%noincl                                         ; dont add includes to listing
;include w32.inc
;include Win32Inc.inc

include win32.inc
include winmsg.inc                              ; windows messgage header
include winuser.inc

include calc.inc                                ; program specific stuff
include resource.ash                            ; Resource definitions

;------------------------------------------------------------------------------------------------------------
MAX_INPUT       equ     0FFFFFFFFh
NULL            equ     0h
IDC_ARROW       equ     32512
DLGWINDOWEXTRA  equ     30

;------------------------------------------------------------------------------------------------------------
.data                                           ; initialized data
align DWORD
iDataType       dd              8               ; current data type choice (2=BYTE, 4=WORD, 8=DWORD)
iByteOrder      dd              0               ; currnet byte ordering (0=RAW, 1=Intel)
iInputType      dd              IDC_RADIO_HEX   ; current input type
wMsg            MSG             <0>

;------------------------------------------------------------------------------------------------------------
.data?                                          ; uninitialized data
align DWORD
hInst           HINSTANCE       ?               ; global application instance
hMain           HWND            ?               ; handle of main dialog box window
hAccel          HACCEL          ?               ; handle of accelerator table

align DWORD
lpszInput       db              32 dup (?)      ; input buffer
lpszOutput      db              32 dup (?)      ; output buffer
lpszBuffer      db              32 dup (?)      ; misc buffer
iInput          dd              ?               ; input buffer (numeric)


;------------------------------------------------------------------------------------------------------------
.const                                          ; constant data segment
dlgError1       db              'Error creating Main dialog!',0
accelError1     db              'Error loading accelerator table!',0
inputError1     db              'Invalid Input!',0
wcClass         db              'DLGMAIN',0

dType1          db              'BYTE',0,0,0,0
dType2          db              'WORD',0,0,0,0
dType3          db              'DWORD',0,0,0
dType4          db              'QWORD',0,0,0

bOrder1         db              'Raw Hex',0
bOrder2         db              'Intel',0,0,0

;------------------------------------------------------------------------------------------------------------
.code
align DWORD
start:                                          ; Entry Point
        push    0h
        call    GetModuleHandle                 ; get hInst (in eax)
        mov     hInst,eax

        call    WinMain                         ; WinMain
@@exit:
        push    eax
        call    ExitProcess                     ; eax = Exit Code
                                                ; Program Terminates Here

;------------------------------------------------------------------------------------------------------------
align DWORD
WinMain proc
        call    InitWindow
        test    eax,eax
        jz      @@return

; Create Main (Dialog) Window
        push    0h
        push    offset MainDialogProc           ; lpDialogFunc (address of dialog procedure)
        call    GetDesktopWindow
        push    eax                             ; hWndParent (handle of owner window)
        push    IDD_DIALOG_MAINDLG              ; lpTemplate (identifies dialog box template name)
        push    hInst                           ; hInstance (handle of application instance)
        call    CreateDialogParamA
        test    eax,eax
        jz      @@return
        mov     hMain,eax

        call    InitDialog

; Get Accelerator table
        push    IDA_ACCEL1                      ; lpTableName (address of table-name string)
        push    hInst                           ; hInstance (handle of application instance)
        call    LoadAccelerators                ; HACCEL LoadAccelerators(HINSTANCE Hinst, LPSTR lpTableName);
        test    eax,eax                         ; if return is NULL, quit
        jz      @@return
        mov     eax,hAccel                      ; save handle of accelerator table

; Window Messaging Loop
@@MessageLoop:                                  ; Message Dispatch Loop
        push    0h                              ; uMsgFilterMax (last message)
        push    0h                              ; uMsgFilterMin (first message)
        push    NULL                            ; hWnd (handle of window)
        push    offset wMsg                     ; lpMsg (address of structure with message)
        call    GetMessage                      ; BOOL GetMessage()
        test    eax,eax                         ; if GetMessage returns false (WM_QUIT), exit loop
        jz      @@quit

        push    offset wMsg                     ; lpmsg (address of structure with message)
        push    hAccel                          ; haccl (handle of accelerator table)
        push    wMsg.hwnd                       ; hwnd (handle of destination window)
        call    TranslateAccelerator            ; int TranslateAccelerator(hwnd, haccl, lpmsg)

        push    offset wMsg                     ; lpmsg (address of structure with message)
        call    TranslateMessage                ; BOOL TranslateMessage(const MSG *lpmsg);

        push    offset wMsg                     ; lpmsg (address of structure with message)
        call    DispatchMessage                 ; long DispatchMessage(const MSG *lpmsg);
        jmp     @@MessageLoop

; Exit WinMain
@@quit:
        mov     eax, wMsg.wParam                 ; wParam = Exit Code
@@return:
        ret
WinMain endp


;;-----------------------------------------------------------------------------------------------------------
align DWORD
MainDialogProc proc STDCALL
        ARG @@hwndDlg:DWORD, @@message:DWORD, @@wParam:DWORD, @@lParam:DWORD
; translate messages:
        mov     eax,@@message                   ; eax = message

        cmp     eax,WM_CLOSE
        je      @@wmclose
        cmp     eax,WM_INITDIALOG
        je      @@initdialog
        cmp     eax,WM_COMMAND
        je      @@command
        jmp     @@default

@@wmclose:
        push    0h
        call    PostQuitMessage
        jmp     @@default

@@initdialog:
        ;call    InitDialog
        mov     eax,1
        jmp     @@return

;----------------------------------------------------------------------------
@@command:
        mov     eax,@@wParam
        mov     ebx,eax
        and     eax,0FFFF0000h                  ; eax = HIWORD of wParam
        ;shr     eax,16
        and     ebx,0000FFFFh                   ; ebx = LOWORD of wParam

        cmp     ebx,IDC_BUTTON1
        jb      @@A
        cmp     ebx,IDC_BUTTON_PLUSMIN
        ja      @@A
        jmp     @@cmd_button_keypad             ; keypad button message
@@A:
        cmp     ebx,IDC_RADIO_BIN
        jb      @@B
        cmp     ebx,IDC_RADIO_HEX
        ja      @@B
        jmp     @@cmd_button_inputtype
@@B:
        cmp     ebx,IDC_EDIT_INPUT
        je      @@cmd_edit

        jmp     @@default

@@cmd_button_inputtype:
        cmp     eax,BN_CLICKED
        jne     @@return

        mov     iInputType,ebx                  ; put radio ID into iInputType

        push    NULL                            ; lParam (must be 0)

        cmp     ebx,IDC_RADIO_HEX
        je      @@AA
        cmp     ebx,IDC_RADIO_DEC
        je      @@BB
        push    32
        jmp     @@CC
@@AA:
        push    8
        jmp     @@CC
@@BB:
        push    10
@@CC:
        push    EM_SETLIMITTEXT                 ; uMsg (message to send)
        push    IDC_EDIT_INPUT                  ; idControl (identifier of control)
        push    hMain                           ; hwndDlg (handle of dialog box)
        call    SendDlgItemMessage              ;

        jmp     @@return

@@cmd_button_keypad:
        jmp     @@return

@@cmd_edit:
        push    NULL                            ; lParam (0)
        push    NULL                            ; wParam (0)
        push    EM_GETMODIFY                    ; uMsg (message to send)
        push    IDC_EDIT_INPUT                  ; idControl (identifier of control)
        push    hMain                           ; hwndDlg (handle of dialog box)
        call    SendDlgItemMessage              ;
        test    eax,eax                         ; if edit control not changed, retutn
        je      @@return

        push    offset lpszInput                ; lParam (address of buffer)
        push    32                              ; wParam (line 0)
        push    WM_GETTEXT                      ; uMsg (message to send)
        push    IDC_EDIT_INPUT                  ; idControl (identifier of control)
        push    hMain                           ; hwndDlg (handle of dialog box)
        call    SendDlgItemMessage              ;

        mov     eax,offset lpszInput
        mov     ebx,iInputType
        sub     ebx,IDC_RADIO_BASE
        call    StrToNum                        ; convert text buffer to number

        cmp     eax,MAX_INPUT
        jbe     @@C

        push    offset inputError1              ; lParam (address of text)
        push    0                               ; wParam (0)
        push    WM_SETTEXT                      ; uMsg (message to send)
        push    IDC_EDIT_INPUT                  ; idControl (identifier of control)
        push    hMain                           ; hwndDlg (handle of dialog box)
        call    SendDlgItemMessage              ;

@@C:
        call    UpdateValues                    ; update bin/hex/dex etc
        jmp     @@return

;----------------------------------------------------------------------------
@@default:
        push    @@lParam
        push    @@wParam
        push    @@message
        push    @@hwndDlg
        call    DefWindowProc
@@return:
        ret
MainDialogProc endp

;;-----------------------------------------------------------------------------------------------------------
align DWORD
InitWindow proc
        LOCAL   @@wc:WNDCLASSEX

        mov     @@wc.cbSize, WNDCLASSEX_SIZE    ; size
        mov     @@wc.style,1000h                ; class style  (CS_BYTEALIGNCLIENT)
        mov     @@wc.lpfnWndProc,offset MainDialogProc; points to window procedure
        mov     @@wc.cbClsExtra,0               ; num bytes to alloc after WNDCLASS struct
        mov     @@wc.cbWndExtra,DLGWINDOWEXTRA  ; num bytes to alloc after instance
        mov     eax,hInst
        mov     @@wc.hInstance,eax              ; instance window proc is in
        push    IDI_ICON1
        push    hInst
        call    LoadIcon                        ; get icon IDI_ICON1
        mov     @@wc.hIcon,eax                  ; class icon
        mov     @@wc.hIconSm,eax
        push    IDC_ARROW
        push    0
        call    LoadCursor                      ; get cursor IDC_ARROW
        mov     @@wc.hCursor,eax                ; class cursor
        mov     @@wc.hbrBackground,COLOR_WINDOW ; background brush
        mov     @@wc.lpszMenuName,0             ; resource name of the class menu
        mov     @@wc.lpszClassName,offset wcClass ; window class name

        lea     eax,@@wc
        push    eax
        call    RegisterClassEx                   ; register class wc

        ret
InitWindow endp

;------------------------------------------------------------------------------------------------------------
align DWORD
InitDialog proc
; Initialize Data Type Combo-Box
        push    offset dType1                   ; lParam (address of string)
        push    NULL                            ; wParam (must be 0)
        push    CB_ADDSTRING                    ; uMsg (message to send)
        push    IDC_COMBOBOX_TYPE               ; idControl (identifier of control)
        push    hMain                           ; hwndDlg (handle of dialog box)
        call    SendDlgItemMessage              ;

        push    offset dType2                   ; lParam (address of string)
        push    NULL                            ; wParam (must be 0)
        push    CB_ADDSTRING                    ; uMsg (message to send)
        push    IDC_COMBOBOX_TYPE               ; idControl (identifier of control)
        push    hMain                           ; hwndDlg (handle of dialog box)
        call    SendDlgItemMessage              ;

        push    offset dType3                   ; lParam (address of string)
        push    NULL                            ; wParam (must be 0)
        push    CB_ADDSTRING                    ; uMsg (message to send)
        push    IDC_COMBOBOX_TYPE               ; idControl (identifier of control)
        push    hMain                           ; hwndDlg (handle of dialog box)
        call    SendDlgItemMessage              ;

        push    offset dType4                   ; lParam (address of string)
        push    NULL                            ; wParam (must be 0)
        push    CB_ADDSTRING                    ; uMsg (message to send)
        push    IDC_COMBOBOX_TYPE               ; idControl (identifier of control)
        push    hMain                           ; hwndDlg (handle of dialog box)
        call    SendDlgItemMessage              ;

        push    NULL                            ; lParam (0)
        push    2                               ; wParam (index) (2h=DWORD)
        push    CB_SETCURSEL                    ; uMsg (message to send)
        push    IDC_COMBOBOX_TYPE               ; idControl (identifier of control)
        push    hMain                           ; hwndDlg (handle of dialog box)
        call    SendDlgItemMessage              ; select default value

; Initialize Byte Ordering Combo-Box
        push    offset bOrder1                  ; lParam (address of string)
        push    NULL                            ; wParam (must be 0)
        push    CB_ADDSTRING                    ; uMsg (message to send)
        push    IDC_COMBOBOX_ORDER              ; idControl (identifier of control)
        push    hMain                           ; hwndDlg (handle of dialog box)
        call    SendDlgItemMessage              ;

        push    offset bOrder2                  ; lParam (address of string)
        push    NULL                            ; wParam (must be 0)
        push    CB_ADDSTRING                    ; uMsg (message to send)
        push    IDC_COMBOBOX_ORDER              ; idControl (identifier of control)
        push    hMain                           ; hwndDlg (handle of dialog box)
        call    SendDlgItemMessage              ;

        push    NULL                            ; lParam (0)
        push    0                               ; wParam (index) (0h=raw)
        push    CB_SETCURSEL                    ; uMsg (message to send)
        push    IDC_COMBOBOX_ORDER              ; idControl (identifier of control)
        push    hMain                           ; hwndDlg (handle of dialog box)
        call    SendDlgItemMessage              ; select default value

;Initialize Input Type Radio Button
        push    NULL                            ; lParam (must be 0)
        push    BST_CHECKED                     ; wParam
        push    BM_SETCHECK                     ; uMsg (message to send)
        push    iInputType                      ; idControl (identifier of control)
        push    hMain                           ; hwndDlg (handle of dialog box)
        call    SendDlgItemMessage              ;

;Initialize Edit Control
        push    NULL                            ; lParam (must be 0)
        push    8                               ; wParam (limit in bytes)
        push    EM_SETLIMITTEXT                 ; uMsg (message to send)
        push    IDC_EDIT_INPUT                  ; idControl (identifier of control)
        push    hMain                           ; hwndDlg (handle of dialog box)
        call    SendDlgItemMessage              ;


@@return:
        ret
InitDialog endp

;------------------------------------------------------------------------------------------------------------

align DWORD
UpdateValues proc STDCALL
        LOCAL   @@Number:DWORD

        mov     @@Number,eax
; Hexadecimal Output
        mov     ebx,16
        mov     ecx,iDataType
        mov     edi,offset lpszOutput
        call    NumToStr

        push    edi                             ; lParam (address of string)
        push    0                               ; wParam (0)
        push    WM_SETTEXT                      ; uMsg (message to send)
        push    IDC_OUTPUT_HEX                  ; idControl (identifier of control)
        push    hMain                           ; hwndDlg (handle of dialog box)
        call    SendDlgItemMessage              ;

; Decimal Output
        mov     eax,@@Number
        mov     ebx,10
        mov     ecx,10
        mov     edi,offset lpszOutput
        call    NumToStr

        push    edi                             ; lParam (address of string)
        push    0                               ; wParam (0)
        push    WM_SETTEXT                      ; uMsg (message to send)
        push    IDC_OUTPUT_DEC                  ; idControl (identifier of control)
        push    hMain                           ; hwndDlg (handle of dialog box)
        call    SendDlgItemMessage              ;

; Binary Output
        mov     eax,@@Number
        mov     ebx,2
        mov     ecx,32
        mov     edi,offset lpszOutput
        call    NumToStr

        push    edi                             ; lParam (address of string)
        push    0                               ; wParam (0)
        push    WM_SETTEXT                      ; uMsg (message to send)
        push    IDC_OUTPUT_BIN                  ; idControl (identifier of control)
        push    hMain                           ; hwndDlg (handle of dialog box)
        call    SendDlgItemMessage              ;

        ret
UpdateValues endp

;------------------------------------------------------------------------------------------------------------
; Parameters:
;   eax = address of string
;   ebx = input base (16=hex, 10=dec, 2=bin)
; Returns:
;   eax = numeric value
;   cf  = 1 if error
; Used Registers:
;   destroys = eax, ebx, ecx, edx, esi, edi
;   saves    = ebp
align   DWORD
StrToNum proc
        push    ebp                             ; save registers

        push    eax                             ; save string address
        cld                                     ; auto increment edi and esi

; find length of input string (into ebp)
        xor     ebp,ebp                         ; initialize length ebp to 0
        mov     esi,eax                         ; load esi with source address
@@lenloop:
        lodsb                                   ; get next character from address esi
        cmp     al,0                            ; continue until char = 0
        je      @@lendone
        inc     ebp                             ; ecx = strlen
        jmp     @@lenloop

@@lendone:
        pop     eax                             ; restore string address

; convert string to numerical value (into eax)
        mov     esi,eax                         ; load esi with source address
        xor     edi,edi                         ; clear total edi

@@repeat:
        cmp     ebp,0                           ; if no more characters, quit
        je      @@done

        dec     ebp                             ; adjust offset ebp
        xor     eax,eax
        lodsb                                   ; get next character at esi into al

        mov     ah,al                           ; save al in ah
; decimal numbers
        sub     al,'0'
        cmp     al,9
        jbe     @@begin
; uppercase hex numbers
        mov     al,ah
        sub     al,'A'
        add     al,0Ah
        cmp     al,15
        jbe     @@begin
; lowercase hex numbers
        mov     al,ah
        sub     al,'a'
        add     al,0Ah
        cmp     al,15
        jbe     @@begin
; Invalid character found
        stc                                     ; error flag zf set
        xor     eax,eax                         ; result is 0
        jmp     @@return

; al  = numeric value of current char
; ebx = number radix
; ebp = offset
@@begin:
        xor     ah,ah                           ; zero ah so eax contains numeric val

; edx = ah * BASE^offset
        mov     edx,eax                         ; init edi to al for multiplication
        cmp     ebp,0                           ; skip if on last character
        je      @@loop1end
        mov     ecx,ebp                         ; loop <offset> number of times
@@loop1:
        imul    edx,ebx                         ; find BASE^ofsset
        loop    @@loop1
@@loop1end:

; update running total edi
        add     edi,edx                         ; total in edi
        jmp     @@repeat                        ; repeat with next character
@@done:
        mov     eax,edi                         ; mov edi into eax
        clc                                     ; no error

@@return:
        pop     ebp                             ; restore registers

        ret
StrToNum endp





;------------------------------------------------------------------------------------------------------------
NumToStr proc
; eax = number
; ebx = base
; ecx = num chars
; edi = address of string
; return:
;
; Binary:  insert space every 4
; Decimal: comma every 3

                                                ; ebp is buffer position
        cld                                     ; auto increment edi
        push    edi
        push    ebp

        xor     ebp,ebp

; loop to get the characters
@@loop1:
        xor     edx,edx
        idiv    ebx

        cmp     dl,9
        ja      @@A
        add     dl,'0'
        jmp     @@gotchar
@@A:
        add     dl,'A'-10
@@gotchar:
        mov     byte ptr [lpszBuffer+ebp], dl
        inc     ebp

        cmp     eax,0
        je      @@endloop1
        jmp     @@loop1

; got all of the characters
@@endloop1:
        mov     ecx, ebp                ; number of characters
        xor     ebp,ebp

        cmp     ebx,16
        je      @@hexadecimal
        cmp     ebx,10
        je      @@decimal
        jmp     @@binary

; Hexadeciaml
@@hexadecimal:
@@hexloop:
        mov     al, byte ptr [lpszBuffer+ebp]
        inc     ebp
        stosb

        loop    @@hexloop
        jmp     @@done

; Decimal Formatting
@@decimal:
@@decloop:
        mov     al, byte ptr [lpszBuffer+ebp]
        inc     ebp
        stosb

        loop    @@decloop
        jmp     @@done

; Binary Formatting
@@binary:
        mov     eax,ecx
        mov     ebx,4
        call    Modulus
        sub     ebx,eax                         ; ebx = num zeros to pad

        cmp     ebx,0
        je      @@binloop
        xchg    ecx,ebx
        mov     al,'0'
        rep     stosb                           ; pad zeros
        xchg    ecx,ebx

@@binloop:
        mov     al, byte ptr [lpszBuffer+ebp]
        inc     ebp
        stosb

; get modulus
        mov     eax,ebp
        mov     ebx,4
        call    Modulus

        cmp     eax,0
        jne     @@nospace
        mov     al,' '
        stosb

@@nospace:
        loop    @@binloop
        jmp     @@done

; Done
@@done:
        xor     eax,eax
        stosb                                   ; add terminator

        pop     ebp
        pop     edi

        ret
NumToStr endp


;-----------------------------------------------------------------------------------------------------
; eax = number
; ebx = mod
;
; returns: eax = (eax % ebx)
Modulus proc
        cmp     eax,ebx
        jl      @@done
@@begmod:
        sub     eax,ebx
        cmp     eax,ebx
        jge     @@begmod
@@done:
        ret
Modulus endp
;------------------------------------------------------------------------------------------------------------
end     start
