; WIN32.INC - Win32 assembly language structures & constants
; For TASM 5.0

; Basic Windows Types -----------------------------------------------------------------
UCHAR           equ <db>
UCHAR_          equ <byte>
CHAR            equ <db>
CHAR_           equ <byte>
USHORT          equ <dw>
USHORT_         equ <word>
UINT            equ <dd>
UINT_           equ <dword>
ULONG           equ <dd>
ULONG_          equ <dword>

ATOM            equ <dw>
ATOM_           equ <word>
BOOL            equ <dd>
BOOL_           equ <dword>
LPBYTE          equ <ptr byte>
LPBYTE_         equ <dword>
LPDWORD         equ <ptr dword>
LPDWORD_        equ <dword>
LPVOID          equ <ptr>
LPVOID_         equ <dword>
LPCVOID         equ <ptr>
LPCVOID_        equ <dword>
LPSTR           equ <dd>
LPSTR_          equ <dword>
LPCSTR          equ <dd>
LPCSTR_         equ <dword>
LPCTSTR         equ <dd>
LPCTSTR_        equ <dword>
PSZ             equ <dd>
PSZ_            equ <dword>

WPARAM          equ <dd>
WPARAM_         equ <dword>
LPARAM          equ <dd>
LPARAM_         equ <dword>
LRESULT         equ <dd>
LRESULT_        equ <dword>

TRUE            equ 1
FALSE           equ 0
NULL            equ 0

; Handles -------------------------------------------------------------------------------
HANDLE          equ <dd>
HANDLE_         equ <dword>
HGOBAL          equ <dd>
HGLOBAL_        equ <dword>
HLOCAL          equ <dd>
HLOCAL_         equ <dword>
GLOBALHANDLE    equ <dd>
GLOBALHANDLE_   equ <dword>
LOCALHANDLE     equ <dd>
LOCALHANDLE_    equ <dword>
HWND            equ <dd>
HWND_           equ <dword>
HHOOK           equ <dd>
HHOOK_          equ <dword>
HGDIOBJ         equ <dd>
HGDIOBJ_        equ <dword>
HACCEL          equ <dd>
HACCEL_         equ <dword>
HBITMAP         equ <dd>
HBITMAP_        equ <dword>
HBRUSH          equ <dd>
HBRUSH_         equ <dword>
HDC             equ <dd>
HDC_            equ <dword>
HFONT           equ <dd>
HFONT_          equ <dword>
HICON           equ <dd>
HICON_          equ <dword>
HMENU           equ <dd>
HMENU_          equ <dword>
HINSTANCE       equ <dd>
HINSTANCE_      equ <dword>
HRGN            equ <dd>
HRGN_           equ <dword>
HCURSOR         equ <dd>
HCURSOR_        equ <dword>
HFILE           equ <dd>
HFILE_          equ <dword>
COLORREF        equ <dd>
COLORREF_       equ <dword>
WNDPROC         equ <dd>
WNDPROC_        equ <dword>

; Structures and Such ----------------------------------------------------------------------

; windef.h
RECT    struc
        left    ULONG   ?
        top     ULONG   ?
        right   ULONG   ?
        bottom  ULONG   ?
RECT    ends

POINT   struc
        x       ULONG   ?
        y       ULONG   ?
POINT   ends

MSG     struc
        hwnd    HWND    ?
        message dd      ?
        wParam  WPARAM  ?
        lParam  WPARAM  ?
        time    dd      ?
        pt      POINT   ?
MSG     ends


; Window's externals -----------------------------------------------------------------------------
extern    BeginPaint:PROC
extern    CloseHandle:PROC
extern    CreateDialogParamA:PROC
extern    CreateToolbar:PROC
extern    CreateToolbarEx:PROC
extern    CreateWindowExA:PROC
extern    DefWindowProcA:PROC
extern    DeleteDC:PROC
extern    DialogBoxParamA:PROC
extern    DispatchMessageA:PROC
extern    EndDialog:PROC
extern    EndDoc:PROC
extern    EndPaint:PROC
extern    EndPage:PROC
extern    ExitProcess:PROC
extern    FindWindowA:PROC
extern    GetDC:PROC
extern    GetDlgItem:PROC
extern    GetDlgItemTextA:PROC
extern    GetLocalTime:PROC
extern    GetMessageA:PROC
extern    GetModuleHandleA:PROC
extern    GetOpenFileNameA:PROC
extern    GetSaveFileNameA:PROC
extern    GetStockObject:PROC
extern    GetSystemMetrics:PROC
extern    GetTextMetricsA:PROC
extern    GetWindowRect:PROC
extern    GlobalAlloc:PROC
extern    GlobalFree:PROC
extern    InitCommonControls:PROC
extern    InvalidateRect:PROC
extern    KillTimer:PROC
extern    LoadAcceleratorsA:PROC
extern    LoadCursorA:PROC
extern    LoadIconA:PROC
extern    LoadMenuA:PROC
extern    LoadStringA:PROC
extern    MessageBeep:PROC
extern    MessageBoxA:PROC
extern    MoveWindow:PROC
extern    OpenFile:PROC
extern    PostQuitMessage:PROC
extern    PrintDlgA:PROC
extern    ReadFile:PROC
extern    RegisterClassA:PROC
extern    RegisterClassExA:PROC
extern    SendMessageA:PROC
extern    SetFocus:PROC
extern    SetTimer:PROC
extern    SetWindowPos:PROC
extern    ShowWindow:PROC
extern    StartDocA:PROC
extern    StartPage:PROC
extern    TextOutA:PROC
extern    TranslateAcceleratorA:PROC
extern    TranslateMessage:PROC
extern    UpdateWindow:PROC
extern    WinHelpA:PROC
extern    WriteFile:PROC

CreateWindowEx   equ <CreateWindowExA>
DefWindowProc    equ <DefWindowProcA>
DialogBoxParam   equ <DialogBoxParamA>
DispatchMessage  equ <DispatchMessageA>
FindWindow       equ <FindWindowA>
GetDlgItemText   equ <GetDlgItemTextA>
GetMessage       equ <GetMessageA>
GetModuleHandle  equ <GetModuleHandleA>
GetOpenFileName  equ <GetOpenFileNameA>
GetSaveFileName  equ <GetSaveFileNameA>
GetTextMetrics   equ <GetTextMetricsA>
LoadAccelerators equ <LoadAcceleratorsA>
LoadCursor       equ <LoadCursorA>
LoadIcon         equ <LoadIconA>
LoadMenu         equ <LoadMenuA>
LoadString       equ <LoadStringA>
MessageBox       equ <MessageBoxA>
PrintDlg         equ <PrintDlgA>
RegisterClass    equ <RegisterClassA>
RegisterClassEx  equ <RegisterClassExA>
SendMessage      equ <SendMessageA>
StartDoc         equ <StartDocA>
TextOut          equ <TextOutA>
TranslateAccelerator equ <TranslateAcceleratorA>
WinHelp          equ <WinHelpA>
