; edit.asm
; (C) Copyright 1999  
; Bill (billasm@usa.net)


.486p
.model flat, stdcall

include windows.inc  
include kernel32.inc 
include user32.inc  
include comctl32.inc 
include comdlg32.inc

include resource.inc                                
                  
includelib kernel32.lib       
includelib user32.lib   
includelib comctl32.lib
includelib comdlg32.lib

WinMain PROTO
InitWindow PROTO
InitFile PROTO
InitEditControl PROTO

EditOpenFile PROTO
EditSaveFile PROTO

FileOpen PROTO :DWORD
FileSave PROTO :DWORD

ConfirmOperation PROTO
SetTitle PROTO

GetCommandLineArgs PROTO

m2m MACRO M1, M2 
	push M2 
	pop  M1 
ENDM 

;---------------------------------------------------------------------------------------------
.data
		
.data?		
	hWndMain		dd	?
	hWndEdit		dd	?
	hInst			dd	?       
	hAccel			dd	?
	wMsg			MSG	<?>
	szCurFileName	db	MAX_PATH dup(?)		
		
.const
	szMainWndClass	db	"MainWndClass",0
	szEditClass		db	"EDIT",0
	szWndTitle		db	"Edit Control Example - ",0
	szMainMenu		db	"MAINMENU",0
	szAccelerator	db	"MAINACCEL",0
	
	szAboutTitle	db 	"About Edit",0
	szAboutMsg		db	"Assembly Language Edit Control Example",10,13
					db  "February 19, 1999",10,13
					db  "billasm@usa.net",0
					
	szSaveFile		db	"Save File",0
	szConfirmSave	db	"File is not saved! Continue?",0	
	szOpenFilter	db	"Text Files (*.txt)",0,"*.txt",0
					db  "All Files (*.*)",0,"*.*",0,0
					
	szFileTooBig	db	"File is too big to load.",0
	szError			db 	"Error!",0
	
	szNULL			db	0
	szUntitled		db	"Untitled",0

;------------------------------------------------------------------------------------------------------------
								
.code
start:
    invoke  GetModuleHandle, 0h             ; get hInst (in eax)
    mov     hInst,eax
               
	invoke	InitCommonControls				; needed to load the edit control class

    invoke	WinMain

    invoke  ExitProcess, eax                ; eax = Exit Code
											; Program Terminates Here

;------------------------------------------------------------------------------------------------------------

align DWORD
WinMain proc
	; Initialize the main app window
	invoke	InitWindow  					
	test	eax,eax
	jz		quit
	
	; Initialize the edit control
	invoke	InitEditControl					
    test	eax,eax
    jz		quit
    
    ; Get command line and open the file (if any)
    invoke	InitFile
    test	eax,eax
    jz		quit
    
    ; load accelerator table        
    invoke	LoadAccelerators, hInst, addr szAccelerator
    test	eax,eax
    jz		quit
    mov		hAccel, eax
        
; Message Dispatch Loop        
MessageLoop:                                  	
    invoke	GetMessage,			; Get next message
			addr wMsg,
			NULL,
			0h,
			0h
    test    eax,eax
    jz      quit
        		
	invoke	TranslateAccelerator,		; check if its an accelerator msg
			hWndMain,
			hAccel,
			addr wMsg
	test	eax,eax
	jnz		MessageLoop
			                   
    invoke  TranslateMessage, addr wMsg

    invoke  DispatchMessage, addr wMsg 

    jmp     MessageLoop
        
; Exit WinMain
quit:
    mov     eax, wMsg.wParam                 ; wParam = Exit Code
    ret
WinMain endp


;------------------------------------------------------------------------------------------------------------
align DWORD
InitWindow proc
    LOCAL   wc:WNDCLASSEX

	; set up window class
    mov     wc.cbSize, sizeof WNDCLASSEX    
    mov     wc.style, CS_VREDRAW + CS_HREDRAW + CS_DBLCLKS + CS_BYTEALIGNCLIENT + CS_BYTEALIGNWINDOW     													
    mov     wc.lpfnWndProc,offset MainWndProc
    mov     wc.cbClsExtra,0               	
    mov     wc.cbWndExtra,0				  	                               
	mov     eax,hInst
    mov     wc.hInstance,eax              			
	invoke	LoadIcon, eax, IDI_ICON1		
    mov     wc.hIcon,eax                  	     
    invoke	LoadImage, hInst, IDI_ICON1, IMAGE_ICON, 16, 16, 0
    mov     wc.hIconSm,eax
	invoke	LoadCursor, 0, IDC_ARROW	  	
    mov     wc.hCursor,eax               
    mov     wc.hbrBackground,COLOR_WINDOW+1 
    mov     wc.lpszMenuName, MAINMENU     
    mov     wc.lpszClassName,offset szMainWndClass 

	; register class wc
    lea     eax,wc
    invoke  RegisterClassEx, eax
                  
		
	; create the window
	invoke	CreateWindowEx, 
			WS_EX_ACCEPTFILES + WS_EX_APPWINDOW, 
			addr szMainWndClass, 
			addr szWndTitle,
			WS_OVERLAPPEDWINDOW or WS_VISIBLE,
			CW_USEDEFAULT, 
			CW_USEDEFAULT, 
			CW_USEDEFAULT, 
			CW_USEDEFAULT, 
			0,
			0, 
			hInst, 
			0
    mov		hWndMain, eax
               
	ret
InitWindow endp


;------------------------------------------------------------------------------------------------
align DWORD
InitEditControl proc
	LOCAL	rectClient:RECT

	; get client area
	invoke	GetClientRect, hWndMain, addr rectClient
	test	eax,eax
	jz		return
		
	; create the window
	invoke	CreateWindowEx, 
			WS_EX_ACCEPTFILES or WS_EX_CLIENTEDGE, 
			addr szEditClass, 
			NULL,
			WS_CHILD or WS_VISIBLE or WS_HSCROLL or WS_VSCROLL or ES_MULTILINE or ES_AUTOVSCROLL or ES_AUTOHSCROLL,
			rectClient.left, 
			rectClient.top, 
			rectClient.right, 
			rectClient.bottom, 
			hWndMain,
			0, 
			hInst, 
			0
    mov		hWndEdit, eax

return:
	ret
InitEditControl endp


;------------------------------------------------------------------------------------------------
align DWORD
InitFile proc
	invoke	GetCommandLineArgs	
	test	eax,eax
	jz		no_args
			
	invoke	FileOpen, eax
no_args:		
	invoke	SetTitle		
	
	mov		eax, TRUE		
	ret
InitFile endp


;------------------------------------------------------------------------------------------------
align DWORD
MainWndProc proc hWnd:DWORD, uMsg:DWORD, wParam:DWORD, lParam:DWORD
	LOCAL	rectClient:RECT
	LOCAL	bRepaint:DWORD
	LOCAL	szBuffer[MAX_PATH]:BYTE
		
	mov	eax, uMsg
	
	; on destroy the main window
	.IF	eax == WM_DESTROY
		invoke 	PostQuitMessage, NULL		

	; menu command messages
	.ELSEIF	eax == WM_COMMAND
		mov	eax, wParam
		and 	eax, 0000FFFFh 	; LOWORD(wParam)
				
		.IF 	eax == IDM_QUIT
			invoke PostQuitMessage, NULL

		.ELSEIF eax == IDM_NEW
			invoke	ConfirmOperation
			.IF	eax == IDYES
				invoke	SendMessage, hWndEdit, EM_SETSEL, 0, -1
				invoke	SendMessage, hWndEdit, WM_CLEAR, 0, 0	
				invoke	SendMessage, hWndEdit, EM_SETMODIFY, FALSE, 0
				mov		szCurFileName, 0
				invoke	SetTitle
			.ENDIF									
				
		.ELSEIF eax == IDM_OPEN
			invoke	ConfirmOperation
			.IF	eax == IDYES
				invoke 	EditOpenFile													
				invoke	SendMessage, hWndEdit, EM_SETMODIFY, FALSE, 0
				invoke	SetTitle
			.ENDIF									
						
		.ELSEIF	eax == IDM_SAVEAS
			invoke	EditSaveFile
			invoke	SendMessage, hWndEdit, EM_SETMODIFY, FALSE, 0
			invoke	SetTitle	
																													
		.ELSEIF	eax == IDM_SAVE
			invoke	lstrcmp, addr szCurFileName, addr szNULL
			.IF	eax == 0
				invoke	EditSaveFile
			.ELSE
				invoke	FileSave, addr szCurFileName
			.ENDIF
			invoke	SendMessage, hWndEdit, EM_SETMODIFY, FALSE, 0
			invoke	SetTitle
		
		.ELSEIF eax == IDM_COPY
			invoke	SendMessage, hWndEdit, WM_COPY, 0, 0
				
		.ELSEIF eax == IDM_PASTE
			invoke	SendMessage, hWndEdit, WM_PASTE, 0, 0
				
		.ELSEIF eax == IDM_CUT
			invoke	SendMessage, hWndEdit, WM_CUT, 0, 0		
				
		.ELSEIF	eax == IDM_UNDO
			invoke	SendMessage, hWndEdit, WM_UNDO, 0, 0

		.ELSEIF	eax == IDM_SELALL
			invoke	SendMessage, hWndEdit, EM_SETSEL, 0, -1
				
		.ELSEIF	eax == IDM_DELETE
			invoke	SendMessage, hWndEdit, WM_CLEAR, 0, 0														
						
		.ELSEIF eax == IDM_ABOUT
			invoke 	MessageBox, 
					hWndMain,
					addr szAboutMsg, 
					addr szAboutTitle, 
					MB_OK or MB_ICONINFORMATION	
		.ELSE
			mov	eax,1
		.ENDIF
		xor	eax,eax			; return 0
				
	; used to resize the edit client area				
	.ELSEIF eax == WM_SIZE
		mov	eax, lParam
		mov	ebx, eax
		and	eax, 00000FFFFh		; LOWORD(lParam)
		shr	ebx, 16			; HIWORD(lParam)

		; resize the edit window		
		invoke	MoveWindow,					
				hWndEdit,
				0, 0,
				eax, ebx,
				TRUE
		xor	eax,eax			; return 0
		
	; default window procedure
	.ELSE
		invoke DefWindowProc, hWnd, uMsg, wParam, lParam
	.ENDIF		
return:
		ret
MainWndProc	endp


;------------------------------------------------------------------------------------------------
align DWORD
EditOpenFile proc
	LOCAL 	ofn:OPENFILENAME
	LOCAL 	szFileName[MAX_PATH]:BYTE
	
	; set up the open dialog box
	mov		ofn.lStructSize, SIZEOF ofn
	m2m		ofn.hWndOwner, hWndMain
	m2m		ofn.hInstance, hInst
	mov		ofn.lpstrFilter, offset szOpenFilter
	mov		ofn.lpstrCustomFilter, NULL
	mov		ofn.nMaxCustFilter,0
	mov		ofn.nFilterIndex,1
	lea		eax, szFileName
	mov		ofn.lpstrFile, eax
	mov		ofn.nMaxFile, SIZEOF szFileName
	mov		ofn.lpstrInitialDir, NULL
	mov		ofn.lpstrTitle, NULL
	mov		ofn.Flags, OFN_EXPLORER or OFN_HIDEREADONLY		
	mov		ofn.nFileOffset,0
	mov		ofn.nFileExtension,0
	mov		ofn.lpstrDefExt,NULL
	mov		ofn.lCustData,0
	mov		ofn.lpfnHook,NULL
			
	; call the common dialog box
	invoke 	GetOpenFileName, addr ofn
	cmp		eax, FALSE
	jz		error
	
	; open the file
	lea		eax,szFileName 
	invoke	FileOpen, eax
	test	eax,eax
	jz		error
	
	jmp		return						
error:		
	xor		eax,eax
return:		
	ret
EditOpenFile endp


;------------------------------------------------------------------------------------------------
align DWORD
FileOpen proc lpszFileName:DWORD
	LOCAL	nBytesToRead:DWORD
	LOCAL   nBytesRead:DWORD
	LOCAL	pBuf:DWORD
	LOCAL	hBuf:DWORD
	LOCAL	hFile:HANDLE		
	
	; Open the file		
	invoke	CreateFile,
			lpszFileName,
			GENERIC_READ,
			FILE_SHARE_READ,
			NULL,
			OPEN_EXISTING,
			NULL,
			NULL
	cmp		eax, INVALID_HANDLE_VALUE
	jz		error
	mov		hFile, eax
					
	; get the file size				
	invoke	GetFileSize, hFile, NULL
	cmp		eax, 0FFFFFFFFh
	jz		error
	mov		nBytesToRead,eax
			
	; allocate memory for the buffer	
	invoke	GetProcessHeap							
	invoke	HeapAlloc, eax, HEAP_ZERO_MEMORY, nBytesToRead
	test	eax,eax
	jz		error
	mov		pBuf, eax			
									
	; Read the File into the buffer
	invoke 	ReadFile,
			hFile,
			pBuf,
			nBytesToRead,
			addr nBytesRead,
			NULL
	test	eax,eax				
	jz		error
	
	; save the filename
	invoke	lstrcpy, addr szCurFileName, lpszFileName
	
	; update edit control
	invoke	SendMessage, hWndEdit, WM_SETTEXT, 0, pBuf
	test	eax,eax
	jz		error_size
	
	; close the file
	invoke	CloseHandle, hFile
	test	eax,eax
	jz		error
	
	; Free the buffer
	invoke	GetProcessHeap
	invoke	HeapFree, eax, NULL, pBuf
	test	eax,eax
	jz		error
	
	mov		eax, TRUE
	jmp		return		
	
error_size:		
	invoke	MessageBox, hWndMain, addr szFileTooBig, addr szError, MB_OK or MB_ICONWARNING	 		
	
error:		
	xor		eax,eax
return:		
	ret
FileOpen endp


;------------------------------------------------------------------------------------------------
align DWORD
EditSaveFile proc
	LOCAL 	ofn:OPENFILENAME
	LOCAL 	szFileName[MAX_PATH]:BYTE
	
	; set up the open dialog box
	mov		ofn.lStructSize, SIZEOF ofn
	m2m		ofn.hWndOwner, hWndMain
	m2m		ofn.hInstance, hInst
	mov		ofn.lpstrFilter, offset szOpenFilter
	mov		ofn.lpstrCustomFilter, NULL
	mov		ofn.nMaxCustFilter,0
	mov		ofn.nFilterIndex, 0
	lea		eax, szFileName
	mov		ofn.lpstrFile, eax
	mov		ofn.nMaxFile, SIZEOF szFileName
	mov		ofn.lpstrInitialDir, NULL
	mov		ofn.Flags, OFN_EXPLORER or OFN_HIDEREADONLY		
	mov		ofn.nFileOffset,0
	mov		ofn.nFileExtension,0
	mov		ofn.lpstrDefExt,NULL
	mov		ofn.lCustData,0
	mov		ofn.lpfnHook,NULL
	
	; call the common dialog box
	invoke 	GetSaveFileName, addr ofn
	cmp		eax, FALSE
	jz		error
	
	; save the file
	invoke	FileSave, addr szFileName
	test	eax,eax
	jz		error
	
	jmp		return				

error:
	xor		eax,eax
return:
	ret
EditSaveFile endp


;------------------------------------------------------------------------------------------------
align DWORD
FileSave proc lpszFileName:DWORD
	LOCAL	nBytesToWrite:DWORD
	LOCAL   nBytesWritten:DWORD
	LOCAL	pBuf:DWORD
	LOCAL	hFile:HANDLE
	
	; Open the file		
	invoke	CreateFile,
			lpszFileName,
			GENERIC_WRITE,
			FILE_SHARE_WRITE,
			NULL,
			CREATE_ALWAYS,
			FILE_ATTRIBUTE_ARCHIVE,
			NULL
	cmp		eax, INVALID_HANDLE_VALUE
	jz		error
	mov		hFile, eax

	; get the length of the text
	invoke	SendMessage, hWndEdit, WM_GETTEXTLENGTH, 0, 0
	mov		nBytesToWrite, eax
	
	; allocate memory for the buffer	
	invoke	GetProcessHeap							
	invoke	HeapAlloc, eax, HEAP_ZERO_MEMORY, nBytesToWrite
	test	eax,eax
	jz		error
	mov		pBuf, eax			

	; fill the buffer with the text		
	invoke	SendMessage, hWndEdit, WM_GETTEXT, nBytesToWrite, pBuf
	
	; Write the buffer out to the file
	invoke	WriteFile,
			hFile,
			pBuf,
			nBytesToWrite,
			addr nBytesWritten,
			NULL
	test	eax,eax
	jz		error
	
	; save the filename
	invoke	lstrcpy, addr szCurFileName, lpszFileName
	
	; close the file
	invoke	CloseHandle, hFile
	test	eax,eax
	jz		error
	
	; destroy the buffer
	invoke	GetProcessHeap
	invoke	HeapFree, eax, NULL, pBuf
	test	eax,eax
	jz		error
	
	mov		eax,TRUE
	jmp		return				

error:
	xor	eax,eax
return:
	ret
FileSave endp

;------------------------------------------------------------------------------------------------
align DWORD
ConfirmOperation proc
	; check to see if control is modified
	invoke	SendMessage, hWndEdit, EM_GETMODIFY, 0, 0
	cmp		eax, FALSE		
	jz		notchanged
			
	; display warning message
	invoke	MessageBox, 
			hWndMain, 
			addr szConfirmSave, 
			addr szSaveFile, 
			MB_YESNO or MB_ICONWARNING
	jmp		return
	
notchanged:
	mov		eax, IDYES
return:
	ret
ConfirmOperation endp


;------------------------------------------------------------------------------------------------
align DWORD
SetTitle proc
	LOCAL	szBuffer[MAX_PATH]:BYTE
	
	invoke	lstrcpy, addr szBuffer, addr szWndTitle
	
	invoke	lstrcmp	, addr szCurFileName, addr szNULL
	.IF	eax == 0
		invoke	lstrcat, addr szBuffer, addr szUntitled
	.ELSE
		invoke	lstrcat, addr szBuffer, addr szCurFileName
	.ENDIF
	
	invoke 	SendMessage, hWndMain, WM_SETTEXT, 0, addr szBuffer
	mov		eax, TRUE
	
	ret
SetTitle endp


;------------------------------------------------------------------------------------------------
; function to get the command line parameters only...
; returns pointer to the argunments string
;		  or NULL if there are none
align DWORD
GetCommandLineArgs proc	USES esi

    call	GetCommandLine
    mov		esi, eax                
    mov		al, [esi]
    cmp		al, 22h				; 22h = "
	jz		loop1	
		
	xor		eax,eax	
	jmp		return
		
	;if path is delimited by quotes, there are parameters...
loop1:		
	inc		esi
	mov		al, [esi]
	cmp		al, 22h
	jnz		loop1
	inc		esi
	inc		esi
	mov		eax,esi		
		
return:        		
	ret
		
GetCommandLineArgs endp	

;------------------------------------------------------------------------------------------------
end start
