; FMan
;--------------------------------------------------------------------------------------------------

.486p
.model flat, stdcall

include fman.inc

WinMain PROTO
;------------------------------------------------------------------------------------------------------------
.data?                                          ; uninitialized data
align DWORD  
	pShellMalloc		LPMALLOC 	?
	hInst				dd			?       
	hWndMain			dd			?
	wMsg				MSG			<?>
	szCurPath			db 			MAX_PATH dup (?)   
	iSeparatorPos		dd			? 
	          
;------------------------------------------------------------------------------------------------------------
.const                                          ; constant data segment
align DWORD   
	szWndClassName		db		"MAINWND",0
	szWndTitle			db		"File Manager",0	
	szAboutText			db		"ASM File Manager Version 0.001",0Ah,0Ah
						db		"Sunday April 11, 1999",0Ah
						db		"billasm@usa.net",0

;------------------------------------------------------------------------------------------------------------
.code
; Entry Point
start:                                          
    invoke  GetModuleHandle, 0h            
    mov     hInst,eax
               
	invoke	InitCommonControls
	
	; initialize the Component Object Model(COM) library
	invoke	CoInitialize, 0
	test	eax,eax				; any HRESULT with the MSB (the sign bit) = 1, is an error
	js		exit				; js = jump if signed

	; Get global IMalloc object
	invoke	SHGetMalloc, addr pShellMalloc
	cmp		eax, E_FAIL
	jz		shutdown
		
	; Winmain
    invoke	WinMain    
    
    ; Release IMalloc Object
    mov		eax, pShellMalloc
    mov		eax, [eax]
    invoke	(IMalloc PTR [eax]).Release, pShellMalloc
    
shutdown:    
    ; close the COM library
    invoke	CoUninitialize 
         
exit:
    invoke	ExitProcess, eax
    ; Program Terminates Here

;------------------------------------------------------------------------------------------------------------
align DWORD
WinMain proc
	LOCAL   wc:WNDCLASSEX

    mov     wc.cbSize, sizeof WNDCLASSEX    
    mov     wc.style, CS_VREDRAW + CS_HREDRAW + CS_DBLCLKS + CS_BYTEALIGNCLIENT + CS_BYTEALIGNWINDOW     				
    mov     wc.lpfnWndProc,offset MainWndProc
    mov     wc.cbClsExtra,0
    mov     wc.cbWndExtra,0	
	mov     eax,hInst
    mov     wc.hInstance,eax
	invoke	LoadIcon, eax, IDI_ICON1
    mov     wc.hIcon,eax 
    mov     wc.hIconSm,eax
	invoke	LoadCursor, 0, IDC_SIZEWE
    mov     wc.hCursor,eax
    mov     wc.hbrBackground,COLOR_WINDOW
    mov     wc.lpszMenuName, MENUEX_1
    mov     wc.lpszClassName,offset szWndClassName

	; register the window class
    invoke	RegisterClassEx, addr wc                                    
		
	; create the window
	invoke	CreateWindowEx, 
			WS_EX_ACCEPTFILES + WS_EX_APPWINDOW, 
			addr szWndClassName, 
			addr szWndTitle,
			WS_OVERLAPPEDWINDOW or WS_VISIBLE,
			CW_USEDEFAULT, 
			CW_USEDEFAULT, 
			CW_USEDEFAULT, 
			CW_USEDEFAULT, 
			0,
			0, 
			hInst, 
			0
	test	eax,eax     
	jz		quit
	 
    mov		hWndMain, eax
	    
; Message Dispatch Loop        
MessageLoop:                                  	
	invoke	GetMessage,	addr wMsg, NULL, 0h, 0h						           
    test    eax,eax				; if false (WM_QUIT), exit loop		  
    jz      quit
                   
    invoke  TranslateMessage, addr wMsg					
    invoke  DispatchMessage, addr wMsg
    jmp     MessageLoop

; Exit WinMain
quit:
    mov     eax, wMsg.wParam 
    ret
WinMain endp
       
       
;--------------------------------------------------------------------------------------------------
align DWORD
MainWndProc proc hWnd:DWORD, uMsg:DWORD, wParam:DWORD, lParam:DWORD
	LOCAL	rect:RECT
	LOCAL	arHdrParts[2]:DWORD
	
	mov		eax,uMsg
	cmp		eax,WM_MOUSEMOVE
	je		wmmousemove
	cmp		eax,WM_NOTIFY
	je		wmnotify					
	cmp		eax,WM_LBUTTONDOWN
	je		wmlbuttondown
	cmp		eax,WM_LBUTTONUP
	je		wmlbuttonup				
	cmp		eax,WM_SIZE
	je		wmsize
	cmp		eax,WM_COMMAND
	je		wmcommand
	cmp		eax,WM_CREATE
	je		wmcreate
	cmp		eax,WM_DESTROY
	je		wmdestroy
					
	invoke 	DefWindowProc, hWnd, uMsg, wParam, lParam
	jmp		return		

; mouse is moved
wmmousemove:
	test	wParam,MK_LBUTTON
	jz		return0
	
	; left button is down, move the splitter		
	mov		eax, lParam
	and		eax, 0000FFFFh	;LOWORD(lParam = xpos)
	mov		iSeparatorPos, eax	

	; now send wm_size message to redraw the window
	invoke	GetClientRect, hWndMain, addr rect
	mov		eax, rect.bottom
	shl		eax, 16
	mov		ebx, rect.right
	mov		ax,bx
	invoke	PostMessage, hWnd, WM_SIZE, 0, eax
	
	jmp		return0
			
; Left mouse button is pressed
wmlbuttondown:
	invoke	SetCapture, hWnd		
	jmp		return0
	
; Left mouse button is released	
wmlbuttonup:
	invoke	ReleaseCapture
	jmp		return0	

wmcommand:
	mov		eax, wParam
	and		eax, 0000FFFFh
	.IF		eax == IDM_QUIT
			invoke	PostQuitMessage, 0
	.ELSEIF	eax == IDM_ABOUT
			invoke	MessageBox, hWnd, addr szAboutText, addr szWndTitle, MB_OK or MB_ICONQUESTION
	.ENDIF	
	jmp		return0
	
; Main window is being resized
wmsize:		
	invoke	SendMessage, hWndStatusBar, WM_SIZE, 0, 0
	
	lea		ebx, arHdrParts
	mov		eax, iSeparatorPos
	mov		[ebx], eax
	mov		eax, lParam
	and		eax, 0000FFFFh 
	mov		[ebx + 4], eax
	invoke	SendMessage, hWndHeaderBar, SB_SETPARTS, 2, addr arHdrParts
	invoke	SendMessage, hWndHeaderBar, WM_SIZE, 0, 0	
	
	; ebx = height of client area
	mov		ebx, lParam
	shr		ebx, 16 ; HIWORD(lParam) = nHeight
	invoke	GetClientRect, hWndStatusBar, addr rect
	sub		ebx, rect.bottom
	invoke	GetClientRect, hWndHeaderBar, addr rect
	mov		esi, rect.bottom
	;inc		esi
	sub		ebx, esi
	
	mov		eax, iSeparatorPos
	dec		eax ; add some space
	invoke	MoveWindow, hWndTree, 0, esi, eax, ebx, TRUE
	
	; edx = witdth of client area
	mov		edx, lParam
	and		edx, 0000FFFFh 

	mov		ecx,iSeparatorPos
	inc		ecx
	sub		edx,ecx
	invoke	MoveWindow, hWndList, ecx, esi, edx, ebx, TRUE
	
	jmp		return0
	
; Create the main window, and its sub-views
wmcreate:
	mov		ebx,lParam
	mov		ebx,(CREATESTRUCT ptr [ebx]).hInstance
	
	; set separator location
   	invoke	GetClientRect, hWnd, addr rect
	mov		eax, rect.right
	shr		eax, 2
	mov		iSeparatorPos, eax
	
	; show the child windows
	invoke	InitStatusBarView, ebx, hWnd
	invoke	InitStatusHeaderView, ebx, hWnd
	invoke	InitTreeView, ebx, hWnd
	invoke	InitListView, ebx, hWnd
	
	; initialize the tree view
	invoke	SetFocus, hWndTree
	invoke	SendMessage, hWndTree, TVM_SELECTITEM, TVGN_CARET, hitemMyComputer
	invoke	SendMessage, hWndTree, TVM_EXPAND, TVE_EXPAND, hitemMyComputer
	
	jmp		return0	
	
; Close the window, and terminate the application
wmdestroy:		
	invoke 	PostQuitMessage, NULL		
	jmp		return0
	
wmnotify:
	.IF		wParam == ID_TREEVIEW
			invoke	TreeViewNotify, hWnd, lParam
			
	.ELSEIF	wParam == ID_LISTVIEW
			invoke	ListViewNotify, hWnd, lParam
	.ENDIF
	jmp		return0
	
		
return0:
	xor		eax,eax		
return:
	ret
MainWndProc	endp

;--------------------------------------------------------------------------------------------------
end start
