; List.asm
; Handles the Files list view
.486p
.model flat, stdcall
                      
include fman.inc

;------------------------------------------------------------------------------------------------------------
.data?                                          	; uninitialized data
align DWORD 
	hWndList			dd		?					; Window handle for the List View
	hListImageList		dd		?
	
;------------------------------------------------------------------------------------------------------------
.const                                          	; constant data segment
align DWORD   
	szListViewName		db		"SysListView32",0    
	szRootPath			db		"C:\",0
	szAllFiles			db		"*.*",0 

;------------------------------------------------------------------------------------------------------------
.code

InitListView	proc	hInstance:DWORD, hWndParent:DWORD
	LOCAL	rectClient:RECT
   	LOCAL	sfi:SHFILEINFO
		                  
	; get parent window size
	invoke	GetClientRect, hWndParent, addr rectClient      
	mov		eax, rectClient.right
	shr		eax,1  
	inc		eax
		
	; create the window 		
	invoke	CreateWindowEx, 
			WS_EX_CLIENTEDGE,
			addr szListViewName, 
			0,
			WS_CHILD or WS_VISIBLE or LVS_LIST or LVS_EDITLABELS or LVS_AUTOARRANGE or LVS_SHAREIMAGELISTS,
			eax, 0,
			rectClient.right, rectClient.bottom, 
			hWndParent,
			ID_LISTVIEW, 
			hInstance, 
			NULL
	test	eax,eax     
	jz	ret_error
	mov	hWndList, eax 
                            
	; Get the shell image list for the list view
	invoke	SHGetFileInfo, addr szRootPath, 0, addr sfi, sizeof SHFILEINFO, SHGFI_SYSICONINDEX or SHGFI_SMALLICON
	test	eax,eax
	jz		ret_error
	mov		hListImageList, eax	
	invoke	SendMessage, hWndList, LVM_SETIMAGELIST , LVSIL_SMALL, eax
      
ret_ok:                     
	mov	eax,TRUE
	ret
ret_error:
	xor	eax,eax
	ret
InitListView	endp    
            
    
    
;--------------------------------------------------------------------------------------------------
UpdateListView proc uses edx hWnd:DWORD, ptvobj:LPTV_OBJDATA, pshfParent:LPSHELLFOLDER
	LOCAL	lvi:LV_ITEM
	LOCAL	peidl:LPENUMIDLIST
	LOCAL	pidl:LPITEMIDLIST
	LOCAL	pidlFull:LPITEMIDLIST
	LOCAL	plvobj:LPLV_OBJDATA
	LOCAL	dwAttr:DWORD
	LOCAL	strret:STRRET

	; remove all the items
	invoke	SendMessage, hWnd, LVM_DELETEALLITEMS, 0, 0

	; get the id lists from the parent folder
    mov		edx, pshfParent
    mov		edx, [edx]
    invoke	(IShellFolder ptr [edx]).EnumObjects, pshfParent, hWnd, SHCONTF_FOLDERS or SHCONTF_NONFOLDERS, addr peidl
	test	eax,eax
	js		ret_error
	
	xor		ecx,ecx	; counter
	mov		lvi.imask, LVIF_TEXT or LVIF_IMAGE or LVIF_PARAM
	
	; display hourglass cursor
	invoke	LoadCursor, NULL, IDC_WAIT
	invoke	SetCursor, eax
	
ObjectLoop:
	mov		edx, peidl
	mov		edx,[edx]
	invoke	(IEnumIDList PTR [edx]).Next, peidl, 1, addr pidl, NULL
	test	eax,eax
	js		ret_error
	cmp		eax,S_FALSE	;no more items
	jz		End_ObjectLoop
	
    mov		eax, pShellMalloc
    mov		eax, [eax]
    invoke	(IMalloc ptr [eax]).Alloc, pShellMalloc, sizeof LV_OBJDATA
	.IF		eax != 0
			mov		plvobj, eax
			
			; Get the name
			mov		edx, pshfParent
			mov		edx,[edx]
			invoke	(IShellFolder PTR [edx]).GetDisplayNameOf, pshfParent, pidl, SHGDN_NORMAL, addr strret
			test	eax,eax
			js		ret_error
			.IF		strret.uType == STRRET_CSTR
					lea		eax, strret.cStr
			.ELSEIF	strret.uType == STRRET_OFFSET
					mov		eax, pidl
					add		eax, strret.uOffset
			.ELSEIF	strret.uType == STRRET_WSTR	
					int 3
			.ENDIF
			mov		lvi.pszText, eax
			
			; Get the attributes
			mov		edx, pshfParent
			mov		edx, [edx]
			invoke	(IShellFolder ptr [edx]).GetAttributesOf, pshfParent, 1, addr pidl, addr dwAttr
			test	eax,eax
			js		ret_error			
			mov		edx,plvobj
			mov		eax, dwAttr
			mov		(LV_OBJDATA ptr [edx]).dwAttr, eax
						
			; Get full pidl						
			mov		eax, ptvobj						
			invoke	IDList_Combine, (TV_OBJDATA ptr [eax]).pidlFull, pidl
			test	eax,eax
			jz		ret_error
			mov		pidlFull, eax
			
			mov		lvi.iItem, ecx
			inc		ecx			
			mov		lvi.iSubItem, 0
			mov		lvi.cchTextMax, 255
			
			; Get the icons
			invoke	GetIcon, pidlFull, 0
			mov		lvi.iImage, eax
			
			; save LV_OBJDATA struct
			mov		edx, plvobj
			invoke	IDList_CopyItem, pidl
			mov		(LV_OBJDATA PTR [edx]).pidlRel, eax		
			mov		eax, pshfParent				
			mov		(LV_OBJDATA ptr [edx]).pshfParent, eax 
			mov		lvi.lParam, edx
				
			; add refernece to parent folder
			mov		eax, (LV_OBJDATA ptr [edx]).pshfParent
			mov		eax, [eax]
			invoke	(IShellFolder ptr [eax]).AddRef, (LV_OBJDATA ptr [edx]).pshfParent

			; add item to the list
			invoke 	SendMessage, hWndList, LVM_INSERTITEM, 0, addr lvi  ;;; USE LVM_SETITEM
			cmp		eax, -1
			jz		ret_error    
			
			mov		edx,pShellMalloc
			mov		edx,[edx]
			;invoke	(IMalloc ptr [edx]).Free, pShellMalloc, pidlFull
			;invoke	(IMalloc ptr [edx]).Free, pShellMalloc, pidl
	.ENDIF
	jmp		ObjectLoop
	
End_ObjectLoop:	

	; reset to normal cursor
	invoke	LoadCursor, NULL, IDC_ARROW
	invoke	SetCursor, eax
			
ret_ok:
	mov		eax,1
	ret			
ret_error:			
	xor		eax,eax
	ret
UpdateListView endp
    
;--------------------------------------------------------------------------------------------------
ListViewNotify proc uses ebx hWnd:DWORD, pnmlv:DWORD
	LOCAL	point:POINT
	LOCAL	lvhti:LV_HITTESTINFO
	LOCAL	lvi:LV_ITEM
	LOCAL	plvobj:LPLV_OBJDATA
	
	mov		eax, pnmlv
	mov		eax, (NM_LISTVIEW ptr [eax]).hdr.code
	cmp		eax, NM_RCLICK
	je		clicked
	cmp		eax, NM_DBLCLK
	je		clicked
	jmp		ret_ok
	
clicked:
	invoke	GetCursorPos, addr point
	invoke	ScreenToClient, hWndList, addr point
	mov		eax, point.x
	mov		lvhti.pt.x, eax
	mov		eax, point.y
	mov		lvhti.pt.y, eax

	invoke	SendMessage, hWndList, LVM_HITTEST, 0, addr lvhti
	; Clicked on an item
	.IF		(lvhti.flags & LVHT_ONITEM)
			invoke	ClientToScreen, hWndList, addr point
			mov		lvi.imask, LVIF_PARAM
			mov		eax, lvhti.iItem
			mov		lvi.iItem, eax
			mov		lvi.iSubItem,0
			
			invoke	SendMessage, hWndList, LVM_GETITEM, 0, addr lvi
			test	eax,eax
			jz		ret_error
			
			mov		eax, lvi.lParam
			mov		plvobj, eax
			
			mov		ebx, pnmlv
			mov		ebx, (NM_LISTVIEW ptr [ebx]).hdr.code
			.IF		ebx == NM_RCLICK
					mov		ebx, plvobj
					invoke	ContextMenu, hWnd, (LV_OBJDATA ptr [ebx]).pshfParent, (LV_OBJDATA ptr [ebx]).pidlRel, addr point
			.ENDIF			
	; clicked in client area
	.ELSE
	
	.ENDIF
		
ret_ok:
	mov		eax,1
	ret
ret_error:
	xor		eax,eax
	ret	
ListViewNotify endp

END                   
