# TEMPLATE
#
# make -B                 Build normal  version
# make -B -DDEBUG         Build debug version
#----------------------------------------------------------------------------
.silent

NAME  	= 	FMan

OBJS  	= 	fman.obj tree.obj list.obj status.obj
FILES 	= 	fman.asm tree.asm list.asm status.asm
     
INCLUDE	=	d:\programm\masm32\include    
LIB	=	d:\programm\masm32\lib

#----------------------------------------------------------------------------

!if $d(DEBUG)
MASMDEBUG=/Zi
LINKDEBUG=/DEBUG /DEBUGTYPE:CV
!else
MASMDEBUG=
LINKDEBUG=
!endif                     

#----------------------------------------------------------------------------
all: $(NAME).res $(NAME).exe                             

$(NAME).exe: $(OBJS) $(NAME).res
        Link /SUBSYSTEM:WINDOWS /LIBPATH:$(LIB) $(LINKDEBUG) $(OBJS) $(NAME).res

$(NAME).res: $(NAME).rc    
#	h2ash resource.h
#	move resource.ash resource.inc
    brc32 -r -i$(INCLUDE) $(NAME).rc     

fman.obj: fman.asm fman.inc
        ml /c /Cp /coff /nologo /I$(INCLUDE) $(MASMDEBUG) fman.asm
tree.obj: tree.asm tree.inc fman.inc                  
        ml /c /Cp /coff /nologo /Fl /I$(INCLUDE) $(MASMDEBUG) tree.asm     
list.obj: list.asm list.inc fman.inc
	ml /c /Cp /coff /nologo /I$(INCLUDE) $(MASMDEBUG) list.asm
status.obj: status.asm status.inc fman.inc
	ml /c /Cp /coff /nologo /I$(INCLUDE) $(MASMDEBUG) status.asm
