; Tree.asm
; Handles the Directories Tree View
.486p
.model flat, stdcall
                      
include fman.inc    

;------------------------------------------------------------------------------------------------------------
.data?                                          	; uninitialized data
align DWORD 
	hWndTree			dd		?               	; Window handle for the Tree View
	hTreeImageList		dd		?
	hitemMyComputer		dd		?

;------------------------------------------------------------------------------------------------------------
.const                                          	; constant data segment
align DWORD   
	szTreeClassName		db		"SysTreeView32",0   
	szRootPath			db		"C:\",0

;------------------------------------------------------------------------------------------------------------
.code       

;--------------------------------------------------------------------------------------------------
; InitTreeView
InitTreeView proc hInstance:DWORD, hWndParent:DWORD
	LOCAL	rectClient:RECT
	LOCAL	lpsf:LPSHELLFOLDER
   	LOCAL	sfi:SHFILEINFO

	                  
	; get parent window size
	invoke	GetClientRect, hWndParent, addr rectClient    	
	mov		eax, rectClient.right
	shr		eax, 1
	dec		eax

	; create the tree view window
	invoke	CreateWindowEx, 
			WS_EX_CLIENTEDGE,
			addr szTreeClassName, 
			0,
			WS_CHILD or WS_VISIBLE or TVS_HASLINES or TVS_HASBUTTONS or TVS_LINESATROOT,
			0, 0,
			eax, rectClient.bottom, 
			hWndParent,
			ID_TREEVIEW, 
			hInstance, 
			NULL
	test	eax,eax     
	jz		ret_error
	mov		hWndTree, eax 
	                   
	; Get the shell image list for the tree view
	invoke	SHGetFileInfo, addr szRootPath, 0, addr sfi, sizeof SHFILEINFO, SHGFI_SYSICONINDEX or SHGFI_SMALLICON
	test	eax,eax
	jz		ret_error
	mov		hTreeImageList, eax	
	invoke	SendMessage, hWndTree, TVM_SETIMAGELIST, 0, eax
	
	; initialize the tree window
    invoke	SHGetDesktopFolder, addr lpsf
    test	eax,eax
    js		ret_error

	; fill the window with the root items    
    invoke	UpdateTreeView, hWndTree, lpsf, 0, TVI_ROOT
    
    ; free the shell folder pointer
    mov		eax, lpsf
    mov		eax,[eax]
    invoke	(IShellFolder ptr [eax]).Release, lpsf

ret_ok:                     
	xor		eax,eax
	inc		eax
	ret
ret_error:
	xor		eax,eax
	ret
InitTreeView	endp



;--------------------------------------------------------------------------------------------------
; UpdateTreeView
UpdateTreeView proc uses ebx edx hWnd:DWORD, pshfParent:LPSHELLFOLDER, pidlFull:LPITEMIDLIST, htreeParent:DWORD
	LOCAL	peidl:LPENUMIDLIST
	LOCAL	pidl:LPITEMIDLIST
	LOCAL	pidlFullCur:LPITEMIDLIST
	LOCAL	ptvobj:LPTV_OBJDATA
	LOCAL	tvis:TV_INSERTSTRUCT
	LOCAL	dwAttr:DWORD
	LOCAL	strret:STRRET
	LOCAL	bFirstItem:DWORD

	
	mov		edx, pshfParent
	mov		edx, [edx]
	invoke	(IShellFolder PTR [edx]).EnumObjects, pshfParent, hWnd, SHCONTF_FOLDERS or SHCONTF_NONFOLDERS or SHCONTF_INCLUDEHIDDEN, addr peidl
	test	eax,eax
	js		ret_error
	mov		bFirstItem,1
		
ObjectLoop:
	mov		edx, peidl
	mov		edx,[edx]
	invoke	(IEnumIDList PTR [edx]).Next, peidl, 1, addr pidl, NULL
	test	eax,eax
	js		ret_error
	cmp		eax,S_FALSE	;no more items
	jz		End_ObjectLoop

	; check to see if its a folder; if its a folder, add it to the tree
	mov		dwAttr, SFGAO_HASSUBFOLDER or SFGAO_FOLDER
	mov		edx, pshfParent
	mov		edx, [edx]
	invoke	(IShellFolder PTR [edx]).GetAttributesOf, pshfParent, 1, addr pidl, addr dwAttr
	test	eax,eax
	js		ret_error
		
	.IF		dwAttr & (SFGAO_HASSUBFOLDER or SFGAO_FOLDER)
	.IF		dwAttr & SFGAO_FOLDER
			 
			; save TV_OBJDATA
			mov		eax, pShellMalloc
			mov		eax,[eax]
			invoke	(IMalloc ptr [eax]).Alloc, pShellMalloc, sizeof TV_OBJDATA			
			test	eax,eax
			jz		ret_error
			mov		ptvobj,eax					
			mov		ebx, eax			
				
			invoke	IDList_Combine, pidlFull, pidl	
			mov		(TV_OBJDATA PTR [ebx]).pidlFull, eax
			mov		pidlFullCur, eax
			
			invoke	IDList_CopyItem, pidl
			mov		(TV_OBJDATA PTR [ebx]).pidlRel, eax				
			
			mov		eax, pshfParent
			mov		(TV_OBJDATA PTR [ebx]).pshfParent, eax

			mov		tvis.item.lParam, ebx
			
			; save tree item datas
			mov		eax, htreeParent
			mov		tvis.hParent, eax
			mov		tvis.item.hItem, 0	
			mov		tvis.hInsertAfter, TVI_LAST
		
			mov		tvis.item.imask, TVIF_TEXT or TVIF_IMAGE or TVIF_SELECTEDIMAGE or TVIF_PARAM
			.IF		dwAttr & SFGAO_HASSUBFOLDER
					mov		tvis.item.cChildren, TRUE
					or		tvis.item.imask, TVIF_CHILDREN					
			.ENDIF
				
			mov		edx, pshfParent
			mov		edx,[edx]
			invoke	(IShellFolder PTR [edx]).GetDisplayNameOf, pshfParent, pidl, SHGDN_NORMAL, addr strret										
			test	eax,eax
			js		ret_error
			.IF		strret.uType == STRRET_CSTR
					lea		eax, strret.cStr
			.ELSEIF	strret.uType == STRRET_OFFSET
					mov		eax, pidl
					add		eax, strret.uOffset
			.ELSEIF	strret.uType == STRRET_WSTR	
					int 3
			.ENDIF
			mov		tvis.item.pszText, eax								
			mov		tvis.item.cchTextMax, 255	
			
			invoke	GetIcon, pidlFullCur, SHGFI_ICON
			mov		tvis.item.iImage, eax
			invoke	GetIcon, pidlFullCur, SHGFI_OPENICON	
			mov		tvis.item.iSelectedImage, eax						
						
			; add item to the tree				
			invoke	SendMessage, hWnd, TVM_INSERTITEM, 0, addr tvis 
			test	eax,eax
			jz		ret_error 			
			.IF		bFirstItem == TRUE
					mov		hitemMyComputer, eax
					mov		bFirstItem, 0
			.ENDIF
	.ENDIF	
	.ENDIF
	mov		eax, pShellMalloc
	mov		eax,[eax]
	invoke	(IMalloc PTR [eax]).Free, pShellMalloc, pidl
	
	jmp		ObjectLoop
	
	mov		eax, peidl
	mov		eax,[eax]
	invoke	(IEnumIDList PTR [eax]).Release, peidl


End_ObjectLoop:	

ret_ok:
	ret
ret_error:	
	ret
UpdateTreeView endp


;--------------------------------------------------------------------------------------------------
; TreeViewNotify
TreeViewNotify proc uses ebx edx hWnd:DWORD, pnmtv:DWORD
	LOCAL	pshf:LPSHELLFOLDER
	LOCAL	pidl:LPITEMIDLIST
	LOCAL	ptvobj:LPTV_OBJDATA
	LOCAL	strret:STRRET
		
	LOCAL	point:POINT
	LOCAL	tvhti:TV_HITTESTINFO
	LOCAL	tvi:TV_ITEM

	mov		eax, pnmtv
	mov		ebx,(NM_TREEVIEW ptr [eax]).itemNew.lParam 
	mov		ptvobj, ebx	
	
	mov		eax, (NM_TREEVIEW ptr [eax]).hdr.code
	cmp		eax, TVN_ITEMEXPANDING
	je		item_expanding
	cmp		eax, TVN_SELCHANGEDA
	je		sel_changed
	cmp		eax, NM_RCLICK
	je		right_clicked
	jmp		ret_ok
	
; Item is expanding...	
item_expanding:	
	mov		ebx, pnmtv
	test	(NM_TREEVIEW ptr [ebx]).itemNew.state, TVIS_EXPANDEDONCE	
	jnz		ret_ok

	mov		ebx, ptvobj		
	mov		edx, (TV_OBJDATA ptr [ebx]).pshfParent
	mov		edx, [edx]
	invoke	(IShellFolder PTR [edx]).BindToObject, 
			(TV_OBJDATA ptr [ebx]).pshfParent, 
			(TV_OBJDATA ptr [ebx]).pidlRel, 
			0, 
			addr IID_IShellFolder, 
			addr pshf	
	test	eax,eax
	js		ret_error				
	
	mov		ebx,pnmtv
	mov		edx,ptvobj
	invoke	UpdateTreeView, hWndTree, pshf, (TV_OBJDATA ptr [edx]).pidlFull, (NM_TREEVIEW ptr [ebx]).itemNew.hItem
	
	mov		eax, pshf
	mov		eax, [eax]
	invoke	(IShellFolder ptr [eax]).Release, pshf
	jmp		ret_ok			
	
; tree item selection changed
sel_changed:
	; update list view header to give full path name
	invoke	SHGetDesktopFolder, addr pshf
	test	eax,eax
	js		ret_error
	
	mov		ebx, ptvobj
	mov		edx, pshf
	mov		edx,[edx]
	invoke	(IShellFolder PTR [edx]).GetDisplayNameOf, pshf, (TV_OBJDATA ptr [ebx]).pidlFull, SHGDN_NORMAL, addr strret										
	test	eax,eax
	js		ret_error
	.IF		strret.uType == STRRET_CSTR
			lea		eax, strret.cStr
	.ELSEIF	strret.uType == STRRET_OFFSET
			mov		eax, (TV_OBJDATA ptr [ebx]).pidlFull
			add		eax, strret.uOffset
	.ELSEIF	strret.uType == STRRET_WSTR	
			int 3
	.ENDIF
	invoke	SendMessage, hWndHeaderBar, SB_SETTEXT, 1, eax
	
	mov		eax, pshf
	mov		eax, [eax]
	invoke	(IShellFolder ptr [eax]).Release, pshf


	; now bind to that folder
	mov		ebx, pnmtv
	mov		ebx,(NM_TREEVIEW ptr [ebx]).itemNew.lParam 
	mov		ptvobj, ebx		

	mov		edx, (TV_OBJDATA ptr [ebx]).pshfParent
	mov		edx, [edx]
	invoke	(IShellFolder PTR [edx]).BindToObject, 
			(TV_OBJDATA ptr [ebx]).pshfParent, 
			(TV_OBJDATA ptr [ebx]).pidlRel, 
			0, 
			addr IID_IShellFolder, 
			addr pshf	
	test	eax,eax
	js		ret_error	
	
	; fill the list view
	invoke	UpdateListView, hWndList, ptvobj, pshf						
	test	eax,eax
	jz		ret_error
	
	mov		eax, pshf
	mov		eax, [eax]
	invoke	(IShellFolder ptr [eax]).Release, pshf
	jmp		ret_ok			
			
; right click context menu
right_clicked:
	invoke	GetCursorPos, addr point
	invoke	ScreenToClient, hWndTree, addr point
	mov		eax, point.x
	mov		tvhti.pt.x, eax
	mov		eax, point.y
	mov		tvhti.pt.y, eax
	
	invoke	SendMessage, hWndTree, TVM_HITTEST, 0, addr tvhti
	invoke	SendMessage, hWndTree, TVM_SELECTITEM, TVGN_CARET, tvhti.hItem
	.IF		(tvhti.flags & TVHT_ONITEM)
			invoke	ClientToScreen, hWndTree, addr point
			mov		tvi.imask, TVIF_HANDLE or TVIF_PARAM
			mov		eax, tvhti.hItem
			mov		tvi.hItem, eax 
			
			invoke	SendMessage, hWndTree, TVM_GETITEM, 0, addr tvi
			test	eax,eax
			jz		ret_error
					
			mov		ebx, tvi.lParam
			mov		ptvobj, ebx
			invoke	ContextMenu, hWnd, (TV_OBJDATA ptr [ebx]).pshfParent, (TV_OBJDATA ptr [ebx]).pidlRel, addr point
	.ENDIF
	jmp		ret_ok


ret_ok:
	mov		eax,TRUE
	ret		
ret_error:
	xor		eax,eax	
	ret
TreeViewNotify endp






;--------------------------------------------------------------------------------------------------
; IDList_GetSize
IDList_GetSize proc uses ebx pidl:LPITEMIDLIST
	LOCAL	cbTotal:DWORD
	
	mov		cbTotal, 0
	.IF		pidl != 0
			mov		ebx,pidl			
start_loop:
			movsx	eax, (ITEMIDLIST PTR [ebx]).mkid.cb
			test	eax,eax
			jz		end_loop
				
			add		cbTotal, eax
			add		ebx, eax
			jmp		start_loop
end_loop:							
	.ENDIF		
	
	mov		eax,cbTotal	
	ret
IDList_GetSize endp



;--------------------------------------------------------------------------------------------------
; IDList_CopyItem
IDList_CopyItem	proc uses ebx edx ecx edi esi pidl:LPITEMIDLIST
	LOCAL	pidlNew:LPITEMIDLIST
	LOCAL	sz:DWORD
	
	mov		ebx, pidl	
	movsx	edx, (ITEMIDLIST PTR [ebx]).mkid.cb
	add		edx, sizeof WORD
	mov		sz,edx
		
	mov		edx, pShellMalloc
	mov		edx, [edx]
	invoke	(IMalloc PTR [edx]).Alloc, pShellMalloc, sz
	
	test	eax,eax
	jz		ret_null
	mov		pidlNew, eax

	mov		esi, pidl
	mov		edi, pidlNew
	mov		ecx, sz
	.WHILE	ecx != 0
			mov 	al,byte ptr [esi]
			mov		byte ptr [edi], al		
			dec		ecx			
			inc		esi
			inc		edi
	.ENDW
	
ret_ok:	
	mov		eax, pidlNew
	ret
	
ret_null:
	xor		eax,eax
	ret	
IDList_CopyItem	endp



;--------------------------------------------------------------------------------------------------
; IDList_Combine
IDList_Combine proc uses esi edi ecx edx pidl1:LPITEMIDLIST, pidl2:LPITEMIDLIST
	LOCAL	pidlNew:LPITEMIDLIST
	LOCAL	cb1:DWORD
	LOCAL	cb2:DWORD
	
	; Get length of 1st pidl (not including NULL terminating word)
	invoke	IDList_GetSize, pidl1
	mov		cb1, eax
	
	; Get length of 2nd pidl (not including NULL terminating word)
	invoke	IDList_GetSize, pidl2
	mov		cb2, eax
	
	; Get total length of resulting combined pidl (including NULL terminating word)
	mov		eax, sizeof ITEMIDLIST.mkid.cb
	add		eax, cb1
	add		eax, cb2	
		
	; Allocate the memory
	mov		edx, pShellMalloc
	mov		edx,[edx]
	invoke	(IMalloc PTR [edx]).Alloc, pShellMalloc, eax
	
	test	eax,eax
	jz		ret_error
	mov		pidlNew, eax
	
	; Set destination 
	mov		edi, eax
	
	; Write 1st pidl to destination (pidlNew)
	mov		esi, pidl1
	mov		ecx, cb1
	.WHILE	ecx != 0
			mov 	al,byte ptr [esi]
			mov		byte ptr [edi], al		
			dec		ecx			
			inc		esi
			inc		edi
	.ENDW			

	; Write 2nd pidl after 1st
	mov		esi, pidl2
	mov		ecx, cb2
	.WHILE	ecx != 0
			mov 	al,byte ptr [esi]
			mov		byte ptr [edi], al		
			dec		ecx			
			inc		esi
			inc		edi
	.ENDW			
	
	; Add terminating word
	mov		word ptr [edi], 0
		
	mov		eax, pidlNew
	ret
ret_error:
	int 	3
	xor		eax,eax
	ret	
IDList_Combine	endp




;--------------------------------------------------------------------------------------------------
; GetIcons
; dwType = SHGFI_OPENICON or SHGFI_ICON
GetIcon	proc uses edx pidl:LPITEMIDLIST, dwType:DWORD
	LOCAL	shfi:SHFILEINFO
		
	mov		edx, SHGFI_PIDL or SHGFI_SYSICONINDEX or SHGFI_SMALLICON
	or		edx, dwType
		
	invoke	SHGetFileInfo, 		; SHGetfileinfo requires full pidl
			pidl, 
			0,
			addr shfi,
			sizeof SHFILEINFO, 
			edx
	mov		eax, shfi.iIcon
	ret
GetIcon	endp


;--------------------------------------------------------------------------------------------------
ContextMenu proc uses ebx edx hWnd:DWORD, pshfParent:LPSHELLFOLDER, pidl:LPITEMIDLIST, ppoint:DWORD
	LOCAL	pcm:LPCONTEXTMENU
	LOCAL	hMenu:DWORD
	LOCAL	iCmd:DWORD
	LOCAL	cmi:CMINVOKECOMMANDINFO
	
	mov		ebx, pshfParent
	mov		ebx,[ebx]
	invoke	(IShellFolder ptr [ebx]).GetUIObjectOf, pshfParent,
			hWnd,
			1,
			addr pidl,
			addr IID_IContextMenu,
			0,
			addr pcm
	test	eax,eax
	js		ret_error
	
	invoke	CreatePopupMenu
	test	eax,eax
	jz		ret_error
	mov		hMenu, eax
	
	mov		ebx, pcm
	mov		ebx, [ebx]
	invoke	(IContextMenu ptr [ebx]).QueryContextMenu, pcm,
			hMenu,
			0,
			1,
			7FFFh,
			CMF_EXPLORE
	test	eax,eax
	js		ret_error
	
	mov		edx, ppoint
	invoke	TrackPopupMenu,
			hMenu,
			TPM_LEFTALIGN or TPM_RIGHTBUTTON or 0100h, ;TPM_RETURNCMD
			(POINT ptr [edx]).x,
			(POINT ptr [edx]).y,
			0,
			hWnd,
			0
	test	eax,eax
	jz		ret_error
	mov		iCmd, eax	

	mov		cmi.cbSize, sizeof CMINVOKECOMMANDINFO
	mov		cmi.fMask, 0
	mov		eax, hWnd
	mov		cmi.hwnd, eax
	
	mov		eax, iCmd
	dec		eax
	and		eax, 0000FFFFh
	mov		cmi.lpVerb, eax
	
	mov		cmi.lpParameters, 0
	mov		cmi.lpDirectory, 0
	mov		cmi.nShow, SW_SHOWNORMAL
	mov		cmi.dwHotKey, 0
	mov		cmi.hIcon, 0
	
	mov		ebx, pcm
	mov		ebx, [ebx]
	invoke	(IContextMenu ptr [ebx]).InvokeCommand, pcm, addr cmi
	.IF		eax < 0 ; failed
			int 3
	.ENDIF
	invoke	DestroyMenu, hMenu
	invoke	(IContextMenu ptr [ebx]).Release, pcm
	
ret_ok:
	mov		eax,1
	ret
			
ret_error:
	xor		eax,eax
	ret
ContextMenu endp



END