//
//
//

#define flipbyte32( x ) ((u32)            \
   ((((u32)(x) & 0x000000FFL) << 24) | \
    (((u32)(x) & 0x0000FF00L) <<  8) | \
    (((u32)(x) & 0x00FF0000L) >>  8) | \
    (((u32)(x) & 0xFF000000L) >> 24)))

#define flipbyte16( x ) ((u16)            \
   ((((u16)(x) & 0x00FF) << 8)       | \
    (((u16)(x) & 0xFF00) >> 8)))



typedef        signed char s8;
typedef      unsigned char u8;
typedef      unsigned int  u16;
typedef long unsigned int  u32;


typedef  struct
{  u32 lo;
   u32 hi;
} u64;

typedef struct
{  u8 addr [8];
} Addr;

typedef  struct
{  u8  ID[6];
} PID;

typedef u32 ProtocolNumber;

typedef enum
{  ODI_SUCCESS          = 0,
   ODI_OUT_OF_RESOURCES = -119,
   ODI_NO_MORE_ITEMS    = -122,
   ODI_FAIL             = -124
} ODIStat;


typedef  enum
{  FIRST_MUST,
   FIRST_NEXT,
   LOAD_DEPENDS,
   LAST_NEXT,
   LAST_MUST,
} CHNPOS;


typedef struct
{
	u8		version;
	u8		type;
	u16		length;
	u16		identification;
	u16		flags1;
	u8		ttl;
	u8		protocol;
	u16		headerCRC;
	u32		srcaddr;
	u32		destaddr;

	//Start TCP Header

	u16		srcport;
	u16		destport;
	u32		seqnumber;
	u32		acknumber;
	u8		dataOffset;
	u8		flags2;
	u16		window;
	u16		tcpCRC;
	u16		pad1;

	//Start NB Header

	u8		nbtype;
	u8		nbflags;
	u16		nblength;

   union
   {
	  struct
	  {
            u8 	Reserved0;
            u8 	IDString[3];
            u8 	FunctionCode;
            u8	Reserved1[4];
            u8	Flags1;
            u16	Flags2;
            u8 	Reserved2[12];
            u16 TreeID;
            u16 ProcessID;
            u16 Reserved3;
            u16 muxId;
      } SMB;
	  struct
	  {
            u8 	buf[32];
	  } RAW;
	  struct
	  {
            u8 	reserved1[9];
            u8 	cmdresp;
            u8 	reserved[43];
            u8	pwlength;
            u8	reserved2;
            u8 	password[32];
	  }USERPWNT;
      struct
	  {
            u8 	reserved1[9];
            u8 	cmdresp;
            u8 	reserved[43];
            u8	pwlength;
            u8	reserved2;
            u8 	password[24];
            u8 	username[16];
	  }USERPW95;
   } x;

} IPpac;


// template for Info Block

typedef u32 Func;

typedef struct
{
   void (_far * LSLAPI )();
   void (_far * GSAPI  )();
   void (_far * MLIDAPI)();
} InfoBlock;

// template for info copied from IP packet

typedef struct
{
   u8	immAddr[6];
   u8   type;
   u16  size;
   PID  pid;
   char data[1500];
}  IPInfo;


typedef struct ECBs
{
   void _far *  NxtECB;
   void _far *  PreECB;
   u16          Status;
   void (_far * ECBISR)();
   u16          ProtocolNum;
   u8           ProtocolID[6];
   u16          BoardNum;
   u8           ImmAddr[6];
   u8           ECBDrvrWkSpace[4];
   u16          ECBPrtclWkSpace[4];
   u16          DataLen;
   u16          FragCnt;
   u8 _far *    Frag1Addr;
   u16          Frag1Len;
} EventCB;

typedef struct
{
  u8  _far *    MediaHdr;     // 4
  u8  _far *    DataPtr;      // 4
  u16           DataLen;           // 2
  PID           ProtocolID;        // 6
  u16           BoardNum;          // 2
  u16           DataSize;          // 2
  PID           ImmAddr;           // 6
  u16           PacAttrib;         // 2
  u16           DestType;          // 2
  u16           StartOffset;       // 2
  u8            PriorityLvl;       // 1
  u8            Reserved;          // 1
} LookAhead;

typedef struct   RxChainNode
{
   u32          nextlink;                                // 4
   u16          boardnum;                                // 2
   u16          position;                                // 2
   void (_far _loadds * ISR)();                          // 4
   void (_far * ControlEntryPt)();                       // 4
   u16          StackID;                                 // 2
   u16          PacFilterMsk;                            // 2
   u32          Reserved;                                // 4
} RxNode;                                                // 24 total

typedef struct
{
   u8           cmajver;
   u8           cminver;
   u32          longname;
   u32          shortname;
   u8           pmajver;
   u8           pminver;
   u8           reserved[16];
} configtbl;

typedef struct
{
   u8           majver;
   u8           minver;
   u16          ctr;
   u32          mask;
   u32          txpac;
   u32          rxpac;
   u32          nopac;
   u16          cusctr;
}  stattbl;
