/*

	FXSAVE (C) Copyright Tenth Planet Software Intl., C Turvey 1998

	Quick test of FXSAVE

	This code was designed to compile with Watcom C/C++ (10.6), and
	MASM v6.11c. I could do it all in Watcom, but it would be more
	cryptic.

		wcc386 -mf -zq -3s -Ox fxsave.c
		ml -Zm /c /Cx /Fl /Sc fxcode.asm
		wlink option quiet system pmodew name fxsave file fxsave,fxcode

	or

		wlink option quiet system dos4g name fxsave file fxsave,fxcode


	Clive, 4-Mar-98, clive@tbcnet.com

*/

#include <stdlib.h>
#include <stdio.h>

extern unsigned char cdecl scratch[1024];

extern long cdecl chk_deschutes(void);
extern void cdecl chk_fsave(unsigned char *);
extern void cdecl chk_fxsave(unsigned char *);

//******************************************************************************

#define WIDTH 16

#define pchar(x)  putchar( ((x > 31) && (x < 127)) ? x : '.');

//******************************************************************************

void dumpdata(len,buf)
unsigned long len;
unsigned char *buf;
{
	unsigned long i, off = 0;

	while(len)
	{
		printf(" %08lX: ",off);

		for(i=0; i<WIDTH; i++)
		{
			if (i < len)
			{
				if (i == (WIDTH / 2))
					printf("- ");

				printf("%02X ",buf[i]);
			}
			else
			{
				if (i == (WIDTH / 2))
					printf("     ");
				else
					printf("   ");
			}
		}

		putchar(' ');

		for(i=0; i<min(WIDTH,len); i++)
			pchar(buf[i]);

		putchar('\n');

		len -= i;
		buf += i;
		off += i;
	}
}

//******************************************************************************

void main(argc,argv)
int argc;
char **argv;
{
	unsigned long i;

	printf("\nFXSAVE v1.00 (c) Copyright Tenth Planet Software Intl., C Turvey 1998.\n"
						"\t\t\t   All rights reserved. Non-Commercial use only.\n\n");

	for(i=0; i<1024; i++)						// Fill scratch buffer with marker
		scratch[i] = 0xE5;

	chk_fsave(scratch);							// Test standard FSAVE function

	i = 1024;

	while(scratch[i-1] == 0xE5)			// Determine bytes actually touched
		i--;

	printf("FSAVE returns %ld bytes\n\n",i);

	dumpdata(i,scratch);						// Dump buffer in hex

	putchar('\n');

	if (!chk_deschutes())						// Test for Deschutes and set CR4.OSFXSR
	{
		puts("This is not a Deschutes class processor, FXSAVE is not available");
	}
	else
	{
		for(i=0; i<1024; i++)					// Fill scratch buffer with marker
			scratch[i] = 0xE5;

		chk_fxsave(scratch);					// Test new FXSAVE function

		i = 1024;

		while(scratch[i-1] == 0xE5)		// Determine bytes actually touched
			i--;

		printf("FXSAVE returns %ld bytes\n\n",i);

		dumpdata(i,scratch);

		putchar('\n');
	}

	exit(1);
}

