/* 
   PEUtils v1.0	
   (c) 1998 Andrew de Quincey
   adq@tardis.ed.ac.uk
   See README.TXT for copying/distribution/modification details.
*/


#include "pejoinp.h"


int main(int argc, char* argv[])
{
  int fd, fd2;
  int tmp, tmp2;
  int peOffset;
  int count;
  char buffer[256];
  char dosStubFilename[256];
  int EOFreached;
  int numDirs;
  int numSections;
  int i;
  int alignSize;

  NTOptionalHeader ntOptHeader;
  PEHeader peHeader;
  DataDirectory** dataDirs;
  Section** sections;
  char** sectionFilenames;

  // check args
  if (argc != 3)
    error("Syntax: pejoin <PE spec filename> <output EXE filename>\n");

  // wipe headers
  for(i=0; i< sizeof(NTOptionalHeader); i++)
    *(((char*) &ntOptHeader) +i) = 0;
  for(i=0; i< sizeof(PEHeader); i++)
    *(((char*) &peHeader) +i) = 0;

  // do main config file
  fd = openX(argv[1], O_RDONLY | O_BINARY, 0);

  // process the file
  EOFreached = 0;
  while(!EOFreached)
  {
    // work out the section of the file we're in
    if (readString(fd, buffer))
      EOFreached = 1;

    // blank line at EOF
    if (!strlen(buffer))
      break;

    switch(getItemNumber(buffer, sectionNames))
    {
    case 0: // pe header
      peHeaderParser(fd, &peHeader, dosStubFilename);
      break;

    case 1: // nt optional header
      ntOptionalHeaderParser(fd, &ntOptHeader);
      break;

    case 2: // data directories
      numDirs = dataDirectoryParser(fd, &dataDirs);
      break;

    case 3: // sections
      numSections = sectionsParser(fd, &sections, &sectionFilenames);
      break;

    default:
      error("Unknown section (%s) in file.\n", buffer);
    }
  }

  // finished with the input file
  close(fd);


  // now, reconstruct the PE file
  unlink(argv[2]);
  fd = openX(argv[2], O_CREAT | O_WRONLY | O_BINARY, _S_IREAD| _S_IWRITE);

  
  // copy the DOS header
  lseek(fd, 0, 0);
  fd2 = openX(dosStubFilename, O_RDONLY | O_BINARY, 0);
  copyData(fd2, fileLength(fd2) ,fd);
  close(fd2);

  // output PE header
  tmp = 0x00004550;   // "PE\0\0"
  write(fd, &tmp, 4);

  // PE header
  write(fd, &peHeader, sizeof(PEHeader));
  
  // NT "optional" header
  write(fd, &ntOptHeader, sizeof(NTOptionalHeader));
  
  // data directories	
  for(i=0; i< numDirs; i++)
    write(fd, dataDirs[i], sizeof(DataDirectory));

  // section headers
  for(i=0; i< numSections; i++)
    write(fd, sections[i], sizeof(Section));

  // actual section data
  for(i=0; i< numSections; i++)
  {
    lseek(fd, sections[i]->dataOffset, 0);
    fd2 = openX(sectionFilenames[i], O_RDONLY | O_BINARY, 0);
    copyData(fd2, fileLength(fd2), fd);
    close(fd2);
  }

  // finished making the EXE file
  close(fd);
}



void peHeaderParser(int fd, PEHeader* peHeader, char* dosStubFilename)
{
  int oldPos;
  char buffer[256];
  char buffer2[256];

  int endLoop;
  int i;
  unsigned long  value;

  endLoop =0;
  while(!endLoop)
  {
    oldPos = tell(fd);

    // check if we've hit the EOF
    if (readString(fd, buffer) == 1)
    {
      if (!strlen(buffer))
	return;
      endLoop =1;
    }
    
    // if we hit the next section, move back to it, & exit
    if (!isspace(buffer[0]))
    {
      lseek(fd, oldPos, 0);
      return;
    }

    // the dos stub filename
    if (getItemNumber(buffer, peHeaderNames) == 7)
    {
      if (sscanf(buffer, "%*s%s", buffer2) != 1)
	error("Missing value\n");
      
      strcpy(dosStubFilename, buffer2);
      continue;
    }

    // get the item's value
    if (sscanf(buffer, "%*s%i", &value) != 1)
      error("Missing value\n");

    // deal with the item
    switch(getItemNumber(buffer, peHeaderNames))
    {
    case 0:
      peHeader->cpuType = value;
      break;

    case 1:
      peHeader->numSections = value;
      break;

    case 2:
      peHeader->dateStamp = value;
      break;

    case 3:
      peHeader->symbolTable = value;
      break;

    case 4:
      peHeader->numSymbols = value;
      break;

    case 5:
      peHeader->optionalHeaderSize = value;
      break;

    case 6:
      peHeader->flags = value;
      break;

    case 7:
      break;
      
    default:
      error("Unknown item type\n");
    }
  }
}


void ntOptionalHeaderParser(int fd, NTOptionalHeader* ntOptHeader)
{
  int oldPos;
  char buffer[256];
  int endLoop;
  int i;
  unsigned long  value;

  endLoop =0;
  while(!endLoop)
  {
    oldPos = tell(fd);

    // check if we've hit the EOF
    if (readString(fd, buffer) == 1)
    {
      if (!strlen(buffer))
	return;
      endLoop =1;
    }
    
    // if we hit the next section, move back to it, & exit
    if (!isspace(buffer[0]))
    {
      lseek(fd, oldPos, 0);
      return;
    }

    // get the item's value
    if (sscanf(buffer, "%*s%i", &value) != 1)
      error("Missing value\n");

    // deal with the item
    switch(getItemNumber(buffer, ntOptionalHeaderNames))
    {
    case 0:
      ntOptHeader->magic = value;
      break;

    case 1:
      ntOptHeader->linkerMajor = value;
      break;

    case 2:
      ntOptHeader->linkerMinor = value;
      break;

    case 3:
      ntOptHeader->codeSize = value;
      break;

    case 4:
      ntOptHeader->initDataSize = value;
      break;

    case 5:
      ntOptHeader->uninitDataSize = value;
      break;

    case 6:
      ntOptHeader->entryPoint = value;
      break;

    case 7:
      ntOptHeader->codeBase = value;
      break;

    case 8:
      ntOptHeader->dataBase = value;
      break;

    case 9:
      ntOptHeader->imageBase = value;
      break;

    case 10:
      ntOptHeader->sectionAlign = value;
      break;

    case 11:
      ntOptHeader->fileAlign = value;
      break;

    case 12:
      ntOptHeader->osMajor = value;
      break;

    case 13:
      ntOptHeader->osMinor = value;
      break;

    case 14:
      ntOptHeader->imageMajor = value;
      break;

    case 15:
      ntOptHeader->imageMinor = value;
      break;

    case 16:
      ntOptHeader->subsystemMajor = value;
      break;

    case 17:
      ntOptHeader->subsystemMinor = value;
      break;

    case 18:
      ntOptHeader->reserved = value;
      break;

    case 19:
      ntOptHeader->imageSize = value;
      break;

    case 20:
      ntOptHeader->headersSize = value;
      break;

    case 21:
      ntOptHeader->checksum = value;
      break;

    case 22:
      ntOptHeader->subsystem = value;
      break;

    case 23:
      ntOptHeader->dllFlags = value;
      break;

    case 24:
      ntOptHeader->stackReserveSize = value;
      break;

    case 25:
      ntOptHeader->stackCommitSize = value;
      break;

    case 26:
      ntOptHeader->heapReserveSize = value;
      break;

    case 27:
      ntOptHeader->heapCommitSize = value;
      break;

    case 28:
      ntOptHeader->loaderFlags = value;
      break;

    case 29:
      ntOptHeader->numDataDirectories = value;
      break;

    default:
      error("Unknown item type\n");
    }
  }
}


int dataDirectoryParser(int fd, DataDirectory*** dataDirs)
{
  int numDirs;
  int oldPos;
  char buffer[256];
  int endLoop;
  long val1, val2;
  DataDirectory* tmpDir;
  DataDirectory** tmpDirs;

  numDirs = 0;
  *dataDirs = NULL;
  endLoop = 0;
  while(!endLoop)
  {
    oldPos = tell(fd);

    // check if we've hit the EOF
    if (readString(fd, buffer) == 1)
    {
      if (!strlen(buffer))
	return(numDirs);
      endLoop =1;
    }
    
    // if we hit the next section, move back to it, & exit
    if (!isspace(buffer[0]))
    {
      lseek(fd, oldPos, 0);
      return(numDirs);
    }

    // deal with this directory
    numDirs++;
    tmpDir = (DataDirectory*) malloc(sizeof(DataDirectory));
    if (sscanf(buffer, "%i%i", &(tmpDir->RVA), &(tmpDir->size)) != 2)
      error("Invalid data directory entry\n");

    tmpDirs = (DataDirectory**) malloc(sizeof(DataDirectory*) * numDirs);
    tmpDirs[numDirs-1] = tmpDir;

    if (*dataDirs != NULL)
    {
      memcpy(tmpDirs, *dataDirs, sizeof(DataDirectory*) * (numDirs-1));
      free(*dataDirs);
    }

    *dataDirs = tmpDirs;
  }

  return(numDirs);
}



int sectionsParser(int fd, Section*** sections, char*** filenames)
{
  int numSections;
  int oldPos;
  char buffer[256];
  int endLoop;
  long val1, val2;
  Section* tmpSection;
  Section** tmpSections;
  char* tmpFilename;
  char** tmpFilenames;

  numSections = 0;
  *sections = NULL;
  *filenames = NULL;
  endLoop = 0;
  while(!endLoop)
  {
    oldPos = tell(fd);

    // check if we've hit the EOF
    if (readString(fd, buffer) == 1)
    {
      if (!strlen(buffer))
	return(numSections);
      endLoop =1;
    }
    
    // if we hit the next section, move back to it, & exit
    if (!isspace(buffer[0]))
    {
      lseek(fd, oldPos, 0);
      return(numSections);
    }

    // deal with this section
    numSections++;
    tmpSection = (Section*) malloc(sizeof(Section));
    tmpFilename = (char*) malloc(256);
    if (sscanf(buffer, "%s%i%i%i%i%i%i%i%i%i%s", 
	       buffer,
	       &(tmpSection->misc.virtualSize),
	       &(tmpSection->RVA),
	       &(tmpSection->dataAlignSize),
	       &(tmpSection->dataOffset),
	       &(tmpSection->relocationsOffset),
	       &(tmpSection->lineNumbersOffset),
	       &(tmpSection->numRelocations),
	       &(tmpSection->numLineNumbers),
	       &(tmpSection->flags),
	       tmpFilename) != 11)
      error("Invalid section entry\n");

    // make sure section name is 8 chars max
    strncpy(tmpSection->name, buffer, 8);

    tmpSections = (Section**) malloc(sizeof(Section*) * numSections);
    tmpSections[numSections-1] = tmpSection;
    tmpFilenames = (char**) malloc(sizeof(char*) * numSections);
    tmpFilenames[numSections-1] = tmpFilename;

    if (*sections != NULL)
    {
      memcpy(tmpSections, *sections, sizeof(Section*) * (numSections-1));
      free(*sections);
      memcpy(tmpFilenames, *filenames, sizeof(char*) * (numSections-1));
      free(*filenames);
    }

    *sections = tmpSections;
    *filenames = tmpFilenames;
  }

  return(numSections);
}





int getItemNumber(char* buffer, char** items)
{
  char buffer2[256];
  int i1, i2;
  int i;

  // skip any leading whitespace
  i1=0;
  while(isspace(buffer[i1]))
    i1++;

  // uppercase the buffer & only get the string up to the first whitespace
  i2 =0;
  strcpy(buffer2, buffer);
  while(buffer2[i2] = toupper(buffer[i1]))
  {
    // end string at first whitespace char
    if (isspace(buffer2[i2]))
    {
      buffer2[i2] = 0;
      break;
    }

    i1++;
    i2++;
  }

  // find which item it is
  i=0;
  while(items[i] != NULL)
  {
    if (!strcmp(items[i], buffer2))
      return(i);
    i++;
  }
  
  return(-1);
}

int readString(int fd, char* buffer)
{
  int i = 0;
  int skipToEOL = 0;
  int EOLreached = 0;
  int nonSpaceRead =0;
  char c;
  int count;

  while(1)
  {
    // read in a line
    count=0;
    skipToEOL=0;
    EOLreached=0;
    nonSpaceRead=0;
    while(!EOLreached)
    {
      // check for error/EOF
      if (read(fd, &c, 1) != 1)
      {
	if (nonSpaceRead)
	  buffer[count] = c;
	else
	  buffer[0] = 0;

	// wipe space at end
	wipeEndSpace(buffer);

	return(1);
      }

      switch(c)
      {
      case ';': // comment reached - skip to EOL
	skipToEOL = 1;
	break;
	
      case '\r': // ignore CR
	break;
	
      case '\n': // EOL
	EOLreached =1;
	break;
	
      default:
	if (!skipToEOL)
	{
	  if (!isspace(c))
	    nonSpaceRead = 1;
	  
	  buffer[count++] = c;
	}
	break;
      }
    }
    buffer[count] =0;

    // OK, we read a line with some non white space in it
    if (nonSpaceRead)
      break;
  }

  // wipe space at end
  wipeEndSpace(buffer);
  
  return(0);
}      

void wipeEndSpace(char* buffer)
{
  int i;

  for(i= strlen(buffer)-1; i >=0 ; i--)
    if (isspace(buffer[i]))
      buffer[i] = 0;
    else
      break;
}


void readX(int fd, void* buf, int size)
{
  if (read(fd, buf, size) != size)
    error("Unexpected end of file\n");
}

int openX(char* file, int flags, int mode)
{
  int fd;

  if ((fd = open(file, flags, mode)) == -1)
    error("Unable to open file %s (cause: %s)\n", file, strerror(errno));
  
  return(fd);
}

void writeString(int fd, char* fmt, ...)
{
  char buffer[256];
  va_list args;

  va_start(args, fmt);
  vsprintf(buffer, fmt, args);
  va_end(args);
  
  write(fd, buffer, strlen(buffer));
}


void copyData(int srcFD, int srcLength, int destFD)
{
  char buffer[4096];
  int copied =0;
  int bufSize = 4096;

  while(copied < srcLength)
  {
    if ((srcLength - copied) < bufSize)
      bufSize = srcLength - copied;

    readX(srcFD, buffer, bufSize);
    write(destFD, buffer, bufSize);
    copied += bufSize;
  }
}

int fileLength(int fd)
{
  int oldPos;
  int len;

  oldPos = tell(fd);
  lseek(fd, 0, 2);
  len = tell(fd);
  lseek(fd, oldPos, 0);

  return(len);
}

