/* 
   PEUtils v1.0	
   (c) 1998 Andrew de Quincey
   adq@tardis.ed.ac.uk
   See README.TXT for copying/distribution/modification details.
*/


#include "pesplitp.h"


int main(int argc, char* argv[])
{
  int fd, fd2;
  int tmp, tmp2;
  int peOffset;
  int i;
  char buffer[256];

  NTOptionalHeader ntOptHeader;
  PEHeader peHeader;
  DataDirectory* dataDirs;
  Section* sections;

  // check args
  if (argc != 2)
    error("Syntax: pesplit <filename>\n");
  
  // open file
  fd = openX(argv[1], O_RDONLY | O_BINARY, 0);

  
  // check DOS header
  tmp = 0;
  readX(fd, &tmp, 2);
  if (tmp != 0x5a4d) // "MZ"
    error("Not an executable file\n");

  // see if it's just a DOS stub
  lseek(fd, 0x18, 0);
  readX(fd, &tmp, 4);
  if (tmp < 0x40)
    error("Not a windows executable\n");

  // get the offset to the windows guff
  lseek(fd, 0x3c, 0);
  readX(fd, &peOffset, 4);

  // check if it's a PE exe
  lseek(fd, peOffset, 0);
  readX(fd, &tmp, 4);
  if (tmp != 0x00004550) // "PE\0\0"
    error("Not a PE format executable\n");

  // dump the DOS header
  lseek(fd, 0, 0);
  unlink(dosStubFilename);
  fd2 = openX(dosStubFilename, 
	      O_CREAT | O_WRONLY | O_BINARY, _S_IREAD| _S_IWRITE);
  copyData(fd, peOffset, fd2);
  close(fd2);

  // move to start of PE data (skipping "PE\0\0" bytes)
  lseek(fd, peOffset+4, 0);
  
  // PE header
  readX(fd, &peHeader, sizeof(PEHeader));

  // PE "optional" header
  readX(fd, &ntOptHeader, sizeof(NTOptionalHeader));

  // data directories
  dataDirs = 
    (DataDirectory*) malloc(sizeof(DataDirectory) * ntOptHeader.numDataDirectories);
  readX(fd, dataDirs, sizeof(DataDirectory) * ntOptHeader.numDataDirectories);

  // section headers
  sections = (Section*) malloc(sizeof(Section) * peHeader.numSections);
  for(i=0; i< peHeader.numSections; i++)
    readX(fd, &(sections[i]), sizeof(Section));

  // dump sections as files
  for(i=0; i< peHeader.numSections; i++)
  {
    sprintf(buffer, "%s%i.bin", sectionFilename, i);
    lseek(fd, sections[i].dataOffset, 0);
    fd2 = openX(buffer,
		O_CREAT | O_WRONLY | O_BINARY, _S_IREAD| _S_IWRITE);
    copyData(fd, sections[i].dataAlignSize, fd2);
    close(fd2);
  }

  close(fd);


  // OK, create main config file
  sprintf(buffer, "%s.pe", argv[1]);
  unlink(buffer);
  fd = openX(buffer, O_CREAT | O_WRONLY | O_BINARY, _S_IREAD| _S_IWRITE);

  // pe header
  writeString(fd, "PEHeader\n");
  writeString(fd, "\tcpuType 0x%x\n", peHeader.cpuType);
  writeString(fd, "\tnumSections 0x%x\n", peHeader.numSections);
  writeString(fd, "\tdateStamp 0x%x\n", peHeader.dateStamp);
  writeString(fd, "\tsymbolTable 0x%x\n", peHeader.symbolTable);
  writeString(fd, "\tnumSymbols 0x%x\n", peHeader.numSymbols);
  writeString(fd, "\toptionalHeaderSize 0x%x\n", 
	      peHeader.optionalHeaderSize);
  writeString(fd, "\tflags 0x%x\n", peHeader.flags);
  writeString(fd, "\tdosStub %s\n", dosStubFilename);


  // pe optional header
  writeString(fd, "\nNTOptionalHeader\n");
  writeString(fd, "\tmagic 0x%x\n", ntOptHeader.magic);
  writeString(fd, "\tlinkerMajor 0x%x\n", ntOptHeader.linkerMajor);
  writeString(fd, "\tlinkerMinor 0x%x\n", ntOptHeader.linkerMinor);
  writeString(fd, "\tcodeSize 0x%x\n", ntOptHeader.codeSize);
  writeString(fd, "\tinitDataSize 0x%x\n", ntOptHeader.initDataSize);
  writeString(fd, "\tuninitDataSize 0x%x\n", ntOptHeader.uninitDataSize);
  writeString(fd, "\tentryPoint 0x%x\n", ntOptHeader.entryPoint);
  writeString(fd, "\tcodeBase 0x%x\n", ntOptHeader.codeBase);
  writeString(fd, "\tdataBase 0x%x\n", ntOptHeader.dataBase);
  writeString(fd, "\timageBase 0x%x\n", ntOptHeader.imageBase);
  writeString(fd, "\tsectionAlign 0x%x\n", ntOptHeader.sectionAlign);
  writeString(fd, "\tfileAlign 0x%x\n", ntOptHeader.fileAlign);
  writeString(fd, "\tosMajor 0x%x\n", ntOptHeader.osMajor);
  writeString(fd, "\tosMinor 0x%x\n", ntOptHeader.osMinor);
  writeString(fd, "\timageMajor 0x%x\n", ntOptHeader.imageMajor);
  writeString(fd, "\timageMinor 0x%x\n", ntOptHeader.imageMinor);
  writeString(fd, "\tsubsystemMajor 0x%x\n", ntOptHeader.subsystemMajor);
  writeString(fd, "\tsubsystemMinor 0x%x\n", ntOptHeader.subsystemMinor);
  writeString(fd, "\treserved 0x%x\n", ntOptHeader.reserved);
  writeString(fd, "\timageSize 0x%x\n", ntOptHeader.imageSize);
  writeString(fd, "\theadersSize 0x%x\n", ntOptHeader.headersSize);
  writeString(fd, "\tchecksum 0x%x\n", ntOptHeader.checksum);
  writeString(fd, "\tsubsystem 0x%x\n", ntOptHeader.subsystem);
  writeString(fd, "\tdllFlags 0x%x\n", ntOptHeader.dllFlags);
  writeString(fd, "\tstackReserveSize 0x%x\n", ntOptHeader.stackReserveSize);
  writeString(fd, "\tstackCommitSize 0x%x\n", ntOptHeader.stackCommitSize);
  writeString(fd, "\theapReserveSize 0x%x\n", ntOptHeader.heapReserveSize);
  writeString(fd, "\theapCommitSize 0x%x\n", ntOptHeader.heapCommitSize);
  writeString(fd, "\tloaderFlags 0x%x\n", ntOptHeader.loaderFlags);
  writeString(fd, "\tnumDataDirectories 0x%x\n", ntOptHeader.numDataDirectories);

  // data directories
  writeString(fd, "\nDataDirectories\n");
  writeString(fd, "\t;RVA\t\tSize\n");
  for(i=0; i< ntOptHeader.numDataDirectories; i++)
  {
    writeString(fd, "\t0x%x\t\t0x%x", 
		dataDirs[i].RVA, dataDirs[i].size);
    
    if (i < (sizeof(dataDirNames) / sizeof(char*)))
      writeString(fd, "\t\t; %s", dataDirNames[i]);

    writeString(fd, "\n");
  }

  // sections
  writeString(fd, "\nSections\n");
  writeString(fd, "\t;Name\t\tVSize\tRVA\tSize\tOffset\tRel\tLines\t#Rel\t#Line\tFlags\tFilename\n");
  for(i=0; i < peHeader.numSections; i++)
  {
    sprintf(buffer, "%s%i.bin", sectionFilename, i);
    strncpy(buffer+100, sections[i].name, 8);
    *(buffer+100+8) = 0;
    writeString(fd, "\t%s\t0x%x\t0x%x\t0x%x\t0x%x\t0x%x\t0x%x\t0x%x\t0x%x\t0x%x\t%s\n", 
		buffer+100,
		sections[i].misc.virtualSize,
		sections[i].RVA,
		sections[i].dataAlignSize,
		sections[i].dataOffset,
		sections[i].relocationsOffset,
		sections[i].lineNumbersOffset,
		sections[i].numRelocations,
		sections[i].numLineNumbers,
		sections[i].flags,
		buffer);
  }
  close(fd);
}


void readX(int fd, void* buf, int size)
{
  if (read(fd, buf, size) != size)
    error("Unexpected end of file\n");
}

int openX(char* file, int flags, int mode)
{
  int fd;

  if ((fd = open(file, flags, mode)) == -1)
    error("Unable to open file %s (cause: %s)\n", file, strerror(errno));
  
  return(fd);
}

void writeString(int fd, char* fmt, ...)
{
  char buffer[256];
  va_list args;

  va_start(args, fmt);
  vsprintf(buffer, fmt, args);
  va_end(args);
  
  write(fd, buffer, strlen(buffer));
}


void copyData(int srcFD, int srcLength, int destFD)
{
  char buffer[4096];
  int copied =0;
  int bufSize = 4096;

  while(copied < srcLength)
  {
    if ((srcLength - copied) < bufSize)
      bufSize = srcLength - copied;

    readX(srcFD, buffer, bufSize);
    write(destFD, buffer, bufSize);
    copied += bufSize;
  }
}
