;----------------------------------------------------------------------------------
; 						Code Snippet Creator 
;----------------------------------------------------------------------------------
; Coded by Iczelion (Iczelion@galaxycorp.com)
; web page: http://win32asm.cjb.net
;----------------------------------------------------------------------------------
.486
.model flat,stdcall
include \masm32\include\windows.inc
include \masm32\include\kernel32.inc
include \masm32\include\user32.inc
include \masm32\include\advapi32.inc
include \masm32\include\comdlg32.inc
include \masm32\include\shell32.inc
includelib \masm32\lib\advapi32.lib
includelib \masm32\lib\user32.lib
includelib \masm32\lib\kernel32.lib
includelib \masm32\lib\comdlg32.lib
includelib \masm32\lib\shell32.lib
.const
include constants.inc
;--------------------------------------------
; Constants for FProjectInProgress
;--------------------------------------------
NO_PROJECT		equ 0		; when there is no project opened/created
PROJECT_OPENED	equ 1		; when the user creates/opens a project
EXEFILE_AVAILABLE	equ 2		; when the exe file is available
TARGET_ONLY		equ 3		; when the target is opened for the PE editor only. No project

;---------------------------[ used by DumpHeader ]-----------------------------
DOSHEADER		equ 0
PEHEADER		equ 1
SECTIONTABLE	equ 2
ALLHEADER		equ 3

;----------------------------------[ Function Prototypes ]----------------------------
GetAppDir PROTO :DWORD,:DWORD
DlgProc PROTO :DWORD,:DWORD,:DWORD,:DWORD
NewProjectProc PROTO :DWORD,:DWORD,:DWORD,:DWORD
BrowseAndFillEditBox PROTO :DWORD,:DWORD
CheckIfValidPE PROTO :DWORD
InfoProc PROTO hDlg:DWORD,uMsg:DWORD,wParam:DWORD,lParam:DWORD
NewTargetProc PROTO hDlg:DWORD,uMsg:DWORD,wParam:DWORD,lParam:DWORD
OptionProc PROTO hDlg:DWORD,uMsg:DWORD,wParam:DWORD,lParam:DWORD
NewSectionProc PROTO hDlg:DWORD,uMsg:DWORD,wParam:DWORD,lParam:DWORD
NewImportProc PROTO hDlg:DWORD,uMsg:DWORD,wParam:DWORD,lParam:DWORD
OutputProc PROTO hDlg:DWORD,uMsg:DWORD,wParam:DWORD,lParam:DWORD
ModifySectionProc PROTO hDlg:DWORD,uMsg:DWORD,wParam:DWORD,lParam:DWORD
CharacteristicsProc PROTO hDlg:DWORD,uMsg:DWORD,wParam:DWORD,lParam:DWORD
FileCharacteristicsProc PROTO hDlg:DWORD,uMsg:DWORD,wParam:DWORD,lParam:DWORD
PatchOptionProc PROTO hDlg:DWORD,uMsg:DWORD,wParam:DWORD,lParam:DWORD
ImportProc PROTO hDlg:DWORD,uMsg:DWORD,wParam:DWORD,lParam:DWORD
DataDirectoryProc PROTO hDlg:DWORD,uMsg:DWORD,wParam:DWORD,lParam:DWORD
SectionProc PROTO hDlg:DWORD,uMsg:DWORD,wParam:DWORD,lParam:DWORD
AboutProc PROTO hDlg:DWORD,uMsg:DWORD,wParam:DWORD,lParam:DWORD
PEHeaderProc PROTO hDlg:DWORD,uMsg:DWORD,wParam:DWORD,lParam:DWORD
ProjectInfoProc PROTO hDlg:DWORD,uMsg:DWORD,wParam:DWORD,lParam:DWORD
DisableControls PROTO :DWORD
EnableControls PROTO :DWORD
EnablePatchVA proto :DWORD
DisablePatchVA proto :DWORD
EnableReturnVA proto :DWORD
DisableReturnVA proto :DWORD
HexString2Dword PROTO :DWORD
UpdateListView proto :DWORD
RVAToOffset proto :DWORD,:DWORD
AssembleCode proto :DWORD
ExportSnippet proto :DWORD
AddressToOffset PROTO :DWORD,:DWORD
PatchTheTarget proto :DWORD
OpenProject proto :DWORD
SaveRichEditContent proto :DWORD
SearchTargetImport proto :DWORD,:DWORD
SetTitle proto :DWORD
ShowErrorMessage proto :DWORD
CloseProject proto :DWORD
FillPEInfo proto :DWORD,:DWORD
ParseName proto :DWORD
SaveSectionToDisk proto :DWORD,:DWORD
FillCombo proto :DWORD
DumpHeader proto :DWORD,:DWORD
GetNewDLL proto :DWORD
GetExportFunctions proto :DWORD,:DWORD
AddNewImport proto :DWORD
PrepareSpaceInSectionTable PROTO :DWORD
String2Dword proto :DWORD
AddSpaceToSection proto :DWORD,:DWORD,:DWORD
GetSpaceNeeded proto :DWORD,:DWORD,:DWORD
AddRelocInfoToTarget proto :DWORD
KillTheSection proto :DWORD,:DWORD
AppendSectionToFile proto :DWORD


.data
HexTemplate			db "%lx",0		; hexadecimal number template for wsprintf
DecTemplate			db "%lu",0		; decimal number template for wsprintf
SectionTemplate		db "%08lx",0	; hexadecimal number template for section characteristics used in the list view control
HalfSectionTemplate	db "%04lx",0	; hexadecimal number template for file characterisitics
MainININame			db "SnippetCreator.ini",0	; the name of the ini file of this program

;-----------------------------[ Sections & Keys for main INI ]-----------------------------
MainINISection		db "OPTIONS",0		; main section
MASM				db "MASM",0			; MASM section
TASM				db "TASM",0			; TASM section
MainINIKeyCurASM		db "CURRENT_ASSEMBLER",0	; Current assembler used
MainINIKeyDefProjDir	db "DEFAULTPROJECTDIR",0	; default project directory key
MainINIKeyASM		db "ASSEMBLER",0			; assembler commandline key
MainINIKeyLink		db "LINKER",0			; linker commandline key
ASM_MASM			db "ML /c /coff /Cp %1",0	; default assembler commandline for MASM
ASM_TASM			db "TASM32 /ml %1",0		; default assembler commandline for TASM
LINK_MASM			db "LINK /FIXED:NO /SUBSYSTEM:WINDOWS /ENTRY:IczelionStart /LIBPATH:C:\MASM\LIB %1",0	; default linker commandline for MASM
LINK_TASM			db "TLINK32 /Tpe /aa /c /V4.0 %1,,,import32.lib",0	; default linker commandline for TASM

;------------------------------[ Keys for project INI ]-------------------
ProjINIKeySnippetVA	db "SNIPPET_VA",0		; Specify the virtual address the snippet should be relocated to
ProjINIKeyPatchOption	db "PATCHOPTION",0	; 0==no patching, 1==patch as new section, 2==patch into an existing section
ProjINIKeyRedirect	db "REDIRECT",0		; 0==no redirection to the snippet,1==redirect from EPRVA, 2== redirect from somewhere in the code section
ProjINIKeyRedirectVA	db "REDIRECT_VA",0	; The virtual address of the instruction that will be replaced with the instructions to turn over control to the snippet
ProjINIKeyReturn		db "RETURN",0		; 0==no return, 1==after the snippet executed, it will return control to somewhere in the program
ProjINIKeyReturnVA	db "RETURN_VA",0		; The virtual address that the snippet will return to, after its job is done
ProjINIKeyRestore		db "RESTORE",0		; 0==don't restore the instruction(s) that were overwritten previously by this program to redirect control to the snippet
								   ; 1== restore the instruction(s)
ProjINIKeyTarget		db "TARGET",0		; The patch target
ProjINIKeyModel		db "MODEL",0		; Model directive


AppName			db "Snippet Creator",0
HelpName			db "snippetcreator.hlp",0
DefaultINI			db "DEFINI",0
RichEditLib			db "RICHED32",0
IniString	 		db "Project Initialization Files (*.ini)",0,"*.ini",0
				db "All Files (*.*)",0,"*.*",0,0
FilterString 		db "Executable Files (*.exe, *.dll)",0,"*.exe;*.dll",0
				db "All Files (*.*)",0,"*.*",0,0
DLLFilterString 		db "Dynamic Linked Library (*.dll)",0,"*.dll",0
				db "All Files (*.*)",0,"*.*",0,0
SaveFilterString 		db "binary file (*.bin)",0,"*.bin",0
				db "All Files (*.*)",0,"*.*",0,0
SectionFilterString	db "All Files (*.*)",0,"*.*",0,0

ofn   			OPENFILENAME <>
IczMarker			db "IczelionMarker",0		; the text used to mark the end of the code section of the snippet exe
DefaultSectionName	db "section1",0		; The suggested name of the new section in case the user chooses to append the snippet as a new section

;-----------------------------[ Various extensions ]-----------------------------------
EXE				db ".exe",0
OBJ				db ".obj",0
BIN				db ".bin",0
SRC				db ".src",0
INI				db ".ini",0
ASM				db ".asm",0
ICZ				db ".icz",0

;------------[ Headers of the listview control used to show the section information ]--------
SectionNameStr		db "Section",0
VirtualSizeStr		db "V.Size",0
VirtualOffsetStr		db "V.Offset",0
RawSizeStr			db "Raw Size",0
RawOffsetStr		db "Raw Off.",0
CharacteristicsStr	db "Charac.",0

;-------------------------[ Various Messages to the user ]-------------------------------
PatchSuccessful		db "Patch successful",0
ExportSuccessful		db "Export successful",0
CloseConfirmation		db "A project is already opened.",0Dh,0Ah
							db "You want to close it?",0
ErrorNoProjectName	db "You haven't specified the name of the project",0
ErrorDirExist			db "The directory already exists",0
ErrorNotValidPEFile	db "The target is not a valid PE file",0
ErrorFileNotFound		db "The target file is not found",0
ErrorNoPatchVA			db "You haven't specify the patch VA yet",0
ErrorNoReturnVA		db "You haven't specify the return VA yet",0
ErrorPatchValueOutOfRange	db "Patch address must be within the target image",0
ErrorReturnValueOutOfRange	db "Return address must be within the target image",0
ErrorSnippetOutOfRange		db "Snippet virtual address must be within the target image",0
ErrorLoadingASM		db "Cannot run the assembler. Check the assembler option",0
ErrorLoadingLink		db "Cannot run the linker. Check the linker option",0
ErrorNoPatchFile		db "You haven't specified the new target yet",0
ErrorEXENotFound		db "Cannot open %s",0
ErrorCreateExport		db "Cannot create %s",0
ErrorMapping			db "Cannot map %s into memory",0
ErrorSectionName		db "You must specify the section name",0
ErrorInvalidProjectINI	db "This file is not a valid project file",0
ErrorSaving				db "Cannot save data to file",0
ErrorImport				db "You use a function that is not present in the target file",0
ErrorCreatingTempExe	db "Can't create %s",0
ErrorDeletingEXE		db "Can't delete %s",0
ErrorRVAOverflow		db "Not enough space for the snippet.",0Dh,0Ah
							db "Please decrease the Snippet VA",0Dh,0Ah
							db "The size of snippet is %lx (in hex)",0
ErrorNotDLL				db "%s is not a DLL",0
ErrorNoFunction		db "You haven't selected a function to import yet",0
ErrorNoImport			db "There is no import functions in this file",0
ErrorInvalidIID		db "The IMAGE_IMPORT_DESCRIPTOR array is invalid",0
SaveComplete			db "Project saved",0
DataSaved				db "Data saved",0
NoProject				db "No Project",0
CloseConfirmation1	db "Are you sure you want to close the current project?",0
NoCallOrJump			db "There is no call/jmp instruction at the specified VA",0

DefaultCPU				db ".386",0

;-------------------[ code to be added to the user snippet before it's assembled ]---------------
CodePrologue		db 0Dh,0Ah
				db ".model flat,stdcall",0Dh,0Ah
				db ".data",0Dh,0Ah
				db "Iczelion23421433 db 0",0Dh,0Ah
				db ".code",0Dh,0ah
				db "IczelionStart:",0Dh,0Ah,0

CodeEpilogue		db 0Dh,0Ah
				db "db 'IczelionMarker'",0Dh,0Ah
				db "end IczelionStart",0

;--------------------[ Used in restoring overwritten instructions at random location ]------------------
MainData			db "jmp BewareIczelion",0Dh,0Ah

OldInstructionPrefix	db " "
				db "OldInstruction db "
FirstByte			db "000h,"
SecondByte			db "000h,"
ThirdByte			db "000h,"
FourthByte			db "000h,"
FifthByte			db "000h,"
SixthByte			db "000h",0Dh,0Ah

PatchVAPrefix		db " "
				db "PatchVA dd 0"
PatchLocation		db "00000000h",0Dh,0Ah

CallOldVAPrefix		db " "
				db "PatchPoint dd 0"
CallOldVA			db "00000000h",0Dh,0Ah
OriginalCallPrefix	db " "
				db "OriginalLocation dd 0"
OriginalCall		db "00000000h",0Dh,0Ah

CallAddressPrefix	db " "
				db "CallAddress dd 0"
CallAddress			db "00000000h",0Dh,0Ah
				db "BewareIczelion:",0Dh,0Ah,0


RestoreSnippet		db "pushad",0Dh,0ah
				db "mov esi,offset OldInstruction",0Dh,0Ah
				db "mov edi,PatchVA",0Dh,0Ah
				db "mov ecx,6",0Dh,0Ah
				db "rep movsb",0Dh,0Ah
				db "popad",0Dh,0Ah,0


;-------------------[ Used in restoring the modified jump/call address ]----------------------

RestoreCallSnippet	db "pushad",0Dh,0ah
				db "mov edi,PatchVA",0Dh,0Ah
				db "push CallAddress",0Dh,0Ah
				db "pop [edi]",0Dh,0Ah
				db "popad",0Dh,0Ah,0


ReturnSnippet		db 0Dh,0Ah
				db "jmp ReturnIczelion",0Dh,0Ah
				db "ReturnVA dd "
ReturnLocation		db "000000000h",0Dh,0Ah
				db "ReturnIczelion:",0Dh,0Ah
				db "push ReturnVA",0Dh,0Ah
				db "ret",0Dh,0Ah,0

;-----------------------[ Strings used in the popup menu in the richedit control ]--------
COPYString			db "&Copy",0
CUTString			db "Cu&t",0
PASTEString			db "&Paste",0
UNDOString			db "&Undo",0
SelectAllString		db "Select &All",0
DeleteString		db  "&Delete",0

;------------[ Used to bracket the name of the target file in the title of pe info dialogs ]------------
LeadBracket			db " [ ",0
CloseBracket		db " ]",0

DumpDOSHeader		db "Dump DOS Header",0
DumpPEHeader		db "Dump PE Header",0
DumpSectionTable		db "Dump Section Table",0
DumpAll			db "Dump All Headers",0
EditSection			db "Edit Section",0
SaveSection			db "Save Section",0
KillSection			db "Kill Section",0
AppendSection		db "Append Section",0

ImportName			db "ImportEx",0
ImportData			db "iImport",0
RelocName			db ".reloc",0
;--------------------------------[ Flags ]----------------------------------------------
FProjectInProgress	dd NO_PROJECT	; Progress flag
FPatch			dd FALSE		; Is patched file opened?

Unknown		db "UNKNOWN",0
I386			db "I386",0
R3000			db "R3000",0
R4000			db "R4000",0
R10000		db "R10000",0
WCEMIPSV2		db "WCEMIPSV2",0
Alpha			db "ALPHA",0
PowerPC		db "POWERPC",0
SH3			db "SH3",0
SH3E			db "SH3E",0
SH4			db "SH4",0
ARM			db "ARM",0
Thumb			db "THUMB",0
IA64			db "IA64",0
Mips16		db "MIPS16",0
MipsFpu		db "MIPSFPU",0
MipsFpu16		db "MIPSFPU16",0
Alpha64		db "ALPHA64",0
AXP64			db "AXP64",0

UnknownSubsystem	db "Unknown",0
Native		db "Native",0
WinGUI		db "Windows GUI",0
WinConsole		db "Windows Console",0
OS2Console		db "OS/2 Console",0
POSIXConsole	db "POSIX Console",0
NativeWin		db "Native Windows",0
WinCEGUI		db "WindowsCE GUI",0
NewSectionName	db 8 dup(?),0	; The name of the new section (used when the user chooses to add the code snippet as a new section)

.data?
hInstance		dd ?			; Instance/Module handle of this program
ProgramDir		db 256 dup(?)	; full path of this program
ProjectDir		db 256 dup(?)	; full path of the project directory
ProjectName		db 256 dup(?)	; The name of the project currently opened/created
FullININame		db 512 dup(?)	; The full name of the program initialization file
FullProjININame	db 512 dup(?)	; The full name of the project ini file
TargetName		db 1024 dup(?)	; The name of the target file, without path name
hRichEditLib	dd ?			; Handle to the richedit dll
hMenu			dd ?			; Handle to the main menu of this program
hMenuPopup		dd ?			; Handle to the popup menu 
FileName		db 256 dup(?)	; The buffer to store filename from GetOpenFileName function
Assembler		db 1024 dup(?)	; The final assembler commandline that will be used with CreateProcess
Linker		db 1024 dup(?)	; The final linker commandline that will be used with CreateProcess
hFile			dd ?			; File handle of the patch target
hMapping		dd ?			; File mapping handle of the patch target
pMapping		dd ?			; File mapping pointer of the patch target
pPEHeader		dd ?			; Pointer to PE header of the patch target
pSectionTable	dd ?			; Pointer to section table of the patch target
pImportSection	dd ?			; Pointer to the import section of the patch target
NumSection		dd ?			; Number of sections in the patch target
hAsm			dd ?			; File handle of the output .asm file
hSource		dd ?			; File handle of the output .src file
CurrentASM		dd ?			; 0==MASM, 1==TASM
NewSectionVA	dd ?			; The virtual address of the new section for the snippet
;----------------------------------------------
; Patch options
;----------------------------------------------
SnippetVA		dd ?		; Virtual address that the snippet will be relocated to
PatchOption		dd ?		; 0== no patching, 1==patch as a new section, 2==patch into an existing section
RedirectOption	dd ?		; 0== no redirection, 1== redirect from a specified va
PatchVA		dd ?		; Virtual address of the instruction that will be overwritten by instructions to give control to the snippet
ReturnOption	dd ?		; 0== no return, 1== return to a specified VA
ReturnVA		dd ?		; Virtual address that the snippet will return control to when it is done with its job
RestoreOption	dd ?		; 0== no restoration of the patched point, 1== restore
Characteristics 	dd ?		; Characteristics of the new section

OldWinProc		dd ?		; Address of the default edit control window procedure, which we subclass

EXEName		db 256 dup(?)
OBJName		db 256 dup(?)
ININame		db 256 dup(?)
SRCName		db 256 dup(?)
BINName		db 256 dup(?)
ASMName		db 256 dup(?)

Charac		dd ?		;Characteristics, used in CharacteristicsProc
SectionPtr		dd ?		;pointer to the IMAGE_SECTION_HEADER structure that is being modified
hSectionPopup	dd ?		; Menu handle of the popup menu used in the section table info dialog

hDLL			dd ?
hDLLMapping		dd ?
pDLLMapping		dd ?
ImportAddress	dd ?

.code
start:
	invoke GetModuleHandle,NULL
	mov hInstance,eax
	;-------------------------------------------------------
	; Check if snippetcreator.ini exists, if it doesn't
	; create it from the data in the resource section
	;-------------------------------------------------------
	call OpenMainINI
	;-------------------------------------------------------
	; Load the richedit control DLL
	;-------------------------------------------------------
	invoke LoadLibrary,addr RichEditLib
	mov hRichEditLib,eax
	invoke DialogBoxParam,hInstance,IDD_MAINWINDOW,NULL,addr DlgProc,NULL
	invoke FreeLibrary,hRichEditLib
	invoke ExitProcess,NULL

DlgProc PROC hDlg:DWORD,uMsg:DWORD,wParam:DWORD,lParam:DWORD
	LOCAL pt:POINT
	LOCAL MainRect:RECT
	LOCAL DlgRect:RECT
	LOCAL buffer[1024]:byte
	.if uMsg==WM_INITDIALOG
		;----------------------------
		; Obtain menu handle
		;----------------------------
		invoke GetMenu,hDlg
		mov hMenu,eax
		;----------------------------
		; Set icon on the main window
		;----------------------------
		invoke LoadIcon,hInstance,IDI_MYICON
		invoke SendMessage,hDlg,WM_SETICON,ICON_SMALL,eax
		;------------------------------------------------
		; Set new text limit for the richedit control
		;------------------------------------------------
		invoke SendDlgItemMessage,hDlg,IDC_CODEEDIT,EM_SETLIMITTEXT,01fffffffh,0
		;-------------------------------------------------
		; Create the popup menus
		;-------------------------------------------------
		call PopupMenuCreate
		call SectionMenuCreate
		;-----------------------------------------------------------------
		; Tell richedit control to send mouse events to the parent window
		;------------------------------------------------------------------
		invoke SendDlgItemMessage,hDlg,IDC_CODEEDIT,EM_SETEVENTMASK,NULL,ENM_MOUSEEVENTS	
	.elseif uMsg==WM_NOTIFY						
		mov edx,lParam
		assume edx:ptr MSGFILTER
		.if [edx].nmhdr.code==EN_MSGFILTER
			.if [edx].msg==WM_RBUTTONDOWN
				mov eax,[edx].lParam
				mov ecx,[edx].lParam
				shr eax,16
				and ecx,0ffffh
				mov pt.x,ecx
				mov pt.y,eax
				invoke GetDlgItem,hDlg,IDC_CODEEDIT
				mov edx,eax
				invoke ClientToScreen,edx,addr pt
				call ManagePopupMenuItem
				invoke TrackPopupMenu,hMenuPopup,TPM_LEFTALIGN,pt.x,pt.y,NULL,hDlg,NULL			
			.endif
		.endif
		assume edx:nothing
	.elseif uMsg==WM_INITMENUPOPUP
		mov eax,lParam
		shr eax,16
		.if ax==FALSE	; if this is our main menu
			mov eax,lParam
			call ManageMenuState
		.endif
	.elseif uMsg==WM_COMMAND
		mov eax,wParam
		.if lParam==0		; menu
			.if ax==IDM_EXIT
				invoke SendMessage,hDlg,WM_CLOSE,0,0
			.elseif ax==IDM_CONTENT
				invoke ShellExecute,hDlg,NULL,addr HelpName,NULL,NULL,SW_SHOW
			.elseif ax==IDM_EXPORT		; export binary data
				mov ofn.lStructSize,SIZEOF ofn
				push hDlg
				pop  ofn.hWndOwner
				push hInstance
				pop  ofn.hInstance
				mov  ofn.lpstrFilter, OFFSET SaveFilterString
				mov  ofn.lpstrFile, OFFSET FileName
				mov  ofn.nMaxFile,sizeof FileName
				mov  ofn.lpstrDefExt,offset BIN
				mov byte ptr [FileName],0
				mov ofn.Flags,OFN_LONGNAMES or OFN_NOCHANGEDIR or\
                				 OFN_EXPLORER or OFN_HIDEREADONLY or OFN_PATHMUSTEXIST
				invoke GetSaveFileName,addr ofn
				mov ofn.lpstrDefExt,NULL
				.if eax!=0
					invoke ExportSnippet,hDlg
					.if eax==TRUE	; if export is successful, display the message to the user
						invoke MessageBox,hDlg,addr ExportSuccessful,addr AppName,MB_OK+MB_ICONINFORMATION
					.endif
				.endif
			.elseif ax==IDM_CLOSE		; close the current project
				invoke CloseProject,hDlg
			.elseif ax==IDM_NEW
				invoke CloseProject,hDlg
				.if eax==TRUE
					invoke DialogBoxParam,hInstance,IDD_NEWPROJECT,hDlg,NewProjectProc,NULL
				.endif
			.elseif ax==IDM_PEHEADER
				invoke DialogBoxParam,hInstance,IDD_PEHEADER,hDlg,PEHeaderProc,NULL
			.elseif ax==IDM_SECTION
				invoke DialogBoxParam,hInstance,IDD_SECTIONINFO,hDlg,SectionProc,NULL		
			.elseif ax==IDM_IMPORT
				invoke DialogBoxParam,hInstance,IDD_IMPORTINFO,hDlg,ImportProc,NULL		
			.elseif ax==IDM_OPTION
				invoke DialogBoxParam,hInstance,IDD_GENERALOPTION,hDlg,OptionProc,NULL		
			.elseif ax==IDM_ABOUT			
				invoke DialogBoxParam,hInstance,IDD_ABOUT,hDlg,AboutProc,NULL		
			.elseif ax==IDM_PROJECTOPTION
				invoke DialogBoxParam,hInstance,IDD_PATCHOPTION,hDlg,PatchOptionProc,NULL		
			.elseif ax==IDM_ASSEMBLE
				invoke AssembleCode,hDlg				
			.elseif ax==IDM_PASTE
				invoke SendDlgItemMessage,hDlg,IDC_CODEEDIT,WM_PASTE,0,0
			.elseif ax==IDM_COPY
				invoke SendDlgItemMessage,hDlg,IDC_CODEEDIT,WM_COPY,0,0
			.elseif ax==IDM_CUT
				invoke SendDlgItemMessage,hDlg,IDC_CODEEDIT,WM_CUT,0,0
			.elseif ax==IDM_UNDO
				invoke SendDlgItemMessage,hDlg,IDC_CODEEDIT,WM_UNDO,0,0
			.elseif ax==IDM_DELETE
				invoke SendDlgItemMessage,hDlg,IDC_CODEEDIT,WM_CLEAR,0,0
			.elseif ax==IDM_NEWTARGET
				invoke DialogBoxParam,hInstance,IDD_NEWPATCHTARGET,hDlg,NewTargetProc,NULL
			.elseif ax==IDM_PATCH
				.if PatchOption!=0	; if some patching is specified
					invoke PatchTheTarget,hDlg
				.endif
			.elseif ax==IDM_DATADIRECTORY
				invoke DialogBoxParam,hInstance,IDD_DATADIRECTORY,hDlg,DataDirectoryProc,NULL				
			.elseif ax==IDM_SELECTALL
				invoke SendDlgItemMessage,hDlg,IDC_CODEEDIT,EM_SETSEL,0,-1
			.elseif ax==IDM_SAVE
				invoke SaveRichEditContent,hDlg
			.elseif ax==IDM_PROJECTINFO
				invoke DialogBoxParam,hInstance,IDD_PROJECTINFO,hDlg,ProjectInfoProc,NULL
			.elseif ax==IDM_NEWIMPORT
				invoke DialogBoxParam,hInstance,IDD_NEWIMPORT,hDlg,NewImportProc,NULL
			.elseif ax==IDM_OPEN
				invoke CloseProject,hDlg
				.if eax==TRUE
					mov ofn.lStructSize,SIZEOF ofn
					push hDlg
					pop  ofn.hWndOwner
					push hInstance
					pop  ofn.hInstance
					mov  ofn.lpstrFilter, OFFSET IniString
					invoke GetPrivateProfileString,addr MainINISection,addr MainINIKeyDefProjDir,addr buffer,addr buffer,1024,addr FullININame
					lea  eax,buffer
					mov  ofn.lpstrInitialDir,eax
					mov  ofn.lpstrFile, OFFSET FileName
					mov  ofn.nMaxFile,sizeof FileName
					mov byte ptr [FileName],0
					mov ofn.Flags,OFN_LONGNAMES or OFN_NOCHANGEDIR or\
               						 OFN_EXPLORER or OFN_HIDEREADONLY or OFN_PATHMUSTEXIST
					invoke GetOpenFileName,addr ofn
					.if eax!=0
						invoke OpenProject,hDlg
					.endif
					mov  ofn.lpstrInitialDir,0
				.endif
			.endif
		.else			; controls
			.if ax==IDC_EXIT
				shr eax,16
				.if ax==BN_CLICKED
					invoke SendMessage,hDlg,WM_CLOSE,0,0
				.endif
			.elseif ax==IDC_ASSEMBLE
				shr eax,16
				.if ax==BN_CLICKED
					invoke AssembleCode,hDlg
				.endif
			.endif
		.endif
	.elseif uMsg==WM_CLOSE
		.if FPatch==TRUE || FProjectInProgress==TARGET_ONLY
			invoke UnmapViewOfFile,pMapping
			invoke CloseHandle,hMapping
			invoke CloseHandle,hFile
		.endif
		invoke EndDialog,hDlg,0
	.else
		mov eax,FALSE
		ret
	.endif
	mov eax,TRUE
	ret
DlgProc endp

KillTheSection proc uses edx ecx edi esi hDlg:DWORD,Index:DWORD
	LOCAL hTemp:DWORD
	LOCAL buffer[512]:byte
	LOCAL pISH:DWORD
	LOCAL bytesWritten:DWORD

	xor edx,edx
	mov eax,Index
	mov ecx,sizeof IMAGE_SECTION_HEADER
	mul ecx
	add eax,pSectionTable
	mov pISH,eax
	;--------------------------------------------------------------------------
	; Create the temporary file in the same dir as the target but it has .icz
	; extension.
	;--------------------------------------------------------------------------
	invoke lstrcpy,addr buffer,addr TargetName
	invoke lstrlen,addr buffer
	mov ecx,eax
	lea edi,buffer
	mov al,"."
	repne scasb
	.if ZERO?
		dec edi
		push esi
		mov esi,offset ICZ
		mov ecx,4
		rep movsb
		pop esi
		mov byte ptr [edi],0
	.else
		invoke lstrcat,addr buffer,addr ICZ
	.endif
	invoke CreateFile,addr buffer,GENERIC_READ+GENERIC_WRITE,0,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,0
	.if eax!=INVALID_HANDLE_VALUE
		mov hTemp,eax
		mov edi,pISH
		assume edi:ptr IMAGE_SECTION_HEADER
		mov ecx,[edi].PointerToRawData
		invoke WriteFile,hTemp,pMapping,ecx,addr bytesWritten,NULL
		;---------------------------------------------------------
		; Skip to the remaining data
		;---------------------------------------------------------
		invoke GetFileSize,hFile,NULL
		mov edx,[edi].PointerToRawData
		add edx,[edi].SizeOfRawData
		sub eax,edx
		mov ecx,eax		; ecx == size of remaining data
		add edx,pMapping
		invoke WriteFile,hTemp,edx,ecx,addr bytesWritten,NULL
		invoke CloseHandle,hTemp
		;-------------------------------------------------------
		; Now rename the file
		;-------------------------------------------------------
		invoke UnmapViewOfFile,pMapping
		invoke CloseHandle,hMapping
		invoke CloseHandle,hFile
		invoke DeleteFile,addr TargetName
		.if eax!=0
			invoke MoveFile,addr buffer,addr TargetName
			.if eax!=0
				mov FPatch,FALSE
				push FProjectInProgress
				mov FProjectInProgress,NO_PROJECT
				invoke CheckIfValidPE,addr TargetName
				pop FProjectInProgress
				;----------------------------------------------
				; Now modify the PE header and section table
				;----------------------------------------------
				mov edi,pPEHeader
				assume edi:ptr IMAGE_NT_HEADERS
				dec [edi].FileHeader.NumberOfSections
				mov eax,Index
				inc eax
				.if eax!=NumSection
					mov eax,Index
					inc eax
					mov ecx,NumSection
					sub ecx,eax		; ecx == number of sections to be processed
					push ecx
					mov edi,pISH
					assume edi:ptr IMAGE_SECTION_HEADER
					mov eax,[edi].SizeOfRawData	; the amount to be subtracted
					add edi,sizeof IMAGE_SECTION_HEADER
					.while ecx>0
						sub [edi].PointerToRawData,eax
						add edi,sizeof IMAGE_SECTION_HEADER
						dec ecx
					.endw
					pop eax
					xor edx,edx
					mov ecx,sizeof IMAGE_SECTION_HEADER
					mul ecx
					mov ecx,eax
					mov edi,pISH
					mov esi,edi
					add esi,sizeof IMAGE_SECTION_HEADER
					rep movsb
				.endif
				dec NumSection
				;----------------------------------------------
				; Get new image size
				;----------------------------------------------
				mov ecx,NumSection
				mov edi,pSectionTable
				xor edx,edx
				xor esi,esi
				.while ecx>0
					.if edx<[edi].VirtualAddress || edx==0
						mov edx,[edi].VirtualAddress
						mov esi,[edi].SizeOfRawData
					.endif
					add edi,sizeof IMAGE_SECTION_HEADER
					dec ecx	
				.endw
				mov edi,pPEHeader
				assume edi:ptr IMAGE_NT_HEADERS
				push edx
				mov eax,esi
				xor edx,edx
				mov ecx,[edi].OptionalHeader.SectionAlignment
				div ecx
				.if edx!=0
					inc eax
				.endif
				mul ecx
				pop edx
				add eax,edx
				mov [edi].OptionalHeader.SizeOfImage,eax
				mov eax,TRUE
			.else
				invoke ShowErrorMessage,hDlg
				mov FPatch,FALSE
				mov eax,FALSE
			.endif
		.else
			mov FPatch,FALSE
			push FProjectInProgress
			mov FProjectInProgress,NO_PROJECT
			invoke CheckIfValidPE,addr TargetName
			pop FProjectInProgress
			invoke ShowErrorMessage,hDlg
			mov eax,FALSE
		.endif
	.else
		invoke ShowErrorMessage,hDlg
		mov eax,FALSE
	.endif
	ret
KillTheSection endp

include routine.asm

end start
