;-----------
; Make keys
;-----------
; Input:
;   None
; Output:
;   Cx & Dx are random
;
; Call makerand first
;
MakeKeys Proc                     ; Create the keys for loader encryption
  Mov    Ax,TmpLen                ; Put value of tmplen into Ax
  Mov    ChgSize,Ax               ; Store the size/2 into ChgSize
  Call   Random                   ; Make Ax, Cx, & Dx random
  Mov    RolChg,Dl                ; Store the 3key decryptor keys
  Mov    XorChg,Ch                ; Store XorKey 
  Mov    RorChg,Cl                ; Store RorKey
  Ret                             ; Return
MakeKeys EndP                     ; End of the makekey procedure

;----------------
; Encrypt Loader
;----------------
; Input:
;   Cx = Size to encrypt
;   Di = The code to encrypt
; Output:
;   Di = Encrypted code+Size :)
;
; Call makekeys first
;
EncryptLoader Proc                ; Encrypt the loader procedure (called 3 times)
  Push   Bx
  XChg   Cx,Bx                    ; Swap cx and Bx
  Mov    Ch,XorChg                ; Get XorKey 
  Mov    Cl,RorChg                ; Get RorKey
 Lp2:                             ; Encryption loop
  Mov    Al,[Di]                  ; Load a byte from Di
  Xor    Al,4                     ; Xor al the num that will return w/o winice
  Rol    Al,Cl                    ; Rotate Al left Cl bits
  Xor    Al,Ch                    ; Xor Al by Ch
  Push   Cx                       ; Save Cx to the stack
  Mov    Cl,RolChg                ; Get the RolChg value
  Ror    Al,Cl                    ; Rotate Al right Cl bits
  Not    Al                       ; Not the byte in Al
  Pop    Cx                       ; Restore Cx from stack
  StoSb                           ; Store the byte back into Di
  Dec    Bx                       ; Decrement bx
  Cmp    Bx,0                     ; Is bx = 0?
  Jne    Lp2                ; Nope, repeat the encryption loop
  Pop    Bx
  Ret                             ; Return
EncryptLoader EndP                ; End the encrypt loader macro

;------------
; Close file
;------------
; Input:
;   BX = File handle
;
; Output:
;   CF is set on error
;
CloseFile Proc                    ; Close file function
  Mov    Ah,3Eh                   ; DOS function to close file
  Int    21h                      ; Close the file
  Ret                             ; Return
CloseFile EndP                    ; End of close file

;-------------------------
; Random Number Generator
;-------------------------
; Input:
;   Nothing, just make sure MakeRand has been called
;
; Output:
;   AX, DX & CX are all random :), BX is preserved
;
Random Proc                       ; Beginning for random number generator
  Push   Bx                       ; Save the File handle register
  Mov    Ah,2Ch                   ; Dos get Time function
  Int    21h                      ; Get the time
  Xor    Cx,Dx                    ; Xor the Hour/Mins by Secs/Hundrd Secs
  Add    Dx,Cx                    ; Add mins to secs
  XChg   Bx,Dx                    ; Swap Dx into Bx
  Mov    Si,OffSet Bufr           ; Put offset of bufr into si
  Mov    Ah,2Ah                   ; Dos get date function
  Int    21h                      ; Get the date
  LodSw                           ; Load a word from si
  Add    Dx,Ax                    ; Add the value to the months
  Add    Bx,Dx                    ; Add months to secs
  Add    Cx,Bx                    ; Add secs to years
  Xor    Dx,Ax                    ; Xor months by value
  Add    Cx,Dx                    ; Add months to years
  LodSb                           ; Load a byte from si
  XChg   Bx,Dx                    ; Swap Dx back into Bx
  Add    Dx,Cx                    ; Add years to secs
  Add    Cx,Bx                    ; Add modded secs/months to years
  Mov    Ax,Dx                    ; Put value of Dx into Ax
  Mul    Cx                       ; Multiply Ax by Cx
  Pop    Bx                       ; Restore file handle
  Ret                             ; Return
Random EndP                       ; End of the random function

;------------
; File write 
;------------
; Input:
;   DS = Segment of data to write
;   DX = Offset of data to write
;   CX = Number of bytes to write
;   BX = File handle
;
; Output:
;   CF is set on error
;
Write Proc                        ; File write function
  Mov    Ah,40h                   ; DOS function to write to file
  Int    21h                      ; Write the data at DS:DX
  Ret                             ; Return
Write EndP                        ; End the writer function

;-------------------
; Move file pointer
;-------------------
; Input:
;   AL = Mode
;         0 : Move relative to beginning of file
;         1 : Move relative to current pointer position
;         2 : Move relative to end of file
;   BX = File handle
;   CX = Hi value to seek to
;   DX = Lo value to seek to
;
; Output:
;   CF is set on error
;
Seek Proc                         ; File seek procedure
  Mov    Ah,42h                   ; DOS function to move file ptr, al = mode
  Int    21h                      ; Seek it!
  Ret                             ; Return
Seek EndP                         ; The end of the file seek procedure

IFNDEF DEBUG
CreateKeys Proc
  PushA
  Xor    Cx,Cx
 LpZ:
  Push   Cx
  Lea    Bx,OfsTab
  Mov    Ax,Cx
  Shl    Ax,1
  Add    Bx,Ax
  Mov    Di,Cs:[Bx]
  Call   Random
  StoSw
  Add    Key_,Ax
  Pop    Cx
  Inc    Cx
  Cmp    Cx,Debuger
  Jb     LpZ
  PopA
  Ret
  Key_   Dw 0
EndP
ENDIF

IFNDEF DEBUG
Encrypt Proc                      ; Encryptor procedure
  Mov    Al,[Di]                  ; Grab a byte from [Di] and put it in al
  Xor    Al,Bl                    ; Opcode for Xor Al,XX
  StoSb                           ; Store the byte into Di
  Loop   Encrypt                  ; Decode each byte
  Ret                             ; Return
Encrypt EndP                      ; Encryptor endp

EncodeNames Proc                  ; Name encoder procedure
  PushA                           ; Save all registers
  In     Al,40h                   ; Get a random number into al
  Mov    XrKey2,Al                ; The Names decoder/encoding key
  Mov    Bl,Al                    ; Put the number into Bl
  Lea    Di,SIce                  ; The name to decrypt first
  Mov    Cx,8                     ; Device driver names size
  Push   Cx                       ; Save the device driver size
  Call   Encrypt                  ; Decrypt the names
  Pop    Cx                       ; Get the device driver size into Cx
  Lea    Di,SProbe                ; Decrypt SoftProbe handle
  Call   Encrypt                  ; Decrypt next name
  Mov    Cx,6                     ; Size of HBoot command
  Lea    Di,HBoot                 ; Decrypt softice command
  Call   Encrypt                  ; Decrypt the name
  PopA                            ; Restore all registers
  Ret                             ; Return
EncodeNames EndP
ENDIF

WriteSig Proc
  Lea    Si,Loader
  Mov    Cx,(Finish-Begin)
  Call   CreateDmd
  Mov    Ah,40h
  Lea    Dx,Bit_1
  Mov    Cx,4*4
  Int    21h
  Add    LdrLen,Ax

  Lea    Si,Decryptr
  Mov    Cx,(Finish-There)
  Call   CreateDmd
  Mov    Ah,40h
  Lea    Dx,Bit_1
  Mov    Cx,4*4
  Int    21h
  Add    LdrLen,Ax

  Lea    Si,Start
  Mov    Cx,(Buf-Start)
  Call   CreateDmd
  Mov    Ah,40h
  Lea    Dx,Bit_1
  Mov    Cx,4*4
  Int    21h
  Add    LdrLen,Ax

  Mov    Ah,40h
  Lea    Dx,Sig
  Mov    Cx,(SigF-SigB)
  Int    21h
  Add    LdrLen,Ax
  Ret
EndP

;-----------------
; Display Decimal
;-----------------
; Input:
;   DX = Hi number value
;   AX = Lo number value
;
DispDec Proc                      ; Beginning of Display decimal
  PushA                           ; Save all general registers
  Mov    Ah,9                     ; DOS print string function
  Mov    Dx,OffSet LdSize         ; Message to print
  Int    21h                      ; Print the string
  PopA                            ; Restore all general registers
  Mov    Di,OffSet Bufr+4         ; Load offset of buffer into Di
  Mov    Bx,0Ah                   ; Put 10 into Bx
  Mov    Cx,4                     ; Number of loops to make
 DnLp:                            ; The decoding loop :)
  Div    Bx                       ; Divide ax by Bx, Ax = quotient, Dx = rem.
  Add    Dx,30h                   ; Add 30h to Dx
  Dec    Di                       ; Decrement Di
  Mov    [Di],Dl                  ; Store Dl into [Di]
  Cmp    Ax,0                     ; Are we  at the end of the buffer?
  Je     ExitD              ; Yes, exit the display decimal
  Xor    Dx,Dx                    ; Zero dx register
  Loop   DnLp                     ; Repeat for each byte
 ExitD:                           ; Exit display decimal label
  XChg   Dx,Di                    ; Swap dx and di
  Jmp    KillCode                 ; Print The message
DispDec EndP                      ; The end of the display decimal

RegRandom Proc                    ; Random reg creator proc (AX = RegNum <= 3)
  PushA                           ; Save all registers
  Call   Random                   ; Get a random number
  Mov    StoNum,Cx                ; Store the random number
  PopA                            ; Restore all the registers
   Db    0B8h                     ; Opcode for a "MOV AX,????"
  StoNum Dw 0                     ; The random number storage place
  And    Ax,3                     ; Make sure its below or equal to 3
  Ret                             ; Return
RegRandom EndP                    ; Random reg producer endpoint

;  INPUT:
;   SI = inbuffer
;   CX = Size
; OUTPUT:
;   BIT_1..4 will be filled with the 4 32bit keys
;
CreateDmd Proc
  PushAd
  Xor    EBx,EBx
  Mov    DmdLen,Cx         ; Save buffer size
  Mov    DmdBuf,Si         ; Save buffer offset
 DmLp1:
  Xor    EAx,EAx
  LodSb
  Shl    Al,Cl
  Mul    Cl
  Add    Al,Al
  Add    EBx,EAx
  Mul    Al
  Add    Al,Cl
  Shr    Al,4
  Xor    Al,Cl
  Add    EBx,EAx
  Add    Al,Bl
  Loop   DmLp1
  Mov    Bit_1,EBx
  Xor    ECx,ECx
  Add    EBx,EBx
  Mov    Si,DmdBuf
  Mov    Cx,DmdLen
 DmLp2:
  Xor    EAx,EAx
  LodSb
  Xor    EBx,EAx
  Add    EBx,ECx
  Shl    Al,Cl
  Mul    Cl
  Xor    Al,Cl
  Add    EBx,EAx
  Mov    EAx,EBx
  Mul    EAx
  Add    EBx,EAx
  Add    EBx,EDx
  Shl    EBx,2
  Add    Al,Bl
  Xor    Al,Cl
  Mul    Al
  Add    EBx,EAx
  Add    EBx,ECx
  Shr    Al,Cl
  Add    EAx,EBx
  Add    EBx,EAx
  Loop   DmLp2
  Mov    Bit_2,EBx
  Add    EBx,Bit_1
  Mov    Si,DmdBuf
  Mov    Cx,DmdLen
 DmLp3:
  Xor    EAx,EAx
  LodSb
  Shl    Al,Cl
  Add    Al,Bl
  Xor    Al,Cl
  Shr    Al,4
  Add    EBx,ECx
  Add    EBx,EAx
  Loop   DmLp3
  Mov    Bit_3,EBx
  Add    EBx,Bit_1
  Add    EBx,Bit_2
  Mov    Si,DmdBuf
  Mov    Cx,DmdLen
 Lp4:
  Xor    EAx,EAx
  LodSb
  Xor    Al,4
  Add    Al,Cl
  Add    Al,Bl
  Shr    Al,Cl
  Add    Al,16 
  Shl    Al,Cl
  Add    EBx,EAx
  Shr    Al,4
  Add    EBx,EAx
  Add    EBx,ECx
  Loop   Lp4
  Mov    Bit_4,EBx
  PopAd
  Ret

  Bit_1  Dd 00000000
  Bit_2  Dd 00000000
  Bit_3  Dd 00000000
  Bit_4  Dd 00000000
  DmdLen Dw 0
  DmdBuf Dw 0
EndP
; Output:
;   Carry if error
;   Bx = File handle of the open file

CheckRegFile Proc
  Push   Ds
  Mov    Ds,Ds:[2Ch]
  Xor    Si,Si
 xxLp1:
  Inc    Si
  Cmp    Word Ptr Ds:[Si],0
  Jnz    xxLp1
  Add    Si,4
  Lea    Di,OutBuf
 xxSc1:
  LodSb
  StoSb
  Or     Al,Al
  Jnz    xxSc1
  Pop    Ds
 xxSc2:
  Dec    Di
  Cmp    Byte Ptr Ds:[Di],'.'
  Jnz    xxSc2
  Lea    Si,KeyStr
  Inc    Di
  MovSw
  MovSb
  Xor    Al,Al
  StoSb
  Mov    Ax,3D00h
  Lea    Dx,OutBuf
  Int    21h
  Jc     XXX1
  XChg   Ax,Bx
 XXX1:
  Ret
EndP

CheckReg Proc
  Push   Bx            ; Save the main file handle
  Mov    Ax,3D00h
  Lea    Dx,RegKey
  Int    21h
  Jc     Try_3
  XChg   Ax,Bx
 OpenF:
  Mov    Ah,3Fh
  Lea    Dx,Buf
  Mov    Cx,0FFFFh
  Int    21h
  Mov    Cx,Ax         ; Get the filesize into CX
  Sub    Cx,6          ; Subtract header values
  Mov    Ah,3Eh
  Int    21h
  Lea    Si,Buf
  Mov    Di,Si
  LodSw
  Mov    CrSize,Ax
  LodSw
  Mov    Crc,Ax
  LodSw
  Mov    UnCrc,Ax
  Push   Si
  Call   XorSum
  Cmp    Bx,Crc
  Je     CrcOk
  lea    dx,ErrMsg
  call   print
  pop    si bx
  ret
 CrcOk:
  Mov    Cx,CrSize
  Pop    Si
  Mov    Di,Si
 RpLp:
  LodSb               ; Decryption key for the byte
  Mov    Bl,Al
  LodSb               ; Load the byte to decrypt
  neg    al
  Sub    Al,Bl
  XChg   Bl,Cl
  Rol    Al,Cl
  XChg   Bl,Cl
  Sub    Al,Bl
  Xor    Al,Bl
  not    al
  StoSb
  Loop   RpLp

  LEA    SI,BUF+6
  MOV    CX,CRSIZE
  CALL   XORSUM
  CMP    BX,UNCRC
  JZ     CRC2OK
  LEA    DX,ERRMSG
  CALL   PRINT
  pop    bx
  RET
 CRC2OK:
  Mov    Ah,9
  Lea    Dx,RegMsg
  Int    21h
  Pop    Bx
  Mov    Dx,LdrLen   ; Input param to Reg routine
  Call   Buf+6
  Mov    LdrLen,Dx   ; Output from reg routine
 Exit_2:
  Ret
 Try_3:
  Call   CheckRegFile
  Jnc    OpenF
  Pop    Bx
  Jmp    Exit_2

XorSum Proc
  Cld
  Xor    Bx,Bx
  Mov    Dx,0ABCDh
 XrLp:
  LodSb
  Rol    Bx,1
  Xor    Bx,Dx
  Xor    Bl,Al
  Loop   XrLp
  Ret
EndP

  RegMsg Db '  Registered to        : $'
  ErrMsg Db 'KeyFile has invalid CRC! Continuing unregistered...',7,7,7,'$'
 NameB   Equ $
  RegKey Db 'DS-CRP.REG',0
 NameF   Equ $
 KeyStr  Equ $-4
  CrSize Dw 0
  Crc    Dw 0
  UnCrc  Dw 0
EndP

 JmpB1 Equ $
  Mov    Ax,0000h                 ; 3 bytes, offset to "Return" to :)
  Push   Ax                       ; 1 Bytes push the value to go to onto stack
  RetN                            ; 1 byte, Return to value on stack
 JmpE1 Equ $

 JmpB2 Equ $
  Mov    Ax,0000h                 ; 3 bytes, offset to jump to
  Jmp    Ax                       ; 2 bytes, Jump to value in Ax
 JmpE2 Equ $

SigB Equ $
  Sig    Db 'DS',HiVer,LoVer,'MsDos'
SigF Equ $
  Intro  Db 13,10
         Db 'DS-CRP v',Ver,' c0ded bY Dark Stalker / UCF',13,10,'$'
  LdSize Db 'Loader size: $'

 KillCode:
  Mov    Cx,(KillCode-Start)/2    ; Number of bytes to erase
  Mov    Di,100h                  ; Where to start at
  Mov    Ax,'SD'                  ; My signature :)
  Rep    StoSw                    ; Erase all of the code with 'DS' :)
  call   print
  mov    ax,4c00h
  int    21h
 Print:                           ; Print procedure
  Mov    Ah,9                     ; DOS print string function
  Int    21h                      ; Print the string
  Mov    Al,13d                   ; Control return char
  Int    29h                      ; Display char in Al (undoc)
  Mov    Al,10d                   ; Linefeed character
  Int    29h                      ; Display char in AL (undoc)
  ret
