;
;
;   HackStop Unpacker v1.14 - (C)Copyright 1997 by Stefan Esser
;
;

; History
; ~~~~~~~
;   v1.13 - v1.14    Ralph's Entrypoint-CRC does no longer work...
;   v1.12 - v1.13    Stonehead passed me an old version, that did not work
;   v1.11 - v1.12    Hehe, Ralph changed HS again... v1.18 seems to be added.
;   v1.10 - v1.11    HS v1.1763 added! 
;   v1.01 - v1.10    HS v1.175 is bugfixed! The unpacking routine does
;                    not work anymore... Wrote a new routine!
;   v1.00 - v1.01    HS v1.14-v1.16 signature is also valid for
;                    the early betas of HS v1.17. Fixed that!

;
; NOTE   after compilation you have to adjust the max value in
; NOTE   the MZ exe header...
;


.286
.model small
.code
.386

db 13,10,13,10
db "| | .-- ,-, |     --+-- | | .--    |   | ,-, ,-, |   |\ ",13,10
db "| | |   | | |       |   | | |      | . | | | | | |   | |",13,10
db "|-| |-- |-| |       |   |-| |--    | | | | | |/  |   | |",13,10
db "| | |   | | |       |   | | |      | | | | | |\  |   | |",13,10
db "| | `-- | | `--     |   | | `--     ~ ~  `-' | \ `-- |/ ",13,10
db 13,10,13,10

;-----------------------------------------------------------------------------
; MACRO: saveregs - saves register in code-segment variables
;-----------------------------------------------------------------------------

saveregs macro
      PUSHF
      MOV       CS:[_oldAX_], AX
      MOV       CS:[_oldBX_], BX
      MOV       CS:[_oldCX_], CX
      MOV       CS:[_oldDX_], DX
      MOV       CS:[_oldDI_], DI
      MOV       CS:[_oldSI_], SI
      MOV       CS:[_oldBP_], BP
      MOV       CS:[_oldSP_], SP
      MOV       CS:[_oldDS_], DS
      MOV       CS:[_oldES_], ES
      MOV       CS:[_oldSS_], SS
      ADD       SP, 2
      POP       AX
      POP       BX
      MOV       CS:[_oldIP_], AX
      MOV       CS:[_oldCS_], BX
      PUSH      BX
      PUSH      AX
      SUB       SP, 2
      MOV       AX, CS:[_oldAX_]
      MOV       BX, CS:[_oldBX_]
endm

;-----------------------------------------------------------------------------
; MACRO: restoreregs - restores registers from code-segment variables
;-----------------------------------------------------------------------------

restoreregs macro
      MOV       AX, CS:[_oldAX_]
      MOV       BX, CS:[_oldBX_]
      MOV       CX, CS:[_oldCX_]
      MOV       DX, CS:[_oldDX_]
      MOV       SI, CS:[_oldSI_]
      MOV       DI, CS:[_oldDI_]
      MOV       SP, CS:[_oldSP_]
      MOV       BP, CS:[_oldBP_]
      MOV       DS, CS:[_oldDS_]
      MOV       ES, CS:[_oldES_]
      MOV       SS, CS:[_oldSS_]
      POPF
endm

;-----------------------------------------------------------------------------
; PROCEDURE: procedure PRINT HEX NUM
;-----------------------------------------------------------------------------

hexstring db "0123456789ABCDEF"

print_hex_num proc
      PUSH      BX
      MOV       BX, AX
      XOR       BH, BH
      PUSH      BX
      MOV       AH, 0Eh
      SHR       BL, 4
      MOV       AL, CS:[hexstring+BX]
      XOR       BX, BX
      INT       10h
      POP       BX
      AND       BL, 15
      MOV       AL, CS:[hexstring+BX]
      XOR       BX, BX
      INT       10h
      MOV       AX, 0E20h
      INT       10h
      POP       BX
      RET
endp

;-----------------------------------------------------------------------------
; PROCEDURE: procedure PRINT STRING
;-----------------------------------------------------------------------------

print_string proc
      XOR       BX, BX
startofprint:
      DB        2Eh  ; <-- CS prefix
      LODSB
      OR        AL, AL
      JZ        endofprint
      MOV       AH, 14
      INT       10h
      JMP       startofprint
endofprint:
      RET
endp

;-----------------------------------------------------------------------------
; PROCEDURE: procedure SAVE EXE
;-----------------------------------------------------------------------------

save_exe proc
      MOV       SI, offset msg10
      CALL      print_string

      ; <-- write CS,IP

      MOV       EAX, 14h
      CALL      fileseekb

      MOV       AH, 40h
      MOV       BX, CS:[_filehandle_]
      PUSH      CS
      POP       DS
      MOV       DX, offset _origIP_
      MOV       CX, 4
      INT       21h
      JC        failed1

      ; <-- write SS,SP

      MOV       EAX, 0eh
      CALL      fileseekb

      MOV       AH, 40h
      MOV       BX, CS:[_filehandle_]
      PUSH      CS
      POP       DS
      MOV       DX, offset _origSS_
      MOV       CX, 4
      INT       21h
      JC        failed1

      ; <-- write SIZE

      MOV       EAX, 2
      CALL      fileseekb

      MOV       EAX, CS:[origsize]
      MOV       BX, AX
      SHR       EAX, 9
      AND       BX, 1ffh
      MOV       CS:[rest], BX
      OR        BX, BX
      JZ        donotinc
      INC       EAX
donotinc:
      MOV       CS:[pages], AX
      

      MOV       AH, 40h
      MOV       BX, CS:[_filehandle_]
      PUSH      CS
      POP       DS
      MOV       DX, offset rest
      MOV       CX, 4
      INT       21h
      JC        failed1

      MOV       EAX, CS:[origsize]
      CALL      fileseekb

      MOV       AH, 40h
      MOV       BX, CS:[_filehandle_]
      MOV       CX, 0
      INT       21h
      JC        failed1
      JMP       ok1
endp

msg1    DB        "HackStop Remover V1.14                                               14 Dec 1997"
        DB        "Copyright (c) 1997 by Stefan Esser                           All Rights Reserved"
        DB        "Copy registered to: PUBLIC!",13,10,0
strich  DB        "",0
msgu    DB  13,10,"Usage: HSREMOVE FileName.ext",13,10,0
msg2    DB        "   Opening File.                     ",0
msg3    DB        "   Retrieving File Date&Time.        ",0
msg4    DB        "   Checking for .EXE Format.         ",0
msg5    DB        "   Checking for HS generic id.       ",0
msg6    DB        "   Detecting HS version.             ",0
msg7p1  DB        "     => [",0
msg7p2  DB                  "/2] Signatures Found.      ",0
msgmod  DB        "   Maybe modified. Continue? (y/n).",0
msg8    DB        "   Reading Hackstop loader.          ",0
msg9    DB        "   Retrieving encrypted information. ",0
msg10   DB        "   Writing deprotected file.         ",0
msg11a  DB        "   Restoring File Date&Time.         ",0
msg11   DB        "   Closing File.                     ",0
msgGTab DW        offset msgG0
        DW        offset msgG1
        DW        offset msgG2
msgG0   DB        "BAD",13,10,0
msgG2   DB        "VERY "
msgG1   DB        "GOOD",13,10,0
msgOK   DB        "OK",13,10,0
msgOK1  DB        "OK, reports v",0
msgFAIL DB        "FAILED",13,10,0
msgFAIL2 DB    13,"   ERROR: unexpected error!          ",13,10,0
msgID   DB        "   ID= ",0
msgRET  DB        13,10,0

; HS nametable
hstable:
        dw offset sig093s, offset sig093
        dw offset sig100s, offset sig100
        dw offset sig110s, offset sig110
        dw offset sig111s, offset sig111
        dw offset sig111iss, offset sig111is
        dw offset sig112s, offset sig112
        dw offset sig113s, offset sig113
        dw offset sig114s, offset sig114
        dw offset sig117s, offset sig117
        dw offset sig1176s, offset sig1176
        dw offset sig118s, offset sig118
        dw offset sig118s2, offset sig1182
        dw 0

; HS names
sig093s db        "OK, v0.9?",0
sig093  db        0B4h,30h,0cdh,21h,86h,0e0h,3dh,0h,3,73h,2h,0cdh,020h,050h,0b8h, 0ebh

sig100s db        "OK, v1.0?",0
sig100  db        0B4h,30h,0cdh,21h,86h,0e0h,3dh,0h,3,73h,6h,0b0h,0ffh,0b4h,4ch, 0cdh

sig110s DB        "OK, v1.10",0
sig110  DB        0B4h,30h,0cdh,21h,86h,0e0h,3dh,0h,3,73h,12h,0b4h,02fh,0cdh,21h,0b4h

sig111s DB        "OK, v1.11",0
sig111  DB        0B4h,30h,0cdh,21h,86h,0e0h,3dh,0h,3,73h,0ah,0b4h,02fh,0cdh,21h,0b0h

sig111iss DB      "OK, v1.11is",0
sig111is  DB      52h,1eh,0b4h,30h,0cdh,21h,86h,0e0h,3dh,0ffh,2,73h,2,0cdh,20h,0eh

sig112s DB        "OK, v1.12",0
sig112  DB        0B8h,0,30h,52h,1eh,0cdh,21h,86h,0e0h,3dh,0feh,2,73h,2,0cdh,20h

sig113s DB        "OK, v1.12hs - v1.13",0
sig113  DB        52h,0b8h,0,30h,1eh,0cdh,21h,86h,0e0h,3dh,0ffh,2,73h,2,0cdh,20h

sig114s DB        "OK, v1.14 - v1.17",0
sig114  DB        52h,0b8h,2,30h,1eh,0cdh,21h,86h,0e0h,3dh,0feh,2,73h,2,0cdh,20h

sig117s DB        "OK, v1.173",0
sig117  DB        3ah,0dbh,74h,7,0b8h,1,4ch,0cdh,21h,0ebh,1eh,0b4h,30h,0cdh,21h,0fah

sig1176s DB       "OK, v1.1763",0
sig1176  DB       1eh,0b4h,30h,0cdh,21h,03ch,002h,073h,005h,033h,0c0h,006h,050h,0cbh,0bfh,066h

sig118s  DB       "OK, v1.18",0
sig118   DB       1eh,52h,0b8h,4dh,30h,0cdh,21h,86h,0c4h,3dh,0feh,2,73h,2,0cdh,20h

sig118s2 DB       "OK, v1.18 Build 66-69",0
sig1182  DB       52h,0bah,0ebh,04h,05ah,0ebh,0fbh,09ah
         DB       1eh,52h,0b8h,42h,30h,0cdh,21h,86h
                 

sigf    DB        " signature found",13,10,0

interrupt14h proc
      saveregs
      mov       ax, cs:[_oldSS_]
      mov       cs:[_origSS_], ax
      mov       ah, 62h
      int       21h
      sub       cs:[_origSS_], bx
      sub       word ptr cs:[_origSS_], 10h
      
      mov       ax, cs:[_oldSP_]
      mov       cs:[_origSP_], ax
      add       word ptr cs:[_origSP_], 8
      mov       ax, cs:[stackadjust]
      add       word ptr cs:[_origSP_], ax
      mov       bp, sp
      mov       es, [bp+4]
      mov       di, [bp+2]
      mov       word ptr es:[di], 4cb4h
      mov       word ptr es:[di+2], 21cdh
      restoreregs
      iret
endp


;-----------------------------------------------------------------------------
; INTERRUPT: interrupt21h - new interrupt 21h
;-----------------------------------------------------------------------------

interrupt21h proc
      saveregs
      CMP       byte ptr CS:[done], 0
      JNE       endh
      MOV       AX, CS:[_oldCS_]  ; Still in HS code
      OR        AX, AX
      JE        endh
      CMP       AX, CS:[validCS]
      JE        endh              ; <-- then exit handler
      ;
      ;۲ search for decrypted values 
      ;
      MOV       byte ptr CS:[done], 1  ; <-- nur einmal!!!
      
      MOV       ES, CS:[validCS]
MOV  DI, 30
   ;   XOR       DI, DI
      MOV       CX, CS:[hstopsize]
search_loop0:
      MOV       AL, 0eah          ; <-- search for "call near" opcode
      REPNE     SCASB
      JNE       not_found      ; if nothing found then leave
      CMP       byte ptr ES:[DI-2], 0eah
      JZ        search_loop0
      
      CMP       byte ptr ES:[DI-4], 0e9h
      MOV       BX, -1
      JNZ       maches
      MOV       BX, -4
maches:
suber:      
      SUB       BX, 2
      CMP       BX, -21
      JE        oldfrage2
      CMP       byte ptr ES:[DI+BX], 02bh    ; IS SUB?
      JE        suber
      CMP       byte ptr ES:[DI+BX], 033h    ; IS XOR?
      JE        suber
      CMP       word ptr ES:[DI+BX], 0fae2h  ; IS LOOP?
      JE        nuke
      CMP       word ptr ES:[DI+BX], 0f9e2h
      JNE       oldfrage2
nuke:      
      JMP       storevalues0
oldfrage2:

oldfrage4:
      CMP       word ptr ES:[DI+4], 'OR'
      JNE       oldfrage 
      CMP       word ptr ES:[DI+6], 'ES'
      JE        storevalues0
   
oldfrage:
      MOV       AX, es:[DI]
      CMP       ES:[DI+6], AX
      JNE       search_loop0
      MOV       AH, 62h
      PUSHF
      CALL      dword ptr CS:[_oldoff_]
      MOV       AX, ES:[DI+4]
      ADD       AX, 10h
      ADD       AX, BX
      CMP       ES:[DI+2], AX
      JE        storevalues0
      JMP       search_loop0
storevalues0:
      MOV       byte ptr CS:[found], 1  ; <-- nur einmal!!!
      MOV       byte ptr CS:[newrout], 1  ; <-- new routine used
                                          ;     need second pass !!!

      CMP       byte ptr ES:[DI-4], 0e9h
      JNZ       nixzumachen
      ADD       DI, ES:[DI-3]
nixzumachen:
      MOV       AX, ES:[DI]     ; <-- get original IP
      MOV       CS:[_origIP_], AX ; <-- store
      MOV       AX, ES:[DI+2]     ; <-- get original CS
      MOV       CS:[_origCS_], AX ; <-- store
      
      MOV       AH, 62h
      PUSHF
      CALL      dword ptr CS:[_oldoff_]
      SUB       CS:[_origCS_], BX
      SUB       word ptr CS:[_origCS_], 10h
      JMP       not_found
      
      
not_found:
      MOV       word ptr CS:[_oldAX_], 4C00h
endh: restoreregs

      ;
      ;۲ jmp back to the old handler 
      ;
         db        234   ; <-- opcode for "jmp far"
_oldoff_ dw        0     ; <-- offset of the old handler
_oldseg_ dw        0     ; <-- segment of the old handler
endp

;-----------------------------------------------------------------------------
; REGISTER VARIABLES
;-----------------------------------------------------------------------------

_oldAX_    dw  0
_oldBX_    dw  0
_oldCX_    dw  0
_oldDX_    dw  0
_oldSI_    dw  0
_oldDI_    dw  0
_oldSP_    dw  0
_oldBP_    dw  0
_oldIP_    dw  0
_oldCS_    dw  0
_oldDS_    dw  0
_oldES_    dw  0
_oldSS_    dw  0

;-----------------------------------------------------------------------------
; VARIABLES
;-----------------------------------------------------------------------------

_origIP_   dw  0    ; <-- *** DO NOT CHANGE ORDER ***
_origCS_   dw  0
_origSS_   dw  0
_origSP_   dw  0

eh_id      dw  0    ; <-- EXE Header
eh_rest    dw  0
eh_pages   dw  0
eh_reloc   dw  0
eh_hsize   dw  0
eh_min     dw  0
eh_max     dw  0
eh_ss      dw  0
eh_sp      dw  0
eh_csum    dw  0
eh_ip      dw  0
eh_cs      dw  0

hsid       dw  0    ; <-- HS - Signature
hsverhi    db  0
hsverlo    db  0
hsvdef     db  'MsDos'

hsheader   db  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
           db  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
           db  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
           db  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

rest       dw  0
pages      dw  0
sfsize     dd  0  ; <-- stored filesize
rfsize     dd  0  ; <-- real filesize
fileip     dw  0
filecs     dw  0

FCB1       db  0,32,32,32,32,32,32,32,32, 32,32,32, 0,0,0,0
FCB2       db  0,32,32,32,32,32,32,32,32, 32,32,32, 0,0,0,0
CTAIL      db  1,32,0d

paraENV    dw  0
paraCT     dw  offset CTAIL
           dw  0
paraFCB1   dw  offset FCB1
           dw  0
paraFCB2   dw  offset FCB2
           dw  0
paraSP     dw  0
paraSS     dw  0
paraIP     dw  0
paraCS     dw  0

origsize   dd  0  ; <-- filesize before hackstoped (for <HS17)

stackadjust dw 0

_filehandle_  dw  0
hstopsize     dw  0
filenameoffset dw 0
startupseg dw 0
filedate dw 0
filetime dw 0
validcs  dw 0
done     db 0
found    db 0
newrout  db 0
ownSP    dw 0
ownSS    dw 0

getparameter proc
      MOV       SI, 81h
      MOV       DS, CS:[startupseg]
      MOV       CS:[filenameoffset],0
gploop1:      
      LODSB
      CMP       AL, 0
      JZ        exitgp
      CMP       AL, 32
      JZ        gploop1
      CMP       AL, 13
      JZ        exitgp
      DEC       SI
      MOV       CS:[filenameoffset],SI
gploop2:
      LODSB
      CMP       AL, 0
      JZ        exitgp
      CMP       AL, 32
      JZ        exitloop2
      CMP       AL, 13
      JZ        exitloop2
      JMP       gploop2
exitloop2:
      MOV       byte ptr DS:[SI-1],0
exitgp:
      RET
endp

background proc
      MOV       CS:[startupseg], DS
      MOV       SI, offset strich
      CALL      print_string
      MOV       SI, offset msg1
      CALL      print_string
      CALL      getparameter
      CMP       CS:[filenameoffset],0
      JNZ       continue
      MOV       SI, offset msgu
      CALL      print_string
      MOV       SI, offset strich
      CALL      print_string
      MOV       AX, 4C00h
      INT       21h
continue:
      MOV       SI, offset strich
      CALL      print_string
      RET
endp

failed1 proc
      MOV       SI, offset msgFAIL
      CALL      print_string
      STC
      RET
endp

failed2 proc
      MOV       SI, offset msgFAIL2
      CALL      print_string
      MOV       AX, 4C00h
      INT       21h
      RET
endp

ok1 proc
      MOV       SI, offset msgOK
      CALL      print_string
      CLC
      RET
endp

closefile proc
      MOV       SI, offset msg11
      CALL      print_string
      MOV       AH, 3Eh
      MOV       BX, CS:[_filehandle_]
      INT       21h
      JC        failed1
      JMP       ok1
endp

savedt proc
      MOV       SI, offset msg3
      CALL      print_string
      MOV       AX, 5700h
      MOV       BX, CS:[_filehandle_]
      JC        failed1
      MOV       CS:[filedate], DX
      MOV       CS:[filetime], CX
      JMP       ok1
endp

restoredt proc
      MOV       SI, offset msg11a
      CALL      print_string
      MOV       AX, 5701h
      MOV       BX, CS:[_filehandle_]
      MOV       DX, CS:[filedate]
      MOV       CX, CS:[filetime]
      JC        failed1
      JMP       ok1
endp

checkexe proc
      MOV       SI, offset msg4
      CALL      print_string
      MOV       AH, 3Fh
      MOV       CX, 18h
      MOV       BX, CS:[_filehandle_]
      MOV       DX, offset eh_id
      PUSH      CS
      POP       DS
      INT       21h
      JC        failed1
      CMP       AX, 18h
      JNE       failed1
      CMP       CS:[eh_id], 'MZ'
      JE        check1
      CMP       CS:[eh_id], 'ZM'
      JE        check1
      JMP       failed1

check1:
      ; <-- from here on get stored filesize
      MOVZX     EAX, CS:[eh_pages]
      CMP       CS:[eh_rest],0
      JE        last_page_is_filled_up
      DEC       EAX
last_page_is_filled_up:
      SHL       EAX, 9
      MOVZX     EBX, CS:[eh_rest]
      ADD       EAX, EBX            ; <-- calculate stored filesize
      MOV       CS:[sfsize], EAX
      ; <-- from here on get actual filesize
      MOV       AX, 4202h
      XOR       CX, CX
      XOR       DX, DX
      MOV       BX, CS:[_filehandle_]
      INT       21h
      JC        failed1 ; <-- positioning error
      ROL       EAX, 16
      MOV       AX, DX
      ROL       EAX, 16
      MOV       CS:[rfsize], EAX
      CMP       EAX, CS:[sfsize]
      JB        failed1 ; <-- real filesize<store filesize then error in .EXE
      MOVSX     EAX, CS:[eh_cs]
      SAL       EAX, 4
      MOVZX     EBX, CS:[eh_ip]
      ADD       EAX, EBX  ; <-- relative entrypoint to image start
      MOVZX     EBX, CS:[eh_hsize]
      SHL       EBX, 4
      ADD       EAX, EBX  ; <-- relative entrypoint to filestart
      CMP       EAX, CS:[sfsize]
      JA        failed1
      MOV       CS:[origsize], EAX ; <-- ATTENTION: not for HS17
      
      JMP       ok1
endp

idcheck proc
      MOV       SI, offset msg5
      CALL      print_string
      MOV       EAX, CS:[sfsize]
      SUB       EAX, 9
      MOV       DX, AX
      ROL       EAX, 16
      MOV       CX, AX
      MOV       BX, CS:[_filehandle_]
      MOV       AX, 4200h
      INT       21h
      JC        failed1

      MOV       AH, 3Fh
      MOV       CX, 9
      MOV       BX, CS:[_filehandle_]
      MOV       DX, offset hsID
      PUSH      CS
      POP       DS
      INT       21h
      JC        failed1
      CMP       AX, 9
      JNE       failed1

      CMP       word ptr CS:[hsVDef], 'sM'
      JNE       failed1
      CMP       word ptr CS:[hsVDef+2], 'oD'
      JNE       failed1
      CMP       byte ptr CS:[hsVDef+4], 's'
      JNE       failed1
      INC       CS:[numids]
      CMP       CS:[hsID], 'SH'
      JNE       ok1
      
      MOV       SI, offset msgok1
      CALL      print_string

      XOR       BX, BX
      MOV       AL, CS:[hsverhi]
      XOR       AH, AH
      MOV       BL, 10
      DIV       BL
      MOV       AH, 14
      OR        AL, AL
      JZ        keine0
      ADD       AL, '0'
      INT       10h
keine0:      
      MOV       AL, CS:[hsverhi]
      MOV       BL, 10
      XOR       AH, AH
      DIV       BL
      ROL       AX, 8
      MOV       AH, 14
      ADD       AL, '0'
      INT       10h
      
      MOV       AX, 0e2eh
      INT       10h
      MOV       AL, CS:[hsverlo]
      MOV       BL, 10
      XOR       AH, AH
      DIV       BL
      MOV       AH, 14
      ADD       AL, '0'
      INT       10h

      MOV       AL, CS:[hsverlo]
      MOV       BL, 10
      XOR       AH, AH
      DIV       BL
      ROL       AX, 8
      MOV       AH, 14
      ADD       AL, '0'
      INT       10h
      
      MOV       AX, 0e0dh
      INT       10h
      MOV       AX, 0e0ah
      INT       10h

      RET
      numids    db  0
endp

readheader proc
      MOV       AH, 3Fh
      MOV       CX, 16*4
      MOV       BX, CS:[_filehandle_]
      MOV       DX, offset hsheader
      PUSH      CS
      POP       DS
      INT       21h
      JC        failed2
      CMP       AX, 16*4
      JNE       failed2
      RET
endp

fileseek proc
      MOV       DX, AX
      ROL       EAX, 16
      MOV       CX, AX
      MOV       BX, CS:[_filehandle_]
      MOV       AX, 4200h
      INT       21h
      JC        failed2
      RET
endp

fileseekb proc
      MOV       DX, AX
      ROL       EAX, 16
      MOV       CX, AX
      MOV       BX, CS:[_filehandle_]
      MOV       AX, 4200h
      INT       21h
      JC        failed1
      RET
endp

detecthsversion proc
      MOV       SI, offset msg6
      CALL      print_string
      MOV       EAX, CS:[origsize]
      CALL      fileseek
      CALL      readheader

      MOV       SI, offset hsheader
      CMP       BYTE PTR CS:[SI], 0e8h
      JNZ       fourthcont
      MOVSX     EBX, word ptr CS:[SI+1]
      MOV       EAX, CS:[origsize]
      ADD       EAX, 3
      ADD       EAX, EBX
      MOV       CS:[origsize], EAX
      CALL      fileseek
      CALL      readheader
fourthcont:

      MOV       BX, offset hstable
      SUB       BX, 4
      ; old signature
oki:
      ADD       BX, 4
      MOV       SI, offset hsheader
      MOV       DI, CS:[BX+2]
      OR        DI, DI
      JZ        failed1
      PUSH      CS
      POP       ES
      MOV       CX, 16
      REP       CMPSB
      JNE       oki
      
      CMP       word ptr CS:[BX], offset sig118s
      JB        newestHS
      
      PUSH      BX
      MOVSX     EBX, CS:[eh_ip]
      MOV       EAX, CS:[origsize]
      SUB       EAX, EBX
      MOV       CS:[origsize], EAX
      CALL      fileseek
      CALL      readheader
      POP       BX
      MOV       SI, 56
searchanfang:      
      DEC       SI
      JS        oki
      CMP       word ptr CS:[SI+hsheader], 0b41eh
      JNE       searchanfang
      CMP       word ptr CS:[SI+4+hsheader], 03c21h
      JNE       searchanfang

      XOR       EAX, EAX
      MOV       AX, SI
      ADD       CS:[origsize], eax

newestHS:
      MOV       SI, CS:[BX]
      CALL      print_string
      MOV       SI, offset sigf
      CALL      print_string

      

      
      INC       CS:[numids]
      RET
endp

openfile proc
      MOV       SI, offset msg2
      CALL      print_string
      MOV       AX, 3D02h
      MOV       DS, CS:[startupseg]
      MOV       DX, CS:[filenameoffset]
      INT       21h
      JNC       openfile1
      JMP       failed1
openfile1:
      MOV       CS:[_filehandle_], AX
      JMP       ok1
endp

siganalysing proc
      MOV       SI, offset msg7p1
      CALL      print_string
      XOR       BH, BH
      MOV       BL, CS:[numids]
      MOV       AL, CS:[hexstring+BX]
      MOV       AH, 14
      INT       10h
      MOV       SI, offset msg7p2
      CALL      print_string
      XOR       BH, BH
      MOV       BL, CS:[numids]
      SHL       BX, 1
      MOV       SI, CS:[msgGTab+BX]
      CALL      print_string
      CMP       CS:[numids], 0
      JNE       do_not_ask
      MOV       SI, offset MSGmod
      CALL      print_string
getkey:      
      XOR       AX, AX
      INT       16h
      CMP       AL, 'y'
      JE        keyyes
      CMP       AL, 'Y'
      JE        keyyes
      CMP       AL, 'n'
      JE        keyno       
      CMP       AL, 'N'
      JE        keyno
      JMP       getkey
keyyes:
      MOV       AX, 0e0dh
      INT       10h
      CLC
      RET
keyno:
      MOV       AX, 0e0dh
      INT       10h
      STC
      RET
do_not_ask:
      CLC
      RET
endp

readhsloader proc
      MOV       SI, offset msg8
      CALL      print_string
      
      MOV       EAX, CS:[sfsize]
      MOVSX     ECX, CS:[eh_cs]
      SAL       ECX, 4
      MOVZX     EBX, CS:[eh_hsize]
      SHL       EBX, 4
      ADD       ECX, EBX
      SUB       EAX, ECX
      MOV       CS:[hstopsize], AX
      ADD       EAX, 16
      SHR       EAX, 4
      PUSH      AX
      PUSH      AX
      MOV       BX, 0ffffh
      MOV       AH, 48h
      INT       21h
      POP       AX
      SUB       BX, AX
      SUB       BX, 1005h
      MOV       AH, 48h
      INT       21h
      JC        failed1
      POP       BX
      PUSH      AX
      MOV       AH, 48h
      MOV       BX, 1000h
      INT       21h
      JC        failed1

      MOV       CS:[validcs], AX
      POP       ES
      MOV       AH, 49h
      INT       21h
      JC        failed1

      MOV       word ptr CS:[paraCT+2], CS
      MOV       word ptr CS:[paraFCB1+2], CS
      MOV       word ptr CS:[paraFCB2+2], CS
      MOV       AX, CS
      MOV       ES, AX
      MOV       DS, AX
      MOV       AX, 4B01h
      MOV       BX, offset paraENV
      MOV       DS, CS:[startupseg]
      MOV       DX, CS:[filenameoffset]
      
      INT       21H
      JC        failed1
      ADD       CS:[paraSP], 2
      CLI
      MOV       CX, CS:[hstopsize]
      MOV       ES, CS:[validcs]
      MOV       DS, CS:[paraCS]
      XOR       SI, SI
      XOR       DI, DI
      REP       MOVSB
      STI
      JMP       ok1
endp


readhsloader2 proc
      MOV       word ptr CS:[paraCT+2], CS
      MOV       word ptr CS:[paraFCB1+2], CS
      MOV       word ptr CS:[paraFCB2+2], CS
      MOV       AX, CS
      MOV       ES, AX
      MOV       DS, AX
      MOV       AX, 4B01h
      MOV       BX, offset paraENV
      MOV       DS, CS:[startupseg]
      MOV       DX, CS:[filenameoffset]
      
      INT       21H
      JC        failed1
      ADD       CS:[paraSP], 2
      RET
endp

retriever2 proc
      MOV       AX, 3514h
      INT       21h
      MOV       CS:[_oldoff_], BX
      MOV       CS:[_oldseg_], ES
      MOV       AH, 62h
      INT       21h
      PUSH      BX
      MOV       AX, 2514h
      PUSH      CS
      POP       DS
      MOV       DX, offset interrupt14h
      INT       21h
      POP       BX
      MOV       DS, BX
      MOV       AX, BX
      ADD       AX, 10h
      ADD       AX, CS:[_origCS_]
      MOV       ES, AX
      MOV       DI, CS:[_origIP_]
      CALL      vorbereiten
      MOV       word ptr ES:[DI], 14cdh
      MOV       ES, BX
      MOV       word ptr DS:[12], CS
      MOV       word ptr DS:[10], offset returnpoint2

      MOV       AX, CS:[paraCS]
      MOV       CS:[Jseg2], AX
      MOV       AX, CS:[paraIP]
      MOV       CS:[Jofs2], AX
      JMP       l986
l986:
      CLI
      MOV       CS:[ownSS], SS
      MOV       CS:[ownsp], SP
      MOV       SS, CS:[paraSS]
      MOV       SP, CS:[paraSP]
      STI
      XOR       AX, AX
      MOV       BX, AX
      MOV       CX, AX
      MOV       DX, AX
      MOV       BP, AX
      MOV       SI, AX
      MOV       DI, AX
      db 0eah  
jofs2 dw 0
jseg2 dw 0
returnpoint2: 
      CLI
      MOV       SS, CS:[ownSS]
      MOV       SP, CS:[ownSP]
      STI
      MOV       DS, CS:[_oldseg_]
      MOV       DX, CS:[_oldoff_]
      MOV       byte ptr CS:[done], 1  ; <-- nur einmal!!!
      MOV       AX, 2514h
      INT       21h
      MOV       AH, 50h
      MOV       BX, CS:[startupseg]
      INT       21h
      CMP       CS:[found],0
      JE        failed1
      JMP       ok1

endp

include opcodes.asm

vorbereiten proc
      PUSH      AX
      PUSH      BX
      PUSH      CX
      PUSH      DX

      XOR       BX, BX
      MOV       CS:stackadjust, Bx
      MOV       BL, ES:[DI]
      SHL       BX, 1
      CALL      word ptr cs:[opcodetable+BX]

      POP       DX
      POP       CX
      POP       BX
      POP       AX
      RET
endp

retriever proc
      MOV       SI, offset msg9
      CALL      print_string
      MOV       AX, 3521h
      INT       21h
      MOV       CS:[_oldoff_], BX
      MOV       CS:[_oldseg_], ES
      MOV       AH, 62h
      INT       21h
      PUSH      BX
      MOV       AX, 2521h
      PUSH      CS
      POP       DS
      MOV       DX, offset interrupt21h
      INT       21h
      POP       BX
      MOV       DS, BX
      MOV       ES, BX
      MOV       word ptr DS:[12], CS
      MOV       word ptr DS:[10], offset returnpoint

      MOV       AX, CS:[validcs]
      MOV       CS:[Jseg], AX
      MOV       AX, CS:[paraIP]
      MOV       CS:[Jofs], AX
      JMP       l1050
l1050:
      CLI
      MOV       CS:[ownSS], SS
      MOV       CS:[ownsp], SP
      MOV       SS, CS:[paraSS]
      MOV       SP, CS:[paraSP]
      STI
      XOR       AX, AX
      MOV       BX, AX
      MOV       CX, AX
      MOV       DX, AX
      MOV       BP, AX
      MOV       SI, AX
      MOV       DI, AX
      db 0eah  
jofs  dw 0
jseg  dw 0
returnpoint: 
      CLI
      MOV       SS, CS:[ownSS]
      MOV       SP, CS:[ownSP]
      STI
      MOV       DS, CS:[_oldseg_]
      MOV       DX, CS:[_oldoff_]
      MOV       byte ptr CS:[done], 1  ; <-- nur einmal!!!
      MOV       AX, 2521h
      INT       21h
      MOV       AH, 50h
      MOV       BX, CS:[startupseg]
      INT       21h
      CMP       CS:[found],0
      JE        failed1
      CMP       CS:[newrout], 1
      JE        soko
      JMP       ok1
soko: CALL      readhsloader2
      JC        soko2
      JMP       retriever2
soko2:
      RET
endp

main proc
      CALL      background
      CALL      openfile
      JC        normend      
      CALL      savedt
      JC        closeend
      CALL      checkexe 
      JC        closeend
      CALL      idcheck
      CALL      detecthsversion
      CALL      siganalysing
      JC        closeend
      CALL      readhsloader
      JC        closeend
      CALL      retriever
      JC        closeend
      CALL      save_exe
      CALL      restoredt
closeend:
      CALL      closefile
normend:      
      MOV       AX, 4C00h
      INT       21h
endp

.stack 200

END main
