unit DirectSentinelAccess;
{$H-}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, SentinelError;

type
  PMyPacket = ^TMyPacket;
  TMyPacket = packed record
    DeviceID: dword;
    DataLen:dword;
    SentFunct:byte;
    CellNo:byte;
    Data1:word;
    Data2:word;
    CryptSeed:word;
    NotUsed: array [0..$17] of byte;
  end;

type
  PMyPacketRet=^TMyPacketRet;
  TMyPacketRet = packed record
    CRC:byte;
    Error:Byte;
    Data1:Byte;
    Data2:Byte;
    Data3:Byte;
    Data4:byte;
    CryptSeed1:byte;
    CryptSeed2:byte;
  end;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Label1: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    hSentDevice:dword;
    Packet:TMyPacket;
    OutPacket:TMyPacketRet;
    DeviceID:dword;
    function CallSentinelUSBDriver(skip_prepare:bool;OutPacketLen:dword):dword;
    function FindUSBDriver:bool;
    function CheckKeyPresence(ForceMode:bool):bool;
    procedure CloseDriverHandle;
    function CheckPacketCRC(packet:PMyPacketRet):bool;
    procedure DisplayPacket(packet:PMyPacketRet);
    function sproSetParam(SetNo:byte;Data1,Data2:word):bool;
    function sproGetParam(SetNo:byte):bool;
    function sproDirectRead(cell:byte):bool; //Used in FindFirstUnit to read cell 0,1,5
    function sproActivate(cell:byte;WP,AP1,AP2:word):bool;
    function sproCustomFunction(cell:byte;functno:byte):bool;

  end;


var
  Form1: TForm1;

implementation

{$R *.dfm}

{ TForm1 }

procedure TForm1.CloseDriverHandle;
begin
        CloseHandle(hSentDevice);
        hSentDevice:=0;
end;

function TForm1.CheckKeyPresence(ForceMode:bool): bool;
var
   Dioc_result:longbool;
   BytesReturned:dword;
   TempPacket:TMyPacket;
begin
   result:=True;
   if ForceMode then begin
        ZeroMemory(@TempPacket,$28);
        ZeroMemory(@Packet,$28);
        DeviceID:=0;
   end;
   if DeviceID>0 then begin
        Exit;
   end;
   Dioc_result:=DeviceIOControl(hSentDevice,$220008,@TempPacket,$28,@TempPacket,$4,BytesReturned,NIL);
   if (not Dioc_result) then begin
        ShowMessage('Function $220008 failed');
        if hSentDevice<>0 then CloseDriverHandle;
        result:=False;
        Exit;
   end;
   DeviceID:=TempPacket.DeviceID;
end;

function TForm1.CallSentinelUSBDriver(skip_prepare:bool;OutPacketLen:dword): dword;
var
   Dioc_result:longbool;
   BytesReturned:dword;
   TempPacket:TMyPacket;
begin
   result:=0;
   if DeviceID=0 then CheckKeyPresence(True);
   TempPacket.DeviceID:=DeviceID;
   if (not skip_prepare) then begin
        //prepare function call
        packet.DeviceID:=DeviceID;
        Dioc_result:=DeviceIOControl(hSentDevice,$220014,@TempPacket,$28,@TempPacket,$0,BytesReturned,NIL);
        if (not Dioc_result) then begin
                ShowMessage('Function $220014 failed');
                if hSentDevice<>0 then CloseDriverHandle;
                result:=$220014;
                Exit;
        end;
   end;
   packet.DeviceID:=DeviceID;
   packet.CryptSeed:=$0;
   Packet.DataLen:=8;
   Crypt(@Packet.SentFunct); //Crypt data
   Dioc_result:=DeviceIOControl(hSentDevice,$22000C,@Packet,$28,@OutPacket,OutPacketLen,BytesReturned,NIL);
   if (not Dioc_result) then begin
        ShowMessage('Function $22000C failed');
        if hSentDevice<>0 then CloseDriverHandle;
        result:=$22000C;
        Exit;
   end;
   if OutPacketLen>0 then
        Crypt(@OutPacket); //Decrypt data
   if (not skip_prepare) then begin
        packet.DeviceID:=DeviceID;
        Dioc_result:=DeviceIOControl(hSentDevice,$220018,@TempPacket,$28,@TempPacket,$0,BytesReturned,NIL);
        if (not Dioc_result) then begin
                ShowMessage('Function $220018 failed');
                if hSentDevice<>0 then CloseDriverHandle;
                result:=$220018;
                Exit;
        end;
   end;
end;

function TForm1.FindUSBDriver: bool;
begin
   result:=False;
   hSentDevice:=CreateFileA(PChar('\\.\SntnlUsb'),$C0000000,3,nil,3,$4000000,0);
   if hSentDevice=$FFFFFFFF then begin
         ShowMessage('Can''t open SntnlUsb driver !!!');
         Exit;
   end;
   result:=True;
end;


function TForm1.CheckPacketCRC(packet: PMyPacketRet): bool;
begin
    result:=true;
    if packet.CRC<>byte((packet.Error+packet.Data1+packet.Data2+
                                packet.Data3+packet.Data4)) then begin
        ShowMessage(Format('Wrong CRC! Correct: %02.2X',[byte(packet.Error+packet.Data1+packet.Data2+
                                packet.Data3+packet.Data4)]));
        result:=false;
    end;
end;

procedure TForm1.DisplayPacket(packet: PMyPacketRet);
begin
    ShowMessage(Format( 'CRC:  %02.2X, Error:%02.2X(%s)'+#10#13+
                        'Word1:%02.2X%02.2X'+#10#13+
                        'Word2:%02.2X%02.2X',
                        [packet.CRC,packet.Error,GetSentError(packet.Error),
                         packet.Data2,packet.Data1,
                         packet.Data4,packet.Data3]));
end;

function TForm1.sproSetParam(SetNo: byte; Data1, Data2: word): bool;
var
  CallRet:dword;
begin
   //Correct value for SetNo are 0,4,8 ->8*4
   result:=False;
   Packet.CellNo:=SetNo;
   Packet.SentFunct:=$3;
   Packet.Data1:=Data1;
   Packet.Data2:=Data2;
   CallRet:=CallSentinelUSBDriver(False,0);
   if CallRet>0 then Exit;
   result:=True;
end;

function TForm1.sproGetParam(SetNo: byte): bool;
var
  CallRet:dword;
  RetPacket:PMyPacketRet;
begin
   //Correct value for SetNo are 0,4,8 ->8*4
   result:=False;
   Packet.CellNo:=SetNo;
   Packet.SentFunct:=$2;
   Packet.Data1:=0;
   Packet.Data2:=0;
   CallRet:=CallSentinelUSBDriver(False,8);
   if CallRet>0 then Exit;
   RetPacket:=@OutPacket;
   if (not CheckPacketCRC(RetPacket)) then Exit;
   result:=True;
end;

function TForm1.sproDirectRead(cell:byte): bool; //used by FindFirstUnit to read
                                      // cells 0,1,5
var
  CallRet:dword;
  RetPacket:PMyPacketRet;
begin
   result:=False;
   Packet.CellNo:=cell;
   Packet.SentFunct:=$10;
   CallRet:=CallSentinelUSBDriver(False,8);
   if CallRet>0 then Exit;
   RetPacket:=@OutPacket;
   if (not CheckPacketCRC(RetPacket)) then Exit;
   result:=True;
   // Data1+Data2  cell content (word)
   // Data2+Data3  garbish
end;

function TForm1.sproActivate(cell:byte;WP,AP1,AP2:word): bool;
var
  CallRet:dword;
  RetPacket:PMyPacketRet;
begin
   sproSetParam(0,AP1,AP2);
   result:=False;
   Packet.CellNo:=cell;
   Packet.SentFunct:=$1C;
   Packet.Data2:=WP;
   Packet.Data1:=0;
   CallRet:=CallSentinelUSBDriver(False,8);
   if CallRet>0 then Exit;
   RetPacket:=@OutPacket;
   if (not CheckPacketCRC(RetPacket)) then Exit;
   sproGetParam(0);
   result:=True;
end;

function TForm1.sproCustomFunction(cell:byte;functno:byte): bool;
var
  CallRet:dword;
  RetPacket:PMyPacketRet;
begin
   result:=False;
   Packet.CellNo:=cell;
   Packet.SentFunct:=functno;
   Packet.Data2:=$1234;
   Packet.Data1:=$5678;
   CallRet:=CallSentinelUSBDriver(False,8);
   if CallRet>0 then Exit;
   RetPacket:=@OutPacket;
   if (not CheckPacketCRC(RetPacket)) then Exit;
   result:=True;
end;

procedure TForm1.Button1Click(Sender: TObject);
var
  i,j:word;
  mytime:dword;
begin
        if FindUSBDriver then begin
            if CheckKeyPresence(True) then begin
                //ShowMessage(Format('KeyID=%08.8X',[DeviceID]));
                //sproDirectRead($18);
                //sproCustomFunction($14,$1);
                MyTime:=GetTickCount;
                for i:=0 to $0 do begin
                    for j:=0 to $FFF do begin
                        sproActivate($14,$2719,1,1);
                        Label1.Caption:=Format('%04.4X  %04.4X',[i,j]);
                        form1.update;
                        //if OutPacket.Error=0 then exit;
                    end;
                end;
                MyTime:=GetTickCount-MyTime;
                ShowMessage(Format('Total:%08.8X, Per cycle:%08.8X',[mytime,(mytime div 1000)]));
                //DisplayPacket(@OutPacket);
                end
            else
                ShowMessage('Don''t find any USB key!!');
        end
        else ShowMessage('Don''t find USB driver!');
        CloseDriverHandle;
end;

procedure TForm1.Button2Click(Sender: TObject);
var
 Buffer:array[0..7] of byte;
begin
  Buffer[0]:=$43;
  Buffer[1]:=$fb;
  Buffer[2]:=$33;
  Buffer[3]:=$af;
  Buffer[4]:=$1a;
  Buffer[5]:=$3a;
  Buffer[6]:=$0;
  Buffer[7]:=$0;
  //Crypt(@Buffer);
  Crypt1(@Buffer);
  ShowMessage(Format('%02.2X %02.2X %02.2X %02.2X '+#13#10+
                     '%02.2X %02.2X %02.2X %02.2X ',
                     [Buffer[0],Buffer[1],Buffer[2],Buffer[3],
                      Buffer[4],Buffer[5],Buffer[6],Buffer[7]]));

end;

end.

