.model small
.386p
.stack
.code
X Segment Para Public Use16 'CODE'      ; don't do "USE32" :--) trust me
Assume cs:X, ds:X

_dpmi_host_not_there db "Error : no DPMI host detected.$"
_error_switching db "Error : couldn't switch to p-mode.$"
_no_desc_str db "PMError : Couldn't create descriptor.$"
_no_mem_str db "PMError : Couldn't allocate memory.$"
_no_base_str db "PMError : Couldn't set base address of descriptor.$"
_no_limit_str db "PMError : Couldn't set the limit on the descriptor.$"

SavedRegs label dword
_esi dd 0
_edi dd 0
_ebp dd 0
reserved dd 0
_ebx dd 0
_edx dd 0
_ecx dd 0
_eax dd 0
_flags dw 0
_es dw 0
_ds dw 0
_fs dw 0
_gs dw 0
_ip dw 0
_cs dw 0
_sp dw 0
_ss dw 0

dpmiEntry dd ?
flag32 dw ?
dProcType db ?
memneeded dw ?
dpmiVersion dw ?
memHHigh dw ?
memHLow dw ?
memLAHigh dw ?
memLALow dw ?
newdesc dw ?

start:
cld
call _detect_dpmi_host
jc @@start_detect_error

and bx, 1
mov word ptr [flag32], bx
mov byte ptr [dProcType], cl
mov word ptr [memneeded], si
mov word ptr [dpmiEntry], di
mov word ptr [dpmiEntry+2], es
mov word ptr [dpmiVersion], dx

mov ax, seg DPMIDATA ; es has 65,000 bytes of free memory
mov es, ax      
xor ax, ax       ; ax = 1 because we want 32-bits, damnit
inc ax
call dword ptr [dpmiEntry]
jc @@dpmiEntry_error

mov ax, ds
mov es, ax
mov word ptr [_ds], seg X
mov word ptr [_es], seg X
mov word ptr [_ss], seg DPMISTACK
mov word ptr [_sp], 1000h

xor ax, ax      ; 31h/0h : create descriptor
mov cx, 00001h  ; specify *one* descriptor
int 31h         
jc @@nodesc
mov newdesc, ax

mov ax, 501h
mov bx, 5
xor cx, cx      ; bx:cx = 50000h bytes, about 1/3 meg
int 31h
jc @@nomem
mov memHHigh, si
mov memHLow, di
mov memLAHigh, bx
mov memLALow, cx

mov dx, cx      ; switch bx:cx to cx:dx
mov cx, bx
mov ax, 7h
mov bx, newdesc
int 31h
jc @@nobase

mov ax, 8h
mov bx, newdesc
mov cx, 5h
xor dx, dx      ; cx:dx = 50000h bytes, the amount that was allocated
int 31h
jc @@nolimit

; .....
; .....
; do something else here
; .....
; .....

; end of the program, time to free the descriptor and memory
; boo-hoo

mov ax, 1
mov bx, newdesc
int 31h

mov ax, 502h
mov si, memHHigh
mov di, memHLow
int 31h

@@exit:
mov ax, 4c00h
int 21h

@@nodesc:
; we're in pmode, so we have to print the error in pmode
mov dword ptr [_edx], offset _no_desc_str
jmp @@pmodeerror

@@nomem:
mov dword ptr [_edx], offset _no_mem_str
jmp @@pmodeerror

@@nobase:
mov dword ptr [_edx], offset _no_base_str
jmp @@pmodeerror

@@nolimit:
mov dword ptr [_edx], offset _no_limit_str

@@pmodeerror:
mov dword ptr [_eax], 900h 
mov ax, 300h    
mov bx, 21h
mov cx, 0
lea edi, SavedRegs      
int 31h
jmp @@exit

@@start_detect_error:           ; tell dummy host not detected
lea dx, _dpmi_host_not_there        
jmp @@end

@@dpmiEntry_error:
lea dx, _error_switching

@@end:
mov ax, 900h
int 21h
jmp @@exit

_detect_dpmi_host proc
mov ax, 1687h
int 2fh
or ax, ax
jnz @@_detect_no_host
clc
ret
@@_detect_no_host:
stc
ret
_detect_dpmi_host endp

X ENDS

DPMIDATA Segment
db 0ffffh dup (?)
DPMIDATA Ends

DPMISTACK Segment
db 1000h dup (?)
DPMISTACK Ends

End start
 
