.model tiny
.386
.code
org 100h
s:

call check_DPMI
jc no_dpmi

push offset dpmi_host_present
jmp @@s_over

no_dpmi:
push offset no_dpmi_host
@@s_over:

call _print
add esp, 2
ret

check_DPMI proc
mov ax, 1687h           ; get dpmi host address from int 2f (multiplex)
int 2fh
clc
or ax, ax
jnz @@check_dpmi_no_host
and bl, 1               ; 0000000x of bl = 32-bit indicator
setnz byte ptr [bits32]
mov byte ptr [dpmiProcType], cl
mov word ptr [dpmiVersion], dx
mov word ptr [memoryNeeded], si
mov word ptr [dpmiAddress], di
mov word ptr [dpmiAddress+2], es
stc
@@check_dpmi_no_host:
cmc
ret
check_DPMI endp

_print PROC
mov dx, word ptr [esp+2]
mov ah, 9
int 21h
ret
_print endp


bits32 db 0
dpmiProcType db ?
dpmiVersion dw ?
memoryNeeded dw ?
dpmiAddress dd ?
no_dpmi_host db "No DPMI host detected.$"
dpmi_host_present db "A DPMI host was detected.$"
end s

