
// JULIA.C
// Accompanying code to fractal.html, by NRoC, All rights reserved, blah blah.
// Note that this source is in no way optimised.
//
// Visit CoRNSouP! (http://cornsoup.cjb.net/)

#include <stdio.h>
#include <dos.h>

// If this is excessively slow, drop the number of iterations, 128 is a nice
// (ish) trade-off between speed and detail.

#define MAX_ITERATIONS 256

// Constant Real, Constant Imaginary, for specific Julia

#define cRe -0.083724754
#define cIm 0.673277736

// Video Routines ////////////////////////////////////////////////////////////

void loadpal( char *palfile )
{
   unsigned char pal[768];
   int i;
   FILE *fp;

   fp = fopen( palfile,"rb" );
   fread( &pal,1,768,fp );
   fclose( fp );

   for( i = 0 ; i < 256 ; i++ )
   {
     outportb( 0x3c8,i );
     outportb( 0x3c9,pal[i*3] );
     outportb( 0x3c9,pal[i*3+1] );
     outportb( 0x3c9,pal[i*3+2] );
   }
}

void pixel( unsigned int x, unsigned int y, unsigned char col )
{
   asm mov ax, 0a000h
   asm mov es, ax
   asm mov ax, y
   asm shl ax, 8
   asm mov di, ax
   asm shr ax, 2
   asm add di, ax
   asm add di, x
   asm mov al, col
   asm stosb
}

void setmode( unsigned int mode )
{
   asm mov ax, mode
   asm int 10h
}

// Julia Generation Routines /////////////////////////////////////////////////

unsigned char iterate( float Zre, float Zim )
{
   float oZre;
   int iterations = 0;
   float odist = 0;

   do
   {
      oZre = Zre;
      Zre = (Zre*Zre)-(Zim*Zim)+cRe;
      Zim = (2*oZre*Zim)+cIm;
      odist = (Zre*Zre)+(Zim*Zim);              // distance from origin
      iterations++;                             // num iterations
   }
   while( ( iterations < MAX_ITERATIONS ) && ( odist < 4 ) );

   if( iterations == MAX_ITERATIONS )
      return( 0 );
   else
      return( iterations );
}

void julia( float MinX,float MaxX,float MinY,float MaxY )
{
   float dx,dy;                        // delta x, and delta y
   int x,y;                            // screen coords
   
   dx = (float)(MaxX-MinX)/320;                  
   dy = (float)(MaxY-MinY)/200;                  

   for( y = 0 ; y < 200 ; y++ )
      for( x = 0 ; x < 320 ; x++ )
      {
         pixel( x,y,iterate( (float)(MinX+(x*dx)),(float)(MaxY-(y*dy)) ) );   
      }
}
                 
void main( void )
{

   setmode( 0x13 );
   loadpal( "rgb.pal" );

   julia( -2,2,-1.5,1.5 );

   asm xor ax, ax
   asm int 16h
   setmode( 0x03 );
}
