.386p
.model flat, stdcall

include rsrc.inc            ;Resource Includes (from resource.h if you use VC++ Resource Editor)
include \masm32\include\windows.inc        ;Standard Windows structs and api calls
include \masm32\include\kernel32.inc        ;Standard Windows structs and api calls
include \masm32\include\user32.inc        ;Standard Windows structs and api calls
include \masm32\include\comctl32.inc
include psapi.inc
include vdmdbg.inc

includelib \masm32\lib\kernel32.lib        ;These are the libraries we'll be using 
includelib \masm32\lib\user32.lib
includelib \masm32\lib\comctl32.lib
includelib psapi.lib
includelib vdmdbg.lib

ICON_SMALL    equ 0        ;Defines not in windows.inc
WM_SETICON    equ 80h
PROCESS_QUERY_INFORMATION   equ 1024
PROCESS_VM_READ             equ 16
;
;Local proc declares
;
BuildProcessList PROTO
DisplayProcessList PROTO, :dword, :dword
DisplayModuleInfo PROTO, :dword, :dword
Enum16Proc PROTO, :DWORD, :WORD,:WORD, :DWORD, :DWORD, :DWORD

extern wsprintfA:proc        ;wsprintf uses a variable # of params, so we have to define it differently

.DATA

AppName    db 'PSAPI & YOU',0
hdrPID	   db 'Process ID',0
hdrModuleFileName db 'Image Name',0
hdrMemory  db 'Mem Used',0
hdrImageSize db 'Image Size',0

szFormat   db '%ld',0
szFormat2  db '%ldK',0
szFormat3  db '%ld',0
szIdleProc db 'System Idle Process',0
szSystem   db 'System',0
szNtVDM	   db 'NTVDM.EXE',0
szBlank    db ' ',0

.DATA?
_hInst      dd ?        ;the hInst
hWnd        dd ?        ;Window Handle
_hIcon      dd ?
dwCount     dd ?

szError	    db 255 dup(?)
szOutput    db 255 dup(?)
szFileName  db 512 dup(?)

_msg        MSG         <?> ;The message Structure
_pnt        PAINTSTRUCT <?>
_col        LV_COLUMN <>
_item       LV_ITEM <>
_procmem    PROCESS_MEMORY_COUNTERS <>
_module	    MODULEINFO <>

.CODE

main:
   invoke    GetModuleHandle, NULL    ;Get the handle to our app
   mov    _hInst, eax        ;Store it

   xor    eax, eax        ;clear eax
   mov    ax, DLG_0100        ;load the handle of the dialog into eax
   push    0            ;Initialization Value...we don't need it, make it 0
   push    offset DlgProc        ;Pointer to the Procedure which handles messages for the dialog
   push    0            ;We have no owner window, so this can be null
   push    eax            ;The dialog that we want to load
   push    _hInst            ;The hInst
   call    DialogBoxParamA    ;Create the Dialog

   call    ExitProcess        ;Exit the Program
    

;
;The DlgProc, handles messages for the Dialog Box
;See API Ref for info on the variables passed to it
;

;PUBLIC DlgProc
DlgProc proc STDCALL, __hwnd:DWORD, wmsg:DWORD, _wparam:DWORD, _lparam:DWORD

xor    eax,eax                ;Clear eax
mov    ax, word ptr [wmsg]        ;Put the message into eax

.IF ax==WM_DESTROY            ;Was the msg WM_DESTROY
 jmp  _wmdestroy            ;If so, destroy the window
.ELSEIF ax==WM_CLOSE            ;Same thing if it's WM_CLOSE
 jmp  _wmdestroy
.ELSEIF ax==WM_COMMAND            ;WM_COMMAND means something interesting happened
 jmp    _wmcommand            ;So process it
.ELSEIF ax==WM_INITDIALOG        ;Code runs when the dialog is first initialized
 jmp    _initdlg
.ELSE
  invoke DefWindowProc,__hwnd,wmsg,_wparam,_lparam
.ENDIF                    
xor eax,eax

ret                    ;Exit the message loop, return 0

_wmdestroy:
push    0                ;Return 0
push    __hwnd                ;The handle of the Dialog
call    EndDialog            ;End the Dialog
call    ExitProcess            ;Exit Process
ret

_wmcommand:
mov    ax, word ptr [_wparam]
.IF ax == IDC_EXIT
    jmp _wmdestroy
.ELSEIF ax == IDCANCEL
    jmp _wmdestroy
.ENDIF
xor  eax, eax
ret

_initdlg:
;
;Here we will put the icon on the dialog and center the dialog
;
invoke InitCommonControls
;invoke CreateStatusWindow,WS_CHILD+WS_VISIBLE,NULL,__hwnd,106
;mov    hWndStat, eax


invoke  LoadIcon,_hInst, IDI_ICON
mov    _hIcon, eax            ;Store the Icon handle
invoke SendMessage, __hwnd, WM_SETICON, ICON_SMALL, eax


mov _item.imask, LVIF_TEXT

mov _col.imask, LVCF_TEXT+LVCF_WIDTH+LVCF_SUBITEM
mov _col.lx, 65
mov _col.iSubItem, 0
mov _col.pszText, offset hdrPID
invoke SendDlgItemMessage, __hwnd, IDC_LIST,LVM_INSERTCOLUMN ,0, addr _col

mov _col.pszText, offset hdrModuleFileName
mov _col.lx, 110
mov _col.iSubItem,1 
invoke SendDlgItemMessage, __hwnd, IDC_LIST,LVM_INSERTCOLUMN ,1, addr _col

mov _col.imask, LVCF_TEXT+LVCF_WIDTH+LVCF_SUBITEM+LVCF_FMT
mov _col.fmt, LVCFMT_RIGHT
mov _col.pszText, offset hdrMemory
mov _col.lx, 65
mov _col.iSubItem, 2
invoke SendDlgItemMessage, __hwnd, IDC_LIST,LVM_INSERTCOLUMN ,2, addr _col

mov _col.pszText, offset hdrImageSize
mov _col.lx, 65
mov _col.iSubItem, 3
invoke SendDlgItemMessage, __hwnd, IDC_LIST,LVM_INSERTCOLUMN ,3, addr _col

mov	eax, __hwnd
mov	hWnd, eax
invoke	BuildProcessList

xor  eax, eax
ret

DlgProc ENDP

BuildProcessList PROC uses ebx edx

local dwSize:DWORD
local dwSize2:DWORD
local lpdwPID:DWORD
local dwPIDCnt:DWORD
	mov	eax, 256	;# of PIDS to look for on first try
	shl	eax, 2		;multiplied by 4 (sizeof(DWORD))
	mov	dwSize2, eax
	mov	lpdwPID, 0
@loopy:
	cmp	lpdwPID, 0
	jz	Size2OK
	invoke	GetProcessHeap
	mov    ebx, eax
      invoke	HeapFree, ebx, 0, addr lpdwPID
	mov	edx, dwSize2
	shl	edx, 1
	mov	dwSize2, edx
Size2OK:
	invoke	GetProcessHeap
	invoke	HeapAlloc, eax, 0, dwSize2
	test	eax, eax
	jnz	AllocOK
	jmp	ErrorReturn
AllocOK:
	mov    lpdwPID, eax
      invoke  EnumProcesses, lpdwPID, dwSize2, addr dwSize
	test	eax, eax
	jnz	EnumProcsOK
	invoke	GetProcessHeap
	invoke	HeapFree, eax, 0, lpdwPID
	jmp	ErrorReturn
EnumProcsOK:
	mov	eax, dwSize
	cmp	eax, dwSize2
	jz	@loopy

	shr	eax, 2
	mov	dwPIDCnt, eax
	invoke	DisplayProcessList, lpdwPID, eax	
	invoke	DisplayModuleInfo, lpdwPID, dwPIDCnt
	ret
ErrorReturn:
	invoke	GetLastError
	invoke      FormatMessage, FORMAT_MESSAGE_FROM_SYSTEM, 0, eax,0, addr szError, 255,0
	invoke	MessageBox, NULL, addr szError, addr AppName, 0
	mov	eax, -1
	ret

BuildProcessList ENDP

DisplayProcessList PROC uses ecx edi ebx lpdwPID:DWORD, dwNumProcs:DWORD
	mov	edi, lpdwPID
	xor	ebx, ebx
@loopy:
     	push	dword ptr [edi]
	push	offset szFormat
	push	offset szOutput
	call	wsprintfA	
	mov	_item.iitem, ebx
	lea	eax, szOutput
	mov	_item.pszText, eax
	mov 	_item.iSubItem, 0
	invoke 	SendDlgItemMessage, hWnd, IDC_LIST,LVM_INSERTITEM,0, addr _item
	inc	ebx
	add	edi, 4
	mov	ecx, dwNumProcs
	dec	ecx
	mov	dwNumProcs, ecx
	jg	@loopy
	ret
DisplayProcessList ENDP

DisplayModuleInfo PROC uses ecx edi ebx lpdwPID:DWORD, dwNumProcs:DWORD
	local	hProcess:DWORD
	local	hModule:DWORD
	local	dwBytes:DWORD
	mov	edi, lpdwPID
	xor	ebx, ebx
@loopy:
	.if dword ptr [edi] == 0
        	lea eax, szIdleProc
		mov	_item.iitem, ebx
		mov	_item.pszText, eax
		mov 	_item.iSubItem, 1
		invoke 	SendDlgItemMessage, hWnd, IDC_LIST,LVM_SETITEMTEXT,ebx, addr _item
	        jmp OpenProcessFailed
	.elseif dword ptr [edi] == 2
		lea eax, szSystem
		mov	_item.iitem, ebx
		mov	_item.pszText, eax
		mov 	_item.iSubItem, 1
		invoke 	SendDlgItemMessage, hWnd, IDC_LIST,LVM_SETITEMTEXT,ebx, addr _item
		jmp OpenProcessFailed
      	.endif          
	invoke	OpenProcess, PROCESS_QUERY_INFORMATION + PROCESS_VM_READ, FALSE, dword ptr [edi]
	mov	hProcess, eax
	test	eax, eax
	jz	OpenProcessFailed
	invoke	EnumProcessModules, hProcess, addr hModule, 4, addr dwBytes
	test	eax, eax
	jz	EnumFailed
	invoke	GetModuleBaseName, hProcess, hModule, addr szFileName, 512
	.if eax == null
		mov byte ptr [szFileName], 0
	.endif
        lea eax, szFileName
	mov	_item.iitem, ebx
	mov	_item.pszText, eax
	mov 	_item.iSubItem, 1
	invoke 	SendDlgItemMessage, hWnd, IDC_LIST,LVM_SETITEMTEXT,ebx, addr _item
	
	invoke GetModuleInformation, hProcess, hModule, addr _module, sizeof _module
	test	eax, eax
	jz	EnumFailed
	push	_module.SizeOfImage
	push	offset szFormat3
	push	offset szOutput
	call	wsprintfA
        lea eax, szOutput
	mov	_item.iitem, ebx
	mov	_item.pszText, eax
	mov 	_item.iSubItem, 3
	invoke 	SendDlgItemMessage, hWnd, IDC_LIST,LVM_SETITEMTEXT,ebx, addr _item
	invoke	lstrcmpi, addr szFileName, addr szNtVDM
	test	eax, eax
	jnz	EnumFailed
	mov   dwCount, ebx
	invoke	VDMEnumTaskWOWEx, dword ptr [edi], addr Enum16Proc, addr szBlank
	mov   ebx, dwCount
EnumFailed:
	invoke	GetProcessMemoryInfo, hProcess, addr _procmem, sizeof _procmem
	test	eax, eax
	jz	ProcMemInfoFailed
      mov   eax, _procmem.WorkingSetSize
      shr   eax, 10
      
	push	eax
	push	offset szFormat2
	push	offset szOutput
	call	wsprintfA
        lea eax, szOutput
	mov	_item.iitem, ebx
	mov	_item.pszText, eax
	mov 	_item.iSubItem, 2
	invoke 	SendDlgItemMessage, hWnd, IDC_LIST,LVM_SETITEMTEXT,ebx, addr _item
	
ProcMemInfoFailed:
	invoke	CloseHandle, hProcess
OpenProcessFailed:
	inc	ebx
	add	edi, 4
	mov	ecx, dwNumProcs
	dec	ecx
	mov	dwNumProcs, ecx
	jnz	@loopy
	ret
DisplayModuleInfo ENDP

Enum16Proc PROC dwThreadID:DWORD, hMod16:WORD, hTask16:WORD, szModName:DWORD, pszFileName:DWORD, lpUserDefined:DWORD
      push  ebx
      inc	dwCount
      mov   ebx, dwCount
	mov	eax, offset szBlank
	mov	_item.iitem, ebx
	mov	_item.pszText, eax
	mov 	_item.iSubItem, 0
	invoke 	SendDlgItemMessage, hWnd, IDC_LIST,LVM_INSERTITEM,ebx, addr _item

	mov	eax, szModName
	mov	_item.iitem, ebx
	mov	_item.pszText, eax
	mov 	_item.iSubItem, 1
	invoke 	SendDlgItemMessage, hWnd, IDC_LIST,LVM_SETITEMTEXT,ebx, addr _item
	xor    eax, eax
      pop   ebx
	ret
Enum16Proc ENDP
end main                ;That's all folks!
