
// TOOLBAR.C
// Accompanying code to toolbar.html, by NRoC, All rights reserved, blah, blah.

// Visit CoRNSouP! (http://cornsoup.cjb.net)

#include <windows.h>
#include <commctrl.h>           // Common Controls header
#include <stdio.h>
#include "toolbar.h"

#define NUM_BUTTONS 4           // Number of buttons on the toolbar

HWND tbarhWnd;                  // Handle for Toolbar
TBBUTTON tbut[NUM_BUTTONS];     // Structure to hold our buttons

LRESULT CALLBACK WindowFunc( HWND hWnd,UINT msg,WPARAM wParam,LPARAM lParam )
{
   HDC hdc;
   PAINTSTRUCT ps;
   RECT rect;
   LPTOOLTIPTEXT TtipText;

   switch( msg )
   {
      case WM_PAINT:
         hdc = BeginPaint( hWnd,&ps );
         GetClientRect( hWnd,&rect );
         EndPaint( hWnd,&ps );
         break;

      case WM_COMMAND:
         switch( LOWORD( wParam ) )
         {
            case ID_NEWFILE:
               MessageBox( hWnd,"Create New File","Woop",MB_OK );
               break;

            case ID_OPENFILE:
               MessageBox( hWnd,"Open New File","Woop",MB_OK );
               break;

            case ID_SAVEFILE:
               MessageBox( hWnd,"Save this File","Woop",MB_OK );
               break;
         }
         break;
           
      case WM_NOTIFY:
         TtipText = (LPTOOLTIPTEXT)lParam;
         if( TtipText->hdr.code == TTN_NEEDTEXT )
            switch( TtipText->hdr.idFrom )
            {
               case ID_NEWFILE :
                  TtipText->lpszText = "Create a New File";
                  break;

               case ID_OPENFILE :
                  TtipText->lpszText = "Open an old File";
                  break;

               case ID_SAVEFILE :
                  TtipText->lpszText = "Save this File";
                  break;
            }
         break;

      case WM_DESTROY:
         PostQuitMessage( 0 );
         break;

      default:
         return( DefWindowProc( hWnd,msg,wParam,lParam ) );
         break;
    }
    return( 0 );
}

void SetupToolbar( void )
{
   tbut[0].iBitmap = 3;                         // A Seperator
   tbut[0].idCommand = 0;                       // Note this is zero.
   tbut[0].fsState = TBSTATE_ENABLED;
   tbut[0].fsStyle = TBSTYLE_SEP;
   tbut[0].dwData = 0L;
   tbut[0].iString = 0;

   tbut[1].iBitmap = 0;                         // Pic in bitmap
   tbut[1].idCommand = ID_NEWFILE;              // ID of button
   tbut[1].fsState = TBSTATE_ENABLED;
   tbut[1].fsStyle = TBSTYLE_BUTTON;
   tbut[1].dwData = 0L;
   tbut[1].iString = 0;

   tbut[2].iBitmap = 1;
   tbut[2].idCommand = ID_OPENFILE;
   tbut[2].fsState = TBSTATE_ENABLED;
   tbut[2].fsStyle = TBSTYLE_BUTTON;
   tbut[2].dwData = 0L;
   tbut[2].iString = 0;

   tbut[3].iBitmap = 2;
   tbut[3].idCommand = ID_SAVEFILE;
   tbut[3].fsState = TBSTATE_ENABLED;
   tbut[3].fsStyle = TBSTYLE_BUTTON;
   tbut[3].dwData = 0L;
   tbut[3].iString = 0;
}

int WINAPI WinMain( HINSTANCE hInst,HINSTANCE hPrevInst,LPSTR lpszArgs, int nWinMode )
{
   WNDCLASS lame;                               // Our Window Class.
   HWND hWnd;
   MSG msg;

   lame.hInstance = hInst;
   lame.lpszClassName = "llama";
   lame.lpfnWndProc = WindowFunc;
   lame.style = 0;
   lame.hIcon = LoadIcon( NULL,IDI_APPLICATION );
   lame.hCursor = LoadCursor( NULL,IDC_ARROW );
   lame.lpszMenuName = NULL;
   lame.cbClsExtra = 0;
   lame.cbWndExtra = 0;
   lame.hbrBackground = GetStockObject( GRAY_BRUSH );
   if( !RegisterClass( &lame )) return 0;
   hWnd = CreateWindow( "llama","Tool - Bar?",WS_OVERLAPPED | WS_SYSMENU,CW_USEDEFAULT,CW_USEDEFAULT,200,80,HWND_DESKTOP,NULL,hInst,NULL );

   SetupToolbar();

   InitCommonControls();
 
   // Create Toolbar
   tbarhWnd = CreateToolbarEx( hWnd,WS_VISIBLE | WS_CHILD | WS_BORDER | TBSTYLE_TOOLTIPS,ID_TOOLBAR,NUM_BUTTONS,hInst,ID_TBAR_BMP,tbut,NUM_BUTTONS,0,0,20,19,sizeof(TBBUTTON) );

   ShowWindow( hWnd,nWinMode );
   UpdateWindow( hWnd );

   while( GetMessage( &msg,NULL,0,0 ))
   {
      TranslateMessage( &msg );
      DispatchMessage( &msg );
   }

   return( msg.wParam );
}

