/****************************************************************************
 *   dotnet dumper
 *   Copyright (C) 2011  deroko of ARTeam
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ****************************************************************************/
 
#include        <windows.h>
#include        <stdio.h>
#include        <stdlib.h>
#include        "pe64.h"


#define         METADATA_SIGNATURE      0x424A5342

typedef struct  _METADATA_HEADER{
        DWORD   Signature;              //signature METADATA_SIGNATURE
        WORD    MajorVersion;           //Major version, 1 (ignore on read);
        WORD    MinorVersion;           //Minor version, 1 (ignore on read);
        DWORD   Reserved;               //Reserved, always 0
        DWORD   Length;                 //Length of string rounderd to a multiple of four
        WCHAR   Version[1];              //UTF8-encoded version string of length
        WCHAR   Padding[1];
        WORD    Flags;                  //reserved, always 0              
        WORD    Streams;                //Number of streams
        BYTE    StreamHeaders;          //Stream header actually...
}METADATA_HEADER, *PMETADATA_HEADER;

typedef struct _METADATA_HEADER_2{
        WORD    Flags;
        WORD    Streams;
        BYTE    StreamHeaders[1];
}METADATA_HEADER_2, *PMETADATA_HEADER_2;


typedef struct _STREAM_HEADER{
        DWORD   Offset;                 //Memory offset to start of this stream from start of the metadata root
        DWORD   Size;                   //Size of this stream in bytes
        CHAR    Name[1];                //Name of the stream as null-terminated variable length array of ASCI, 
                                        //padded to next 4-byte boundary with \0 charactes. The name is limited to 32 
                                        //characters
}STREAM_HEADER, *PSTREAM_HEADER;



typedef struct _TABLE_HEADER{
        DWORD           Reserved0;      //reserved, always 0
        BYTE            MajorVersion;   //Major version of table schemata, shall be 2
        BYTE            MinorVersion;   //Minor version of table schemata, shall be 0
        BYTE            HeapSizes;      //Bit vector for heap sizes
        BYTE            Reserved1;      //Reserved, always 1
        ULONGLONG       Valid;          //Bit vector of present tables, let n be the number of bits that are 1
        ULONGLONG       Sorted;         //Bit vector of sorted tables
        ULONG           Rows[1];        //Array of n 4-byte unsigned untegers indicating the number of rows for each present 
                                        //table
}TABLE_HEADER, *PTABLE_HEADER;
        //TABLES offset = TABLE_HEADER->Rows + NumberOfRows * 4
      
typedef enum _HeapSizeFlags{
        STRINGS_HEAP_SIZE  =       1,   //if set, index into #Strings heap is 4 otherwise 2 bytes wide
        GUID_HEAP_SIZE     =       2,   //if set, index into #GUID    heap is 4 otherwise 2 bytes wide
        BLOB_HEAP_SIZE     =       4    //if set, index into #BLOB    heap is 4 otherwise 2 bytes wide
};


/****************************************************************************
 *  typedef struct _STREAMS_HEADER{
 *              "StringsIndex", "index strings", 0
 *              "BlobIndex"   , "index blob", 0
 *              "GuidIndex"   , "index guid",
 *              "HashId"      , "dword", 0
 *              "AlgID"       , "word",  0
 *              etc...
 *              NULL,           NULL,    0      <--- end
 * So, parser for this will work:
 * 1. Check if 1st filed is NULL, if so end
 * 2. Check what type of operation we have (index, dword, word)
 *    - if index, check if it's blob, strings, guid to know size of this field
 * 3. Extract data based on this information and store in 3rd field of structure
 *    or return that data back. That's even better, as structures can be globally
 *    defined and used straigh from header file...
 * 4. Go to next field and update structure size according to index fields
 * 5. goto 1
 * 
 * Implemented in parser.c and parser.h
 ****************************************************************************/

typedef enum _Tables{
        Module                  = 0x00,
        TypeRef                 = 0x01,
        TypeDef                 = 0x02,
        FieldPtr                = 0x03,
        Field                   = 0x04,
        MethodPtr               = 0x05,
        MethodDef               = 0x06,
        ParamPtr                = 0x07,
        Param                   = 0x08,
        InterfaceImpl           = 0x09,
        MemberRef               = 0x0A,
        Constant                = 0x0B,
        CustomAttribute         = 0x0C,
        FieldMarshal            = 0x0D,
        DeclSecurity            = 0x0E,
        ClassLayout             = 0x0F,
        FieldLayout             = 0x10,
        StandAloneSig           = 0x11,
        EventMap                = 0x12,
        EventPtr                = 0x13,
        Event                   = 0x14,
        PropertyMap             = 0x15,
        PropertyPtr             = 0x16,
        
        Property                = 0x17,
        MethodSemantics         = 0x18,
        MethodImpl              = 0x19,
        ModuleRef               = 0x1A,
        TypeSpec                = 0x1B,
        ImplMap                 = 0x1C,
        FieldRVA                = 0x1D,
        EnClog                  = 0x1E,
        EnCMap                  = 0x1F,
        
        Assembly                = 0x20,
        AssemblyProcessor       = 0x21,
        AssemblyOS              = 0x22,
        AssemblyRef             = 0x23,
        AssemblyRefProcessor    = 0x24,
        AssemblyRefOS           = 0x25,
        File                    = 0x26,
        ExportedType            = 0x27,
        ManifestResource        = 0x28,
        NestedClass             = 0x29,
        GenericParam            = 0x2A,
        MethodSpec              = 0x2B,
        GenericParamConstraint  = 0x2C,
        MaxTables               = 0x2D
};

       

typedef struct table_descriptor{
        DWORD   b_valid;
        DWORD   dwNumberOfRows;                 //number of Raws Used...       
        DWORD   dwTableSize;
        CHAR    Name[MAX_PATH];                 //This keeps names which are used to match Indexes...
}TABLE_DESCRIPTOR, *PTABLE_DESCRIPTOR;

typedef struct _table_sizes_info{
        DWORD             HeapSizes;
        PTABLE_DESCRIPTOR  ptables;
}TABLE_SIZES_INFO, *PTABLE_SIZES_INFO;
        

DWORD  ParseMetaData(__in PVOID lpData,
                     __in CHAR *Table,
                     __in CHAR *Value,
                     __in PTABLE_SIZES_INFO ptabalesizes);

DWORD   GetTableOffset(__in CHAR *Table, 
                       __in PTABLE_SIZES_INFO ptablesizes);
DWORD   GetTableSize(__in CHAR *Table, __in PTABLE_SIZES_INFO ptablesizes);
DWORD   GetTableRows(__in CHAR *Table, __in PTABLE_SIZES_INFO ptablesizes);
PVOID   ParseBlobData(__in PVOID pblob, __out DWORD *dwBlobDataSize);

VOID    DisplayMetaDataTables(__in ULONGLONG Valid);

extern struct  container_struct *ModuleContainer;    

extern const   char    *Tables_Names[];

#define ADDPVOID(x,y)   (PVOID)((ULONG_PTR)x + y)


//structs used to describe and dump methods

#define CorILMethod_TinyFormat          0x2
#define CorILMethod_FatFormat           0x3
#define CorILMethod_MoreSects           0x8
#define CorILMethod_InitLocals          0x10

typedef struct _METHOD_TINYFORMAT{
        unsigned  char Flags:2;
        unsigned  char Size:6;
}Method_TinyFormat, *PMethod_TinyFormat;

typedef struct _METHOD_FATFORMAT{
        unsigned  short   Flags:12;
        unsigned  short   Size:4;     //Size:4; Size of this header expressed as the count of 4-byte integers occupied (currently 3) 
        unsigned  short   MaxStack;
        unsigned  int     CodeSize;
        unsigned  int     LocalVarSigTok;
}Method_FatFormat, *PMethod_FatFormat;
        