/****************************************************************************
 *   dotnet dumper
 *   Copyright (C) 2011  deroko of ARTeam
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ****************************************************************************/
 
#include        "defs.h"


TABLE_DESCRIPTOR        g_tables[MaxTables];

int __cdecl wmain(int argc, wchar_t **argv){
        PIMAGE_DOS_HEADER       pmz;
        PPEHEADER32             pe32;
        PPEHEADER64             pe64;
        PSECTION_HEADER         section;
        BOOL                    b_use64;
        HANDLE                  hFile, hSection;
        ULONG_PTR               mapped, lpBuffer;
        ULONG                   index, i, j;
        ULONG                   offset, rows, size;
        PIMAGE_COR20_HEADER     pcor;
        PMETADATA_HEADER        pmetadata;
        PMETADATA_HEADER_2      pmetadata2;
        PTABLE_HEADER           ptable;
        PSTREAM_HEADER          pstreams;
        PVOID                   lpString;
        PVOID                   lpData;
        ULONG                   dwNumberOfTables;
        ULONGLONG               Valid;
                
        PVOID                   pstrings;
        PVOID                   pus;
        PVOID                   pblob;
        PVOID                   pguid;
        PVOID                   ptables;
        
        PVOID                   pblobData, ptmp;
        DWORD                   blobDataSize;
        CHAR                    szManifestDump[MAX_PATH];
        PULONG                  pulong;
        DWORD                   dwWritten;
        
        TABLE_SIZES_INFO        tablesizes;
        PMethod_TinyFormat      pMethod_TinyFormat;
        PMethod_FatFormat       pMethod_FatFormat;

        printf("dotnet dumper - (c) 2011 deroko of ARTeam\n");

        if (argc != 2) return 1;
                
        hFile = CreateFile(argv[1], GENERIC_READ, FILE_SHARE_READ, 0, OPEN_EXISTING, 0,0);
        hSection = CreateFileMapping(hFile, 0, PAGE_READONLY, 0,0,0);
        mapped   = (ULONG_PTR)MapViewOfFile(hSection, FILE_MAP_READ, 0,0,0);
        
        pmz = (PIMAGE_DOS_HEADER)mapped;
        if (pmz->e_magic != IMAGE_DOS_SIGNATURE){
                printf("[X] Not MZ file...\n");
                return 1;
        }
        pe32= (PPEHEADER32)(mapped + pmz->e_lfanew);
        if (pe32->pe_magic == 0x20B){
                pe64 = (PPEHEADER64)(mapped + pmz->e_lfanew);
                section = (PSECTION_HEADER)((ULONG_PTR)pe64 + 4 + sizeof(IMAGE_FILE_HEADER) + pe32->pe_sizeofoptionalheader);
                lpBuffer = (ULONG_PTR)VirtualAlloc(0, pe64->pe_sizeofimage, MEM_COMMIT, PAGE_READWRITE);
                memcpy((void *)lpBuffer, (void *)mapped, pe64->pe_sizeofheaders);
                b_use64 = TRUE;
        }else{
                section = (PSECTION_HEADER)((ULONG_PTR)pe32 + 4 + sizeof(IMAGE_FILE_HEADER) + pe32->pe_sizeofoptionalheader);
                lpBuffer = (ULONG_PTR)VirtualAlloc(0, pe32->pe_sizeofimage, MEM_COMMIT, PAGE_READWRITE);
                memcpy((void *)lpBuffer, (void *)mapped, pe32->pe_sizeofheaders);
                b_use64 = FALSE;
        }
        
        //doesn't relly matter if pe32 or pe64 as pe_numberofsections is at same offset in PE header
        for (index = 0; index < pe32->pe_numberofsections; index++)
                memcpy((void *)(lpBuffer + section[index].sh_virtualaddress),
                       (void *)(mapped   + section[index].sh_pointertorawdata),
                       section[index].sh_sizeofrawdata);
        
        UnmapViewOfFile((PVOID)mapped);
        CloseHandle(hSection);
        CloseHandle(hFile);
        
        mapped = lpBuffer;
        
        pmz = (PIMAGE_DOS_HEADER)mapped;
        pe32= (PPEHEADER32)(mapped + pmz->e_lfanew);
        section = (PSECTION_HEADER)((ULONG_PTR)pe32 + 4 + sizeof(IMAGE_FILE_HEADER) + pe32->pe_sizeofoptionalheader);
        
        if (!pe32->pe_comdescriptor){
                printf("Not .NET file...\n");
                return 1;
        }
        
        pcor = (PIMAGE_COR20_HEADER)(lpBuffer + pe32->pe_comdescriptor);
                
        printf("pcor->cb                                     : %.08X\n", pcor->cb);
        printf("pcor->MajorRuntimeVersion                    : %.04X\n", pcor->MajorRuntimeVersion);
        printf("pcor->MinorRuntimeVersion                    : %.04X\n", pcor->MinorRuntimeVersion);
        printf("pcor->MetaData.VirtualAddress                : %.08X\n", pcor->MetaData.VirtualAddress);
        printf("pcor->MetaData.Size                          : %.08X\n", pcor->MetaData.Size);
        printf("pcor->Flags                                  : %.08X\n", pcor->Flags);
        printf("pcor->EntryPointToken or pcor->EntryPointRVA : %.08X\n", pcor->EntryPointToken);
        printf("pcor->Resources.VirtualAddress               : %.08X\n", pcor->Resources.VirtualAddress);
        printf("pcor->Resources.Size                         : %.08X\n", pcor->Resources.Size);
        printf("pcor->StrongNameSignature.VirtualAddress     : %.08X\n", pcor->StrongNameSignature.VirtualAddress);
        printf("pcor->StrongNameSignature.Size               : %.08X\n", pcor->StrongNameSignature.Size); 
        printf("pcor->CodeManagerTable.VirtualAddress        : %.08X\n", pcor->CodeManagerTable.VirtualAddress);
        printf("pcor->CodeManagerTable.Size                  : %.08X\n", pcor->CodeManagerTable.Size);
        printf("pcor->VTableFixups.VirtualAddress            : %.08X\n", pcor->VTableFixups.VirtualAddress);
        printf("pcor->VTableFixups.Size                      : %.08X\n", pcor->VTableFixups.Size);
        printf("pcor->ExportAddressTableJumps.VirtualAddress : %.08X\n", pcor->ExportAddressTableJumps.VirtualAddress);
        printf("pcor->ExportAddressTableJumps.Size           : %.08X\n", pcor->ExportAddressTableJumps.Size);
        printf("pcor->ManagedNativeHeader.VirtualAddress     : %.08X\n", pcor->ManagedNativeHeader.VirtualAddress);
        printf("pcor->ManagedNativeHeader.Size               : %.08X\n", pcor->ManagedNativeHeader.Size);
        
        
        pmetadata = (PMETADATA_HEADER)(mapped + pcor->MetaData.VirtualAddress);
        
        printf("pmetadata->Signature            : %.08X\n", pmetadata->Signature);
        printf("pmetadata->MajorVersion         : %.08X\n", pmetadata->MajorVersion);
        printf("pmetadata->MinorVersion         : %.08X\n", pmetadata->MinorVersion);
        printf("pmetadata->Reserved             : %.08X\n", pmetadata->Reserved);
        printf("pmetadata->Length               : %.08X\n", pmetadata->Length);
        
        lpString = GlobalAlloc(GPTR, pmetadata->Length + 2);
        memset(lpString, 0, pmetadata->Length + 2);
        memcpy(lpString, &pmetadata->Version, pmetadata->Length);
        
        printf("pmetadata->Version              : %s\n", lpString);
        GlobalFree(lpString);
        
        //now we need to jump to METADATA_HEADER_2 which is pmetadata->Vesrion + pmetadata->Length aligned on 4 byte boundary
        pmetadata2 = (PMETADATA_HEADER_2)((ULONG_PTR)&pmetadata->Version + pmetadata->Length);

        (ULONG_PTR)pmetadata2 = ((ULONG_PTR)pmetadata2 + 3) &~ 3;

        printf("pmetadata2->Flags               : %.04X\n", pmetadata2->Flags);
        printf("pmetadata2->Streams             : %.04X\n", pmetadata2->Streams);   
        
        pstreams = (PSTREAM_HEADER)&pmetadata2->StreamHeaders;
        
        //find all Streams (#blob, #us, #strings, #~, #guid)
        for (index = 0; index < pmetadata2->Streams; index++){
                printf("%d pstreams->Offset     : %.08X\n", index, pstreams->Offset);
                printf("%d pstreams->Size       : %.08X\n", index, pstreams->Size);
                printf("%d pstreams->Name       : %s\n",    index, &pstreams->Name);
                
                if (!_stricmp(pstreams->Name, "#~"))
                        ptable = (PTABLE_HEADER)((ULONG_PTR)pmetadata + pstreams->Offset);
                if (!_stricmp(pstreams->Name, "#US"))
                        pus    = (PVOID)((ULONG_PTR)pmetadata + pstreams->Offset);
                if (!_stricmp(pstreams->Name, "#Blob"))
                        pblob  = (PVOID)((ULONG_PTR)pmetadata + pstreams->Offset);
                if (!_stricmp(pstreams->Name, "#GUID"))
                        pguid= (PVOID)((ULONG_PTR)pmetadata + pstreams->Offset);
                if (!_stricmp(pstreams->Name, "#Strings"))
                        pstrings = (PVOID)((ULONG_PTR)pmetadata + pstreams->Offset);
                
                pstreams = (PSTREAM_HEADER)((ULONG_PTR)&pstreams->Name + strlen(pstreams->Name) + 1);
                (ULONG_PTR)pstreams = ((ULONG_PTR)pstreams + 3) &~3;
        }
        
        
        printf("Dumping #~ heap\n"); 
        printf(" + ptable->Reserved0    : %.08X\n", ptable->Reserved0);
        printf(" + ptable->MajorVersion : %.02X\n", ptable->MajorVersion);
        printf(" + ptable->MinorVersion : %.02X\n", ptable->MinorVersion);
        //Heaps tells us the size of index into Blob, and String heaps
        //so it can be 2 bytes or 4 bytes
        printf(" + ptable->HeapSizes    : %.02X\n",    ptable->HeapSizes);
        printf(" + ptable->Reserved1    : %.02X\n",    ptable->Reserved1);
        printf(" + ptable->Valid        : %.16llX\n",  ptable->Valid);
        printf(" + ptable->Sorted       : %.16llX\n",  ptable->Sorted);   
        
        dwNumberOfTables = 0;
        Valid = ptable->Valid;
        //for (i = 0; i < 8 * 8; i++){
        //        if (Valid & 1){
        //                g_tables[i].dwNumberOfRows = ptable->
        //                dwNumberOfTables++;
        //        }
        //        Valid = Valid >> 1;         
        //}
        //every bit above 0x2C is invalid, as no more then 0x2C tables exist...
        for (i = 0; i < MaxTables; i++){
                if (Valid & (1i64 << i)){
                        g_tables[i].dwNumberOfRows  = ptable->Rows[dwNumberOfTables];
                        g_tables[i].b_valid         = TRUE;
                        dwNumberOfTables++;
                }
                //alwasy copy name, even if table is invalid (eg. 0 rows)
                strcpy(g_tables[i].Name, Tables_Names[i]);               
        }
        
        tablesizes.HeapSizes = ptable->HeapSizes;
        tablesizes.ptables   = g_tables;
        
        for (i = 0; i < MaxTables; i++){
                if (g_tables[i].b_valid){
                        g_tables[i].dwTableSize = ParseMetaData(NULL, g_tables[i].Name, NULL, &tablesizes);
                }
        }
             
        printf(" + ptable->NumberOfTables = %d\n", dwNumberOfTables);    
        
        printf("Dumping rows : \n");
        for (i = 0; i < MaxTables; i++){
                if (g_tables[i].b_valid == TRUE){
                        printf(" + %-25s - Number of rows : %8d struct size : %4d\n", g_tables[i].Name, g_tables[i].dwNumberOfRows, g_tables[i].dwTableSize);
                }
        } 
        
        //DisplayMetaDataTables(ptable->Valid);
        //
        //for (i = 0; i < dwNumberOfTables; i++)
        //        printf("Number of rows : %d\n", ptable->Rows[i]);
        
        ptables = (PVOID)((ULONG_PTR)&ptable->Rows[0] + dwNumberOfTables * 4);                
        
        //try to get module name...
        offset = GetTableOffset("Module", &tablesizes);
        if (offset != 0xFFFFFFFF){
                rows   = GetTableRows  ("Module", &tablesizes);
                size   = GetTableSize  ("Module", &tablesizes);
                
                for (i = 0; i < rows; i++){
                        index = ParseMetaData(ADDPVOID(ptables,offset), "Module", "Name", &tablesizes);
                        if (index == 0)
                                printf("Module Name      : <null>\n");
                        else
                                printf("Module Name      : %s\n", (ULONG_PTR)pstrings + index);
                        offset += size;
                }   
        }

        
        offset = GetTableOffset("TypeRef", &tablesizes);
        if (offset != 0xFFFFFFFF){
                rows   = GetTableRows("TypeRef", &tablesizes);
                size   = GetTableSize("TypeRef", &tablesizes);
                
                for (i = 0; i < rows; i++){
                        index = ParseMetaData(ADDPVOID(ptables,offset), "TypeRef", "TypeName", &tablesizes);
                        if (index == 0)
                                printf("TypeRef TypeName      : <null>\n");
                        else
                                printf("TypeRef TypeName      : %s\n", (ULONG_PTR)pstrings + index);
                        index = ParseMetaData(ADDPVOID(ptables,offset), "TypeRef", "TypeNamespace", &tablesizes);
                        if (index == 0)
                                printf("TypeRef TypeNamespace : <null>\n");
                        else
                                printf("TypeRef TypeNamespace : %s\n", (ULONG_PTR)pstrings + index);
                        offset += size;
                }   
        }
        
        offset = GetTableOffset("TypeDef", &tablesizes);
        if (offset != 0xFFFFFFFF){
                rows   = GetTableRows  ("TypeDef", &tablesizes);
                size   = GetTableSize  ("TypeDef", &tablesizes);
                
                for (i = 0; i < rows; i++){
                        index = ParseMetaData(ADDPVOID(ptables,offset), "TypeDef", "TypeName", &tablesizes);
                        if (index == 0)
                                printf("TypeDef TypeName      : <null>\n");
                        else
                                printf("TypeDef TypeName      : %s\n", (ULONG_PTR)pstrings + index);
                        index = ParseMetaData(ADDPVOID(ptables,offset), "TypeDef", "TypeNamespace", &tablesizes);
                        if (index == 0)
                                printf("TypeDef TypeNamespace : <null>\n");
                        else
                                printf("TypeDef TypeNamespace : %s\n", (ULONG_PTR)pstrings + index);
                        offset += size;
                }   
        }
        
        offset = GetTableOffset("MethodDef", &tablesizes);
        if (offset != 0xFFFFFFFF){
                rows   = GetTableRows("MethodDef", &tablesizes);
                size   = GetTableSize("MethodDef", &tablesizes);
                
                for (i = 0; i < rows; i++){
                        index = ParseMetaData(ADDPVOID(ptables,offset), "MethodDef", "Name", &tablesizes);
                        if (index == 0)
                                printf("Method Name : <null>\n");
                        else
                                printf("Method Name : %s\n", (ULONG_PTR)pstrings + index);
                        
                        index = ParseMetaData(ADDPVOID(ptables,offset), "MethodDef", "RVA", &tablesizes);
                        printf("Method RVA  : %.08X\n", index);
                        
                        pMethod_TinyFormat = (PMethod_TinyFormat)(mapped + index);
                        pMethod_FatFormat  = (PMethod_FatFormat)(mapped + index);
                        if (pMethod_TinyFormat->Flags == CorILMethod_TinyFormat){
                                printf("MethodHeader Format     : Tiny\n");
                                printf("MethodHeader CodeSize   : %d\n", pMethod_TinyFormat->Size);
                        }else{
                                printf("MethodHeader Format     : Fat\n");
                                printf("MethodHeader CodeSize   : %d\n", pMethod_FatFormat->CodeSize);
                                printf("MethodHeader Size       : %d\n", pMethod_FatFormat->Size); 
                        }
                        offset += size;       
                }  
        }
        
        
        offset = GetTableOffset("Field", &tablesizes);
        if (offset != 0xFFFFFFFF){
                rows   = GetTableRows("Field", &tablesizes);
                size   = GetTableSize("Field", &tablesizes);
                
                for (i = 0; i < rows; i++){
                        index = ParseMetaData(ADDPVOID(ptables,offset), "Field", "Name", &tablesizes);
                        if (index == 0)
                                printf("Field Name : <null>\n");
                        else
                                printf("Field Name : %s\n", (ULONG_PTR)pstrings + index);
                        offset += size;
                }  
        }
        
        
        offset = GetTableOffset("ImplMap", &tablesizes);
        if (offset != 0xFFFFFFFF){
                rows   = GetTableRows("ImplMap", &tablesizes);
                size   = GetTableSize("ImplMap", &tablesizes);
                
                for (i = 0; i < rows; i++){
                        index = ParseMetaData(ADDPVOID(ptables,offset), "ImplMap", "ImportName", &tablesizes);
                        if (index == 0)
                                printf("ImplMap Name : <null>\n");
                        else
                                printf("ImplMap Name : %s\n", (ULONG_PTR)pstrings + index);
                        offset += size;
                }   
        }
        
        offset = GetTableOffset("Property", &tablesizes);
        if (offset != 0xFFFFFFFF){
                rows   = GetTableRows("Property", &tablesizes);
                size   = GetTableSize("Property", &tablesizes);
                
                for (i = 0; i < rows; i++){
                        index = ParseMetaData(ADDPVOID(ptables,offset), "Property", "Name", &tablesizes);
                        if (index == 0)
                                printf("Property Name : <null>\n");
                        else
                                printf("Property Name : %s\n", (ULONG_PTR)pstrings + index);
                        offset += size;
                }  
        }
        
        offset = GetTableOffset("ModuleRef", &tablesizes);
        if (offset != 0xFFFFFFFF){
                rows   = GetTableRows("ModuleRef", &tablesizes);
                size   = GetTableSize("ModuleRef", &tablesizes);
                
                for (i = 0; i < rows; i++){
                        index = ParseMetaData(ADDPVOID(ptables,offset), "ModuleRef", "Name", &tablesizes);
                        if (index == 0)
                                printf("ModuleRef Name : <null>\n");
                        else
                                printf("ModuleRef Name : %s\n", (ULONG_PTR)pstrings + index);
                        offset += size;
                } 
        }
        
        offset = GetTableOffset("Assembly", &tablesizes);
        if (offset != 0xFFFFFFFF){
                rows   = GetTableRows  ("Assembly", &tablesizes);
                size   = GetTableSize  ("Assembly", &tablesizes);
                
                for (i = 0; i < rows; i++){
                        index = ParseMetaData(ADDPVOID(ptables,offset), "Assembly", "Name", &tablesizes);
                        if (index == 0)
                                printf("Assembly Name : <null>\n");
                        else
                                printf("Assembly Name : %s\n", (ULONG_PTR)pstrings + index);      
                        index = ParseMetaData(ADDPVOID(ptables,offset), "Assembly", "HashAlgId", &tablesizes);
                        printf("Assembly HashId : %.08X\n", index);
                        index = ParseMetaData(ADDPVOID(ptables,offset), "Assembly", "PublicKey", &tablesizes);
                        if (index != 0){
                                pblobData = ParseBlobData(ADDPVOID(pblob,index), &blobDataSize);
                                printf("Assembly PublicKey : \n");
                                ptmp = pblobData;
                                for (index = 0; index < blobDataSize; index++){
                                        printf("%.02X ", *(PUCHAR)ptmp);        
                                        ptmp = ADDPVOID(ptmp,1);
                                }
                                printf("\n");
                                free(pblobData);
                        }
                        offset += size;
                }  
        }
        
        offset = GetTableOffset("AssemblyRef", &tablesizes);
        if (offset != 0xFFFFFFFF){
                rows   = GetTableRows  ("AssemblyRef", &tablesizes);
                size   = GetTableSize  ("AssemblyRef", &tablesizes);

                for (i = 0; i < rows; i++){
                        index = ParseMetaData(ADDPVOID(ptables,offset), "AssemblyRef", "Name", &tablesizes);
                        if (index == 0)
                                printf("AssemblyRef Name : <null>\n");
                        else
                                printf("AssemblyRef Name : %s\n", (ULONG_PTR)pstrings + index);
                                
                        index = ParseMetaData(ADDPVOID(ptables,offset), "AssemblyRef", "Culture", &tablesizes);
                        if (index == 0)
                                printf("AssemblyRef Culture : <null>\n");
                        else
                                printf("AssemblyRef Culture : %s\n", (ULONG_PTR)pstrings + index);
                                
                        index = ParseMetaData(ADDPVOID(ptables,offset), "AssemblyRef", "PublicKeyOrToken", &tablesizes);
                        if (index != 0){
                                pblobData = ParseBlobData(ADDPVOID(pblob,index), &blobDataSize);
                                printf("AssemblyRef PublicKeyOrToken : \n");
                                ptmp = pblobData;
                                for (index = 0; index < blobDataSize; index++){
                                        printf("%.02X ", *(PUCHAR)ptmp);        
                                        ptmp = ADDPVOID(ptmp,1);
                                }
                                printf("\n");
                                free(pblobData);
                        }
                        
                        index = ParseMetaData(ADDPVOID(ptables,offset), "AssemblyRef", "HashValue", &tablesizes);
                        if (index != 0){
                                pblobData = ParseBlobData(ADDPVOID(pblob,index), &blobDataSize);
                                printf("AssemblyRef HashValue : \n");
                                ptmp = pblobData;
                                for (index = 0; index < blobDataSize; index++){
                                        printf("%.02X ", *(PUCHAR)ptmp);        
                                        ptmp = ADDPVOID(ptmp,1);
                                }
                                printf("\n");
                                free(pblobData);
                        }
                        
                        
                        offset += size;
                }    
        }
        
        
        offset = GetTableOffset("ManifestResource", &tablesizes);
        if (offset != 0xFFFFFFFF){
                rows   = GetTableRows  ("ManifestResource", &tablesizes);
                size   = GetTableSize  ("ManifestResource", &tablesizes);
                
                for (i = 0; i < rows; i++){
                        index = ParseMetaData(ADDPVOID(ptables,offset), "ManifestResource", "Name", &tablesizes);
                        if (index == 0)
                                printf("ManifestResource Name : <null>\n");
                        else
                                printf("ManifestResource Name : %s\n", (ULONG_PTR)pstrings + index);
                        index = ParseMetaData(ADDPVOID(ptables,offset), "ManifestResource", "Flags", &tablesizes);
                        printf("ManifestResource Flags  : %.08X\n", index);
                        index = ParseMetaData(ADDPVOID(ptables,offset), "ManifestResource", "Offset", &tablesizes);
                        printf("ManifestResource Offset : %.08X\n", index);
                        index = ParseMetaData(ADDPVOID(ptables,offset), "ManifestResource", "Implementation", &tablesizes);
                        printf("ManifestResource Implementation : %.08X\n", index);
                        offset += size;
                }     
        }
        
        offset = GetTableOffset("File", &tablesizes);
        if (offset != 0xFFFFFFFF){
                rows = GetTableRows("File", &tablesizes);
                size = GetTableSize("File", &tablesizes);
                
                for (i = 0; i <rows; i++){
                        index = ParseMetaData(ADDPVOID(ptables,offset), "File", "Name", &tablesizes);
                        if (index == 0)
                                printf("File Name  : <null>\n");
                        else
                                printf("File Name  : %s\n", (ULONG_PTR)pstrings + index);        
                        offset += size;
                }
        }
        
        offset = GetTableOffset("GenericParam", &tablesizes);
        if (offset != 0xFFFFFFFF){
                rows   = GetTableRows  ("GenericParam", &tablesizes);
                size   = GetTableSize  ("GenericParam", &tablesizes);
                
                for (i = 0; i < rows; i++){
                        index = ParseMetaData(ADDPVOID(ptables,offset), "GenericParam", "Name", &tablesizes);
                        if (index == 0)
                                printf("GenericParam Name : <null>\n");
                        else
                                printf("GenericParam Name : %s\n", (ULONG_PTR)pstrings + index);
                        offset += size;
                }     
        }
        
        offset = GetTableOffset("Event", &tablesizes);
        if (offset != 0xFFFFFFFF){
                rows   = GetTableRows  ("Event", &tablesizes);
                size   = GetTableSize  ("Event", &tablesizes);
                
                for (i = 0; i < rows; i++){
                        index = ParseMetaData(ADDPVOID(ptables,offset), "Event", "Name", &tablesizes);
                        if (index == 0)
                                printf("Event Name : <null>\n");
                        else
                                printf("Event Name : %s\n", (ULONG_PTR)pstrings + index);
                        offset += size;
                }     
        }
        
        offset = GetTableOffset("ExportedType", &tablesizes);
        if (offset != 0xFFFFFFFF){
                rows   = GetTableRows  ("ExportedType", &tablesizes);
                size   = GetTableSize  ("ExportedType", &tablesizes);
                
                for (i = 0; i < rows; i++){
                        index = ParseMetaData(ADDPVOID(ptables,offset), "ExportedType", "Name", &tablesizes);
                        if (index == 0)
                                printf("ExportedType Name : <null>\n");
                        else
                                printf("ExportedType Name : %s\n", (ULONG_PTR)pstrings + index);
                        offset += size;
                }     
        }
        
        offset = GetTableOffset("Param", &tablesizes);
        if (offset != 0xFFFFFFFF){
                rows   = GetTableRows  ("Param", &tablesizes);
                size   = GetTableSize  ("Param", &tablesizes);
                
                for (i = 0; i < rows; i++){
                        index = ParseMetaData(ADDPVOID(ptables,offset), "Param", "Name", &tablesizes);
                        if (index == 0)
                                printf("Param Name : <null>\n");
                        else
                                printf("Param Name : %s\n", (ULONG_PTR)pstrings + index);
                        offset += size;
                }     
        }
                
        VirtualFree((PVOID)lpBuffer, 0, MEM_RELEASE);        
}