/****************************************************************************
 *   dotnet dumper
 *   Copyright (C) 2011  deroko of ARTeam
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ****************************************************************************/
 
#include        "defs.h"
#include        "parser.h"

BOOL    TestBit(__in ULONGLONG  value, __in ULONG bit){
        if (value & (1i64 << bit))
                return TRUE;
        return FALSE;       
}

VOID    DisplayMetaDataTables(__in ULONGLONG Valid){
        printf("MetaDataTables:\n");
        if (TestBit(Valid, Module))
                printf("        Module\n");
        if (TestBit(Valid, TypeRef))
                printf("        TypeRef\n");
        if (TestBit(Valid, TypeDef))
                printf("        TypeDef\n");
        if (TestBit(Valid, Field))
                printf("        Field\n");
        if (TestBit(Valid, MethodDef))
                printf("        MethodDef\n");
        if (TestBit(Valid, Param))
                printf("        Param\n");
        if (TestBit(Valid, InterfaceImpl))
                printf("        InterfaceImpl\n");
        if (TestBit(Valid, MemberRef))
                printf("        MemeberRef\n");
        if (TestBit(Valid, Constant))
                printf("        Constant\n");
        if (TestBit(Valid, CustomAttribute))
                printf("        CustomAttribute\n");
        if (TestBit(Valid, DeclSecurity))
                printf("        DeclSecruity\n");
        if (TestBit(Valid, ClassLayout))
                printf("        ClassLayout\n");
        if (TestBit(Valid, FieldLayout))
                printf("        FieldLayout\n");
        if (TestBit(Valid, StandAloneSig))
                printf("        StandAloneSig\n");
        if (TestBit(Valid, EventMap))
                printf("        EventMap\n");
        if (TestBit(Valid, PropertyMap))
                printf("        PropertyMap\n");
        if (TestBit(Valid, Property))
                printf("        Property\n");
        if (TestBit(Valid, MethodSemantics))
                printf("        MethodSemantics\n");
        if (TestBit(Valid, MethodImpl))
                printf("        MethodImpl\n");
        if (TestBit(Valid, ModuleRef))
                printf("        ModuleRef\n");
        if (TestBit(Valid, TypeSpec))
                printf("        TypeSpec\n");
        if (TestBit(Valid, ImplMap))
                printf("        ImplMap\n");
        if (TestBit(Valid, FieldRVA))
                printf("        FieldRVA\n");
        if (TestBit(Valid, Assembly))
                printf("        Assembly\n");
        if (TestBit(Valid, AssemblyProcessor))
                printf("        AssemblyProcessor\n");
        if (TestBit(Valid, AssemblyOS))
                printf("        AssemblyOS\n");
        if (TestBit(Valid, AssemblyRef))
                printf("        AssemblyRef\n");
        if (TestBit(Valid, AssemblyRefProcessor))
                printf("        AssemblyRefProcessor\n");
        if (TestBit(Valid, AssemblyRefOS))
                printf("        AssemblyRefOS\n");
        if (TestBit(Valid, File))
                printf("        File\n");
        if (TestBit(Valid, ExportedType))
                printf("        ExportedType\n");
        if (TestBit(Valid, ManifestResource))
                printf("        ManifestResource\n");
        if (TestBit(Valid, NestedClass))
                printf("        NastedClass\n");
        if (TestBit(Valid, GenericParam))
                printf("        GenericParam\n");
        if (TestBit(Valid, MethodSpec))
                printf("        MethodSpec\n");
        if (TestBit(Valid, GenericParamConstraint))
                printf("        GenericParamConstraint\n");   
}

DWORD  ParseMetaData(__in PVOID lpData, __in CHAR *Table, CHAR *Value, __in PTABLE_SIZES_INFO ptablesizes){
        DWORD   dwPosition = 0;
        DWORD   dwSize;
        PULONG  plong;
        PUSHORT pshort;
        PUCHAR  pchar;
        DWORD   index, i, j;
        DWORD   maximumrows;
        CHAR    *str;
        struct  container_struct  *pcontainer;
        struct  containers        *pcontainers;
        
        pcontainers = containers;
        while (pcontainers->Name != NULL){
                if (!_stricmp(pcontainers->Name, Table)){
                        pcontainer = pcontainers->pcont;
                        break;
                }
                pcontainers++;
        }

        while (pcontainer->Name != NULL){
                if (!_stricmp(pcontainer->Type, "dword"))
                        dwSize = 4;
                else if (!_stricmp(pcontainer->Type, "word"))
                        dwSize = 2;
                else if (!_stricmp(pcontainer->Type, "byte"))
                        dwSize = 1;
                else if (!_stricmp(pcontainer->Type, "index blob")){
                        if (ptablesizes->HeapSizes & BLOB_HEAP_SIZE)
                                dwSize = 4;
                        else
                                dwSize = 2;
                }else if (!_stricmp(pcontainer->Type, "index string")){
                        if (ptablesizes->HeapSizes & STRINGS_HEAP_SIZE)
                                dwSize = 4;
                        else
                                dwSize = 2;
                }else if (!_stricmp(pcontainer->Type, "index guid")){
                        if (ptablesizes->HeapSizes & GUID_HEAP_SIZE)
                                dwSize = 4;
                        else
                                dwSize = 2;
                
                }else if (strstr(pcontainer->Type, "index coded ")){
                        //each coded index takes a few low bits to tell which table
                        //it's indexing. This depends on coded index to coded index
                        //some take 1 bit, some 2, 3 or 5 bits, so to check if coded
                        //index is 2 or 4 bytes we have to see what's the maximum number
                        //of rows that biggest table it can address has and do comparasion:
                        //if (maximumrows < pow(2, (16-bitsused))
                        //      index size = 2
                        //else
                        //      index size = 4
                        //example for Implementation coded index which is 2 bits
                        //if (maximumrows < pow(2, (16-2))
                        //      index size = 2
                        //else
                        //      index size = 4
                        str = &pcontainer->Type[strlen("index coded ")];
                        //now loop through indexes to find proper index_coded table
                        i = 0;
                        dwSize = 0xFFFFFFFF;
                        while (index_coded[i].Name != NULL){
                                if (!_stricmp(index_coded[i].Name, str)){
                                        maximumrows = 0;
                                        //we found coded index in index_coded table...        
                                        j = 0;
                                        //check each value in ptablesizes->ptables->Name/dwNumberOfRows
                                        while (index_coded[i].Values[j] != NULL){
                                                for (index = 0; index < MaxTables; index++){
                                                        if (ptablesizes->ptables[index].b_valid == FALSE) continue;       
                                                        if (!_stricmp(ptablesizes->ptables[index].Name, index_coded[i].Values[j]))
                                                                if (maximumrows < ptablesizes->ptables[index].dwNumberOfRows)
                                                                        maximumrows = ptablesizes->ptables[index].dwNumberOfRows;
                                                }
                                                j++;        
                                        }
                                        
                                        //we have found maximum rows, now simply do comparasion...
                                        if (maximumrows < (DWORD)pow((double)2, (double)(16 - index_coded[i].BitsUsed)))
                                                dwSize = 2;
                                        else    
                                                dwSize = 4;
                                        break;
                                }
                                i++;              
                        }
                        
                        if (dwSize == 0xFFFFFFFF){
                                printf("Error parsing coded index : %s\n", str);
                                __debugbreak();
                        }
                        
                }else if (strstr(pcontainer->Type, "index simple ")){
                        //we have simple index, thus we need only to find this field
                        //in ptablesizes->ptables[index].Name and check how many rows are there
                        //which is very simply...
                        dwSize = 0xFFFFFFFF; 
                        str = &pcontainer->Type[strlen("index simple ")];
                        for (index = 0; index < MaxTables; index++){
                                if (!_stricmp(ptablesizes->ptables[index].Name, str)){
                                        if (ptablesizes->ptables[index].dwNumberOfRows < 0x10000){
                                                dwSize = 2;
                                                break;
                                        }else{
                                                dwSize = 4; 
                                                break;
                                        }       
                                }                
                        } 
                        if (dwSize == 0xFFFFFFFF){
                                printf("%s - Invalid index simple : %s\n", Table, pcontainer->Type);
                                __debugbreak();
                        }
                }else{
                        printf("Unknown Type : %s\n", pcontainer->Type);
                        __debugbreak();        
                }
                
                                        
                if (Value != NULL && !_stricmp(pcontainer->Name, Value)){
                        if (dwSize == 1)
                                return *(PUCHAR)((ULONG_PTR)lpData + dwPosition);
                        else if (dwSize == 2)
                                return *(PUSHORT)((ULONG_PTR)lpData + dwPosition);
                        else if (dwSize == 4)
                                return *(PULONG)((ULONG_PTR)lpData + dwPosition);                        
                        else
                                return 0;
                        
                }else{
                        dwPosition+=dwSize;
                }
                pcontainer++;
        }        
        
        if (Value == NULL)
                return dwPosition;
        return 0;    
}

DWORD   GetTableOffset(__in CHAR *Table, __in PTABLE_SIZES_INFO ptablesizes){
        ULONG   index;
        DWORD   Offset = 0;
        
        for (index = 0; index < MaxTables; index++){
                if (ptablesizes->ptables[index].b_valid == FALSE) continue;
                if (!_stricmp(ptablesizes->ptables[index].Name, Table))
                        return Offset;        
                Offset += (ptablesizes->ptables[index].dwNumberOfRows * ptablesizes->ptables[index].dwTableSize);
        }        
        return (DWORD)-1;
}

DWORD   GetTableRows(__in CHAR *Table, __in PTABLE_SIZES_INFO ptablesizes){
        ULONG   index;
        
        for (index = 0; index < MaxTables; index++){
                if (ptablesizes->ptables[index].b_valid == FALSE) continue;
                if (!_stricmp(ptablesizes->ptables[index].Name, Table))
                        return ptablesizes->ptables[index].dwNumberOfRows;
        }        
        return (DWORD)-1;
}        

DWORD   GetTableSize(__in CHAR *Table, __in PTABLE_SIZES_INFO ptablesizes){
        ULONG   index;
        
        for (index = 0; index < MaxTables; index++){
                if (ptablesizes->ptables[index].b_valid == FALSE) continue;
                if (!_stricmp(ptablesizes->ptables[index].Name, Table))
                        return ptablesizes->ptables[index].dwTableSize;
        }        
        return (DWORD)-1;
}   
/***********************************************************************************
 * Parsing blob data is easy:
 *   If the first one byte of the 'blob' is 0bbbbbbb2, then the rest of the 'blob' contains the bbbbbbb2 
 *    bytes of actual data. 
 *   If the first two bytes of the 'blob' are 10bbbbbb2 and x, then the rest of the 'blob' contains the 
 *    (bbbbbb2 << 8 + x) bytes of actual data. 
 *   If the first four bytes of the 'blob' are 110bbbbb2, x, y, and z, then the rest of the 'blob' contains the 
 *    (bbbbb2 << 24 + x << 16 + y << 8 + z) bytes of actual data.  
 ***********************************************************************************/
PVOID   ParseBlobData(__in PVOID pblobArgument, __out DWORD *dwBlobDataSize){
        PUCHAR  pblob;
        PVOID   lpret  = NULL;
        
        pblob = pblobArgument;
        
        if (!(pblob[0] & 0x80)){
                lpret = malloc(pblob[0]);
                memcpy(lpret, &pblob[1], pblob[0]);
                *dwBlobDataSize = pblob[0];
        }
                
        if ((pblob[0] >> 6) == 0x2){
                *dwBlobDataSize = ((pblob[0] & 0x3F) << 8) + pblob[1];
                lpret = malloc(*dwBlobDataSize);
                memcpy(lpret, &pblob[2], *dwBlobDataSize);
        }
        
        if ((pblob[0] >> 5) == 0x6){
                *dwBlobDataSize = (((pblob[0] & 0x1F) << 24) + (pblob[1] << 16) + (pblob[2] << 8) + pblob[3]);
                lpret = malloc(*dwBlobDataSize);
                memcpy(lpret, &pblob[3], *dwBlobDataSize);
        }
        
        return lpret;
}

const   char    *Tables_Names[] = {
        {"Module"               },                  //= 0x00,
        {"TypeRef"              },                 //= 0x01,
        {"TypeDef"              },   //= 0x02, 
        {"FieldPtr"             },   //= 0x03
        {"Field"},                   //= 0x04,
        {"MethodPtr"            },   //= 0x05
        {"MethodDef"},               //= 0x06,
        {"ParamPtr"},                     //= 0x07
        {"Param"},                   //= 0x08,
        {"InterfaceImpl"},           //= 0x09,
        {"MemberRef"},               //= 0x0A,
        {"Constant"},                //= 0x0B,
        {"CustomAttribute"},         //= 0x0C,
        {"FieldMarshal"},                      //0x0D
        {"DeclSecurity"},            //= 0x0E,
        {"ClassLayout"},             //= 0x0F,
        {"FieldLayout"},             //= 0x10,
        {"StandAloneSig"},           //= 0x11,
        {"EventMap"},                //= 0x12,
        {"EventPtr"},                     //
        {"Event"},                     //
        {"PropertyMap"},             //= 0x15,
        {"PropertyPtr"},                     //
        {"Property"},                //= 0x17,
        {"MethodSemantics"},         //= 0x18,
        {"MethodImpl"},              //= 0x19,
        {"ModuleRef"},               //= 0x1A,
        {"TypeSpec"},                //= 0x1B,
        {"ImplMap"},                 //= 0x1C,
        {"FieldRVA"},                //= 0x1D,
        {"EnClog"},                     //
        {"EnCMap"},                     //
        {"Assembly"},                //= 0x20,
        {"AssemblyProcessor"},       //= 0x21,
        {"AssemblyOS"},              //= 0x22,
        {"AssemblyRef"},             //= 0x23,
        {"AssemblyRefProcessor"},    //= 0x24,
        {"AssemblyRefOS"},           //= 0x25,
        {"File"},                    //= 0x26,
        {"ExportedType"},            //= 0x27,
        {"ManifestResource"},        //= 0x28,
        {"NestedClass"},             //= 0x29,
        {"GenericParam"},            //= 0x2A,
        {"MethodSpec"},              //= 0x2B,
        {"GenericParamConstraint"},  //= 0x2C,
        {"MaxTables"}               //= 0x2D
};