.586p
.model  flat, stdcall
locals
jumps

include                 ring0.inc
include                 apimacro.mac
include                 c:\tasm32\include\shitheap.inc

public C start

.data
driver:                 unis    <\Device\fakerdtsc>
symlink:                unis    <\??\fakerdtsc>
driver_us               unicode_string  <0>
sym_us                  unicode_string <0>
pdeviceobject           dd      ?

.code
start:                  push    ebp             ;ebp+8 pDriverObject, ebp+0c pReg
                        mov     ebp, esp
                        pushad 
                        
                        push    offset driver
                        push    offset driver_us
                        iWin32  RtlInitUnicodeString
                        
                        push    offset  pdeviceobject
                        push    0
                        push    0
                        push    FILE_DEVICE_UNKNOWN
                        push    offset driver_us
                        push    0
                        push    dword ptr[ebp+8]
                        iWin32  IoCreateDevice
                        test    eax, eax
                        jnz     __fail_init
                        
                        push    offset symlink
                        push    offset sym_us
                        iWin32  RtlInitUnicodeString
                        
                        push    offset driver_us
                        push    offset sym_us
                        iWin32  IoCreateSymbolicLink
                        test    eax, eax
                        jnz     __deletedevice
                        
                        mov     eax, [ebp+8]
                        mov     [eax.dro_majorfunctions.irp_mj_create], offset RequestHandler
                        mov     [eax.dro_majorfunctions.irp_mj_close], offset RequestHandler
                        mov     [eax.dro_majorfunctions.irp_mj_device_control], offset ServiceHandler
                        mov     [eax.dro_DriverUnload], offset DriverUnload
                        xor     eax, eax
                        jmp     __exit_init

__deletedevice:         push    pdeviceobject
                        iWin32  IoDeleteDevice

__fail_init:            mov     eax, 1        
               
__exit_init:            mov     [esp.Pushad_eax], eax
                        popad
                        pop     ebp
                        ret     8
                        
RequestHandler:         mov     ecx, [esp+8]            ;[esp+4] pDriverObject [esp+8] pIrp
                        mov     [ecx.irp_iostatus.iob_status], 0
                        mov     [ecx.irp_iostatus.iob_information], 0
                        xor     edx, edx
                        iWin32  IofCompleteRequest
                        xor     eax, eax
                        ret     8

DriverUnload:           push    offset sym_us           ;[esp+4] pDriverObject
                        iWin32  IoDeleteSymbolicLink
                        mov     eax, [esp+4]
                        push    [eax.dro_deviceobject]
                        iWin32  IoDeleteDevice
                        ret     4
                        
ServiceHandler:         push    ebp                     ;ebp+8 pDriverObject, ebp+0c Irp
                        mov     ebp, esp
                        pushad
                                                                       
                        mov     ecx, [ebp+0ch]          ;pIrp
                        mov     eax, [ecx.irp_tail.t_CurrentStackLocation]
                        cmp     [eax.isl_IoControlCode], 20h
                        jne     __sh_fail
                                             
                        mov     eax, [ecx.irp_systembuffer]
                        mov     eax, [eax]
                        cmp     eax, 'hook'
                        je      __hook
                        cmp     eax, 'unho'
                        jne     __sh_fail
                        
                        cli
                        call    unhookrdtsc
                        sti
                        jmp     __sh_oki

__hook:                 cli
                        call    hookrdtsc
                        sti
                        
__sh_oki:               mov     ecx, [ebp+0ch]
                        xor     edx, edx
                        iWin32  IofCompleteRequest
                        xor     eax, eax
                        jmp     __sh_exit
                        
__sh_fail:              mov     ecx, [ebp+0ch]
                        xor     edx, edx
                        iWin32  IofCompleteRequest
                        mov     eax, 1
__sh_exit:              mov     [esp.Pushad_eax], eax
                        popad
                        pop     ebp
                        ret     8
                        
hookrdtsc:              cmp     hooked, 1
                        je      __donothook
                        mov     eax, cr4
                        or      eax, 4
                        mov     cr4, eax
                        
                        sidt    fword ptr[idttable]
                        mov     esi, dword ptr[idttable+2]
                        lea     eax, [esi+0dh*8]
                        
                        mov     bx, word ptr[eax+6]
                        rol     ebx, 16
                        mov     bx, word ptr[eax]
                        
                        mov     int0dhoffset, eax
                        mov     oldint0dh, ebx
                        
                        mov     ebx, offset newint0dh
                        mov     word ptr[eax], bx
                        rol     ebx, 16
                        mov     word ptr[eax+6], bx
                        
                        mov     hooked, 1
__donothook:            ret
                        
unhookrdtsc:            cmp     hooked, 1
                        jne     __donotunhook
                        mov     eax, cr4
                        and     eax, 0FFFFFFFBh
                        mov     cr4, eax
                        
                        mov     eax, int0dhoffset
                        mov     ebx, oldint0dh
                        
                        mov     word ptr[eax], bx
                        rol     ebx, 16
                        mov     word ptr[eax+6], bx
                        
                        mov     hooked, 0
__donotunhook:          ret                        
                        
idttable                dq      ?
int0dhoffset            dd      ?
oldint0dh               dd      ?
hooked                  dd      0

newint0dh:              initint
                        cmp     [esp.inte_cs], 1bh
                        jne     __passdown
                        iMOV    ebx, MmHighestUserAddress
                        mov     ebx, [ebx]
                        mov     eax, [esp.inte_eip]
                        cmp     eax, ebx
                        jnb     __passdown
                        cmp     word ptr[eax], 310fh
                        jne     __passdown
                        
                        add     [esp.inte_eip], 2
                        restoreint
                        xor     edx, edx
                        xor     eax, eax
                        add     esp, 4
                        iretd

__passdown:             restoreint
                        jmp     cs:[oldint0dh]
                        
end                     start