.586p
.model  flat, stdcall
locals
jumps

include                 c:\tasm32\include\shitheap.inc
include                 apimacro.mac
include                 ring0.inc

public  C start

.data
driver:                 unis    <\Device\ring0>
symlink:                unis    <\??\ring0>
driver_us               unicode_string <0>
sym_us                  unicode_string <0>
pdeviceobject           dd      ?
.code
start:                  ;[ebp+8] pDriverObject [ebp+0ch] pRegPatch
                        push    ebp
                        mov     ebp, esp
                        pushad
                        
                        push    offset driver
                        push    offset driver_us
                        iWin32  RtlInitUnicodeString
                        
                        push    offset pdeviceobject
                        push    0
                        push    0
                        push    FILE_DEVICE_UNKNOWN
                        push    offset driver_us
                        push    0
                        push    dword ptr[ebp+8]
                        iWin32  IoCreateDevice
                        test    eax, eax
                        jnz     __failinit
                        
                        push    offset symlink
                        push    offset sym_us
                        iWin32  RtlInitUnicodeString
                        
                        push    offset driver_us
                        push    offset sym_us
                        iWin32  IoCreateSymbolicLink
                        test    eax, eax
                        jnz     __deletedevice
                        
                        mov     eax, [ebp+8]                    ;pDriverObject

                        mov     [eax.dro_majorfunctions.irp_mj_create], offset RequestHandler     
                        mov     [eax.dro_majorfunctions.irp_mj_close], offset RequestHandler    
                        mov     [eax.dro_majorfunctions.irp_mj_device_control], offset ServiceHandler     
                        mov     [eax.dro_DriverUnload], offset DriverUnload                           
                                                
                        xor     eax, eax
                        jmp     __exitinit                        
                        
__deletedevice:         push    pdeviceobject
                        iWin32  IoDeleteDevice      
                        
__failinit:             mov     eax, 1
                        
__exitinit:             mov     [esp.Pushad_eax], eax
                        popad
                        pop     ebp
                        ret     8
                        
RequestHandler:         ;[esp+4] pDeviceObject, [esp+8] pIrp
                        mov     ecx, [esp+8]
                        mov     [ecx.irp_iostatus.iob_status], 0
                        mov     [ecx.irp_iostatus.iob_information], 0
                        xor     edx, edx
                        iWin32  IofCompleteRequest
                        xor     eax, eax
                        ret     8

DriverUnload:           ;pDriverObject  [esp+4]
                        push    offset sym_us
                        iWin32  IoDeleteSymbolicLink

                        mov     eax, [esp+4]
                        push    [eax.dro_deviceobject]
                        iWin32  IoDeleteDevice
                        ret     4

ServiceHandler:         ;[ebp+8] pDeviceObject, [ebp+0ch] pIrp
                        push    ebp
                        mov     ebp, esp
                        pushad
                        
                        mov     ebx, [ebp+0ch]  ;pIrp
                        mov     edx, [ebx.irp_tail.t_CurrentStackLocation]  
                        mov     eax, [edx.isl_IoControlCode ]
                        
                        cmp     eax, 20h
                        jne     __sh_fail
                        mov     eax, [ebx.irp_systembuffer]
                        
                        cmp     [eax], 'hook'
                        je      __hook
                        cmp     [eax], 'unho'
                        jne     __sh_fail
                                            
                        iWin32  KeRaiseIrqlToDpcLevel                                               
                        call    unhook
                        xor     ecx, ecx
                        iWin32  KfLowerIrql
                                                
                        jmp     __sh_oki
                        
__hook:                 iWin32  KeRaiseIrqlToDpcLevel   ;make sure that no thread is running atm
                        call    hook                       
                        xor     ecx, ecx
                        iWin32  KfLowerIrql             ;lower irql to passive_level
                        
                        
__sh_oki:               mov     ecx, [ebp+0ch]
                        xor     edx, edx
                        iWin32  IofCompleteRequest
                        xor     eax, eax
                        jmp     __sh_exit
                        
__sh_fail:              mov     ecx, [ebp+0ch]
                        xor     edx, edx
                        iWin32  IofCompleteRequest                       
                        mov     eax, 1            
                                    
__sh_exit:              mov     [esp.Pushad_eax], eax
                        popad
                        pop     ebp
                        ret     8                        

;
; responsible for locating IopXxxControlFile and hooking it
;
hook:                   cmp     hooked, 1
                        je      __hooked
                        
                        iMOV    esi, NtDeviceIoControlFile
                        mov     edi, esi
                        xor     ecx, ecx
                        
__trytolocate:          push    esi
                        call    ldex86
                        inc     ecx
                        add     esi, eax
                        cmp     byte ptr[esi], 0e8h
                        je      __foundsomething
                        cmp     ecx, 20
                        je      __hooked
                        jmp     __trytolocate

__foundsomething:       mov     eax, [esi+1]
                        add     esi, 5
                        add     esi, eax                ;at this point _IopXxxControlFile should be in ESI
                        mov     IopXxxControlFile, esi
                        
                        xor     ecx, ecx
__get6bytes:            push    esi
                        call    ldex86
                        add     ecx, eax
                        add     esi, eax
                        cmp     ecx, 6
                        jb      __get6bytes
                        
                        mov     goback, esi
                        mov     oldbytessize, ecx
                        mov     esi, IopXxxControlFile
                        mov     edi, offset oldbytes
                        cld
                        rep     movsb
                        
                        mov     eax, cr0
                        mov     c_cr0, eax
                        and     eax, 0FFFEFFFFh
                        mov     cr0, eax
                        
                        mov     edi, IopXxxControlFile
                        mov     al, 68h 
                        stosb
                        mov     eax, offset myhookcode
                        stosd
                        mov     al, 0c3h
                        stosb
                        
                        mov     eax, c_cr0
                        mov     cr0, eax
                                                
                        mov     hooked, 1
__hooked:               ret


;
; Responsible for unhooking of IopXxxControlFile
;
unhook:                 cmp     hooked, 1
                        jne     __unhookwhat
                        
                        mov     eax, cr0
                        mov     c_cr0, eax
                        and     eax, 0FFFEFFFFh
                        mov     cr0, eax
                        
                        mov     edi, IopXxxControlFile
                        mov     esi, offset oldbytes
                        mov     ecx, oldbytessize
                        cld
                        rep     movsb
                        
                        mov     eax, c_cr0
                        mov     cr0, eax 
                        
                        mov     hooked, 0
__unhookwhat:           ret

;
; hook code for IopXxxControlFile
; this part should be stored in NonPagedPool to avoid possible bsod
; never encountered it, but it might happen 
;
;ebp-4 ptr to objecthandle
myhookcode:             push    ebp
                        mov     ebp, esp
                        sub     esp, 4                          ;allocate data for object_body
                        pushad
                                                            
                        push    0                               ;handle!?!? 0...
                        lea     eax, [ebp-4]
                        push    eax                             ;retrive ptr to pobject
                        push    1                               ;UserMode
                        iMOV    ebx, IoFileObjectType   
                        push    dword ptr[ebx]                  ;IoFileObjectType
                        push    0                               ;Acess
                        push    dword ptr[ebp+8]                ;handle of device
                        iWin32  ObReferenceObjectByHandle                        
                        test    eax, eax 
                        jnz     __obgetfail
 
                        mov     eax, [ebp-4]
                        mov     eax, [eax.fo_deviceobject]      ;eax = file_object.deviceobject
                        sub     eax, 18h                        ;addres of OBJECT_HEADER of device_object
                        movzx   ebx, [eax.ob_objectname]        ;offset to OBJECT_NAME
                        test    ebx, ebx                        ;zero???
                        jz      __dereference_object            ;no name for this device!?!? strange :D
                        
                        sub     eax, ebx                        ;get pointer to OBJECT_NAME
                        mov     esi, [eax.obname_name.us_buff]  ;buffer...
                        movzx   ecx, [eax.obname_name.us_len]   ;len...           
                        shr     ecx, 1                          
                        
                        push    esi
                        push    ecx
                        
                        mov     edi, offset oreans1             ;orean32 device?
                        cld
                        repe    cmpsw
                        
                        pop     ecx
                        pop     esi
                        
                        jz      __found_oreans
                        
                        mov     edi, offset oreans2             ;XPROTECTOR device?
                        repe    cmpsw
                        jz      __found_oreans
                        jmp     __dereference_object
                        
__found_oreans:         push    dword ptr[ebp+1ch]              ;ioctl code
                        pushs   <"Oreans IOCTL : 0x%.08X", 13, 10>
                        iWin32  DbgPrint
                        add     esp, 8
                        
__dereference_object:   push    dword ptr[ebp-4]
                        iWin32  ObDereferenceObject

__obgetfail:            popad         
                        mov     esp, ebp
                        pop     ebp    
oldbytes:               db      30      dup(90h)
                        jmp     cs:[goback]


oreans1:                unis    <oreans32>
oreans2:                unis    <XPROTECTOR>
              
hooked                  dd      0                        
oldbytessize            dd      ?
goback                  dd      ?
IopXxxControlFile       dd      ?
c_cr0                   dd      ?

include                 ldex86bin.inc
end                     start

:u NtDeviceIoControlFile L 100
_NtDeviceIoControlFile
0008:80578BD0  MOV       EDI,EDI
0008:80578BD2  PUSH      EBP
0008:80578BD3  MOV       EBP,ESP
0008:80578BD5  PUSH      01
0008:80578BD7  PUSH      DWORD PTR [EBP+2C]
0008:80578BDA  PUSH      DWORD PTR [EBP+28]
0008:80578BDD  PUSH      DWORD PTR [EBP+24]
0008:80578BE0  PUSH      DWORD PTR [EBP+20]
0008:80578BE3  PUSH      DWORD PTR [EBP+1C]
0008:80578BE6  PUSH      DWORD PTR [EBP+18]
0008:80578BE9  PUSH      DWORD PTR [EBP+14]
0008:80578BEC  PUSH      DWORD PTR [EBP+10]
0008:80578BEF  PUSH      DWORD PTR [EBP+0C]    
0008:80578BF2  PUSH      DWORD PTR [EBP+08]    
0008:80578BF5  CALL      _IopXxxControlFile   ;relative call e8
0008:80578BFA  POP       EBP
0008:80578BFB  RET       0028

_IopXxxControlFile
0008:805767D7  PUSH      68                     ;2 bytes 
0008:805767D9  PUSH      804E64A8               ;5 bytes = 7 bytes
0008:805767DE  CALL      __SEH_prolog

kd> !object \device\ring0
Object: fec79c88  Type: (81fb6788) Device
    ObjectHeader: fec79c70
    HandleCount: 0  PointerCount: 2
    Directory Object: e100d608  Name: ring0
kd> dt nt!_FILE_OBJECT 81d2aa20         POBJECT returned by by ObReferenceObjectByHandle
   +0x000 Type             : 5          <---- IO_TYPE_FILE        
   +0x002 Size             : 112
   +0x004 DeviceObject     : 0xfec79c88 <---- ptr to DEVICE_OBJECT 
   +0x008 Vpb              : (null)
   +0x00c FsContext        : (null)
   +0x010 FsContext2       : (null)
   +0x014 SectionObjectPointer : (null)
   +0x018 PrivateCacheMap  : (null)
   +0x01c FinalStatus      : 0
   +0x020 RelatedFileObject : (null)
   +0x024 LockOperation    : 0 ''
   +0x025 DeletePending    : 0 ''
   +0x026 ReadAccess       : 0 ''
   +0x027 WriteAccess      : 0 ''
   +0x028 DeleteAccess     : 0 ''
   +0x029 SharedRead       : 0 ''
   +0x02a SharedWrite      : 0 ''
   +0x02b SharedDelete     : 0 ''
   +0x02c Flags            : 0x40002
   +0x030 FileName         : _UNICODE_STRING ""
   +0x038 CurrentByteOffset : _LARGE_INTEGER 0x0
   +0x040 Waiters          : 0
   +0x044 Busy             : 0
   +0x048 LastLock         : (null)
   +0x04c Lock             : _KEVENT
   +0x05c Event            : _KEVENT
   +0x06c CompletionContext : (null)
kd> dt nt!_DEVICE_OBJECT fec79c88
   +0x000 Type             : 3          <---- IO_TYPE_DEVICE
   +0x002 Size             : 0xb8
   +0x004 ReferenceCount   : 1
   +0x008 DriverObject     : 0x8136b1e8 <---- ptr to DRIVER_OBJECT 
   +0x00c NextDevice       : (null)
   +0x010 AttachedDevice   : (null)
   +0x014 CurrentIrp       : (null)
   +0x018 Timer            : (null)
   +0x01c Flags            : 0x40
   +0x020 Characteristics  : 0
   +0x024 Vpb              : (null)
   +0x028 DeviceExtension  : (null)
   +0x02c DeviceType       : 0x22
   +0x030 StackSize        : 1 ''
   +0x034 Queue            : __unnamed
   +0x05c AlignmentRequirement : 0
   +0x060 DeviceQueue      : _KDEVICE_QUEUE
   +0x074 Dpc              : _KDPC
   +0x094 ActiveThreadCount : 0
   +0x098 SecurityDescriptor : 0xe150a178
   +0x09c DeviceLock       : _KEVENT
   +0x0ac SectorSize       : 0
   +0x0ae Spare1           : 0
   +0x0b0 DeviceObjectExtension : 0xfec79d40
   +0x0b4 Reserved         : (null)
kd> dt nt!_DRIVER_OBJECT 8136b1e8
   +0x000 Type             : 4          <---- IO_TYPE_DRIVER
   +0x002 Size             : 168
   +0x004 DeviceObject     : 0xfec79c88 
   +0x008 Flags            : 0x12
   +0x00c DriverStart      : 0xf70af000
   +0x010 DriverSize       : 0xac0
   +0x014 DriverSection    : 0xff490008
   +0x018 DriverExtension  : 0x8136b290
   +0x01c DriverName       : _UNICODE_STRING "\Driver\ring0.sys"
   +0x024 HardwareDatabase : 0x80686e90  "\REGISTRY\MACHINE\HARDWARE\DESCRIPTION\SYSTEM"
   +0x028 FastIoDispatch   : (null)
   +0x02c DriverInit       : 0xf70af2a0    
   +0x030 DriverStartIo    : (null)
   +0x034 DriverUnload     : 0xf70af353     +0          
   +0x038 MajorFunction    : [28] 0xf70af334     +0 
kd>

 