#include        "debugger.h"

CHAR    breaks[MAX_BREAK];
PVOID   breakid[MAX_BREAK];

HANDLE  hTracer;
HANDLE  hEvent;

VOID    BreakSet(__in HANDLE hProcess, __in PVOID lpMemory)
{
        ULONG   index;
        for (index = 0; index < MAX_BREAK; index++){
                if (breakid[index] == 0){
                        if (!ReadProcessMemory(hProcess, lpMemory, &breaks[index], 1, 0)) break;        
                        WriteProcessMemory(hProcess, lpMemory, "\xcc", 1, 0);
                        breakid[index] = lpMemory; 
                        break;
                }       
                
        }               
}

VOID    BreakRemove(__in HANDLE hProcess, __in PVOID lpMemory)
{
        ULONG   index;
        for (index = 0; index < MAX_BREAK; index++){
                if (breakid[index] == lpMemory){
                        WriteProcessMemory(hProcess, lpMemory, &breaks[index], 1, 0);
                        breakid[index] = NULL;
                        break;
                }
        }       
}


BOOL    DebugInitProcess(__in DWORD dwProcessId)
{
        INIT_PROCESS    init;
        DWORD           cbReturned;
        
        init.dwProcessId = (HANDLE)dwProcessId;
        init.hEvent      = hEvent = CreateEvent(NULL, 0,0, NULL);
        
        hTracer = CreateFile(L"\\\\.\\tracer", GENERIC_READ | GENERIC_WRITE, 0, 0, OPEN_EXISTING, 0,0);
        if (hTracer == INVALID_HANDLE_VALUE)
                return FALSE;
                
        DeviceIoControl(hTracer, IOCTL_INIT_PROCESS, &init, sizeof(init), NULL, 0, &cbReturned, NULL);
        return TRUE; 
}


BOOL    DebugWait(PTRACER_DATA pdata, DWORD timeout)
{
        DWORD   cbReturned;
        if (WaitForSingleObject(hEvent, timeout) == WAIT_TIMEOUT){
                return FALSE;
        }
        DeviceIoControl(hTracer, IOCTL_GET_REGISTERS, NULL, 0, pdata, sizeof(TRACER_DATA), &cbReturned, NULL);
        return TRUE;
}

BOOL    DebugContinue(PTRACER_DATA pdata)
{
        DWORD   cbReturned;
        DeviceIoControl(hTracer, IOCTL_SET_REGISTERS, pdata, sizeof(TRACER_DATA), NULL, 0, &cbReturned, NULL);
        return TRUE;
}

VOID    DebugStop()
{
        DWORD   cbReturned;
        DeviceIoControl(hTracer, IOCTL_STOP_PROCESS, NULL, 0, NULL, 0, &cbReturned, NULL);
        CloseHandle(hTracer);
        CloseHandle(hEvent);
}

