/*
    timestop Copyright (c) 2013 deroko of ARTeam
    This file is part of timestop.

    timestop is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    timestop is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with timestop.  If not, see <http://www.gnu.org/licenses/>.

*/
#include        "defs.h"

BOOLEAN    TestBit(ULONG value, ULONG bit){
        if (value & (1 << bit))
                return TRUE;
        return FALSE;
}

PVOID   pKiUserSharedData;
PVOID   pBuffer;

ULONG   TickCountMultiplierOffset       = 0x04;
ULONG   TickCountLowOffset              = 0x00;
ULONG   TickCountLow320Offset           = 0x320;
ULONG   TickCountHigh1TimeOffset        = 0x324;
ULONG   TickCountHigh2TimeOffset        = 0x328;
ULONG   ProcessNameOffset;
/*****************************************************
WinXp
7C80934A > BA 0000FE7F      MOV EDX,7FFE0000
7C80934F   8B02             MOV EAX,DWORD PTR DS:[EDX]
7C809351   F762 04          MUL DWORD PTR DS:[EDX+4]
7C809354   0FACD0 18        SHRD EAX,EDX,18
7C809358   C3               RETN
******************************************************/

/*****************************************************
Win7
757367F2 Get> 8B0D 2403FE7F             MOV ECX,DWORD PTR DS:[7FFE0324]   <-- TickCount.High1Time
757367F8      8B15 2003FE7F             MOV EDX,DWORD PTR DS:[7FFE0320]   <-- TickCount.Low;
757367FE      A1 2803FE7F               MOV EAX,DWORD PTR DS:[7FFE0328]   <-- TickCount.High2Time
75736803      3BC8                      CMP ECX,EAX                     
75736805      75 1B                     JNZ SHORT KERNELBA.75736822       <-- loop untill high1/2 aren't equal
75736807      A1 0400FE7F               MOV EAX,DWORD PTR DS:[7FFE0004]   <-- TickCountMultiplier
7573680C      F7E2                      MUL EDX
7573680E      C1E1 08                   SHL ECX,8
75736811      0FAF0D 0400FE7F           IMUL ECX,DWORD PTR DS:[7FFE0004]  <-- TickCountMultiplier
75736818      0FACD0 18                 SHRD EAX,EDX,18
7573681C      C1EA 18                   SHR EDX,18
7573681F      03C1                      ADD EAX,ECX
75736821      C3                        RETN
*******************************************************/


VOID  ThreadStart(__in PVOID  StartContext){
        PULONG  pTickCountMultiplier;
        PULONG  pTickCountLow;
        PULONG  pTickCountLow320;
        PULONG  pTickCountHigh1Time;
        PULONG  pTickCountHigh2Time;
        LARGE_INTEGER   delay;        
        
        pTickCountMultiplier    = (PULONG)((ULONG_PTR)pKiUserSharedData + TickCountMultiplierOffset);
        pTickCountLow           = (PULONG)((ULONG_PTR)pKiUserSharedData + TickCountLowOffset);      
        pTickCountLow320        = (PULONG)((ULONG_PTR)pKiUserSharedData + TickCountLow320Offset);
        pTickCountHigh1Time     = (PULONG)((ULONG_PTR)pKiUserSharedData + TickCountHigh1TimeOffset); 
        pTickCountHigh2Time     = (PULONG)((ULONG_PTR)pKiUserSharedData + TickCountHigh2TimeOffset);
        
        InterlockedExchange(pTickCountHigh1Time, 0);
        InterlockedExchange(pTickCountHigh2Time, 0);
        InterlockedExchange(pTickCountLow, 0x01000000);
        InterlockedExchange(pTickCountMultiplier, 1);
        InterlockedExchange(pTickCountLow320, 0x01000000);
                
        for (;;){
                delay.QuadPart = RELATIVE(MILLISECONDS(500));
                KeDelayExecutionThread(KernelMode, FALSE, &delay);        
                InterlockedIncrement(pTickCountMultiplier);        
        }
        
}

VOID CreateProcessNotifyRoutine(__in HANDLE ParentId, __in HANDLE ProcessId, __in BOOLEAN Create){
        PPDE    pde;
        PPTE    pte;
        PPDE_NOPAE pde_nopae;
        PPTE_NOPAE pte_nopae;
        
        PLINEAR_ADDRESS pLinear;
        PLINEAR_ADDRESS_PTE pLinearPte;
        PLINEAR_ADDRESS_NOPAE pLinearNoPae;
        PLINEAR_ADDRESS_PTE_NOPAE pLinearPteNoPae;
        
        ULONG   pde_index;
        ULONG   pte_index;
        ULONG   address;
        PHYSICAL_ADDRESS phys;
        PEPROCESS       peprocess;       
        NTSTATUS        status;
        KAPC_STATE      kapc_state;

        status = PsLookupProcessByProcessId(ProcessId, &peprocess);
        if (status != STATUS_SUCCESS) return;
        if (_stricmp((char *)((ULONG_PTR)peprocess + ProcessNameOffset), "test.exe")){
                ObDereferenceObject(peprocess);
                return;
        }
        
        KeStackAttachProcess(peprocess, &kapc_state);
        
        if (Create)
                DbgPrint("Fake KUSER_SHARED_DATA for process with pid : %d\n", ProcessId);
        else
                DbgPrint("Restore KUSER_SHARED_DATA for process with pid : %d\n", ProcessId);
                
        address = KUSER_SHARED_DATA_RING3;
        
        if (Create){
                __asm   mov eax, KUSER_SHARED_DATA_RING3;
                __asm   mov eax, [eax]
                phys = MmGetPhysicalAddress(pKiUserSharedData);
        }else
                phys = MmGetPhysicalAddress((PVOID)KUSER_SHARED_DATA_RING0);
        
        if (TestBit(__readcr4(), 5)){
                pde = PDE_OFFSET;
                pte = PTE_OFFSET;
                pLinear = (PLINEAR_ADDRESS)&address;
                pLinearPte = (PLINEAR_ADDRESS_PTE)&address;
                pde_index  = pLinear->Directory;
                pte_index  = pLinearPte->Table;
                pte[pte_index].PageBaseAddress = phys.QuadPart >> 12;
        }else{
                pde_nopae = PDE_OFFSET_NOPAE;
                pte_nopae = PTE_OFFSET_NOPAE;
                pLinearNoPae = (PLINEAR_ADDRESS_NOPAE)&address;
                pLinearPteNoPae = (PLINEAR_ADDRESS_PTE_NOPAE)&address;
                pde_index    = pLinearNoPae->Directory;
                pte_index    = pLinearPteNoPae->Table;
                
                pte_nopae[pte_index].PageBaseAddress = phys.LowPart >> 12;
        }
                
        
        KeUnstackDetachProcess(&kapc_state);  
        ObDereferenceObject(peprocess);     
}

NTSTATUS        DriverEntry(__in PDRIVER_OBJECT pDriverObject, __in PUNICODE_STRING pRegPath){
        ULONG   c_cr4;
        BOOLEAN b_pae;
        PPDE    ppde;
        PPTE    ppte;
        PLINEAR_ADDRESS pLinear;
        PLINEAR_ADDRESS_PTE pLinearPte;
        ULONG   address;
        ULONG   pte_index;
        ULONG   pde_index;
        ULONGLONG physical;
        LARGE_INTEGER li;
        HANDLE  hThread;
        OBJECT_ATTRIBUTES oa;
        CLIENT_ID         cid;
        PEPROCESS         peprocess;
        char              *szname;
        ULONG             index;
        
        peprocess = PsGetCurrentProcess();
        
        szname = (char *)peprocess;
        
        for (index = 0; index < 0x1000; index++){
                if (!_stricmp(&szname[index], "system")){
                        ProcessNameOffset = index;
                        break;
                }        
        }
          
        c_cr4 = __readcr4();
        if (TestBit(c_cr4, 5))
                b_pae = TRUE;
        else
                b_pae = FALSE;
                
        pBuffer = ExAllocatePoolWithTag(NonPagedPool, 0x4000, 0);
        
        pKiUserSharedData = (PVOID)(((ULONG_PTR)pBuffer + 0xFFF) & ~0xFFF);
        memcpy(pKiUserSharedData, (PVOID)KUSER_SHARED_DATA_RING0, 0x1000);

        PsSetCreateProcessNotifyRoutine(CreateProcessNotifyRoutine, FALSE);
        
        InitializeObjectAttributes(&oa, NULL, OBJ_KERNEL_HANDLE, NULL, NULL);
        PsCreateSystemThread(&hThread, THREAD_ALL_ACCESS, &oa, NULL, &cid, ThreadStart, NULL);
        ZwClose(hThread);
                
        return  STATUS_SUCCESS;        
}