/*************************************************************************
 *   tracer driver Copyright (c) 2008 deroko of ARTeam
 *   This file is part of tracer driver.
 *
 *   xtracer is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   xtracer is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with xtracer.  If not, see <http://www.gnu.org/licenses/>.
 *
 *************************************************************************/
 
#include "defs.h"

/*****************************************************************
 * This module defines data needed for the dr7.GD bit manipulation
 * on mp processors and single core cpus. This code is literally 
 * copied from dr7_mp_safe code, with a few modifications. 
 *****************************************************************/

extern BOOLEAN hook_active;
extern ULONG   OldInt1Handler;
extern ULONG   KiTrap0D;
extern ULONG   dr6_state[32];

UCHAR   *reg32[]  = {"eax", "ecx", "edx", "ebx", "esp", "ebp", "esi", "edi"};
UCHAR   *regDrX[] = {"dr0", "dr1", "dr2", "dr3", "dr4", "dr5", "dr6", "dr7"};

VOID  HandleDebugReg(PREGISTERS regs, ULONG TaskRegister){
        PULONG reg32index;
        ULONG  drValue, reg32value;
        UCHAR  drUsed, reg32Used, reg32_stack;
        PUCHAR regField, fault_eip = (PUCHAR)regs->reg_Eip;
        
        reg32index = &regs->reg_Edi;
        regField = (UCHAR *)(regs->reg_Eip + 2);
        drUsed = (*regField & 0x38) >> 3;
        reg32Used = *regField & 7; 
        
        //convert indexes to stack layout...
        reg32_stack = ConvertRegIndexToStructIndex(reg32Used);
        // allow only this driver, and process which we are tracing
        // to modify debug registers. This is done so no softice will
        // be able to clear our debug breaks during tracing, if softice
        // is used btw... this happens if EIP <> debuger driver and 
        // when EIP <> ntoskrnl.exe && pid == traced_pid!!!
        if (fault_eip[0] == 0x0F && fault_eip[1] == 0x21){
                // mov from debug reg
                if (IsSiceRange(regs->reg_Eip)){
                        reg32index[reg32_stack] = ExtractDrByIndex(drUsed);
                }else{
                        // emulate all movs except dr7 which is faked for everything
                        // including softice if present, and all other processes...
                        if (drUsed == 7)
                                reg32index[reg32_stack] = 0x400;
                        else if (drUsed == 6)
                                reg32index[reg32_stack] = 0xFFFF0FF0;
                        else
                                reg32index[reg32_stack] = 0;
                }
                        
        }else if (fault_eip[0] == 0x0F && fault_eip[1] == 0x23){
                // mov to debug reg
                if (IsSiceRange(regs->reg_Eip)){
                        // we update drX always when it's my driver, and when eip is in
                        // ntoskrnl.exe and when pid == traced_pid
                        reg32value = reg32index[reg32_stack];
                        UpdateDrByIndex(drUsed, reg32value);
                }else{
                        // this is do nothing code as we don't do anything when 
                        // drX is not allowed to update!!!
                        if (drUsed == 7)
                                //UpdateDrByIndex(7, 0x400);   
                                __asm nop
                        else
                                //UpdateDrByIndex(drUsed, 0);
                               __asm nop
                }             
        }       
        
        
        return;
}  

VOID __declspec(naked)Int1Hook(VOID){
        __asm{
                cli
                pushad                                  ;r0 prolog
                push    fs
                push    ds
                push    es
                mov     eax, 30h                        ;KPCR
                mov     fs, ax
                mov     eax, 23h
                mov     ds, ax
                mov     es, ax
                
                mov     eax, dr6
                btr     eax, 13                         
                mov     dr6, eax
                jnc     __oldint1                       
                
                cmp     [esp.reg_Cs], 1Bh                ;ring3 drX mov... intel cpu...
                je      __ring3
                
                xor     ecx, ecx
                str     cx        
                mov     eax, esp
                ;push    ecx                            ;TaskSelector is used to determine if DbgPrint will
                push    58h                             ;be used... (disable dbgoutput atm - push 58h)
                push    eax                              
                call    HandleDebugReg
                
                add     [esp.reg_Eip], 3                ;skip this instruction as it is emulated
                
                cmp     hook_active, FALSE
                je      __s0
                mov     eax, dr7
                or      eax, 2000h                      ;update dr7.GD when we exit...
                mov     dr7, eax
                                
__s0:           str     ax
                cmp     ax, 58h
                je      __nmi
                
                pop     es
                pop     ds
                pop     fs
                popad                                   
                iretd                                   

__nmi:          mov     eax, [esp.reg_Eflags]           ;if drX access comes from NMI, iretd will enable NMIs
                push    eax                             ;on this processor... very bad... this is the case when
                popfd                                   ;using softice on mp systems... if we deceide to use 
                pop     es                              ;iretd(why would we?) then NT flag has to be cleared
                pop     ds                              ;prior to executing iretd... NMI is TaskGate, so NT + iretd
                pop     fs                              ;will return to previous task stored in TSS.BackLink, and 
                popad                                   ;thats not what I want!!!
                retn    8                               ;pickup EIP, and wipe CS/Eflags from stack...      


__ring3:        cmp     hook_active, FALSE              ;prepare stack for kitrap0d
                je      __s2
                mov     eax, dr7
                or      eax, 2000h
                mov     dr7, eax
__s2:           pop     es
                pop     ds
                pop     fs
                popad
                push    0                               ;<--- make dummy error code
                jmp     cs:[KiTrap0D]                   ;<--- GD has higher priority then privileged
                                                        ;     instruction on intel cpu, but this isnt
                                                        ;     the case with AMD cpu...
                                                        
                                                        ;maybe they have different logic of resolving instruction?
                                                        ;AMD    -> CPL != 0    ->throw exception (int0D)
                                                        ;          -> dr7.GD == 1 ->throw exception(int01)
                                                        ;INTEL  -> dr7.GD == 1 -> throw exception(int01)
                                                        ;          -> CPL != 0    ->throw exception(int0D)
                                                        ;maybe Im wrong, who cares...
                                              
__oldint1:      call    dword ptr[KeGetCurrentProcessorNumber]
                mov     ecx, eax
                mov     eax, dr6                        ;each CPU in MP system has its own debug regs
                mov     dr6_state[ecx*4], eax           ;thats why those are updated for each CPU...
                
                cmp     hook_active, FALSE
                je      __s1
                mov     eax, dr7
                or      eax, 2000h                      ;update dr7.GD always as it is cleared when int 1 occurs...
                mov     dr7, eax
__s1:           pop     es
                pop     ds
                pop     fs
                popad
                jmp     cs:[OldInt1Handler]

        }
}


