/*************************************************************************
 *   tracer driver Copyright (c) 2008 deroko of ARTeam
 *   This file is part of tracer driver.
 *
 *   xtracer is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   xtracer is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with xtracer.  If not, see <http://www.gnu.org/licenses/>.
 *
 *************************************************************************/
 
#include "defs.h"

/******************************************************************
 * This module implements all stuff needed for the drX updating.
 * note that IsSiceRange(ULONG eip) doesn't take care of SoftICE 
 * anymore, it only tells tracer that it should update regs in 3
 * conditions:
 *      1. tracer_init = 1 and eip <> this driver
 *      2. tracer_init = 1 and eip <> ntoskrnl.exe and pid = traced_pid
 *      3. tracer_init = 0 - always return true!!!
 *
 * Other procedures are not that much important except that those
 * update drXes
 *****************************************************************/
 

extern  ULONG tracer_init;
extern  HANDLE traced_pid;
extern  BOOLEAN sice_present;
extern  BOOLEAN cpthook_present;
extern  BOOLEAN test_present;
extern  ULONG sice_start, sice_end;
extern  ULONG cpthook_start, cpthook_end;
extern  ULONG test_start, test_end;
extern  ULONG dr6_state[32];

/***********************************************************
 * This routine tells to the int1 top handler (the one responsible for
 * GD bit), that it should update drX or disallow drX update
 * Note that here drX are system wide, so that means that any thread
 * which is using drX from SEH might clear them for good!!!!
 * Windows only updates drX if certain filed in KTHREAD is set:
 * KTHREAD.DebugActive (offset 0x2C on XP)!!!
 ***********************************************************/
BOOLEAN IsSiceRange(ULONG eip){
        // update drXes always when tracer is not running...
        if (!tracer_init)
                return TRUE;
        
        // allow cpthook to access drX registers
        if (cpthook_present)
                if (cpthook_start < eip && eip < cpthook_end)
                        return TRUE;
        
        // allow ntice to access drX registers
        if (sice_present)
                if (sice_start < eip && eip < sice_end)
                        return TRUE;
        
        // allow this driver to change drX
        if (test_start < eip && eip < test_end)
                return TRUE;
        
        // allow any change to drX when code is executed in traced pid!!!
        // in this way, I allow traced app to change drX, but only when
        // it's needed. eg. application uses self debugging via drX!!!
        if (traced_pid == PsGetCurrentProcessId())
                return TRUE;
        
        return FALSE;
}
                

ULONG   ExtractDrByIndex(UCHAR drIndex){
        ULONG drValue;
        switch (drIndex){
                case 0:
                       __asm mov eax, dr0
                       __asm mov drValue, eax
                       break;
                case 1:
                       __asm mov eax, dr1
                       __asm mov drValue, eax
                       break;
                case 2:
                       __asm mov eax, dr2
                       __asm mov drValue, eax
                       break;
                case 3:
                       __asm mov eax, dr3
                       __asm mov drValue, eax
                       break;
                case 6:
                       __asm call dword ptr[KeGetCurrentProcessorNumber]
                       __asm mov ecx, eax
                       __asm mov eax, dr6_state[ecx*4]
                       __asm mov drValue, eax
                       break;
                case 7:
                       __asm mov eax, dr7
                       __asm mov drValue, eax
                       break;
         }
         return drValue;
}

ULONG   UpdateDrByIndex(UCHAR drIndex, ULONG reg32value){
        switch (drIndex){
                case 0: 
                       __asm mov eax, reg32value;
                       __asm mov dr0, eax
                       break;
                case 1:
                       __asm mov eax, reg32value;
                       __asm mov dr1, eax
                       break;
                case 2:
                       __asm mov eax, reg32value;
                       __asm mov dr2, eax
                       break;
                case 3:
                       __asm mov eax, reg32value;
                       __asm mov dr3, eax
                       break;
                case 6:
                       __asm call dword ptr[KeGetCurrentProcessorNumber]
                       __asm mov ecx, eax
                       __asm mov eax, reg32value;
                       __asm mov dr6, eax
                       __asm mov dr6_state[ecx*4], eax
                       break;
                case 7:
                       __asm mov eax, reg32value;
                       __asm btr eax, 13               ;dont allow Dr7.GD bit to be updated here!!!!!
                       __asm mov dr7, eax
                       break; 
        }
        return 0;
} 

/*
        Registers stored on stack in REGISTERS struct are ordered:
        
                eax     <---- +1C       -- index 7
                ecx     <---- +18       -- index 6
                edx     <---- +14       -- index 5
                ebx     <---- +10       -- index 4
                esp     <---- +0C       -- index 3
                ebp     <---- +8        -- index 2
                esi     <---- +4        -- index 1
                edi     <---- +0        -- index 0

       so index from opcode has to be converted to look like this...

*/

UCHAR   reg32UsedTranslationBuffer[] = {7, 6, 5, 4, 3, 2, 1, 0};


UCHAR   ConvertRegIndexToStructIndex(UCHAR reg32Used){
        UCHAR   reg32Used1;
        return reg32UsedTranslationBuffer[reg32Used];
        /*
        switch (reg32Used){
                case 0: reg32Used1 = 7;                 //eax 
                        break;
                case 1: reg32Used1 = 6;                 //ecx
                        break;
                case 2: reg32Used1 = 5;                 //edx
                        break;
                case 3: reg32Used1 = 4;                 //ebx
                        break;
                case 4: reg32Used1 = 3;                 //esp
                        break;
                case 5: reg32Used1 = 2;                 //ebp
                        break;
                case 6: reg32Used1 = 1;                 //esi
                        break;                
                case 7: reg32Used1 = 0;                 //edi
                        break;       
        }
        return reg32Used1;
        */
}                  