/****************************************************************************
 *   win32k SDT resolver
 *   Copyright (C) 2010  deroko of ARTeam
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ****************************************************************************/
#include        "defs.h"


WCHAR   *g_wsClassName = L"WiN32kSyScAlLtAbLeDuMpEr";
HWND    hlist;
HINSTANCE g_hinstance;

#define ITEM_COUNT   100000


LRESULT CALLBACK WndProc( HWND hWnd,
                          UINT uMessage,
                          WPARAM wParam,
                          LPARAM lParam)
{
        BOOL    b_handled = TRUE;
        LVCOLUMN LvCol;	
        RECT    rc;		
        LVITEM  LvItem;	
        MSGBOXPARAMS    mbparams;
        OPENFILENAME  ofn;
        FILE          *pfile;
        int           itemCount, index;
        WCHAR         *wsBuffer;
        SHORT         sKeyState;
        
        DWORD   dwStyle =   WS_TABSTOP | 
                            WS_CHILD | 
                            WS_BORDER | 
                            WS_VISIBLE |
                            LVS_REPORT;

        switch (uMessage)
        {
        case WM_CREATE:
                GetClientRect(hWnd, &rc);
                
                hlist = CreateWindowEx(WS_EX_CLIENTEDGE,  
                                       WC_LISTVIEW,       
                                       L"",          
                                       dwStyle,           
                                       0,                 
                                       0,                 
                                       0,                 
                                       0,                 
                                       hWnd,        
                                       (HMENU)ID_LISTVIEW,
                                       g_hinstance,           
                                       NULL);             
                
                MoveWindow(hlist,
                           rc.left,
                           rc.top,
                           rc.right - rc.left,
                           rc.bottom - rc.top,
                           TRUE);
                //ListView_DeleteAllItems(hlist);
                
                memset(&LvCol,0,sizeof(LvCol));
                LvCol.mask      = LVCF_FMT | LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM ;
                LvCol.fmt       = LVCFMT_LEFT;
                LvCol.cx        = 0x80;
                LvCol.pszText   = L"System Call Number";
                SendMessage(hlist,LVM_INSERTCOLUMN,0,(LPARAM)&LvCol);
                
                LvCol.mask   = LVCF_FMT | LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM ;
                LvCol.fmt    = LVCFMT_LEFT;	
                LvCol.pszText= L"System Call Symbol";			
                LvCol.cx     = 0x150;
                SendMessage(hlist,LVM_INSERTCOLUMN,1,(LPARAM)&LvCol);
                ListView_SetExtendedListViewStyleEx(hlist,0 , LVS_EX_FULLROWSELECT );
     
                DumpList(hWnd, hlist);
                break;
        case WM_SIZE:
                GetClientRect(hWnd, &rc);
                MoveWindow(hlist,
                           rc.left,
                           rc.top,
                           rc.right - rc.left,
                           rc.bottom - rc.top,
                           TRUE);
                break;
        case WM_DESTROY:
                PostQuitMessage(0);
                break;
        case WM_COMMAND:
                switch (LOWORD(wParam))
                {
                case IDM_FILE_EXIT:
                        DestroyWindow(hWnd);
                        break;
                case IDM_HELP_HELP:
                        memset(&mbparams, 0, sizeof(mbparams));
                        mbparams.dwStyle = MB_USERICON;
                        mbparams.cbSize = sizeof(mbparams);
                        mbparams.hInstance = g_hinstance;
                        mbparams.lpszText    = L"C'mon... there is no help for this program...";
                        mbparams.lpszCaption = L"You need help?";
                        mbparams.lpszIcon    = MAKEINTRESOURCE(IDI_ICON);
                        MessageBoxIndirect(&mbparams);
                        break;
                case IDM_HELP_ABOUT:
                        memset(&mbparams, 0, sizeof(mbparams));
                        mbparams.dwStyle = MB_USERICON;
                        mbparams.cbSize = sizeof(mbparams);
                        mbparams.hInstance = g_hinstance;
                        mbparams.lpszText    = L"win32k SDT resolver - (c) 2010 deroko of ARTeam";
                        mbparams.lpszCaption = L"About";
                        mbparams.lpszIcon    = MAKEINTRESOURCE(IDI_ICON);
                        MessageBoxIndirect(&mbparams);
                        break;        
                case IDM_FILE_SAVE:
                        memset(&ofn, 0, sizeof(ofn));
                        
                        ofn.lStructSize = sizeof(OPENFILENAME);
                        ofn.hwndOwner   = hWnd;
                        ofn.hInstance   = g_hinstance;
                        ofn.lpstrFilter = L"Text files\x00*.txt\x00\x00";
                        ofn.lpstrFile   = GlobalAlloc(GPTR, MAX_PATH * sizeof(WCHAR));
                        memset(ofn.lpstrFile, 0, MAX_PATH * sizeof(WCHAR));
                        ofn.nMaxFile    = MAX_PATH;
                        ofn.lpstrTitle  = L"Where do you want to save?";
                        
                        if (!GetSaveFileName(&ofn)){
                                GlobalFree(ofn.lpstrFile);
                                break;
                        }
                        
                        pfile = _wfopen(ofn.lpstrFile, L"w");
                        if (!pfile){
                                MessageBox(hWnd, L"Failed to open slected file", L"error", MB_ICONWARNING);
                                GlobalFree(ofn.lpstrFile);
                                break;
                        }
                        
                        
                        itemCount = ListView_GetItemCount(hlist);
                        
                        wsBuffer = GlobalAlloc(GPTR, MAX_PATH * sizeof(WCHAR));
                        memset(wsBuffer, 0, MAX_PATH * sizeof(WCHAR));
                        for (index = 0; index < itemCount; index++){
                                memset(&LvItem, 0, sizeof(LvItem));
                                
                                LvItem.mask     = LVIF_TEXT;
                                LvItem.iItem    = index;        
                                LvItem.iSubItem = 0;
                                LvItem.pszText  = wsBuffer;
                                LvItem.cchTextMax = MAX_PATH;
                                ListView_GetItem(hlist, &LvItem);
                                fwprintf(pfile, L"%s  -  ", wsBuffer);
                                LvItem.mask     = LVIF_TEXT;
                                LvItem.iItem    = index;        
                                LvItem.iSubItem = 1;
                                LvItem.pszText  = wsBuffer;
                                LvItem.cchTextMax = MAX_PATH;
                                ListView_GetItem(hlist, &LvItem);
                                fwprintf(pfile, L"%s\n", wsBuffer);
                        }
                        fclose(pfile);
                        GlobalFree(ofn.lpstrFile);
                        GlobalFree(wsBuffer);
                        
                        memset(&mbparams, 0, sizeof(mbparams));
                        mbparams.dwStyle = MB_USERICON;
                        mbparams.cbSize = sizeof(mbparams);
                        mbparams.hInstance = g_hinstance;
                        mbparams.lpszText    = L"saving file done";
                        mbparams.lpszCaption = L"save done";
                        mbparams.lpszIcon    = MAKEINTRESOURCE(IDI_ICON);
                        MessageBoxIndirect(&mbparams);
                        
                        break;
                default:
                        b_handled = FALSE;
                }
                break;        
        default:
                b_handled = FALSE;
                break;
        }
        
        if (b_handled == FALSE)
                return DefWindowProc(hWnd, uMessage, wParam, lParam);
        return 0;
}

int WINAPI wWinMain(HINSTANCE hInstance,
                   HINSTANCE hPrevInstance,
                   LPWSTR lpCmdLine,
                   int nCmdShow
)
{
        WNDCLASSEX  wcex;
        HWND        hwnd;
        MSG         msg;
        
        g_hinstance = hInstance;
        
        memset(&wcex, 0, sizeof(wcex));
        
        InitCommonControls();
        
        wcex.cbSize          = sizeof(WNDCLASSEX);
        wcex.style           = 0;
        wcex.lpfnWndProc     = (WNDPROC)WndProc;
        wcex.cbClsExtra      = 0;
        wcex.cbWndExtra      = 0;
        wcex.hInstance       = hInstance;
        wcex.hCursor         = LoadCursor(NULL, IDC_ARROW);
        wcex.hbrBackground   = (HBRUSH)(COLOR_WINDOW + 1);
        wcex.lpszMenuName    = MAKEINTRESOURCE(IDM_MENU);
        wcex.lpszClassName   = g_wsClassName;
        wcex.hIcon           = LoadIcon(hInstance, MAKEINTRESOURCE(IDI_ICON));
        wcex.hIconSm         = LoadImage(hInstance, MAKEINTRESOURCE(IDI_ICON), IMAGE_ICON, 16, 16, 0);        
        
        RegisterClassEx(&wcex);
        
        hwnd = CreateWindowEx(0,
                              g_wsClassName,
                              L"win32k SDT resolver - (c) 2010 deroko of ARTeam",
                              WS_OVERLAPPEDWINDOW,
                              CW_USEDEFAULT,
                              CW_USEDEFAULT,
                              500,
                              400,
                              NULL,
                              LoadMenu(hInstance, MAKEINTRESOURCE(IDM_MENU)),
                              hInstance,
                              NULL);
        
        ShowWindow(hwnd, nCmdShow);
        UpdateWindow(hwnd);
        
        while(GetMessage( &msg, NULL, 0, 0)){
                TranslateMessage(&msg);
                DispatchMessage(&msg);
        }

}

