/******************************************************************************
 *   xchat_sasl plugin
 *   Copyright (C) 2010  deroko of ARTeam
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *****************************************************************************/
#include        <xchat/xchat-plugin.h>
#include        <string.h>

#include        <openssl/sha.h>
#include        <openssl/hmac.h>
#include        <openssl/evp.h>
#include        <openssl/bio.h>
#include        <openssl/buffer.h>

#define PNAME "sasl"
#define PDESC "SASL Authentification"
#define PVERSION "0.1"

typedef unsigned int BOOL;
#define TRUE  1
#define FALSE 0

#define USER     "MU_USER_NAME"
#define PASSWORD "MY_PASSWORD"
#define NETWORK  "FreeNodeTor"

static xchat_plugin *ph;   /* plugin handle */

void *base64(void *input, int length)
{
        BIO *bmem, *b64;
        BUF_MEM *bptr;
        char    *buff;
        
        b64 = BIO_new(BIO_f_base64());
        bmem = BIO_new(BIO_s_mem());
        b64 = BIO_push(b64, bmem);
        BIO_write(b64, input, length);
        BIO_flush(b64);
        BIO_get_mem_ptr(b64, &bptr);
        
        buff  = malloc(bptr->length);
        memcpy(buff, bptr->data, bptr->length-1);
        buff[bptr->length-1] = 0;
        
        BIO_free_all(b64);       
        return buff;
}


void xchat_plugin_get_info(char **name, char **desc, char **version, void **reserved)
{
   *name = PNAME;
   *desc = PDESC;
   *version = PVERSION;
}

static int sasl_command(char **word, char **word_eol, void *userdata){
        xchat_print(ph, "/sasl add/remove network [user password]\n");
        return XCHAT_EAT_ALL;
}

//dummy hook, to list what comes from an IRC server...
static int command_hook(char **word, char **word_eol, void *userdata){
        //xchat_print(ph, word_eol[2]);
        return XCHAT_EAT_NONE;
}

static int authenticate_hook(char **word, char **word_eol, void *userdata){
        char *convert;
        char *buff;
        size_t len_user, len_password, len_convert, index;

        if (!strcmp(word[2], "+")){
                //send string in format AUTHENTICATE base64(user\0user\0password)
                len_user     = strlen(USER);
                len_password = strlen(PASSWORD);
                len_convert  = len_user + len_user + len_password + 2;
                
                convert = malloc(len_convert);
                index = 0;
                memcpy(&convert[index], USER, len_user);
                index+= len_user;
                convert[index] = '\x00';
                index++;
                memcpy(&convert[index], USER, len_user);
                index+= len_user;
                convert[index] = '\x00';
                index++;
                memcpy(&convert[index], PASSWORD, len_password);
                
                buff = base64(convert, len_convert);
                xchat_commandf(ph, "AUTHENTICATE %s", buff);
                free(buff);
                free(convert);
                return XCHAT_EAT_ALL;        
        }       
        
        return XCHAT_EAT_NONE;
}

static int cap_hook(char **word, char **word_eol, void *userdata){
        char *subcmd;
        const char *network;
        BOOL  b_multiprefix, b_sasl;
        
        network = xchat_get_info(ph, "network");
        if (network == NULL){
                //xchat_print(ph, "No network!!?!!?!");
                goto __Exit0;
        }
        if (strcasecmp(network, NETWORK)){
                //xchat_printf(ph, "wrong network %s", network);
                goto __Exit0; 
        }
        
        if (strstr(word_eol[1], " LS ")){
                //check if there is mutli-prefix
                xchat_printf(ph, "Received CAP LS : %s", word_eol[2]);
                b_multiprefix = (strstr(word_eol[1], "multi-prefix")) ? TRUE : FALSE;
                b_sasl        = (strstr(word_eol[1], "sasl")) ? TRUE : FALSE;
                
                if (!b_sasl){
                        xchat_print(ph, "Server is not SASL capable");
                }
                
                //xchat_print(ph, "Received CAP LS");
                xchat_printf(ph, "Setting %s %s", (b_multiprefix) ? "multi-prefix" : "",
                                                  (b_sasl) ? "sasl" : "");
                xchat_commandf(ph, "CAP REQ : %s %s", (b_multiprefix) ? "multi-prefix" : "",
                                                      (b_sasl) ? "sasl" : "");                
                return XCHAT_EAT_ALL;
        }else if (strstr(word_eol[1], " ACK ")){
                xchat_printf(ph, "Received ACK : %s", word_eol[2]);
                xchat_print(ph, "Setting Authentification to plain");
                xchat_command(ph, "AUTHENTICATE PLAIN");
                return XCHAT_EAT_ALL;
        }else if (strstr(word_eol[1], " NAK ")){
                xchat_printf(ph, "Received NAK : %s", word_eol[2]);
                xchat_print(ph, "Sending CAP END");
                xchat_command(ph, "CAP END");
                return XCHAT_EAT_ALL;
        }
        
__Exit0:
        //for debugging enable this...
        //xchat_print(ph, word_eol[2]);
        return XCHAT_EAT_NONE;
}

//now simply wait for response and give it to the user... done...
static int response_hook(char **word, char **word_eol, void *userdata){
        xchat_print(ph, word_eol[2]);
        xchat_command(ph, "CAP END");
        return XCHAT_EAT_NONE;        
        
}

int xchat_plugin_init(xchat_plugin *plugin_handle,
                      char **plugin_name,
                      char **plugin_desc,
                      char **plugin_version,
                      char *arg)
{
        /* we need to save this for use with any xchat_* functions */
        ph = plugin_handle;
        
        /* tell xchat our info */
        *plugin_name = PNAME;
        *plugin_desc = PDESC;
        *plugin_version = PVERSION;
        
        xchat_print(ph, "SASL Authentification by deroko of ARTeam");
        
        xchat_hook_command(ph, "sasl", XCHAT_PRI_NORM, &sasl_command, NULL, NULL);
        xchat_hook_server(ph, "RAW LINE", XCHAT_PRI_NORM, &command_hook, NULL);
        xchat_hook_server(ph, "CAP", XCHAT_PRI_NORM, cap_hook, NULL);
        xchat_hook_server(ph, "AUTHENTICATE", XCHAT_PRI_NORM, authenticate_hook, NULL);
        xchat_hook_server(ph, "903", XCHAT_PRI_NORM, response_hook, NULL);
        xchat_hook_server(ph, "904", XCHAT_PRI_NORM, response_hook, NULL);
        xchat_hook_server(ph, "905", XCHAT_PRI_NORM, response_hook, NULL);
        xchat_hook_server(ph, "906", XCHAT_PRI_NORM, response_hook, NULL);
        xchat_hook_server(ph, "907", XCHAT_PRI_NORM, response_hook, NULL);        

   return 1;       /* return 1 for success */
}
